/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Scaling;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import com.github.tommyettinger.textra.TypingLabel;
import forge.Forge;
import forge.adventure.character.EnemySprite;
import forge.adventure.data.EnemyData;
import forge.adventure.data.WorldData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.scene.GameScene;
import forge.adventure.scene.QuestLogScene;
import forge.adventure.scene.Scene;
import forge.adventure.scene.UIScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.world.WorldSave;
import forge.assets.FBufferedImage;
import forge.card.ColorSet;
import forge.game.GameType;
import forge.localinstance.achievements.Achievement;
import forge.localinstance.achievements.AchievementCollection;
import forge.localinstance.achievements.CardActivationAchievements;
import forge.localinstance.achievements.PlaneswalkerAchievements;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.util.TextUtil;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class PlayerStatisticScene
extends UIScene {
    Image avatar;
    Image avatarBorder;
    Image colorFrame;
    TextraLabel money;
    TextraLabel life;
    TextraLabel shards;
    TextraLabel wins;
    TextraLabel totalWins;
    TextraLabel eventWins;
    TextraLabel eventMatchWins;
    TextraLabel loss;
    TextraLabel totalLoss;
    TextraLabel eventLosses;
    TextraLabel eventMatchLosses;
    TextraLabel winloss;
    TextraLabel lossWinRatio;
    TextraLabel eventLossWinRatio;
    TextraLabel eventMatchLossWinRatio;
    TextraLabel headerAchievements;
    TextraLabel headerAvatar;
    TextraLabel headerName;
    TextraLabel headerWinLoss;
    TypingLabel playerName;
    TextraButton back;
    TextraButton toggleAward;
    private final Table scrollContainer;
    private final Table achievementContainer;
    TextraLabel blessingScroll;
    ScrollPane scroller;
    Table root;
    boolean toggle = false;
    AchievementCollection planeswalkers = PlaneswalkerAchievements.instance;
    AchievementCollection achievements = FModel.getAchievements(GameType.Adventure);
    AchievementCollection cardActivation = CardActivationAchievements.instance;
    Scene lastGameScene;
    private static PlayerStatisticScene object;

    private PlayerStatisticScene() {
        super(Forge.isLandscapeMode() ? "ui/statistic.json" : "ui/statistic_portrait.json");
        this.scrollContainer = new Table(Controls.getSkin());
        this.scrollContainer.row();
        this.achievementContainer = new Table(Controls.getSkin());
        this.blessingScroll = Controls.newTextraLabel("");
        this.blessingScroll.setAlignment(10);
        this.blessingScroll.setWrap(true);
        this.ui.onButtonPress("return", this::back);
        this.ui.onButtonPress("quests", this::quests);
        this.avatar = (Image)this.ui.findActor("avatar");
        this.avatarBorder = (Image)this.ui.findActor("avatarBorder");
        this.playerName = (TypingLabel)this.ui.findActor("playerName");
        this.life = (TextraLabel)this.ui.findActor("lifePoints");
        this.money = (TextraLabel)this.ui.findActor("money");
        this.shards = (TextraLabel)this.ui.findActor("shards");
        this.wins = (TextraLabel)this.ui.findActor("wins");
        this.colorFrame = (Image)this.ui.findActor("colorFrame");
        this.totalWins = (TextraLabel)this.ui.findActor("totalWins");
        this.loss = (TextraLabel)this.ui.findActor("loss");
        this.totalLoss = (TextraLabel)this.ui.findActor("totalLoss");
        this.winloss = (TextraLabel)this.ui.findActor("winloss");
        this.lossWinRatio = (TextraLabel)this.ui.findActor("lossWinRatio");
        this.eventMatchWins = (TextraLabel)this.ui.findActor("eventMatchWins");
        this.eventMatchLosses = (TextraLabel)this.ui.findActor("eventMatchLosses");
        this.eventMatchLossWinRatio = (TextraLabel)this.ui.findActor("eventMatchLossWinRatio");
        this.eventWins = (TextraLabel)this.ui.findActor("eventWins");
        this.eventLosses = (TextraLabel)this.ui.findActor("eventLosses");
        this.eventLossWinRatio = (TextraLabel)this.ui.findActor("eventLossWinRatio");
        this.totalWins = (TextraLabel)this.ui.findActor("totalWins");
        this.loss = (TextraLabel)this.ui.findActor("loss");
        this.totalLoss = (TextraLabel)this.ui.findActor("totalLoss");
        this.winloss = (TextraLabel)this.ui.findActor("winloss");
        this.lossWinRatio = (TextraLabel)this.ui.findActor("lossWinRatio");
        this.back = (TextraButton)this.ui.findActor("return");
        this.toggleAward = (TextraButton)this.ui.findActor("toggleAward");
        this.headerAchievements = Controls.newTextraLabel("[%110]" + Forge.getLocalizer().getMessage("lblAchievements", new Object[0]));
        this.headerAvatar = Controls.newTextraLabel("[%110]" + Forge.getLocalizer().getMessage("lblAvatar", new Object[0]));
        this.headerName = Controls.newTextraLabel("[%110]" + Forge.getLocalizer().getMessage("lblName", new Object[0]));
        this.headerWinLoss = Controls.newTextraLabel("[%110]" + Forge.getLocalizer().getMessage("lblWinProper", new Object[0]) + "/" + Forge.getLocalizer().getMessage("lblLossProper", new Object[0]));
        this.toggleAward.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                PlayerStatisticScene.this.toggleScroller();
            }
        });
        Window window = (Window)this.ui.findActor("scrollWindow");
        this.root = (Table)this.ui.findActor("enemies");
        this.root.add(this.headerAvatar).pad(5.0f).center();
        this.root.add(this.headerName).fillX().pad(5.0f).width(100.0f).center();
        this.root.add(this.headerWinLoss).pad(5.0f).center();
        this.root.row();
        this.scroller = new ScrollPane((Actor)this.scrollContainer);
        this.root.add(this.scroller).colspan(3);
        ScrollPane blessing = (ScrollPane)this.ui.findActor("blessingInfo");
        blessing.setActor(this.blessingScroll);
        window.add(this.root);
    }

    public static PlayerStatisticScene instance(Scene lastGameScene) {
        if (object == null) {
            object = new PlayerStatisticScene();
        }
        if (lastGameScene != null) {
            PlayerStatisticScene.object.lastGameScene = lastGameScene;
        }
        return object;
    }

    @Override
    public void dispose() {
        if (this.achievements != null) {
            for (Achievement a : this.achievements) {
                ((FBufferedImage)a.getImage()).dispose();
            }
        }
        if (this.planeswalkers != null) {
            for (Achievement a : this.planeswalkers) {
                ((FBufferedImage)a.getImage()).dispose();
            }
        }
        if (this.cardActivation != null) {
            for (Achievement a : this.cardActivation) {
                ((FBufferedImage)a.getImage()).dispose();
            }
        }
    }

    private void toggleScroller() {
        boolean bl = this.toggle = !this.toggle;
        if (this.toggle) {
            this.root.clear();
            this.root.add(this.headerAchievements).pad(5.0f).colspan(2).center().expand();
            this.root.row();
            this.root.add(this.scroller).expand();
            this.scroller.setActor(this.achievementContainer);
            this.toggleAward.setText("[%125][+VS]");
        } else {
            this.root.clear();
            this.root.add(this.headerAvatar).pad(5.0f).center();
            this.root.add(this.headerName).fillX().pad(5.0f).width(100.0f).center();
            this.root.add(this.headerWinLoss).pad(5.0f).center();
            this.root.row();
            this.root.add(this.scroller).colspan(3);
            this.scroller.setActor(this.scrollContainer);
            this.toggleAward.setText("[%125][+AWARD]");
        }
        this.performTouch(this.scroller);
    }

    private TextureRegion getColorFrame(ColorSet color) {
        String colorName = "color_";
        if (color.hasWhite()) {
            colorName = colorName + "w";
        }
        if (color.hasBlue()) {
            colorName = colorName + "u";
        }
        if (color.hasBlack()) {
            colorName = colorName + "b";
        }
        if (color.hasRed()) {
            colorName = colorName + "r";
        }
        if (color.hasGreen()) {
            colorName = colorName + "g";
        }
        return Config.instance().getAtlas("ui/color_frames.atlas").findRegion(colorName);
    }

    @Override
    public void enter() {
        super.enter();
        GameHUD.getInstance().switchAudio();
        this.achievementContainer.clear();
        this.updateAchievements(this.cardActivation, true);
        this.updateAchievements(this.planeswalkers, true);
        this.updateAchievements(this.achievements, false);
        this.scrollContainer.clear();
        if (this.playerName != null) {
            String gender = Current.player().isFemale() != false ? "{GRADIENT=MAGENTA;MAUVE;1;1}\u2640{ENDGRADIENT}[BLACK] " : "{GRADIENT=CYAN;BLUE;1;1}\u2642{ENDGRADIENT}[BLACK] ";
            this.playerName.setText(gender + GamePlayerUtil.getGuiPlayer().getName());
            this.playerName.skipToTheEnd();
        }
        if (this.avatar != null) {
            this.avatar.setDrawable(new TextureRegionDrawable(Current.player().avatar()));
        }
        if (this.life != null) {
            AdventurePlayer.current().onLifeChange(() -> this.life.setText("[+Life] [BLACK]" + AdventurePlayer.current().getLife() + "/" + AdventurePlayer.current().getMaxLife()));
        }
        if (this.money != null) {
            WorldSave.getCurrentSave().getPlayer().onGoldChange(() -> this.money.setText("[+Gold] [BLACK]" + AdventurePlayer.current().getGold()));
        }
        if (this.shards != null) {
            WorldSave.getCurrentSave().getPlayer().onShardsChange(() -> this.shards.setText("[+Shards] [BLACK]" + AdventurePlayer.current().getShards()));
        }
        if (this.totalWins != null) {
            this.totalWins.setText(String.valueOf(Current.player().getStatistic().totalWins()));
        }
        if (this.totalLoss != null) {
            this.totalLoss.setText(String.valueOf(Current.player().getStatistic().totalLoss()));
        }
        if (this.lossWinRatio != null) {
            this.lossWinRatio.setText(TextUtil.decimalFormat(Current.player().getStatistic().winLossRatio()));
        }
        if (this.eventMatchWins != null) {
            this.eventMatchWins.setText(String.valueOf(Current.player().getStatistic().eventWins()));
        }
        if (this.eventMatchLosses != null) {
            this.eventMatchLosses.setText(String.valueOf(Current.player().getStatistic().eventMatchLosses()));
        }
        if (this.eventMatchLossWinRatio != null) {
            this.eventMatchLossWinRatio.setText(Float.toString(Current.player().getStatistic().eventMatchWinLossRatio()));
        }
        if (this.eventWins != null) {
            this.eventWins.setText(String.valueOf(Current.player().getStatistic().eventWins()));
        }
        if (this.eventLosses != null) {
            this.eventLosses.setText(String.valueOf(Current.player().getStatistic().eventLosses()));
        }
        if (this.eventLossWinRatio != null) {
            this.eventLossWinRatio.setText(Float.toString(Current.player().getStatistic().eventWinLossRatio()));
        }
        if (this.colorFrame != null) {
            this.colorFrame.setDrawable(new TextureRegionDrawable(this.getColorFrame(Current.player().getColorIdentity())));
        }
        if (this.blessingScroll != null) {
            if (Current.player().getBlessing() != null) {
                this.blessingScroll.setText("[BLACK]" + Current.player().getBlessing().getDescription());
            } else {
                this.blessingScroll.setText("[BLACK]No blessing.");
            }
        }
        for (Map.Entry<String, Pair<Integer, Integer>> entry : Current.player().getStatistic().getWinLossRecord().entrySet()) {
            EnemyData data = WorldData.getEnemy(entry.getKey());
            if (data == null) continue;
            Image enemyImage = new Image(new EnemySprite(data).getAvatar());
            enemyImage.setScaling(Scaling.stretch);
            this.scrollContainer.add(enemyImage).pad(5.0f).size(16.0f).fillY();
            this.scrollContainer.add().width(16.0f);
            this.scrollContainer.add(data.getName()).fillX().pad(5.0f).width(120.0f);
            this.scrollContainer.add(entry.getValue().getLeft().toString() + "/" + entry.getValue().getRight().toString()).pad(5.0f);
            this.scrollContainer.row();
        }
        this.performTouch(this.scrollPaneOfActor(this.scrollContainer));
    }

    void updateAchievements(AchievementCollection achievementCollection, boolean isActive) {
        for (Achievement a : achievementCollection) {
            float alpha;
            GameType g2;
            if (isActive ? !a.isActive() : (g2 = GameType.smartValueOf(a.getKey())) != null) continue;
            a.updateTrophyImage();
            TextureRegion textureRegion = new TextureRegion(((FBufferedImage)a.getImage()).getTexture());
            textureRegion.flip(false, true);
            Image image = new Image(textureRegion);
            image.getColor().a = alpha = a.isActive() ? 1.0f : 0.25f;
            this.achievementContainer.add(image).height(50.0f).width(40.0f).center().pad(5.0f);
            String value = "[%105]" + a.getDisplayName() + "[%98]";
            String subTitle = a.getSubTitle(true);
            if (subTitle != null) {
                value = value + "\n" + subTitle;
            }
            TextraLabel label = Controls.newTextraLabel(value);
            label.getColor().a = alpha;
            this.achievementContainer.add(label).left().pad(5.0f);
            this.achievementContainer.row();
        }
    }

    public boolean quests() {
        Forge.switchScene(QuestLogScene.instance(this.lastGameScene), true);
        return true;
    }

    @Override
    public boolean back() {
        Forge.switchScene(this.lastGameScene == null ? GameScene.instance() : this.lastGameScene);
        return true;
    }
}

