/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.github.tommyettinger.textra.TextraLabel;
import forge.Forge;
import forge.adventure.data.DialogData;
import forge.adventure.data.DifficultyData;
import forge.adventure.data.HeroListData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.scene.GameScene;
import forge.adventure.scene.MenuScene;
import forge.adventure.scene.StartScene;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.AdventureModes;
import forge.adventure.util.Config;
import forge.adventure.util.Selector;
import forge.adventure.util.UIActor;
import forge.adventure.world.WorldSave;
import forge.card.CardEdition;
import forge.card.ColorSet;
import forge.deck.DeckProxy;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.player.GamePlayerUtil;
import forge.screens.TransitionScreen;
import forge.sound.SoundSystem;
import forge.util.NameGenerator;
import java.util.Random;

public class NewGameScene
extends MenuScene {
    TextField selectedName;
    ColorSet[] colorIds;
    CardEdition[] editionIds;
    private final Image avatarImage;
    private int avatarIndex = 0;
    private final Selector race;
    private final Selector colorId;
    private final Selector gender;
    private final Selector mode;
    private final Selector difficulty;
    private final Selector starterEdition;
    private final TextraLabel starterEditionLabel;
    private final Array<String> custom;
    private final TextraLabel colorLabel;
    private final ImageButton difficultyHelp;
    private DialogData difficultySummary;
    private final ImageButton modeHelp;
    private DialogData modeSummary;
    private final Random rand = new Random();
    private final Array<AdventureModes> modes = new Array();
    private static NewGameScene object;
    float avatarT = 1.0f;
    float avatarTT = 1.0f;
    float nameT = 1.0f;
    float nameTT = 1.0f;
    boolean started = false;

    private NewGameScene() {
        super(Forge.isLandscapeMode() ? "ui/new_game.json" : "ui/new_game_portrait.json");
        this.gender = (Selector)this.ui.findActor("gender");
        this.selectedName = (TextField)this.ui.findActor("nameField");
        this.generateName();
        this.avatarImage = (Image)this.ui.findActor("avatarPreview");
        this.mode = (Selector)this.ui.findActor("mode");
        this.modeHelp = (ImageButton)this.ui.findActor("modeHelp");
        this.colorLabel = (TextraLabel)this.ui.findActor("colorIdL");
        String colorIdLabel = this.colorLabel.storedText;
        this.custom = new Array();
        this.colorId = (Selector)this.ui.findActor("colorId");
        String[] colorSet = Config.instance().colorIds();
        String[] colorIdNames = Config.instance().colorIdNames();
        this.colorIds = new ColorSet[colorSet.length];
        for (int i = 0; i < this.colorIds.length; ++i) {
            this.colorIds[i] = ColorSet.fromNames(colorSet[i].toCharArray());
        }
        Array<String> colorNames = new Array<String>(this.colorIds.length);
        for (String idName : colorIdNames) {
            colorNames.add(UIActor.localize(idName));
        }
        this.colorId.setTextList(colorNames);
        Object[] objectArray = Config.instance().getConfigData().difficulties;
        int n = objectArray.length;
        int n2 = 0;
        if (n2 < n) {
            String[] diff = objectArray[n2];
            if (diff.starterDecks != null) {
                this.modes.add(AdventureModes.Standard);
                AdventureModes.Standard.setSelectionName(colorIdLabel);
                AdventureModes.Standard.setModes(colorNames);
            }
            if (diff.constructedStarterDecks != null) {
                this.modes.add(AdventureModes.Constructed);
                AdventureModes.Constructed.setSelectionName(colorIdLabel);
                AdventureModes.Constructed.setModes(colorNames);
            }
            if (diff.pileDecks != null) {
                this.modes.add(AdventureModes.Pile);
                AdventureModes.Pile.setSelectionName(colorIdLabel);
                AdventureModes.Pile.setModes(colorNames);
            }
        }
        this.starterEdition = (Selector)this.ui.findActor("starterEdition");
        this.starterEditionLabel = (TextraLabel)this.ui.findActor("starterEditionL");
        String[] starterEditions = Config.instance().starterEditions();
        String[] starterEditionNames = Config.instance().starterEditionNames();
        this.editionIds = new CardEdition[starterEditions.length];
        for (int i = 0; i < this.editionIds.length; ++i) {
            this.editionIds[i] = FModel.getMagicDb().getEditions().get(starterEditions[i]);
        }
        Array<String> editionNames = new Array<String>(this.editionIds.length);
        for (String editionName : starterEditionNames) {
            editionNames.add(UIActor.localize(editionName));
        }
        this.starterEdition.setTextList(editionNames);
        this.modes.add(AdventureModes.Chaos);
        AdventureModes.Chaos.setSelectionName("[BLACK]" + Forge.getLocalizer().getMessage("lblDeck", new Object[0]) + ":");
        AdventureModes.Chaos.setModes(new Array<String>(new String[]{Forge.getLocalizer().getMessage("lblRandomDeck", new Object[0])}));
        for (DeckProxy deckProxy : DeckProxy.getAllCustomStarterDecks()) {
            this.custom.add(deckProxy.getName());
        }
        if (!this.custom.isEmpty()) {
            this.modes.add(AdventureModes.Custom);
            AdventureModes.Custom.setSelectionName("[BLACK]" + Forge.getLocalizer().getMessage("lblDeck", new Object[0]) + ":");
            AdventureModes.Custom.setModes(this.custom);
        }
        String[] modeNames = new String[this.modes.size];
        for (int i = 0; i < this.modes.size; ++i) {
            modeNames[i] = this.modes.get(i).getName();
        }
        this.mode.setTextList(modeNames);
        this.gender.setTextList(new String[]{Forge.getLocalizer().getMessage("lblMale", new Object[0]) + "[%120][CYAN] \u2642", Forge.getLocalizer().getMessage("lblFemale", new Object[0]) + "[%120][MAGENTA] \u2640"});
        this.gender.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                NewGameScene.this.nameTT = 0.8f;
                super.clicked(event, x, y);
            }
        });
        this.gender.addListener(event -> this.updateAvatar());
        this.mode.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                AdventureModes smode = (AdventureModes)((Object)NewGameScene.this.modes.get(NewGameScene.this.mode.getCurrentIndex()));
                NewGameScene.this.colorLabel.setText(smode.getSelectionName());
                NewGameScene.this.colorId.setTextList(smode.getModes());
                NewGameScene.this.starterEdition.setVisible(smode == AdventureModes.Standard);
                NewGameScene.this.starterEditionLabel.setVisible(smode == AdventureModes.Standard);
            }
        });
        this.race = (Selector)this.ui.findActor("race");
        this.race.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                NewGameScene.this.avatarTT = 0.7f;
                super.clicked(event, x, y);
            }
        });
        this.race.addListener(event -> this.updateAvatar());
        this.race.setTextList(HeroListData.getRaces());
        this.difficulty = (Selector)this.ui.findActor("difficulty");
        this.difficultyHelp = (ImageButton)this.ui.findActor("difficultyHelp");
        Array<String> diffList = new Array<String>(this.colorIds.length);
        int i = 0;
        int startingDifficulty = 0;
        for (DifficultyData diff : Config.instance().getConfigData().difficulties) {
            if (diff.startingDifficulty) {
                startingDifficulty = i;
            }
            diffList.add(Forge.getLocalizer().getMessageorUseDefault("lbl" + diff.name, diff.name, new Object[0]));
            ++i;
        }
        this.difficulty.setTextList(diffList);
        this.difficulty.setCurrentIndex(startingDifficulty);
        this.generateAvatar();
        this.gender.setCurrentIndex(this.rand.nextInt());
        this.colorId.setCurrentIndex(this.rand.nextInt());
        this.race.setCurrentIndex(this.rand.nextInt());
        this.ui.onButtonPress("back", this::back);
        this.ui.onButtonPress("start", this::start);
        this.ui.onButtonPress("leftAvatar", this::leftAvatar);
        this.ui.onButtonPress("rightAvatar", this::rightAvatar);
        this.difficultyHelp.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent e, float x, float y) {
                NewGameScene.this.showDifficultyHelp();
            }
        });
        this.modeHelp.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent e, float x, float y) {
                NewGameScene.this.showModeHelp();
            }
        });
    }

    public static NewGameScene instance() {
        if (object == null) {
            object = new NewGameScene();
        }
        return object;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.avatarT > this.avatarTT) {
            this.avatarTT += delta / 0.5f;
            this.generateAvatar();
        } else {
            this.avatarTT = this.avatarT;
        }
        if (this.nameT > this.nameTT) {
            this.nameTT += delta / 0.5f;
            this.generateName();
        } else {
            this.nameTT = this.nameT;
        }
    }

    private void generateAvatar() {
        this.avatarIndex = this.rand.nextInt();
        this.updateAvatar();
    }

    private void generateName() {
        String val = this.gender.getCurrentIndex() > 0 ? "Female" : "Male";
        this.selectedName.setText(NameGenerator.getRandomName(val, "Any", ""));
    }

    public boolean start() {
        if (this.started) {
            return true;
        }
        this.started = true;
        if (this.selectedName.getText().isEmpty()) {
            this.generateName();
        }
        Runnable runnable = () -> {
            this.started = false;
            WorldSave.generateNewWorld(this.selectedName.getText(), this.gender.getCurrentIndex() == 0, this.race.getCurrentIndex(), this.avatarIndex, this.colorIds[this.custom.isEmpty() || !AdventureModes.Custom.equals((Object)this.modes.get(this.mode.getCurrentIndex())) ? this.colorId.getCurrentIndex() : 0], Config.instance().getConfigData().difficulties[this.difficulty.getCurrentIndex()], this.modes.get(this.mode.getCurrentIndex()), this.colorId.getCurrentIndex(), this.editionIds[this.starterEdition.getCurrentIndex()], 0L);
            GamePlayerUtil.getGuiPlayer().setName(this.selectedName.getText());
            SoundSystem.instance.changeBackgroundTrack();
            WorldStage.getInstance().setDirectlyEnterPOI();
            if (AdventurePlayer.current().getQuests().stream().noneMatch(q -> q.getID() == 28)) {
                AdventurePlayer.current().addQuest("28");
            }
            Forge.switchScene(GameScene.instance());
        };
        Forge.setTransitionScreen(new TransitionScreen(runnable, null, false, true, Forge.getLocalizer().getMessage("lblGeneratingWorld", new Object[0])));
        return true;
    }

    @Override
    public boolean back() {
        Forge.switchScene(StartScene.instance());
        return true;
    }

    private void rightAvatar() {
        ++this.avatarIndex;
        this.updateAvatar();
    }

    private void leftAvatar() {
        --this.avatarIndex;
        this.updateAvatar();
    }

    private boolean updateAvatar() {
        this.avatarImage.setDrawable(new TextureRegionDrawable(HeroListData.getAvatar(this.race.getCurrentIndex(), this.gender.getCurrentIndex() != 0, this.avatarIndex)));
        return false;
    }

    @Override
    public void enter() {
        this.updateAvatar();
        if (Forge.createNewAdventureMap) {
            FModel.getPreferences().setPref(ForgePreferences.FPref.UI_ENABLE_MUSIC, false);
            WorldSave.generateNewWorld(this.selectedName.getText(), this.gender.getCurrentIndex() == 0, this.race.getCurrentIndex(), this.avatarIndex, this.colorIds[this.colorId.getCurrentIndex()], Config.instance().getConfigData().difficulties[this.difficulty.getCurrentIndex()], this.modes.get(this.mode.getCurrentIndex()), this.colorId.getCurrentIndex(), this.editionIds[this.starterEdition.getCurrentIndex()], 0L);
            GamePlayerUtil.getGuiPlayer().setName(this.selectedName.getText());
            Forge.switchScene(GameScene.instance());
        }
        this.unselectActors();
        super.enter();
    }

    private void showDifficultyHelp() {
        DifficultyData selectedDifficulty = Config.instance().getConfigData().difficulties[this.difficulty.getCurrentIndex()];
        this.difficultySummary = new DialogData();
        this.difficultySummary.name = "Summary";
        switch (selectedDifficulty.name) {
            case "Easy": {
                this.difficultySummary.text = String.format("Difficulty: %s\nFor newer players or those who want a relaxed experience.\nStarter decks are monocolored.\nStarting equipment: Manasight Amulet, Leather Boots", selectedDifficulty.name);
                break;
            }
            case "Normal": {
                this.difficultySummary.text = String.format("Difficulty: %s\nHow Adventure Mode is intended to be played.\nStarter decks will include a second color.\nStarting equipment: Leather Boots", selectedDifficulty.name);
                break;
            }
            case "Hard": {
                this.difficultySummary.text = String.format("Difficulty: %s\nFor players who want a challenge.\nSome enemies will use genetic AI decks.\nStarter decks will include 2-3 colors.\nStarting equipment: None", selectedDifficulty.name);
                break;
            }
            case "Insane": {
                this.difficultySummary.text = String.format("Difficulty: %s\nFor players who don't want to like the game.\nIdentical to Hard difficulty, but with even less forgiving and rewarding results.\nStarter decks will include 2-3 colors.\nStarting equipment: None", selectedDifficulty.name);
                break;
            }
            default: {
                this.difficultySummary.text = "((Custom difficulty settings))";
            }
        }
        DialogData dismiss = new DialogData();
        dismiss.name = "OK";
        DialogData matchImpacts = new DialogData();
        matchImpacts.text = String.format("Difficulty: %s\nStarting Life: %d\nEnemy Health: %d%%\nGold loss on defeat: %d%%\nLife loss on defeat: %d%%", selectedDifficulty.name, selectedDifficulty.startingLife, (int)(selectedDifficulty.enemyLifeFactor * 100.0f), (int)(selectedDifficulty.goldLoss * 100.0f), (int)(selectedDifficulty.lifeLoss * 100.0f));
        matchImpacts.name = "Duels";
        DialogData economyImpacts = new DialogData();
        economyImpacts.text = String.format("Difficulty: %s\nStarting Gold: %d\nStarting Mana Shards: %d\nCard Sale Price: %d%%\nMana Shard Sale Price: %d%%\nRandom loot rate: %d%%", selectedDifficulty.name, selectedDifficulty.staringMoney, selectedDifficulty.startingShards, (int)(selectedDifficulty.sellFactor * 100.0f), (int)(selectedDifficulty.shardSellRatio * 100.0f), (int)(selectedDifficulty.rewardMaxFactor * 100.0f));
        economyImpacts.name = "Economy";
        this.difficultySummary.options = new DialogData[3];
        this.difficultySummary.options[0] = matchImpacts;
        this.difficultySummary.options[1] = economyImpacts;
        this.difficultySummary.options[2] = dismiss;
        matchImpacts.options = new DialogData[3];
        matchImpacts.options[0] = this.difficultySummary;
        matchImpacts.options[1] = economyImpacts;
        matchImpacts.options[2] = dismiss;
        economyImpacts.options = new DialogData[3];
        economyImpacts.options[0] = this.difficultySummary;
        economyImpacts.options[1] = matchImpacts;
        economyImpacts.options[2] = dismiss;
        this.loadDialog(this.difficultySummary);
    }

    private void showModeHelp() {
        AdventureModes selectedMode = this.modes.get(this.mode.getCurrentIndex());
        DifficultyData selectedDifficulty = Config.instance().getConfigData().difficulties[this.difficulty.getCurrentIndex()];
        this.modeSummary = new DialogData();
        this.modeSummary.name = "Summary";
        StringBuilder summaryText = new StringBuilder();
        block0 : switch (selectedMode) {
            case Standard: {
                summaryText.append("Mode: Standard\n\nYour starting deck is built from 2-3 Jumpstart packs of twenty cards each.\n\n");
                switch (selectedDifficulty.name) {
                    case "Easy": {
                        summaryText.append("On your currently selected difficulty, Easy, you will receive three jumpstart packs of your chosen color.");
                        break block0;
                    }
                    case "Normal": {
                        summaryText.append("On your currently selected difficulty, Normal, you will receive two jumpstart packs of your chosen color and one of an allied color.");
                        break block0;
                    }
                    case "Hard": {
                        summaryText.append("On your currently selected difficulty, Hard, you will receive one jumpstart pack of your chosen color and one of an allied color.");
                        break block0;
                    }
                    case "Insane": {
                        summaryText.append("On your currently selected difficulty, Insane, you will receive one jumpstart pack of your chosen color and one of an allied color.");
                        break block0;
                    }
                }
                this.difficultySummary.text = "((Cannot determine starter deck based on custom difficulty settings))";
                break;
            }
            case Constructed: {
                summaryText.append("Mode: Constructed\n\nYou will receive a specific preconstructed deck based on your chosen color and difficulty.\n\n");
                switch (selectedDifficulty.name) {
                    case "Easy": {
                        summaryText.append("On your currently selected difficulty, Easy, your deck will only contain your chosen color.");
                        break block0;
                    }
                    case "Normal": {
                        summaryText.append("On your currently selected difficulty, Normal, your deck will contain your chosen color and one allied color.");
                        break block0;
                    }
                    case "Hard": {
                        summaryText.append("On your currently selected difficulty, Hard, your deck will contain your chosen color and one opposing color.");
                        break block0;
                    }
                    case "Insane": {
                        summaryText.append("On your currently selected difficulty, Insane, your deck will contain your chosen color and one opposing color.");
                        break block0;
                    }
                }
                this.difficultySummary.text = "((Cannot determine starter deck based on custom difficulty settings))";
                break;
            }
            case Pile: {
                summaryText.append("Mode: Pile\n\nYou will receive a random pile of cards based on your chosen color and difficulty.\n\n");
                switch (selectedDifficulty.name) {
                    case "Easy": {
                        summaryText.append("On your currently selected difficulty, Easy, your deck will only contain your chosen color and one allied color.");
                        break block0;
                    }
                    case "Normal": {
                        summaryText.append("On your currently selected difficulty, Normal, your deck will contain your chosen color and two allied colors.");
                        break block0;
                    }
                    case "Hard": {
                        summaryText.append("On your currently selected difficulty, Hard, your deck will contain your chosen color and two allied colors.\n\n");
                        summaryText.append("You will receive less uncommon and rare cards than on Normal difficulty.");
                        break block0;
                    }
                    case "Insane": {
                        summaryText.append("On your currently selected difficulty, Insane, your deck will contain your chosen color and two allied colors.\n\n");
                        summaryText.append("You will receive less uncommon and rare cards than on Normal difficulty.");
                        break block0;
                    }
                }
                this.difficultySummary.text = "((Cannot determine starter deck based on custom difficulty settings))";
                break;
            }
            case Chaos: {
                summaryText.append("Mode: Chaos\n\nYou (and all enemies) will receive a random preconstructed deck.\n\nWarning: This will make encounter difficulty vary wildly from the developers' intent");
                break;
            }
            case Custom: {
                summaryText.append("Mode: Custom\n\nChoose your own preconstructed deck. Enemies can receive a random genetic AI deck (difficult).\n\nWarning: This will make encounter difficulty vary wildly from the developers' intent");
                break;
            }
            default: {
                summaryText.append("No summary available for your this game mode.");
            }
        }
        DialogData dismiss = new DialogData();
        dismiss.name = "OK";
        this.modeSummary.text = summaryText.toString();
        this.modeSummary.options = new DialogData[1];
        this.modeSummary.options[0] = dismiss;
        this.loadDialog(this.modeSummary);
    }
}

