/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Timer;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TypingAdapter;
import com.github.tommyettinger.textra.TypingLabel;
import forge.Forge;
import forge.adventure.data.DialogData;
import forge.adventure.data.RewardData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.scene.RewardScene;
import forge.adventure.scene.UIScene;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.util.Reward;
import forge.card.ColorSet;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.List;

public class MenuScene
extends UIScene {
    protected final Dialog dialog;
    private final Array<TextraButton> dialogButtonMap = new Array();
    protected List<ChangeListener> dialogCompleteList = new ArrayList<ChangeListener>();

    public MenuScene(String uiFilePath) {
        super(uiFilePath);
        this.dialog = Controls.newDialog("");
    }

    public Dialog getDialog() {
        return this.dialog;
    }

    public boolean activate(Array<DialogData> data) {
        boolean dialogShown = false;
        if (data != null) {
            for (DialogData dialog : data) {
                if (!this.isConditionOk(dialog.condition)) continue;
                this.loadDialog(dialog);
                dialogShown = true;
            }
        }
        return dialogShown;
    }

    void setEffects(DialogData.ActionData[] data) {
        if (data == null) {
            return;
        }
        for (DialogData.ActionData E : data) {
            if (E == null) continue;
            if (E.removeItem != null && !E.removeItem.isEmpty()) {
                Current.player().removeItem(E.removeItem);
            }
            if (E.addItem != null && !E.addItem.isEmpty()) {
                Current.player().addItem(E.addItem);
            }
            if (E.addLife != 0) {
                Current.player().heal(E.addLife);
            }
            if (E.addGold != 0) {
                if (E.addGold > 0) {
                    Current.player().giveGold(E.addGold);
                } else {
                    Current.player().takeGold(-E.addGold);
                }
            }
            if (E.addShards != 0) {
                if (E.addShards > 0) {
                    Current.player().addShards(E.addShards);
                } else {
                    Current.player().takeShards(-E.addShards);
                }
            }
            if (E.giveBlessing != null) {
                Current.player().addBlessing(E.giveBlessing);
            }
            if (E.setColorIdentity != null && !E.setColorIdentity.isEmpty()) {
                Current.player().setColorIdentity(E.setColorIdentity);
            }
            if (E.setCharacterFlag != null && !E.setCharacterFlag.key.isEmpty()) {
                Current.player().setCharacterFlag(E.setCharacterFlag.key, E.setCharacterFlag.val);
            }
            if (E.advanceCharacterFlag != null && !E.advanceCharacterFlag.isEmpty()) {
                Current.player().advanceCharacterFlag(E.advanceCharacterFlag);
            }
            if (E.setQuestFlag != null && !E.setQuestFlag.key.isEmpty()) {
                Current.player().setQuestFlag(E.setQuestFlag.key, E.setQuestFlag.val);
            }
            if (E.advanceQuestFlag != null && !E.advanceQuestFlag.isEmpty()) {
                Current.player().advanceQuestFlag(E.advanceQuestFlag);
            }
            if (E.grantRewards == null || E.grantRewards.length <= 0) continue;
            Array<Reward> ret = new Array<Reward>();
            for (RewardData rdata : E.grantRewards) {
                ret.addAll(rdata.generate(false, true));
            }
            RewardScene.instance().loadRewards(ret, RewardScene.Type.QuestReward, null);
            Forge.switchScene(RewardScene.instance());
        }
    }

    void loadDialog(DialogData dialog) {
        this.setEffects(dialog.action);
        Dialog D = this.getDialog();
        Localizer L = Forge.getLocalizer();
        D.getTitleTable().clear();
        D.getContentTable().clear();
        D.getButtonTable().clear();
        D.clearListeners();
        String text = dialog.loctext != null && !dialog.loctext.isEmpty() ? L.getMessage(dialog.loctext, new Object[0]) : dialog.text;
        final TypingLabel A2 = Controls.newTypingLabel(text);
        A2.setWrap(true);
        final Array<TextraButton> buttons = new Array<TextraButton>();
        A2.setTypingListener(new TypingAdapter(){

            @Override
            public void end() {
                float delay = 0.09f;
                for (final TextraButton button : buttons) {
                    Timer.schedule(new Timer.Task(){

                        @Override
                        public void run() {
                            button.setVisible(true);
                        }
                    }, delay);
                    delay += 0.1f;
                }
            }
        });
        float width = 250.0f;
        D.getContentTable().add(A2).width(width);
        if (dialog.options != null) {
            int i = 0;
            for (DialogData option : dialog.options) {
                if (!this.isConditionOk(option.condition)) continue;
                String name = option.locname != null && !option.locname.isEmpty() ? L.getMessage(option.locname, new Object[0]) : option.name;
                TextraButton B = Controls.newTextButton(name, () -> {
                    this.loadDialog(option);
                    if (option.callback != null) {
                        option.callback.run(true);
                    }
                });
                B.getTextraLabel().setWrap(true);
                buttons.add(B);
                B.setVisible(false);
                D.getButtonTable().add(B).width(width - 10.0f);
                D.getButtonTable().row();
                ++i;
            }
            D.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    A2.skipToTheEnd();
                    super.clicked(event, x, y);
                }
            });
            if (i == 0) {
                this.hideDialog();
                this.emitDialogFinished();
            } else {
                this.showDialog(this.getDialog());
            }
        } else {
            this.hideDialog();
        }
    }

    public void addDialogCompleteListener(ChangeListener listener) {
        this.dialogCompleteList.add(listener);
    }

    private void emitDialogFinished() {
        if (this.dialogCompleteList != null && this.dialogCompleteList.size() > 0) {
            ChangeListener.ChangeEvent evt = new ChangeListener.ChangeEvent();
            for (ChangeListener listener : this.dialogCompleteList) {
                listener.changed(evt, null);
            }
        }
    }

    public boolean isConditionOk(DialogData.ConditionData[] data) {
        if (data == null) {
            return true;
        }
        AdventurePlayer player = Current.player();
        for (DialogData.ConditionData condition : data) {
            int QF;
            int val;
            String cond;
            String key;
            if (condition.item != null && !condition.item.isEmpty() && (!player.hasItem(condition.item) ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.colorIdentity != null && !condition.colorIdentity.isEmpty() && (player.getColorIdentity().hasAllColors(ColorSet.fromNames(condition.colorIdentity.toCharArray()).getColor()) ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.hasGold != 0 && (player.getGold() < condition.hasGold ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.hasShards != 0 && (player.getShards() < condition.hasShards ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.hasLife != 0 && (player.getLife() < condition.hasLife + 1 ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.hasBlessing != null && !condition.hasBlessing.isEmpty() && (!player.hasBlessing(condition.hasBlessing) ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.getQuestFlag != null) {
                key = condition.getQuestFlag.key;
                cond = condition.getQuestFlag.op;
                val = condition.getQuestFlag.val;
                QF = player.getQuestFlag(key);
                if (!player.checkQuestFlag(key)) {
                    return false;
                }
                if (!this.checkFlagCondition(QF, cond, val) ? !condition.not : condition.not) {
                    return false;
                }
            }
            if (condition.checkQuestFlag != null && !condition.checkQuestFlag.isEmpty() && (!player.checkQuestFlag(condition.checkQuestFlag) ? !condition.not : condition.not)) {
                return false;
            }
            if (condition.getCharacterFlag != null) {
                key = condition.getCharacterFlag.key;
                cond = condition.getCharacterFlag.op;
                val = condition.getCharacterFlag.val;
                QF = player.getCharacterFlag(key);
                if (!player.checkCharacterFlag(key)) {
                    return false;
                }
                if (!this.checkFlagCondition(QF, cond, val) ? !condition.not : condition.not) {
                    return false;
                }
            }
            if (condition.checkCharacterFlag == null || condition.checkCharacterFlag.isEmpty() || !(!player.checkCharacterFlag(condition.checkCharacterFlag) ? !condition.not : condition.not)) continue;
            return false;
        }
        return true;
    }

    private boolean checkFlagCondition(int flag, String condition, int value) {
        switch (condition.toUpperCase()) {
            default: {
                if (flag == value) {
                    return true;
                }
            }
            case "LESSTHAN": 
            case "<": {
                if (flag < value) {
                    return true;
                }
            }
            case "MORETHAN": 
            case ">": {
                if (flag > value) {
                    return true;
                }
            }
            case "LE_THAN": 
            case "<=": {
                if (flag > value) break;
                return true;
            }
            case "ME_THAN": 
            case ">=": 
        }
        return flag >= value;
    }

    public void showDialog(Array<DialogData> data) {
        if (!this.activate(data)) {
            return;
        }
        this.dialogButtonMap.clear();
        for (int i = 0; i < this.dialog.getButtonTable().getCells().size; ++i) {
            this.dialogButtonMap.add((TextraButton)this.dialog.getButtonTable().getCells().get(i).getActor());
        }
        this.dialog.show(this.stage, Actions.show());
        this.dialog.setPosition((this.stage.getWidth() - this.dialog.getWidth()) / 2.0f, (this.stage.getHeight() - this.dialog.getHeight()) / 2.0f);
        if (Forge.hasGamepad() && !this.dialogButtonMap.isEmpty()) {
            this.stage.setKeyboardFocus(this.dialogButtonMap.first());
        }
    }

    public void hideDialog() {
        this.dialog.hide();
        this.dialog.clearListeners();
    }
}

