/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.SnapshotArray;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import forge.Forge;
import forge.adventure.data.ItemData;
import forge.adventure.scene.RewardScene;
import forge.adventure.scene.UIScene;
import forge.adventure.stage.ConsoleCommandInterpreter;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.MapStage;
import forge.adventure.util.AdventureQuestController;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.util.MapDialog;
import forge.deck.Deck;
import forge.deck.DeckBase;
import java.util.HashMap;
import java.util.Map;

public class InventoryScene
extends UIScene {
    TextraButton leave;
    Button equipButton;
    TextraButton useButton;
    TextraLabel itemDescription;
    private final Table inventory;
    private final Array<Button> inventoryButtons = new Array();
    private final HashMap<String, Button> equipmentSlots = new HashMap();
    HashMap<Button, String> itemLocation = new HashMap();
    HashMap<Button, Deck> deckLocation = new HashMap();
    Button selected;
    Button deleteButton;
    Texture equipOverlay = Forge.getAssets().getTexture(Config.instance().getFile("skin/equip.png"));
    Dialog useDialog;
    Dialog deleteDialog;
    Dialog openDialog;
    int columns = 0;
    private static InventoryScene object;

    public InventoryScene() {
        super(Forge.isLandscapeMode() ? "ui/inventory.json" : "ui/inventory_portrait.json");
        this.ui.onButtonPress("return", this::done);
        this.leave = (TextraButton)this.ui.findActor("return");
        this.ui.onButtonPress("delete", this::showConfirm);
        this.ui.onButtonPress("equip", this::equip);
        this.ui.onButtonPress("use", this::use);
        this.equipButton = (Button)this.ui.findActor("equip");
        this.useButton = (TextraButton)this.ui.findActor("use");
        this.useButton.setDisabled(true);
        this.deleteButton = (Button)this.ui.findActor("delete");
        this.itemDescription = (TextraLabel)this.ui.findActor("item_description");
        this.itemDescription.setAlignment(10);
        this.itemDescription.setWrap(true);
        ScrollPane pane = new ScrollPane((Actor)this.itemDescription);
        pane.setBounds(this.itemDescription.getX(), this.itemDescription.getY(), this.itemDescription.getWidth() - 5.0f, this.itemDescription.getHeight() - 8.0f);
        this.ui.addActor(pane);
        SnapshotArray<Actor> children = this.ui.getChildren();
        int n = children.size;
        for (int i = 0; i < n; ++i) {
            if (((Actor)children.get(i)).getName() == null || !((Actor)children.get(i)).getName().startsWith("Equipment")) continue;
            final String slotName = ((Actor)children.get(i)).getName().split("_")[1];
            this.equipmentSlots.put(slotName, (Button)children.get(i));
            Actor slot = (Actor)children.get(i);
            slot.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    Button button = (Button)actor;
                    if (button.isChecked()) {
                        for (Button otherButton : InventoryScene.this.equipmentSlots.values()) {
                            if (button == otherButton || !otherButton.isChecked()) continue;
                            otherButton.setChecked(false);
                        }
                        String item = Current.player().itemInSlot(slotName);
                        if (item != null && !item.isEmpty()) {
                            Button changeButton = null;
                            for (Button invButton : InventoryScene.this.inventoryButtons) {
                                if (InventoryScene.this.itemLocation.get(invButton) == null || !InventoryScene.this.itemLocation.get(invButton).equals(item)) continue;
                                changeButton = invButton;
                                break;
                            }
                            if (changeButton != null) {
                                changeButton.setChecked(true);
                            }
                        } else {
                            InventoryScene.this.setSelected(null);
                        }
                    }
                }
            });
        }
        this.inventory = new Table(Controls.getSkin());
        ScrollPane scrollPane = (ScrollPane)this.ui.findActor("inventory");
        scrollPane.setScrollingDisabled(true, false);
        scrollPane.setActor(this.inventory);
        this.columns = (int)(scrollPane.getWidth() / this.createInventorySlot().getWidth());
        --this.columns;
        if (this.columns <= 0) {
            this.columns = 1;
        }
        scrollPane.setActor(this.inventory);
    }

    private void showConfirm() {
        if (this.deleteDialog == null) {
            this.deleteDialog = this.createGenericDialog("", Forge.getLocalizer().getMessage("lblDelete", new Object[0]), Forge.getLocalizer().getMessage("lblYes", new Object[0]), Forge.getLocalizer().getMessage("lblNo", new Object[0]), () -> {
                this.delete();
                this.removeDialog();
            }, this::removeDialog);
        }
        this.showDialog(this.deleteDialog);
    }

    public static InventoryScene instance() {
        if (object == null) {
            object = new InventoryScene();
        }
        return object;
    }

    public void done() {
        GameHUD.getInstance().getTouchpad().setVisible(false);
        Forge.switchToLast();
    }

    public void delete() {
        ItemData data = ItemData.getItem(this.itemLocation.get(this.selected));
        if (data != null) {
            Current.player().removeItem(data.name);
        }
        this.updateInventory();
    }

    public void equip() {
        if (this.selected == null) {
            return;
        }
        ItemData data = ItemData.getItem(this.itemLocation.get(this.selected));
        if (data == null) {
            return;
        }
        Current.player().equip(data);
        this.updateInventory();
    }

    @Override
    public void act(float delta) {
        this.stage.act(delta);
    }

    private void triggerUse() {
        if (this.selected == null) {
            return;
        }
        ItemData data = ItemData.getItem(this.itemLocation.get(this.selected));
        if (data == null) {
            return;
        }
        Current.player().addShards(-data.shardsNeeded);
        this.done();
        if (data.commandOnUse != null && !data.commandOnUse.isEmpty()) {
            ConsoleCommandInterpreter.getInstance().command(data.commandOnUse);
        }
        if (data.dialogOnUse != null && data.dialogOnUse.text != null && !data.dialogOnUse.text.isEmpty()) {
            MapDialog dialog = new MapDialog(data.dialogOnUse, MapStage.getInstance(), 0, null);
            MapStage.getInstance().showDialog();
            dialog.activate();
            ChangeListener listen = new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                    AdventureQuestController.instance().showQuestDialogs(MapStage.getInstance());
                }
            };
            dialog.addDialogCompleteListener(listen);
        }
        AdventureQuestController.instance().updateItemUsed(data);
    }

    private void openBooster() {
        if (this.selected == null) {
            return;
        }
        Deck data = this.deckLocation.get(this.selected);
        if (data == null) {
            return;
        }
        this.done();
        this.setSelected(null);
        RewardScene.instance().loadRewards(data, RewardScene.Type.Loot, null, data.getTags().contains("noSell"));
        Forge.switchScene(RewardScene.instance());
        Current.player().getBoostersOwned().removeValue(data, true);
    }

    private void use() {
        Object data;
        if (this.itemLocation.containsKey(this.selected)) {
            data = ItemData.getItem(this.itemLocation.get(this.selected));
            if (data == null) {
                return;
            }
            if (this.useDialog == null) {
                this.useDialog = this.createGenericDialog("", null, Forge.getLocalizer().getMessage("lblYes", new Object[0]), Forge.getLocalizer().getMessage("lblNo", new Object[0]), () -> {
                    this.triggerUse();
                    this.removeDialog();
                }, this::removeDialog);
                this.useDialog.getContentTable().add(Controls.newTextraLabel("Use " + ((ItemData)data).name + "?\n" + ((ItemData)data).getDescription()));
            }
            this.showDialog(this.useDialog);
        }
        if (this.deckLocation.containsKey(this.selected)) {
            data = this.deckLocation.get(this.selected);
            if (data == null) {
                return;
            }
            if (this.openDialog == null) {
                this.openDialog = this.createGenericDialog("", null, Forge.getLocalizer().getMessage("lblYes", new Object[0]), Forge.getLocalizer().getMessage("lblNo", new Object[0]), () -> {
                    this.openBooster();
                    this.removeDialog();
                }, this::removeDialog);
                this.openDialog.getContentTable().add(Controls.newTextraLabel("Open Booster Pack?"));
            }
            this.showDialog(this.openDialog);
        }
    }

    public void clearItemDescription() {
        this.itemDescription.setText("");
    }

    private void setSelected(Button actor) {
        Object data;
        this.selected = actor;
        if (actor == null) {
            this.clearItemDescription();
            this.deleteButton.setDisabled(true);
            this.equipButton.setDisabled(true);
            this.useButton.setDisabled(true);
            for (Button button : this.inventoryButtons) {
                button.setChecked(false);
            }
            return;
        }
        if (this.itemLocation.containsKey(actor)) {
            data = ItemData.getItem(this.itemLocation.get(actor));
            if (data == null) {
                return;
            }
            this.deleteButton.setDisabled(((ItemData)data).questItem);
            boolean isInPoi = MapStage.getInstance().isInMap();
            this.useButton.setDisabled(!(isInPoi && ((ItemData)data).usableInPoi || !isInPoi && ((ItemData)data).usableOnWorldMap));
            if (((ItemData)data).shardsNeeded == 0) {
                this.useButton.setText("Use");
            } else {
                this.useButton.setText("Use " + ((ItemData)data).shardsNeeded + "[+Shards]");
            }
            this.useButton.layout();
            if (Current.player().getShards() < ((ItemData)data).shardsNeeded) {
                this.useButton.setDisabled(true);
            }
            if (((ItemData)data).equipmentSlot == null || ((ItemData)data).equipmentSlot.isEmpty() || ((ItemData)data).isCracked) {
                this.equipButton.setDisabled(true);
            } else {
                this.equipButton.setDisabled(false);
                if (this.equipButton instanceof TextraButton) {
                    TextraButton button = (TextraButton)this.equipButton;
                    String item = Current.player().itemInSlot(((ItemData)data).equipmentSlot);
                    if (item != null && item.equals(((ItemData)data).name)) {
                        button.setText("Unequip");
                    } else {
                        button.setText("Equip");
                    }
                    button.layout();
                }
            }
            String status = ((ItemData)data).isCracked ? " (" + Forge.getLocalizer().getMessage("lblCracked", new Object[0]) + ")" : "";
            this.itemDescription.setText(((ItemData)data).name + status + "\n[%98]" + ((ItemData)data).getDescription());
        } else if (this.deckLocation.containsKey(actor)) {
            data = this.deckLocation.get(actor);
            if (data == null) {
                return;
            }
            this.deleteButton.setDisabled(true);
            this.useButton.setDisabled(false);
            this.useButton.setText("Open");
            this.useButton.layout();
            this.equipButton.setDisabled(true);
            this.itemDescription.setText("Card Pack - " + ((DeckBase)data).getName() + "\n[%98]" + (((DeckBase)data).getComment() == null ? "" : ((DeckBase)data).getComment() + " - ") + ((Deck)data).getAllCardsInASinglePool().countAll() + " cards");
        }
        for (Button button : this.inventoryButtons) {
            if (actor == button || !button.isChecked()) continue;
            button.setChecked(false);
        }
        this.performTouch(this.scrollPaneOfActor(this.itemDescription));
    }

    private void updateInventory() {
        Image img;
        Button newActor;
        int i;
        this.clearSelectable();
        this.inventoryButtons.clear();
        this.inventory.clear();
        Current.player().getItems().sort();
        int itemSlotsUsed = 0;
        for (i = 0; i < Current.player().getItems().size; ++i) {
            if (i % this.columns == 0) {
                this.inventory.row();
            }
            newActor = this.createInventorySlot();
            this.inventory.add(newActor).top().left().space(1.0f);
            this.addToSelectable(new UIScene.Selectable(newActor){

                @Override
                public void onSelect(UIScene scene) {
                    InventoryScene.this.setSelected(newActor);
                    super.onSelect(scene);
                }
            });
            this.inventoryButtons.add(newActor);
            ItemData item = ItemData.getItem(Current.player().getItems().get(i));
            if (item == null) {
                System.err.print("Can not find item name " + Current.player().getItems().get(i) + "\n");
                continue;
            }
            if (item.sprite() == null) {
                System.err.print("Can not find sprite name " + item.iconName + "\n");
                continue;
            }
            Image img2 = new Image(item.sprite());
            img2.setX((newActor.getWidth() - img2.getWidth()) / 2.0f);
            img2.setY((newActor.getHeight() - img2.getHeight()) / 2.0f);
            newActor.addActor(img2);
            this.itemLocation.put(newActor, Current.player().getItems().get(i));
            if (Current.player().getEquippedItems().contains(item.name)) {
                Image overlay = new Image(this.equipOverlay);
                overlay.setX((newActor.getWidth() - img2.getWidth()) / 2.0f);
                overlay.setY((newActor.getHeight() - img2.getHeight()) / 2.0f);
                newActor.addActor(overlay);
            }
            newActor.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (((Button)actor).isChecked()) {
                        InventoryScene.this.setSelected((Button)actor);
                    }
                }
            });
            ++itemSlotsUsed;
        }
        for (i = 0; i < Current.player().getBoostersOwned().size; ++i) {
            if ((i + itemSlotsUsed) % this.columns == 0) {
                this.inventory.row();
            }
            newActor = this.createInventorySlot();
            this.inventory.add(newActor).top().left().space(1.0f);
            this.addToSelectable(new UIScene.Selectable(newActor){

                @Override
                public void onSelect(UIScene scene) {
                    InventoryScene.this.setSelected(newActor);
                    super.onSelect(scene);
                }
            });
            this.inventoryButtons.add(newActor);
            Deck deck = Current.player().getBoostersOwned().get(i);
            if (deck == null | deck.isEmpty()) {
                System.err.print("Can not add null / empty booster " + Current.player().getBoostersOwned().get(i) + "\n");
                continue;
            }
            Sprite deckSprite = Config.instance().getItemSprite("Deck");
            img = new Image(deckSprite);
            img.setX((newActor.getWidth() - img.getWidth()) / 2.0f);
            img.setY((newActor.getHeight() - img.getHeight()) / 2.0f);
            newActor.addActor(img);
            this.deckLocation.put(newActor, Current.player().getBoostersOwned().get(i));
            newActor.addListener(new ChangeListener(){

                @Override
                public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                    if (((Button)actor).isChecked()) {
                        InventoryScene.this.setSelected((Button)actor);
                    }
                }
            });
        }
        for (Map.Entry<String, Button> slot : this.equipmentSlots.entrySet()) {
            ItemData item;
            String equippedItem;
            if (slot.getValue().getChildren().size >= 2) {
                slot.getValue().removeActorAt(1, false);
            }
            if ((equippedItem = Current.player().itemInSlot(slot.getKey())) == null || equippedItem.isEmpty() || (item = ItemData.getItem(equippedItem)) == null) continue;
            img = new Image(item.sprite());
            img.setX((slot.getValue().getWidth() - img.getWidth()) / 2.0f);
            img.setY((slot.getValue().getHeight() - img.getHeight()) / 2.0f);
            slot.getValue().addActor(img);
        }
    }

    @Override
    public void enter() {
        this.updateInventory();
        super.enter();
    }

    public Button createInventorySlot() {
        return new ImageButton(Controls.getSkin(), "item_frame");
    }
}

