/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Scaling;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import com.github.tommyettinger.textra.TypingLabel;
import forge.Forge;
import forge.adventure.character.EnemySprite;
import forge.adventure.data.AdventureEventData;
import forge.adventure.data.DialogData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.scene.DeckEditScene;
import forge.adventure.scene.DeckPreviewScene;
import forge.adventure.scene.DraftScene;
import forge.adventure.scene.DuelScene;
import forge.adventure.scene.GameScene;
import forge.adventure.scene.MenuScene;
import forge.adventure.scene.Scene;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.IAfterMatch;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.AdventureEventController;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.world.WorldSave;
import forge.deck.Deck;
import forge.gui.FThreads;
import forge.screens.TransitionScreen;
import forge.util.Callback;
import forge.util.MyRandom;
import java.util.Arrays;
import java.util.List;

public class EventScene
extends MenuScene
implements IAfterMatch {
    TextraLabel money;
    TextraLabel shards;
    TextraButton advance;
    TextraButton back;
    TextraButton editDeck;
    TextraButton nextPage;
    TextraButton previousPage;
    private Table scrollContainer;
    ScrollPane scroller;
    Table root;
    Table headerTable;
    Table metaDraftTable;
    int pageIndex = 0;
    Scene lastGameScene;
    Table[] eventPages;
    static AdventureEventData currentEvent;
    static PointOfInterestChanges changes;
    private Array<DialogData> entryDialog;
    private int packsSelected = 0;
    private static EventScene object;
    AdventureEventData.AdventureEventMatch humanMatch = null;

    private EventScene() {
        super(Forge.isLandscapeMode() ? "ui/event.json" : "ui/event_portrait.json");
        DialogData.ActionData giveCoin;
        DialogData.ConditionData hasCoin;
        DialogData introDialog = new DialogData();
        introDialog.text = "Enter this event?";
        DialogData enterWithCoin = new DialogData();
        DialogData enterWithShards = new DialogData();
        enterWithShards.name = String.format("Spend %d [+shards]", Math.round((float)EventScene.currentEvent.eventRules.shardsToEnter * changes.getTownPriceModifier()));
        DialogData enterWithGold = new DialogData();
        enterWithGold.name = String.format("Spend %d [+gold]", Math.round((float)EventScene.currentEvent.eventRules.goldToEnter * changes.getTownPriceModifier()));
        DialogData.ConditionData hasGold = new DialogData.ConditionData();
        hasGold.hasGold = Math.round((float)EventScene.currentEvent.eventRules.goldToEnter * changes.getTownPriceModifier());
        enterWithGold.condition = new DialogData.ConditionData[]{hasGold};
        DialogData.ConditionData hasShards = new DialogData.ConditionData();
        hasShards.hasShards = Math.round((float)EventScene.currentEvent.eventRules.shardsToEnter * changes.getTownPriceModifier());
        enterWithShards.condition = new DialogData.ConditionData[]{hasShards};
        if (EventScene.currentEvent.eventRules.acceptsChallengeCoin) {
            enterWithCoin.name = "Redeem a Challenge Coin [+ChallengeCoin]";
            hasCoin = new DialogData.ConditionData();
            hasCoin.item = "Challenge Coin";
            enterWithCoin.condition = new DialogData.ConditionData[]{hasCoin};
            giveCoin = new DialogData.ActionData();
            giveCoin.removeItem = hasCoin.item;
            enterWithCoin.action = new DialogData.ActionData[]{giveCoin};
        } else if (EventScene.currentEvent.eventRules.acceptsSilverChallengeCoin) {
            enterWithCoin.name = "Redeem a Challenge Coin [+SilverChallengeCoin]";
            hasCoin = new DialogData.ConditionData();
            hasCoin.item = "Silver Challenge Coin";
            enterWithCoin.condition = new DialogData.ConditionData[]{hasCoin};
            giveCoin = new DialogData.ActionData();
            giveCoin.removeItem = hasCoin.item;
            enterWithCoin.action = new DialogData.ActionData[]{giveCoin};
        } else if (EventScene.currentEvent.eventRules.acceptsBronzeChallengeCoin) {
            enterWithCoin.name = "Redeem a Challenge Coin [+BronzeChallengeCoin]";
            hasCoin = new DialogData.ConditionData();
            hasCoin.item = "Bronze Challenge Coin";
            enterWithCoin.condition = new DialogData.ConditionData[]{hasCoin};
            giveCoin = new DialogData.ActionData();
            giveCoin.removeItem = hasCoin.item;
            enterWithCoin.action = new DialogData.ActionData[]{giveCoin};
        } else {
            DialogData.ConditionData alwaysFalse = new DialogData.ConditionData();
            alwaysFalse.item = "NonexistentItem";
            enterWithCoin.condition = new DialogData.ConditionData[]{alwaysFalse};
        }
        DialogData.ActionData spendGold = new DialogData.ActionData();
        spendGold.addGold = -Math.round((float)EventScene.currentEvent.eventRules.goldToEnter * changes.getTownPriceModifier());
        enterWithGold.action = new DialogData.ActionData[]{spendGold};
        DialogData.ActionData spendShards = new DialogData.ActionData();
        spendShards.addShards = -Math.round((float)EventScene.currentEvent.eventRules.shardsToEnter * changes.getTownPriceModifier());
        enterWithShards.action = new DialogData.ActionData[]{spendShards};
        DialogData decline = new DialogData();
        decline.name = "Do not enter event";
        enterWithCoin.callback = new Callback<Boolean>(){

            @Override
            public void run(Boolean result) {
                EventScene.currentEvent.eventStatus = AdventureEventController.EventStatus.Entered;
                EventScene.this.refresh();
            }
        };
        enterWithShards.callback = new Callback<Boolean>(){

            @Override
            public void run(Boolean result) {
                EventScene.currentEvent.eventStatus = AdventureEventController.EventStatus.Entered;
                EventScene.this.refresh();
            }
        };
        enterWithGold.callback = new Callback<Boolean>(){

            @Override
            public void run(Boolean result) {
                EventScene.currentEvent.eventStatus = AdventureEventController.EventStatus.Entered;
                EventScene.this.refresh();
            }
        };
        introDialog.options = new DialogData[4];
        introDialog.options[0] = enterWithCoin;
        introDialog.options[1] = enterWithShards;
        introDialog.options[2] = enterWithGold;
        introDialog.options[3] = decline;
        this.entryDialog = new Array();
        this.entryDialog.add(introDialog);
        TypingLabel blessingScroll = Controls.newTypingLabel("[BLACK]" + currentEvent.getDescription(changes));
        blessingScroll.skipToTheEnd();
        blessingScroll.setAlignment(10);
        blessingScroll.setWrap(true);
        this.ui.onButtonPress("return", this::back);
        this.ui.onButtonPress("advance", this::advance);
        this.ui.onButtonPress("editDeck", this::editDeck);
        this.back = (TextraButton)this.ui.findActor("return");
        this.advance = (TextraButton)this.ui.findActor("advance");
        this.nextPage = (TextraButton)this.ui.findActor("nextPage");
        this.nextPage.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (EventScene.this.nextPage.isDisabled()) {
                    return;
                }
                EventScene.this.nextPage(false);
            }
        });
        this.previousPage = (TextraButton)this.ui.findActor("previousPage");
        this.previousPage.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (EventScene.this.previousPage.isDisabled()) {
                    return;
                }
                EventScene.this.nextPage(true);
            }
        });
        this.editDeck = (TextraButton)this.ui.findActor("editDeck");
        this.editDeck.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                if (EventScene.currentEvent.format == AdventureEventController.EventFormat.Draft && EventScene.currentEvent.eventStatus == AdventureEventController.EventStatus.Ready) {
                    DraftScene.instance().loadEvent(currentEvent);
                    Forge.switchScene(DraftScene.instance());
                } else if (EventScene.currentEvent.format == AdventureEventController.EventFormat.Jumpstart && EventScene.currentEvent.eventStatus == AdventureEventController.EventStatus.Ready) {
                    DeckEditScene.getInstance().loadEvent(currentEvent);
                    Forge.switchScene(DeckEditScene.getInstance());
                }
            }
        });
        Window window = (Window)this.ui.findActor("scrollWindow");
        this.root = (Table)this.ui.findActor("enemies");
        Window header = (Window)this.ui.findActor("header");
        header.toFront();
        this.headerTable = new Table(Controls.getSkin());
        this.headerTable.add("Event Standings").expand();
        header.add(this.headerTable).expand();
        ScrollPane blessing = (ScrollPane)this.ui.findActor("blessingInfo");
        blessing.setActor(blessingScroll);
        blessingScroll.setWidth(blessing.getWidth() - 5.0f);
        blessing.layout();
        window.add(this.root);
        this.metaDraftTable = (Table)this.ui.findActor("metaDraftTable");
        this.root.add(this.metaDraftTable);
        this.metaDraftTable.setVisible(false);
        this.refresh();
    }

    private void refresh() {
        if (this.metaDraftTable.isVisible()) {
            this.scrollContainer = this.metaDraftTable;
            this.headerTable.clear();
            this.headerTable.add("Pack Selection");
            if (EventScene.currentEvent.eventStatus == AdventureEventController.EventStatus.Entered) {
                this.loadMetaDraft();
            }
        } else {
            this.scrollContainer = new Table(Controls.getSkin());
            this.scrollContainer.row();
            Arrays.sort(EventScene.currentEvent.participants);
            for (AdventureEventData.AdventureEventParticipant participant : EventScene.currentEvent.participants) {
                Image avatar = participant.getAvatar();
                avatar.setScaling(Scaling.stretch);
                this.scrollContainer.add(avatar).pad(5.0f).size(16.0f).fillY();
                this.scrollContainer.add().width(16.0f);
                boolean notEliminated = !EventScene.currentEvent.eventStatus.equals((Object)AdventureEventController.EventStatus.Started) || !EventScene.currentEvent.matches.containsKey(EventScene.currentEvent.currentRound) || EventScene.currentEvent.matches.get(EventScene.currentEvent.currentRound).stream().anyMatch(q -> q.p1.equals(participant) || q.p2.equals(participant));
                TextraLabel participantName = Controls.newTextraLabel((notEliminated ? "" : "[RED]") + participant.getName());
                participantName.setWrap(true);
                this.scrollContainer.add(participantName).fillX().pad(5.0f).width(120.0f);
                this.scrollContainer.add().width(16.0f);
                this.scrollContainer.add(String.format("%d-%d", participant.wins, participant.losses)).pad(5.0f);
                this.scrollContainer.row();
            }
            this.eventPages = new Table[EventScene.currentEvent.rounds + 1];
            this.eventPages[0] = this.scrollContainer;
            for (int i = 0; i < EventScene.currentEvent.rounds; ++i) {
                Table round = new Table(Controls.getSkin());
                round.row();
                List<AdventureEventData.AdventureEventMatch> matches = currentEvent.getMatches(i + 1);
                if (matches == null) {
                    round.add(Controls.newTextraLabel("Pairings not yet generated"));
                } else {
                    Table roundScrollContainer = new Table(Controls.getSkin());
                    for (AdventureEventData.AdventureEventMatch match : matches) {
                        Table p1Table = new Table(Controls.getSkin());
                        Image p1Avatar = match.p1.getAvatar();
                        p1Avatar.setScaling(Scaling.stretch);
                        p1Table.add(p1Avatar).pad(5.0f).size(16.0f).fillY().top();
                        String color = match.winner == null ? "" : (match.winner.equals(match.p1) ? "[GREEN]" : (match.winner.equals(match.p2) ? "[RED]" : ""));
                        TypingLabel p1Name = Controls.newTypingLabel(color + match.p1.getName());
                        p1Name.skipToTheEnd();
                        p1Name.setWrap(true);
                        p1Table.add(p1Name).width(50.0f).expandX().top();
                        roundScrollContainer.add(p1Table).left().uniformY().top().padBottom(10.0f);
                        Table verbTable = new Table(Controls.getSkin());
                        if (match.p2 == null) {
                            verbTable.add("has a bye").expand().fillX().top();
                        } else if (match.winner != null && match.winner.equals(match.p1)) {
                            verbTable.add("defeated").expand().fillX().top();
                        } else if (match.winner != null && match.winner.equals(match.p2)) {
                            verbTable.add("defeated by").expand().fillX().top();
                        } else {
                            verbTable.add("versus").expand().fillX().top();
                        }
                        roundScrollContainer.add(verbTable).padLeft(10.0f).padRight(10.0f).top();
                        Table p2Table = new Table(Controls.getSkin());
                        if (match.p2 != null) {
                            Image p2Avatar = match.p2.getAvatar();
                            p2Avatar.setScaling(Scaling.stretch);
                            String color2 = match.winner == null ? "" : (match.winner.equals(match.p2) ? "[GREEN]" : (match.winner.equals(match.p1) ? "[RED]" : ""));
                            TypingLabel p2Name = Controls.newTypingLabel(color2 + match.p2.getName());
                            p2Name.skipToTheEnd();
                            p2Name.setWrap(true);
                            p2Table.add(p2Name).width(50.0f).expandX().top();
                            p2Table.add(p2Avatar).pad(5.0f).size(16.0f).fillY().top();
                        }
                        roundScrollContainer.add(p2Table).right().uniformY().top().padBottom(10.0f);
                        roundScrollContainer.row();
                    }
                    round.add(roundScrollContainer).expandX().fillX();
                    round.row();
                }
                this.eventPages[i + 1] = round;
            }
        }
        this.performTouch(this.scrollPaneOfActor(this.scrollContainer));
        this.root.clear();
        this.scrollContainer.layout();
        this.scroller = new ScrollPane((Actor)this.scrollContainer);
        this.root.add(this.scroller).fill().prefWidth(this.root.getWidth());
        this.root.layout();
        this.scroller.layout();
        this.scroller.clear();
        this.scroller.setActor(this.eventPages[this.pageIndex]);
        this.performTouch(this.scroller);
        switch (EventScene.currentEvent.eventStatus) {
            case Available: {
                this.nextPage.setDisabled(true);
                this.previousPage.setDisabled(true);
                this.editDeck.setDisabled(true);
                this.editDeck.setVisible(false);
                this.advance.setText("Join Event");
                this.advance.setVisible(true);
                break;
            }
            case Entered: {
                this.nextPage.setDisabled(true);
                this.previousPage.setDisabled(true);
                this.editDeck.setDisabled(true);
                this.editDeck.setVisible(false);
                if (currentEvent.getDraft() != null) {
                    this.advance.setText("Enter Draft");
                } else {
                    this.advance.setText("Select Deck");
                }
                this.advance.setVisible(true);
                break;
            }
            case Ready: {
                this.advance.setText("Start Event");
                this.advance.setVisible(true);
                this.editDeck.setDisabled(false);
                this.editDeck.setVisible(true);
                this.nextPage.setDisabled(false);
                this.previousPage.setDisabled(false);
                break;
            }
            case Started: {
                this.advance.setText("Play round " + EventScene.currentEvent.currentRound);
                this.advance.setVisible(true);
                this.editDeck.setDisabled(true);
                this.editDeck.setVisible(false);
                this.nextPage.setDisabled(false);
                this.previousPage.setDisabled(false);
                break;
            }
            case Completed: {
                this.advance.setText("Collect Rewards");
                this.advance.setVisible(true);
                this.editDeck.setDisabled(true);
                this.editDeck.setVisible(false);
                this.nextPage.setDisabled(false);
                this.previousPage.setDisabled(false);
                break;
            }
            case Awarded: 
            case Abandoned: {
                this.advance.setVisible(false);
                this.editDeck.setDisabled(true);
                this.editDeck.setVisible(false);
                this.nextPage.setDisabled(false);
                this.previousPage.setDisabled(false);
                AdventureEventController.instance().finalizeEvent(currentEvent);
            }
        }
    }

    public static EventScene instance(Scene lastGameScene, AdventureEventData event, PointOfInterestChanges localChanges) {
        currentEvent = event;
        changes = localChanges;
        object = new EventScene();
        if (lastGameScene != null) {
            EventScene.object.lastGameScene = lastGameScene;
        }
        return object;
    }

    private void nextPage(boolean reverse) {
        this.headerTable.clear();
        if (!reverse && ++this.pageIndex >= this.eventPages.length) {
            this.pageIndex = 0;
        } else if (reverse && --this.pageIndex < 0) {
            this.pageIndex = this.eventPages.length - 1;
        }
        if (this.pageIndex == 0) {
            this.headerTable.add("Event Standings").expand();
        } else {
            this.headerTable.add("Round " + this.pageIndex + " of " + (this.eventPages.length - 1));
        }
        this.refresh();
    }

    @Override
    public void enter() {
        super.enter();
        GameHUD.getInstance().switchAudio();
        this.scrollContainer.clear();
        if (this.money != null) {
            WorldSave.getCurrentSave().getPlayer().onGoldChange(() -> this.money.setText("[+Gold] [BLACK]" + AdventurePlayer.current().getGold()));
        }
        if (this.shards != null) {
            WorldSave.getCurrentSave().getPlayer().onShardsChange(() -> this.shards.setText("[+Shards] [BLACK]" + AdventurePlayer.current().getShards()));
        }
        this.performTouch(this.scrollPaneOfActor(this.scrollContainer));
        if (EventScene.currentEvent.eventStatus == AdventureEventController.EventStatus.Entered) {
            this.loadMetaDraft();
        }
        this.refresh();
    }

    public void editDeck() {
        if (EventScene.currentEvent.eventStatus == AdventureEventController.EventStatus.Ready) {
            DraftScene.instance().loadEvent(currentEvent);
            Forge.switchScene(DraftScene.instance());
        }
    }

    public void advance() {
        switch (EventScene.currentEvent.eventStatus) {
            case Available: {
                this.activate(this.entryDialog);
                break;
            }
            case Entered: {
                switch (EventScene.currentEvent.format) {
                    case Draft: {
                        DraftScene.instance().loadEvent(currentEvent);
                        Forge.switchScene(DraftScene.instance());
                        break;
                    }
                    case Jumpstart: {
                        this.loadMetaDraft();
                    }
                }
                break;
            }
            case Ready: {
                currentEvent.startEvent();
            }
            case Started: {
                this.advance.setDisabled(true);
                this.startRound();
                break;
            }
            case Completed: 
            case Awarded: {
                this.advance.setDisabled(true);
                currentEvent.giveRewards();
                break;
            }
        }
        this.refresh();
    }

    @Override
    public boolean back() {
        if (EventScene.currentEvent.eventStatus.equals((Object)AdventureEventController.EventStatus.Awarded)) {
            AdventureEventController.instance().finalizeEvent(currentEvent);
            currentEvent = null;
        }
        Forge.switchScene(this.lastGameScene == null ? GameScene.instance() : this.lastGameScene);
        return true;
    }

    public void startRound() {
        for (AdventureEventData.AdventureEventMatch match : EventScene.currentEvent.matches.get(EventScene.currentEvent.currentRound)) {
            match.round = EventScene.currentEvent.currentRound;
            if (match.winner != null) continue;
            if (match.p2 == null) {
                match.winner = match.p1;
                ++match.p1.wins;
            }
            if (match.p1 instanceof AdventureEventData.AdventureEventHuman) {
                this.humanMatch = match;
                continue;
            }
            if (match.p2 instanceof AdventureEventData.AdventureEventHuman) {
                AdventureEventData.AdventureEventParticipant placeholder = match.p1;
                match.p1 = match.p2;
                match.p2 = placeholder;
                this.humanMatch = match;
                continue;
            }
            if (MyRandom.percentTrue(50)) {
                ++match.p1.wins;
                ++match.p2.losses;
                match.winner = match.p1;
                continue;
            }
            ++match.p1.losses;
            ++match.p2.wins;
            match.winner = match.p2;
        }
        if (this.humanMatch != null && this.humanMatch.round != EventScene.currentEvent.currentRound) {
            this.humanMatch = null;
        }
        if (this.humanMatch != null) {
            DuelScene duelScene = DuelScene.instance();
            EnemySprite enemy = this.humanMatch.p2.getSprite();
            EventScene.currentEvent.nextOpponent = this.humanMatch.p2;
            FThreads.invokeInEdtNowOrLater(() -> Forge.setTransitionScreen(new TransitionScreen(() -> {
                duelScene.initDuels(WorldStage.getInstance().getPlayerSprite(), enemy, false, currentEvent);
                Forge.switchScene(duelScene);
            }, Forge.takeScreenshot(), true, false, false, false, "", Current.player().avatar(), enemy.getAtlasPath(), Current.player().getName(), enemy.getName(), this.humanMatch.p1.getRecord(), this.humanMatch.p2.getRecord())));
        } else {
            this.finishRound();
        }
        this.advance.setDisabled(false);
    }

    @Override
    public void setWinner(boolean winner) {
        if (winner) {
            this.humanMatch.winner = this.humanMatch.p1;
            ++this.humanMatch.p1.wins;
            ++this.humanMatch.p2.losses;
            ++EventScene.currentEvent.matchesWon;
        } else {
            this.humanMatch.winner = this.humanMatch.p2;
            ++this.humanMatch.p2.wins;
            ++this.humanMatch.p1.losses;
            ++EventScene.currentEvent.matchesLost;
        }
        if (winner) {
            // empty if block
        }
        this.finishRound();
    }

    public void finishRound() {
        if (EventScene.currentEvent.currentRound == EventScene.currentEvent.rounds) {
            this.finishEvent();
        } else {
            ++EventScene.currentEvent.currentRound;
        }
        this.refresh();
    }

    public void finishEvent() {
        EventScene.currentEvent.eventStatus = AdventureEventController.EventStatus.Completed;
    }

    public void loadMetaDraft() {
        this.metaDraftTable.setVisible(true);
        this.metaDraftTable.clear();
        for (final Deck deckOption : EventScene.currentEvent.jumpstartBoosters) {
            if (this.metaDraftTable.hasChildren()) {
                this.metaDraftTable.row();
            }
            TypingLabel packName = Controls.newTypingLabel(deckOption.getName().replaceFirst("^[A-Z]([A-Z|\\d]){2}\\s", ""));
            packName.skipToTheEnd();
            this.metaDraftTable.add(packName);
            TextraButton previewButton = Controls.newTextButton("Preview");
            previewButton.addListener(new ClickListener(){

                @Override
                public void clicked(InputEvent event, float x, float y) {
                    Forge.switchScene(DeckPreviewScene.getInstance(deckOption));
                }
            });
            final TextraButton selectButton = Controls.newTextButton("Select");
            if (deckOption.getTags().contains("Selected")) {
                packName.setColor(Color.FOREST);
                selectButton.setColor(Color.FOREST);
                selectButton.setDisabled(true);
            } else {
                selectButton.addListener(new ClickListener(){

                    @Override
                    public void clicked(InputEvent event, float x, float y) {
                        selectButton.clearListeners();
                        deckOption.getTags().add("Selected");
                        if (!EventScene.this.selectedJumpstartPackIsLast(deckOption)) {
                            EventScene.this.loadMetaDraft();
                        } else {
                            EventScene.this.metaDraftTable.setVisible(false);
                        }
                    }
                });
            }
            this.metaDraftTable.add(previewButton).padLeft(10.0f);
            this.metaDraftTable.add(selectButton).padLeft(10.0f);
        }
        this.eventPages[0] = this.metaDraftTable;
    }

    private boolean selectedJumpstartPackIsLast(Deck selectedPack) {
        int packsToPick = 3;
        int packsPicked = 0;
        Deck currentPicks = new Deck();
        for (Deck deckOption : EventScene.currentEvent.jumpstartBoosters) {
            if (deckOption.getTags().contains("Selected")) {
                ++packsPicked;
                currentPicks.getMain().addAll(deckOption.getAllCardsInASinglePool());
            }
            if (packsPicked < packsToPick) continue;
            EventScene.currentEvent.registeredDeck.getMain().clear();
            EventScene.currentEvent.registeredDeck.getMain().addAll(currentPicks.getAllCardsInASinglePool());
            this.metaDraftTable.setVisible(false);
            EventScene.currentEvent.eventStatus = AdventureEventController.EventStatus.Ready;
            this.refresh();
            return true;
        }
        return false;
    }
}

