/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.google.common.collect.ImmutableList;
import forge.Forge;
import forge.Graphics;
import forge.LobbyPlayer;
import forge.adventure.character.EnemySprite;
import forge.adventure.character.PlayerSprite;
import forge.adventure.data.AdventureEventData;
import forge.adventure.data.EffectData;
import forge.adventure.data.EnemyData;
import forge.adventure.data.ItemData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.scene.ForgeScene;
import forge.adventure.scene.Scene;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.IAfterMatch;
import forge.adventure.util.AdventureEventController;
import forge.adventure.util.Config;
import forge.adventure.util.Current;
import forge.assets.FBufferedImage;
import forge.assets.FSkin;
import forge.deck.Deck;
import forge.deck.DeckProxy;
import forge.game.GameRules;
import forge.game.GameType;
import forge.game.player.Player;
import forge.game.player.PlayerView;
import forge.game.player.RegisteredPlayer;
import forge.gamemodes.match.HostedMatch;
import forge.gamemodes.quest.QuestUtil;
import forge.gui.FThreads;
import forge.gui.interfaces.IGuiGame;
import forge.item.IPaperCard;
import forge.player.GamePlayerUtil;
import forge.player.PlayerControllerHuman;
import forge.screens.FScreen;
import forge.screens.LoadingOverlay;
import forge.screens.TransitionScreen;
import forge.screens.match.MatchController;
import forge.sound.MusicPlaylist;
import forge.toolbox.FOptionPane;
import forge.trackable.TrackableCollection;
import forge.util.Aggregates;
import forge.util.Callback;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class DuelScene
extends ForgeScene {
    private static DuelScene object;
    HostedMatch hostedMatch;
    EnemySprite enemy;
    PlayerSprite player;
    RegisteredPlayer humanPlayer;
    private EffectData dungeonEffect;
    Deck playerDeck;
    boolean chaosBattle = false;
    boolean callbackExit = false;
    boolean arenaBattleChallenge = false;
    boolean isArena = false;
    AdventureEventData eventData;
    private LoadingOverlay matchOverlay;
    final int enemyAvatarKey = 90001;
    final int playerAvatarKey = 90000;
    FOptionPane bossDialogue;
    List<IPaperCard> playerExtras = new ArrayList<IPaperCard>();
    List<IPaperCard> AIExtras = new ArrayList<IPaperCard>();
    Runnable endRunnable = null;

    public static DuelScene instance() {
        if (object == null) {
            object = new DuelScene();
        }
        return object;
    }

    private DuelScene() {
    }

    @Override
    public void dispose() {
    }

    public boolean hasCallbackExit() {
        return this.callbackExit;
    }

    public void GameEnd() {
        if (this.eventData != null) {
            this.eventData.nextOpponent = null;
        }
        boolean winner = false;
        try {
            List<PlayerControllerHuman> humans;
            boolean bl = winner = this.humanPlayer == this.hostedMatch.getGame().getMatch().getWinner();
            if ((this.eventData == null || this.eventData.eventRules.allowsShards) && (humans = this.hostedMatch.getHumanControllers()).size() == 1) {
                Current.player().setShards(humans.get(0).getPlayer().getNumManaShards());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String enemyName = this.enemy.getName();
        boolean showMessages = this.enemy.getData().boss || this.enemy.getData().copyPlayerDeck && Current.player().isUsingCustomDeck();
        Current.player().clearBlessing();
        if ((this.chaosBattle || showMessages) && !winner) {
            FBufferedImage fb = this.getFBEnemyAvatar();
            this.callbackExit = true;
            boolean finalWinner = winner;
            this.bossDialogue = this.createFOption(Forge.getLocalizer().getMessage("AdvBossInsult" + Aggregates.randomInt(1, 44), new Object[0]), enemyName, fb, () -> {
                this.afterGameEnd(enemyName, finalWinner);
                this.exitDuelScene();
                fb.dispose();
            });
            FThreads.invokeInEdtNowOrLater(() -> this.bossDialogue.show());
        } else {
            this.afterGameEnd(enemyName, winner);
        }
    }

    void afterGameEnd(String enemyName, boolean winner) {
        Forge.advFreezePlayerControls = winner;
        this.endRunnable = () -> Gdx.app.postRunnable(() -> {
            GameHUD.getInstance().switchAudio();
            this.dungeonEffect = null;
            this.callbackExit = false;
            Forge.clearTransitionScreen();
            Forge.clearCurrentScreen();
            Forge.advFreezePlayerControls = false;
            Scene last = Forge.switchToLast();
            Current.player().getStatistic().setResult(enemyName, winner);
            if (last instanceof IAfterMatch) {
                ((IAfterMatch)((Object)last)).setWinner(winner);
            }
        });
    }

    public void exitDuelScene() {
        Forge.setTransitionScreen(new TransitionScreen(this.endRunnable, Forge.takeScreenshot(), false, false));
    }

    private FOptionPane createFOption(String message, String title, FBufferedImage icon, final Runnable runnable) {
        return new FOptionPane(message, null, title, icon, null, ImmutableList.of(Forge.getLocalizer().getMessage("lblOK", new Object[0])), -1, new Callback<Integer>(){

            @Override
            public void run(Integer result) {
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    void addEffects(RegisteredPlayer player, Array<EffectData> effects) {
        if (effects == null) {
            return;
        }
        int lifeMod = 0;
        int changeStartCards = 0;
        int extraManaShards = 0;
        Array<IPaperCard> startCards = new Array<IPaperCard>();
        Array<IPaperCard> startCardsInCommandZone = new Array<IPaperCard>();
        for (EffectData data : effects) {
            lifeMod += data.lifeModifier;
            changeStartCards += data.changeStartCards;
            startCards.addAll(data.startBattleWithCards());
            startCardsInCommandZone.addAll(data.startBattleWithCardsInCommandZone());
            extraManaShards += data.extraManaShards;
        }
        player.addExtraCardsOnBattlefield(startCards);
        player.addExtraCardsInCommandZone(startCardsInCommandZone);
        if (lifeMod != 0) {
            player.setStartingLife(Math.max(1, lifeMod + player.getStartingLife()));
        }
        player.setStartingHand(player.getStartingHand() + changeStartCards);
        player.setManaShards(player.getManaShards() + extraManaShards);
        player.setEnableETBCountersEffect(true);
    }

    public void setDungeonEffect(EffectData E) {
        this.dungeonEffect = E;
    }

    @Override
    public void enter() {
        boolean showMessages;
        GameRules rules;
        GameHUD.getInstance().unloadAudio();
        HashSet<GameType> appliedVariants = new HashSet<GameType>();
        if (this.eventData != null && this.eventData.eventRules != null) {
            appliedVariants.add(this.eventData.eventRules.gameType);
        } else {
            appliedVariants.add(GameType.Adventure);
        }
        AdventurePlayer advPlayer = Current.player();
        ArrayList<RegisteredPlayer> players = new ArrayList<RegisteredPlayer>();
        int missingCards = Config.instance().getConfigData().minDeckSize - this.playerDeck.getMain().countAll();
        if (missingCards > 0) {
            this.playerDeck.getMain().add("Wastes", missingCards);
        }
        int playerCount = 1;
        EnemyData currentEnemy = this.enemy.getData();
        for (int i = 0; i < 8 && currentEnemy != null; ++i) {
            ++playerCount;
            currentEnemy = currentEnemy.nextEnemy;
        }
        this.humanPlayer = RegisteredPlayer.forVariants(playerCount, appliedVariants, this.playerDeck, null, false, null, null);
        LobbyPlayer playerObject = GamePlayerUtil.getGuiPlayer();
        FSkin.getAvatars().put(90000, advPlayer.avatar());
        playerObject.setAvatarIndex(90000);
        this.humanPlayer.setPlayer(playerObject);
        this.humanPlayer.setTeamNumber(0);
        this.humanPlayer.setStartingLife(this.eventData != null ? this.eventData.eventRules.startingLife : advPlayer.getLife());
        if (this.eventData == null || this.eventData.eventRules.allowsShards) {
            this.humanPlayer.setManaShards(advPlayer.getShards());
        }
        Array<EffectData> playerEffects = new Array<EffectData>();
        Array<EffectData> oppEffects = new Array<EffectData>();
        Map<DeckProxy, Pair<List<String>, List<String>>> deckProxyMapMap = null;
        DeckProxy deckProxy = null;
        if (this.chaosBattle) {
            deckProxyMapMap = DeckProxy.getAllQuestChallenges();
            ArrayList<DeckProxy> decks = new ArrayList<DeckProxy>(deckProxyMapMap.keySet());
            deckProxy = (DeckProxy)Aggregates.random(decks);
            ArrayList<IPaperCard> playerCards = new ArrayList<IPaperCard>();
            for (String s2 : deckProxyMapMap.get(deckProxy).getLeft()) {
                playerCards.add(QuestUtil.readExtraCard(s2));
            }
            this.humanPlayer.addExtraCardsOnBattlefield(playerCards);
        }
        if (this.eventData == null || this.eventData.eventRules.allowsItems) {
            for (String playerItem : advPlayer.getEquippedItems()) {
                ItemData item = ItemData.getItem(playerItem);
                if (item != null && item.effect != null) {
                    playerEffects.add(item.effect);
                    if (item.effect.opponent == null) continue;
                    oppEffects.add(item.effect.opponent);
                    continue;
                }
                System.err.printf("Item %s not found.", playerItem);
            }
        }
        if (this.eventData == null || this.eventData.eventRules.allowsBlessings) {
            if (advPlayer.getBlessing() != null) {
                playerEffects.add(advPlayer.getBlessing());
                if (advPlayer.getBlessing().opponent != null) {
                    oppEffects.add(advPlayer.getBlessing().opponent);
                }
            }
            if (this.enemy.effect != null) {
                oppEffects.add(this.enemy.effect);
                if (this.enemy.effect.opponent != null) {
                    playerEffects.add(this.enemy.effect.opponent);
                }
            }
        }
        if (this.dungeonEffect != null) {
            oppEffects.add(this.dungeonEffect);
            if (this.dungeonEffect.opponent != null) {
                playerEffects.add(this.dungeonEffect.opponent);
            }
        }
        this.addEffects(this.humanPlayer, playerEffects);
        currentEnemy = this.enemy.getData();
        boolean bossBattle = currentEnemy.boss;
        for (int i = 0; i < 8 && currentEnemy != null; ++i) {
            Deck deck;
            if (this.chaosBattle) {
                if (deckProxyMapMap == null) continue;
                ArrayList<IPaperCard> aiCards = new ArrayList<IPaperCard>();
                for (String s3 : deckProxyMapMap.get(deckProxy).getRight()) {
                    aiCards.add(QuestUtil.readExtraCard(s3));
                }
                this.AIExtras = aiCards;
                deck = deckProxy.getDeck();
            } else {
                deck = this.arenaBattleChallenge ? Aggregates.random(DeckProxy.getAllGeneticAIDecks()).getDeck() : (this.eventData != null ? this.eventData.nextOpponent.getDeck() : (currentEnemy.copyPlayerDeck ? this.playerDeck : currentEnemy.generateDeck(Current.player().isFantasyMode(), Current.player().isUsingCustomDeck() || Current.player().isHardorInsaneDifficulty())));
            }
            RegisteredPlayer aiPlayer = RegisteredPlayer.forVariants(playerCount, appliedVariants, deck, null, false, null, null);
            LobbyPlayer enemyPlayer = GamePlayerUtil.createAiPlayer(currentEnemy.getName(), this.selectAI(currentEnemy.ai));
            enemyPlayer.setName(this.enemy.getName());
            Sprite enemyAvatar = this.enemy.getAvatar(i);
            ((TextureRegion)enemyAvatar).flip(true, false);
            FSkin.getAvatars().put(90001 + i, enemyAvatar);
            enemyPlayer.setAvatarIndex(90001 + i);
            aiPlayer.setPlayer(enemyPlayer);
            aiPlayer.setTeamNumber(currentEnemy.teamNumber);
            aiPlayer.setStartingLife(this.eventData != null ? this.eventData.eventRules.startingLife : Math.round((float)currentEnemy.life * advPlayer.getDifficulty().enemyLifeFactor));
            Array<EffectData> equipmentEffects = new Array<EffectData>();
            if (this.eventData != null && this.eventData.eventRules.allowsItems && currentEnemy.equipment != null) {
                for (String oppItem : currentEnemy.equipment) {
                    ItemData item = ItemData.getItem(oppItem);
                    if (item == null) continue;
                    equipmentEffects.add(item.effect);
                    if (item.effect.opponent == null) continue;
                    playerEffects.add(item.effect.opponent);
                }
            }
            this.addEffects(aiPlayer, oppEffects);
            this.addEffects(aiPlayer, equipmentEffects);
            if (this.chaosBattle) {
                aiPlayer.addExtraCardsOnBattlefield(this.AIExtras);
            }
            players.add(aiPlayer);
            if (this.eventData == null) {
                Current.setLatestDeck(deck);
            }
            currentEnemy = currentEnemy.nextEnemy;
        }
        players.add(this.humanPlayer);
        HashMap<RegisteredPlayer, IGuiGame> guiMap = new HashMap<RegisteredPlayer, IGuiGame>();
        guiMap.put(this.humanPlayer, MatchController.instance);
        this.hostedMatch = MatchController.hostMatch();
        if (this.eventData != null) {
            rules = new GameRules(this.eventData.eventRules.gameType);
            rules.setGamesPerMatch(this.eventData.eventRules.gamesPerMatch);
            bossBattle = false;
        } else {
            rules = new GameRules(GameType.Adventure);
            rules.setGamesPerMatch(this.enemy.getData().gamesPerMatch);
        }
        rules.setPlayForAnte(false);
        rules.setMatchAnteRarity(true);
        rules.setManaBurn(false);
        rules.setWarnAboutAICards(false);
        this.hostedMatch.startMatch(rules, appliedVariants, players, guiMap, bossBattle ? MusicPlaylist.BOSS : MusicPlaylist.MATCH);
        MatchController.instance.setGameView(this.hostedMatch.getGameView());
        boolean bl = showMessages = this.enemy.getData().boss || this.enemy.getData().copyPlayerDeck && Current.player().isUsingCustomDeck();
        if (this.chaosBattle || showMessages) {
            FBufferedImage fb = this.getFBEnemyAvatar();
            this.bossDialogue = this.createFOption(Forge.getLocalizer().getMessage("AdvBossIntro" + Aggregates.randomInt(1, 35), new Object[0]), this.enemy.getName(), fb, fb::dispose);
            this.matchOverlay = new LoadingOverlay(() -> FThreads.delayInEDT(300, () -> FThreads.invokeInEdtNowOrLater(() -> this.bossDialogue.show())), false, true);
        } else {
            this.matchOverlay = new LoadingOverlay(null);
        }
        for (Player p : this.hostedMatch.getGame().getPlayers()) {
            if (!(p.getController() instanceof PlayerControllerHuman)) continue;
            PlayerControllerHuman humanController = (PlayerControllerHuman)p.getController();
            humanController.setGui(MatchController.instance);
            MatchController.instance.setOriginalGameController(p.getView(), humanController);
            MatchController.instance.openView(new TrackableCollection<PlayerView>(p.getView()));
        }
        super.enter();
        this.matchOverlay.show();
    }

    @Override
    public FScreen getScreen() {
        return MatchController.getView();
    }

    public void initDuels(PlayerSprite playerSprite, EnemySprite enemySprite) {
        this.initDuels(playerSprite, enemySprite, false, null);
    }

    public void initDuels(PlayerSprite playerSprite, EnemySprite enemySprite, boolean isArena, AdventureEventData eventData) {
        this.player = playerSprite;
        this.enemy = enemySprite;
        this.isArena = isArena;
        this.eventData = eventData;
        if (eventData != null && eventData.eventRules == null) {
            eventData.eventRules = new AdventureEventData.AdventureEventRules(AdventureEventController.EventFormat.Constructed, 1.0f);
        }
        this.arenaBattleChallenge = isArena && Current.player().isHardorInsaneDifficulty();
        this.playerDeck = eventData != null && eventData.registeredDeck != null ? eventData.registeredDeck : (Deck)Current.player().getSelectedDeck().copyTo("PlayerDeckCopy");
        this.chaosBattle = this.enemy.getData().copyPlayerDeck && Current.player().isFantasyMode();
        this.AIExtras.clear();
        this.playerExtras.clear();
    }

    private String selectAI(String ai) {
        String AI = "";
        if (ai != null) {
            switch (ai.toLowerCase()) {
                case "default": {
                    AI = "Default";
                    break;
                }
                case "reckless": {
                    AI = "Reckless";
                    break;
                }
                case "cautious": {
                    AI = "Cautious";
                    break;
                }
                case "experimental": {
                    AI = "Experimental";
                    break;
                }
                default: {
                    AI = "";
                }
            }
        }
        return AI;
    }

    private FBufferedImage getFBEnemyAvatar() {
        return new FBufferedImage(120.0f, 120.0f){

            @Override
            protected void draw(Graphics g2, float w, float h2) {
                if (FSkin.getAvatars().get(90001) != null) {
                    g2.drawImage(FSkin.getAvatars().get(90001), 0.0f, 0.0f, w, h2);
                }
            }
        };
    }
}

