/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.utils.IntMap;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import forge.Forge;
import forge.adventure.scene.DeckEditScene;
import forge.adventure.scene.UIScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;

public class DeckSelectScene
extends UIScene {
    private final IntMap<TextraButton> buttons = new IntMap();
    Color defColor;
    TextField textInput;
    Table layout;
    TextraLabel header;
    TextraButton back;
    TextraButton edit;
    TextraButton rename;
    int currentSlot = 0;
    ScrollPane scrollPane;
    Dialog renameDialog;
    private static DeckSelectScene object;

    public static DeckSelectScene instance() {
        if (object == null) {
            object = new DeckSelectScene();
        }
        return object;
    }

    public DeckSelectScene() {
        super(Forge.isLandscapeMode() ? "ui/deck_selector.json" : "ui/deck_selector_portrait.json");
        Window window = (Window)this.ui.findActor("deckSlots");
        Table root = new Table();
        this.layout = new Table();
        this.scrollPane = new ScrollPane((Actor)this.layout);
        this.header = Controls.newTextraLabel(Forge.getLocalizer().getMessage("lblSelectYourDeck", new Object[0]));
        root.row();
        root.add(this.header).colspan(2);
        root.row();
        root.add(this.scrollPane).expand().width(window.getWidth() - 20.0f);
        for (int i = 0; i < 10; ++i) {
            this.addDeckSlot(Forge.getLocalizer().getMessage("lblDeck", new Object[0]) + ": " + (i + 1), i);
        }
        this.textInput = Controls.newTextField("");
        this.back = (TextraButton)this.ui.findActor("return");
        this.edit = (TextraButton)this.ui.findActor("edit");
        this.rename = (TextraButton)this.ui.findActor("rename");
        this.ui.onButtonPress("return", this::back);
        this.ui.onButtonPress("edit", this::edit);
        this.ui.onButtonPress("rename", () -> {
            this.textInput.setText(Current.player().getSelectedDeck().getName());
            this.showRenameDialog();
        });
        this.ui.onButtonPress("copy", this::copy);
        this.ui.onButtonPress("delete", this::maybeDelete);
        this.defColor = ((Actor)this.ui.findActor("return")).getColor();
        window.add(root);
    }

    private void copy() {
        if (Current.player().isEmptyDeck(this.currentSlot)) {
            return;
        }
        int index = Current.player().copyDeck();
        if (index == -1) {
            this.showDialog(this.createGenericDialog(Forge.getLocalizer().getMessage("lblCopy", new Object[0]), Forge.getLocalizer().getMessage("lblNoAvailableSlots", new Object[0]), Forge.getLocalizer().getMessage("lblOK", new Object[0]), null, this::removeDialog, null));
        } else {
            this.updateDeckButton(index);
            this.select(index);
            this.scrollPane.scrollTo(this.buttons.get(index).getX(), this.buttons.get(index).getY(), 0.0f, 0.0f);
        }
    }

    private void maybeDelete() {
        if (Current.player().isEmptyDeck(this.currentSlot)) {
            return;
        }
        Dialog deleteDialog = this.createGenericDialog(Forge.getLocalizer().getMessage("lblDelete", new Object[0]), Forge.getLocalizer().getMessage("lblAreYouSureProceedDelete", new Object[0]), Forge.getLocalizer().getMessage("lblOK", new Object[0]), Forge.getLocalizer().getMessage("lblAbort", new Object[0]), this::delete, this::removeDialog);
        this.showDialog(deleteDialog);
    }

    private void delete() {
        Current.player().deleteDeck();
        this.updateDeckButton(this.currentSlot);
        this.removeDialog();
    }

    private void updateDeckButton(int index) {
        this.buttons.get(index).setText(Current.player().getDeck(index).getName());
        this.buttons.get(index).getTextraLabel().layout();
        this.buttons.get(index).layout();
    }

    private void showRenameDialog() {
        if (this.renameDialog == null) {
            this.renameDialog = this.createGenericDialog(Forge.getLocalizer().getMessage("lblRenameDeck", new Object[0]), null, Forge.getLocalizer().getMessage("lblOK", new Object[0]), Forge.getLocalizer().getMessage("lblAbort", new Object[0]), () -> {
                this.rename();
                this.removeDialog();
            }, this::removeDialog);
            this.renameDialog.getContentTable().add(Controls.newLabel(Forge.getLocalizer().getMessage("lblNewNameDeck", new Object[0]))).colspan(2);
            this.renameDialog.getContentTable().row();
            this.renameDialog.getContentTable().add(Controls.newLabel(Forge.getLocalizer().getMessage("lblName", new Object[0]) + ": ")).align(8);
            this.renameDialog.getContentTable().add(this.textInput).fillX().expandX();
            this.renameDialog.getContentTable().row();
        }
        this.showDialog(this.renameDialog);
    }

    private TextraButton addDeckSlot(String name, final int i) {
        final TextraButton button = Controls.newTextButton("-");
        button.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                try {
                    if (!button.isDisabled()) {
                        DeckSelectScene.this.select(i);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.layout.add(Controls.newLabel(name)).pad(2.0f);
        this.layout.add(button).fill(true, false).expand(true, false).align(8).expandX().pad(2.0f);
        this.buttons.put(i, button);
        this.addToSelectable(new UIScene.Selectable<TextraButton>(button));
        this.layout.row();
        return button;
    }

    public boolean select(int slot) {
        this.currentSlot = slot;
        for (IntMap.Entry butt : new IntMap.Entries((IntMap)this.buttons)) {
            ((TextraButton)butt.value).setColor(this.defColor);
        }
        if (this.buttons.containsKey(slot)) {
            TextraButton button = this.buttons.get(slot);
            button.setColor(Color.RED);
        }
        Current.player().setSelectedDeckSlot(slot);
        return true;
    }

    @Override
    public void enter() {
        for (int i = 0; i < 10; ++i) {
            if (!this.buttons.containsKey(i)) continue;
            this.buttons.get(i).setText(Current.player().getDeck(i).getName());
            this.buttons.get(i).getTextraLabel().layout();
            this.buttons.get(i).layout();
        }
        GameHUD.getInstance().switchAudio();
        this.select(Current.player().getSelectedDeckIndex());
        this.performTouch(this.scrollPane);
        super.enter();
    }

    private void rename() {
        String text = this.textInput.getText();
        Current.player().renameDeck(text);
        this.buttons.get(this.currentSlot).setText(Current.player().getDeck(this.currentSlot).getName());
        this.buttons.get(this.currentSlot).getTextraLabel().layout();
        this.buttons.get(this.currentSlot).layout();
    }

    private void edit() {
        Forge.switchScene(DeckEditScene.getInstance());
    }
}

