/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.scenes.scene2d.Stage;
import forge.adventure.data.AdventureEventData;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.scene.AdventureDeckEditor;
import forge.adventure.scene.ForgeScene;
import forge.item.PaperCard;
import forge.screens.FScreen;

public class DeckEditScene
extends ForgeScene {
    AdventureDeckEditor screen;
    Stage stage;
    AdventureEventData currentEvent;
    private static DeckEditScene object;

    private DeckEditScene() {
    }

    public static DeckEditScene getInstance() {
        if (object == null) {
            object = new DeckEditScene();
        }
        return object;
    }

    @Override
    public void dispose() {
        if (this.stage != null) {
            this.stage.dispose();
        }
    }

    public void loadEvent(AdventureEventData event) {
        this.currentEvent = event;
    }

    @Override
    public void enter() {
        this.screen = null;
        this.getScreen();
        this.screen.refresh();
        super.enter();
    }

    @Override
    public FScreen getScreen() {
        if (this.screen == null) {
            if (this.currentEvent == null) {
                this.screen = new AdventureDeckEditor(false);
                this.screen.setEvent(null);
            } else {
                this.screen = new AdventureDeckEditor(this.currentEvent);
            }
        }
        return this.screen;
    }

    public boolean isAutoSell(PaperCard pc) {
        return AdventurePlayer.current().getAutoSellCards().contains(pc);
    }

    public boolean isNoSell(PaperCard pc) {
        return AdventurePlayer.current().getNoSellCards().contains(pc);
    }
}

