/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.scene;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Dialog;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import forge.Forge;
import forge.adventure.character.EnemySprite;
import forge.adventure.data.ArenaData;
import forge.adventure.data.EnemyData;
import forge.adventure.data.WorldData;
import forge.adventure.scene.DuelScene;
import forge.adventure.scene.GameScene;
import forge.adventure.scene.RewardScene;
import forge.adventure.scene.UIScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.IAfterMatch;
import forge.adventure.stage.MapStage;
import forge.adventure.stage.WorldStage;
import forge.adventure.util.AdventureQuestController;
import forge.adventure.util.Config;
import forge.adventure.util.Controls;
import forge.adventure.util.Current;
import forge.adventure.util.Reward;
import forge.gui.FThreads;
import forge.screens.TransitionScreen;
import java.util.Random;

public class ArenaScene
extends UIScene
implements IAfterMatch {
    private static ArenaScene object;
    private final float gridSize;
    private ArenaData arenaData;
    private final TextraButton startButton;
    private final TextraButton doneButton;
    private final TextraLabel goldLabel;
    private final Group arenaPlane;
    private final Table arenaTable;
    private final Random rand = new Random();
    final Sprite fighterSpot;
    final Sprite lostOverlay;
    final Sprite up;
    final Sprite upWin;
    final Sprite side;
    final Sprite sideWin;
    final Sprite edge;
    final Sprite edgeM;
    final Sprite edgeWin;
    final Sprite edgeWinM;
    boolean enable = true;
    boolean arenaStarted = false;
    Dialog startDialog;
    Dialog concedeDialog;
    int roundsWon = 0;
    boolean started = false;
    Array<EnemySprite> enemies = new Array();
    Array<ArenaRecord> fighters = new Array();
    Actor player;

    public static ArenaScene instance() {
        if (object == null) {
            object = new ArenaScene();
        }
        return object;
    }

    private ArenaScene() {
        super(Forge.isLandscapeMode() ? "ui/arena.json" : "ui/arena_portrait.json");
        this.fighterSpot = Config.instance().getAtlasSprite("ui/arena.atlas", "Spot");
        this.lostOverlay = Config.instance().getAtlasSprite("ui/arena.atlas", "Lost");
        this.up = Config.instance().getAtlasSprite("ui/arena.atlas", "Up");
        this.upWin = Config.instance().getAtlasSprite("ui/arena.atlas", "UpWin");
        this.side = Config.instance().getAtlasSprite("ui/arena.atlas", "Side");
        this.sideWin = Config.instance().getAtlasSprite("ui/arena.atlas", "SideWin");
        this.edge = Config.instance().getAtlasSprite("ui/arena.atlas", "Edge");
        this.edgeM = Config.instance().getAtlasSprite("ui/arena.atlas", "EdgeFlip");
        this.edgeM.setFlip(true, false);
        this.edgeWin = Config.instance().getAtlasSprite("ui/arena.atlas", "EdgeWin");
        this.edgeWinM = Config.instance().getAtlasSprite("ui/arena.atlas", "EdgeWinFlip");
        this.edgeWinM.setFlip(true, false);
        this.gridSize = this.fighterSpot.getRegionWidth();
        this.goldLabel = (TextraLabel)this.ui.findActor("gold");
        this.ui.onButtonPress("done", () -> {
            if (!this.enable) {
                return;
            }
            if (!this.arenaStarted) {
                this.done();
            } else {
                this.showAreYouSure();
            }
        });
        this.ui.onButtonPress("start", this::startButton);
        this.doneButton = (TextraButton)this.ui.findActor("done");
        ScrollPane pane = (ScrollPane)this.ui.findActor("arena");
        this.arenaPlane = new Table();
        this.arenaTable = new Table();
        pane.setActor(this.arenaPlane);
        this.startButton = (TextraButton)this.ui.findActor("start");
    }

    private void showAreYouSure() {
        if (this.concedeDialog == null) {
            this.concedeDialog = this.createGenericDialog(Forge.getLocalizer().getMessage("lblConcedeTitle", new Object[0]), "\n" + Forge.getLocalizer().getMessage("lblConcedeCurrentGame", new Object[0]), Forge.getLocalizer().getMessage("lblYes", new Object[0]), Forge.getLocalizer().getMessage("lblNo", new Object[0]), () -> {
                this.loose();
                this.removeDialog();
            }, this::removeDialog);
        }
        this.showDialog(this.concedeDialog);
    }

    private void loose() {
        this.doneButton.setText("[%80][+Exit]");
        this.doneButton.layout();
        this.startButton.setDisabled(true);
        this.arenaStarted = false;
        AdventureQuestController.instance().updateArenaComplete(false);
        AdventureQuestController.instance().showQuestDialogs(MapStage.getInstance());
    }

    private void startDialog() {
        if (this.startDialog == null) {
            this.startDialog = this.createGenericDialog(Forge.getLocalizer().getMessage("lblStart", new Object[0]), Forge.getLocalizer().getMessage("lblStartArena", new Object[0]), Forge.getLocalizer().getMessage("lblYes", new Object[0]), Forge.getLocalizer().getMessage("lblNo", new Object[0]), () -> {
                this.startArena();
                this.removeDialog();
            }, this::removeDialog);
        }
        this.showDialog(this.startDialog);
    }

    private void startButton() {
        if (!this.enable) {
            return;
        }
        if (this.roundsWon == 0) {
            this.startDialog();
        } else {
            this.startRound();
        }
    }

    private void startArena() {
        this.enable = false;
        this.goldLabel.setVisible(false);
        this.arenaStarted = true;
        this.startButton.setText("[%80][+OK]");
        this.startButton.layout();
        this.doneButton.setText("[%80][+Exit]");
        this.doneButton.layout();
        Forge.setCursor(null, Forge.magnifyToggle ? "1" : "2");
        Current.player().takeGold(this.arenaData.entryFee);
        this.startRound();
    }

    @Override
    public void setWinner(boolean winner) {
        this.enable = false;
        Array<ArenaRecord> winners = new Array<ArenaRecord>();
        Array<EnemySprite> winnersEnemies = new Array<EnemySprite>();
        for (int i = 0; i < this.fighters.size - 2; i += 2) {
            boolean leftWon;
            int matchHP = this.enemies.get((int)i).getData().life + this.enemies.get((int)(i + 1)).getData().life;
            boolean bl = leftWon = this.rand.nextInt(matchHP) < this.enemies.get((int)i).getData().life;
            if (leftWon) {
                winners.add(this.fighters.get(i));
                winnersEnemies.add(this.enemies.get(i));
                this.moveFighter(this.fighters.get((int)i).actor, true);
                this.markLostFighter(this.fighters.get((int)(i + 1)).actor);
                continue;
            }
            this.markLostFighter(this.fighters.get((int)i).actor);
            this.moveFighter(this.fighters.get((int)(i + 1)).actor, false);
            winners.add(this.fighters.get(i + 1));
            winnersEnemies.add(this.enemies.get(i + 1));
        }
        if (winner) {
            this.markLostFighter(this.fighters.get((int)(this.fighters.size - 2)).actor);
            this.moveFighter(this.fighters.get((int)(this.fighters.size - 1)).actor, false);
            winners.add(this.fighters.get(this.fighters.size - 1));
            ++this.roundsWon;
        } else {
            this.markLostFighter(this.fighters.get((int)(this.fighters.size - 1)).actor);
            this.moveFighter(this.fighters.get((int)(this.fighters.size - 2)).actor, true);
            winners.add(this.fighters.get(this.fighters.size - 2));
            this.loose();
        }
        this.fighters = winners;
        this.enemies = winnersEnemies;
        if (this.roundsWon >= this.arenaData.rounds) {
            this.arenaStarted = false;
            this.startButton.setDisabled(true);
            this.doneButton.setText("[%80][+Exit]");
            this.doneButton.layout();
            AdventureQuestController.instance().updateArenaComplete(true);
            AdventureQuestController.instance().showQuestDialogs(MapStage.getInstance());
        }
        if (!Forge.isLandscapeMode()) {
            this.drawArena();
        }
    }

    private void moveFighter(Actor actor, boolean leftPlayer) {
        Image spotImg = new Image(this.upWin);
        double stepsToTheSide = Math.pow(2.0, this.roundsWon);
        float widthDiff = actor.getWidth() - spotImg.getWidth();
        spotImg.setPosition(actor.getX() + widthDiff / 2.0f, actor.getY() + this.gridSize + widthDiff / 2.0f);
        this.arenaPlane.addActor(spotImg);
        int i = 0;
        while ((double)i < stepsToTheSide) {
            Image leftImg = i == 0 ? new Image(leftPlayer ? this.edgeWin : this.edgeWinM) : new Image(this.sideWin);
            leftImg.setPosition(actor.getX() + (float)(i * (leftPlayer ? 1 : -1)) * this.gridSize + widthDiff / 2.0f, actor.getY() + this.gridSize * 2.0f + widthDiff / 2.0f);
            this.arenaPlane.addActor(leftImg);
            ++i;
        }
        if (Forge.isLandscapeMode()) {
            actor.toFront();
            actor.addAction(Actions.sequence((Action)Actions.moveBy(0.0f, this.gridSize * 2.0f, 1.0f), (Action)Actions.moveBy((float)((double)this.gridSize * stepsToTheSide * (double)(leftPlayer ? 1 : -1)), 0.0f, 1.0f), new Action(){

                @Override
                public boolean act(float v) {
                    ArenaScene.this.enable = true;
                    return true;
                }
            }));
        } else {
            this.enable = true;
        }
    }

    private void markLostFighter(Actor fighter) {
        Image lost = new Image(this.lostOverlay);
        float widthDiff = fighter.getWidth() - lost.getWidth();
        lost.setPosition(fighter.getX() + widthDiff / 2.0f, fighter.getY() + widthDiff / 2.0f);
        this.arenaPlane.addActor(lost);
    }

    private void startRound() {
        if (this.started) {
            return;
        }
        this.started = true;
        DuelScene duelScene = DuelScene.instance();
        EnemySprite enemy = this.enemies.get(this.enemies.size - 1);
        FThreads.invokeInEdtNowOrLater(() -> Forge.setTransitionScreen(new TransitionScreen(() -> {
            this.started = false;
            duelScene.initDuels(WorldStage.getInstance().getPlayerSprite(), enemy, true, null);
            Forge.switchScene(duelScene);
        }, Forge.takeScreenshot(), true, false, false, false, "", Current.player().avatar(), enemy.getAtlasPath(), Current.player().getName(), enemy.getName())));
    }

    public boolean start() {
        return true;
    }

    public boolean done() {
        GameHUD.getInstance().getTouchpad().setVisible(false);
        Forge.switchToLast();
        if (this.roundsWon != 0) {
            Array<Reward> data = new Array<Reward>();
            for (int i = 0; i < this.roundsWon; ++i) {
                for (int j = 0; j < this.arenaData.rewards[i].length; ++j) {
                    data.addAll(this.arenaData.rewards[i][j].generate(false, null, true));
                }
            }
            RewardScene.instance().loadRewards(data, RewardScene.Type.Loot, null);
            Forge.switchScene(RewardScene.instance());
        }
        return true;
    }

    @Override
    public void act(float delta) {
        this.stage.act(delta);
    }

    public void loadArenaData(ArenaData data, long seed) {
        this.startButton.setText("[%80][+OK]");
        this.startButton.layout();
        this.doneButton.setText("[%80][+Exit]");
        this.doneButton.layout();
        this.arenaData = data;
        this.enemies.clear();
        this.fighters.clear();
        this.arenaPlane.clear();
        this.roundsWon = 0;
        int numberOfEnemies = (int)(Math.pow(2.0, data.rounds) - 1.0);
        for (int i = 0; i < numberOfEnemies; ++i) {
            EnemyData enemyData = null;
            while (enemyData == null) {
                enemyData = WorldData.getEnemy(data.enemyPool[this.rand.nextInt(data.enemyPool.length)]);
            }
            EnemySprite enemy = new EnemySprite(enemyData);
            this.enemies.add(enemy);
            this.fighters.add(new ArenaRecord(new Image(enemy.getAvatar()), enemyData.getName()));
        }
        this.fighters.add(new ArenaRecord(new Image(Current.player().avatar()), Current.player().getName()));
        this.player = this.fighters.get((int)(this.fighters.size - 1)).actor;
        this.goldLabel.setText("[+GoldCoin] " + data.entryFee);
        this.goldLabel.layout();
        this.goldLabel.setVisible(true);
        this.startButton.setDisabled(data.entryFee > Current.player().getGold());
        int currentSpots = numberOfEnemies + 1;
        int gridWidth = currentSpots * 2;
        int gridHeight = data.rounds + 1;
        this.arenaPlane.setSize((float)gridWidth * this.gridSize, (float)gridHeight * this.gridSize * 2.0f);
        int fighterIndex = 0;
        for (int x = 0; x < gridWidth; ++x) {
            for (int y = 0; y < gridHeight; ++y) {
                if ((double)x % Math.pow(2.0, y + 1) != Math.pow(2.0, y)) continue;
                if (y == 0 && fighterIndex < this.fighters.size) {
                    float widthDiff = this.gridSize - this.fighters.get((int)fighterIndex).actor.getWidth();
                    this.fighters.get((int)fighterIndex).actor.setPosition((float)x * this.gridSize + widthDiff / 2.0f, (float)y * this.gridSize * 2.0f + widthDiff / 2.0f);
                    this.arenaPlane.addActor(this.fighters.get((int)fighterIndex).actor);
                    ++fighterIndex;
                }
                Image spotImg = new Image(this.fighterSpot);
                spotImg.setPosition((float)x * this.gridSize, (float)y * this.gridSize * 2.0f);
                this.arenaPlane.addActor(spotImg);
                if (y != gridHeight - 1) {
                    Image upImg = new Image(this.up);
                    upImg.setPosition((float)x * this.gridSize, (float)y * this.gridSize * 2.0f + this.gridSize);
                    this.arenaPlane.addActor(upImg);
                }
                if (y == 0) continue;
                int i = 0;
                while ((double)i < Math.pow(2.0, y - 1)) {
                    Image rightImg;
                    Image leftImg;
                    if ((double)i == Math.pow(2.0, y - 1) - 1.0) {
                        leftImg = new Image(this.edge);
                        rightImg = new Image(this.edgeM);
                    } else {
                        leftImg = new Image(this.side);
                        rightImg = new Image(this.side);
                    }
                    leftImg.setPosition((float)(x - (i + 1)) * this.gridSize, (float)y * this.gridSize * 2.0f);
                    rightImg.setPosition((float)(x + (i + 1)) * this.gridSize, (float)y * this.gridSize * 2.0f);
                    this.arenaPlane.addActor(leftImg);
                    this.arenaPlane.addActor(rightImg);
                    ++i;
                }
            }
        }
        this.drawArena();
    }

    void drawArena() {
        ScrollPane pane = (ScrollPane)this.ui.findActor("arena");
        if (pane != null) {
            pane.clear();
            this.arenaTable.clear();
            if (Forge.isLandscapeMode()) {
                this.arenaTable.add(Controls.newTextraLabel("[;][%150]" + GameScene.instance().getAdventurePlayerLocation(true, true) + " Arena")).top();
                this.arenaTable.row();
                this.arenaTable.add(this.arenaPlane).width(this.arenaPlane.getWidth()).height(this.arenaPlane.getHeight());
                pane.setActor(this.arenaTable);
            } else {
                this.arenaTable.add(Controls.newTextraLabel("[;][%150]" + GameScene.instance().getAdventurePlayerLocation(true, true) + " Arena")).colspan(3).top();
                this.arenaTable.row();
                int size = this.fighters.size;
                int pv = 0;
                for (int x = 0; x < size; ++x) {
                    ArenaRecord record = this.fighters.get(x);
                    int divider = size == 1 ? 2 : (size == 2 ? 3 : size);
                    this.arenaTable.add(record.actor).pad(20.0f, 5.0f, 20.0f, 5.0f).size(pane.getWidth() / (float)divider);
                    if (++pv == 1) {
                        if (size > 1) {
                            this.arenaTable.add(Controls.newTextraLabel("[%135]VS")).padLeft(5.0f).padRight(5.0f);
                        } else {
                            this.arenaTable.row();
                            this.arenaTable.add(Controls.newTextraLabel("[%135]Winner!")).padLeft(5.0f).padRight(5.0f);
                        }
                    }
                    if (pv != 2) continue;
                    this.arenaTable.row();
                    pv = 0;
                }
                pane.setActor(this.arenaTable);
            }
        }
    }

    class ArenaRecord {
        Actor actor;
        String name;

        ArenaRecord(Actor a, String n) {
            this.actor = a;
            this.name = n;
        }
    }
}

