/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.pointofintrest;

import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.util.SaveFileContent;
import forge.adventure.util.SaveFileData;
import java.util.ArrayList;
import java.util.List;

public class PointOfInterestMap
implements SaveFileContent {
    private int numberOfChunksX;
    private int numberOfChunksY;
    int tileSize;
    int chunkSize;
    private List<PointOfInterest>[][] mapObjects;

    public PointOfInterestMap(int chunkSize, int tiles, int numberOfChunksX, int numberOfChunksY) {
        this.tileSize = tiles;
        this.chunkSize = chunkSize;
        this.numberOfChunksX = numberOfChunksX;
        this.numberOfChunksY = numberOfChunksY;
        this.mapObjects = new List[numberOfChunksX][numberOfChunksY];
        for (int x = 0; x < numberOfChunksX; ++x) {
            for (int y = 0; y < numberOfChunksY; ++y) {
                this.mapObjects[x][y] = new ArrayList<PointOfInterest>();
            }
        }
    }

    public void add(PointOfInterest obj) {
        int chunkX = (int)(obj.position.x / (float)this.tileSize / (float)this.chunkSize);
        int chunkY = (int)(obj.position.y / (float)this.tileSize / (float)this.chunkSize);
        if (chunkX >= this.numberOfChunksX || chunkY >= this.numberOfChunksY || chunkX < 0 || chunkY < 0) {
            return;
        }
        this.mapObjects[chunkX][chunkY].add(obj);
    }

    public PointOfInterest findPointsOfInterest(String name) {
        List<PointOfInterest>[][] listArray = this.mapObjects;
        int n = listArray.length;
        for (int i = 0; i < n; ++i) {
            List<PointOfInterest>[] poiList1;
            for (List<PointOfInterest> poiList : poiList1 = listArray[i]) {
                for (PointOfInterest poi : poiList) {
                    if (!poi.getData().name.equals(name)) continue;
                    return poi;
                }
            }
        }
        return null;
    }

    public List<PointOfInterest> getAllPointOfInterest() {
        ArrayList<PointOfInterest> allPOI = new ArrayList<PointOfInterest>();
        List<PointOfInterest>[][] listArray = this.mapObjects;
        int n = listArray.length;
        for (int i = 0; i < n; ++i) {
            List<PointOfInterest>[] poiList1;
            for (List<PointOfInterest> poiList : poiList1 = listArray[i]) {
                allPOI.addAll(poiList);
            }
        }
        return allPOI;
    }

    public List<PointOfInterest> pointsOfInterest(int chunkX, int chunkY) {
        if (chunkX >= this.numberOfChunksX || chunkY >= this.numberOfChunksY || chunkX < 0 || chunkY < 0) {
            return new ArrayList<PointOfInterest>();
        }
        return this.mapObjects[chunkX][chunkY];
    }

    @Override
    public void load(SaveFileData data) {
        this.numberOfChunksX = data.readInt("numberOfChunksX");
        this.numberOfChunksY = data.readInt("numberOfChunksY");
        this.tileSize = data.readInt("tileSize");
        this.chunkSize = data.readInt("chunkSize");
        this.mapObjects = new List[this.numberOfChunksX][this.numberOfChunksY];
        for (int x = 0; x < this.numberOfChunksX; ++x) {
            for (int y = 0; y < this.numberOfChunksY; ++y) {
                this.mapObjects[x][y] = new ArrayList<PointOfInterest>();
                int arraySize = data.readInt("mapObjects[" + x + "][" + y + "]");
                for (int i = 0; i < arraySize; ++i) {
                    PointOfInterest pointsOfInterest = new PointOfInterest();
                    pointsOfInterest.load(data.readSubData("mapObjects[" + x + "][" + y + "][" + i + "]"));
                    this.mapObjects[x][y].add(pointsOfInterest);
                }
            }
        }
    }

    @Override
    public SaveFileData save() {
        SaveFileData data = new SaveFileData();
        data.store("numberOfChunksX", this.numberOfChunksX);
        data.store("numberOfChunksY", this.numberOfChunksY);
        data.store("tileSize", this.tileSize);
        data.store("chunkSize", this.chunkSize);
        for (int x = 0; x < this.numberOfChunksX; ++x) {
            for (int y = 0; y < this.numberOfChunksY; ++y) {
                data.store("mapObjects[" + x + "][" + y + "]", this.mapObjects[x][y].size());
                for (int i = 0; i < this.mapObjects[x][y].size(); ++i) {
                    data.store("mapObjects[" + x + "][" + y + "][" + i + "]", this.mapObjects[x][y].get(i).save());
                }
            }
        }
        return data;
    }
}

