/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.pointofintrest;

import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import forge.adventure.data.DialogData;
import forge.adventure.data.PointOfInterestData;
import forge.adventure.util.Config;
import forge.adventure.util.Current;
import forge.adventure.util.SaveFileContent;
import forge.adventure.util.SaveFileData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class PointOfInterest
implements Serializable,
SaveFileContent {
    PointOfInterestData data;
    final Vector2 position = new Vector2();
    transient Sprite sprite;
    int spriteIndex;
    final Rectangle rectangle = new Rectangle();
    String oldMapId = "";
    boolean active = true;
    private String displayName;
    public ArrayList<DialogData.ActionData.QuestFlag> questFlagsToActivate = new ArrayList();

    @Override
    public void load(SaveFileData saveFileData) {
        this.position.set(saveFileData.readVector2("position"));
        this.data = PointOfInterestData.getPointOfInterest(saveFileData.readString("name"));
        this.rectangle.set(saveFileData.readRectangle("rectangle"));
        this.spriteIndex = saveFileData.readInt("spriteIndex");
        this.active = saveFileData.containsKey("active") ? saveFileData.readBool("active") : this.data.active;
        this.displayName = saveFileData.containsKey("displayName") ? saveFileData.readString("displayName") : (this.data == null ? "" : this.data.getDisplayName());
        this.oldMapId = "";
        Array<Sprite> textureAtlas = Config.instance().getPOISprites(this.data);
        this.sprite = textureAtlas.get(this.spriteIndex % textureAtlas.size);
    }

    @Override
    public SaveFileData save() {
        SaveFileData data = new SaveFileData();
        data.store("name", this.data.name);
        data.store("position", this.position);
        data.store("rectangle", this.rectangle);
        data.store("spriteIndex", this.spriteIndex);
        data.store("active", this.active);
        data.store("displayName", this.getDisplayName());
        data.storeObject("questFlagsToActivate", this.questFlagsToActivate);
        return data;
    }

    public PointOfInterest() {
    }

    public PointOfInterest(PointOfInterestData d, Vector2 pos, Random rand) {
        Array<Sprite> textureAtlas = Config.instance().getPOISprites(d);
        if (textureAtlas.isEmpty()) {
            System.out.print("sprite " + d.sprite + " not found");
        }
        this.spriteIndex = rand.nextInt(31) % textureAtlas.size;
        this.sprite = textureAtlas.get(this.spriteIndex);
        this.data = d;
        this.active = d.active;
        this.position.set(pos);
        this.questFlagsToActivate.addAll(Arrays.asList(this.data.questFlagsToActivate));
        this.rectangle.set(this.position.x, this.position.y, this.sprite.getWidth(), this.sprite.getHeight());
    }

    public PointOfInterest(PointOfInterestData d, PointOfInterest parent) {
        this.spriteIndex = parent.spriteIndex;
        this.sprite = parent.sprite;
        this.data = d;
        this.active = d.active;
        this.position.set(parent.position);
        this.oldMapId = parent.getID();
        this.rectangle.set(this.position.x, this.position.y, this.sprite.getWidth(), this.sprite.getHeight());
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public Vector2 getPosition() {
        return this.position;
    }

    public Vector2 getTilePosition(int tileSize) {
        return new Vector2((this.position.x + this.sprite.getWidth() / 2.0f) / (float)tileSize, this.position.y / (float)tileSize);
    }

    public Rectangle getBoundingRectangle() {
        return this.rectangle;
    }

    public PointOfInterestData getData() {
        return this.data;
    }

    public long getSeedOffset() {
        return (long)this.position.x * 715567L + (long)this.position.y + (long)(this.data.name + "/" + this.oldMapId).hashCode();
    }

    public String getID() {
        return this.getSeedOffset() + this.data.name + "/" + this.data.map;
    }

    public boolean getActive() {
        for (DialogData.ActionData.QuestFlag flag : this.questFlagsToActivate) {
            if (Current.player().getQuestFlag(flag.key) >= flag.val) continue;
            return false;
        }
        return true;
    }

    public Vector2 getNavigationVector(Vector2 origin) {
        Vector2 navVector = new Vector2(this.rectangle.x + this.rectangle.getWidth() / 2.0f, this.rectangle.y + this.rectangle.getHeight() / 2.0f);
        if (origin != null) {
            navVector.sub(origin);
        }
        return navVector;
    }

    public String getDisplayName() {
        if (this.displayName == null || this.displayName.isEmpty()) {
            this.displayName = this.data.getDisplayName();
        }
        return this.displayName;
    }

    public void setDisplayName(String val) {
        this.displayName = val;
    }

    public boolean hasDisplayName() {
        return this.displayName != null && !this.displayName.isEmpty();
    }
}

