/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.player;

import forge.adventure.data.AdventureEventData;
import forge.adventure.util.AdventureQuestController;
import forge.adventure.util.SaveFileContent;
import forge.adventure.util.SaveFileData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class PlayerStatistic
implements SaveFileContent {
    HashMap<String, Pair<Integer, Integer>> winLossRecord = new HashMap();
    List<AdventureEventData> completedEvents = new ArrayList<AdventureEventData>();
    int secondPlayed = 0;

    public HashMap<String, Pair<Integer, Integer>> getWinLossRecord() {
        return this.winLossRecord;
    }

    public int totalWins() {
        int wins = 0;
        for (Map.Entry<String, Pair<Integer, Integer>> value : this.winLossRecord.entrySet()) {
            wins += value.getValue().getLeft().intValue();
        }
        return wins;
    }

    public int totalLoss() {
        int loss = 0;
        for (Map.Entry<String, Pair<Integer, Integer>> value : this.winLossRecord.entrySet()) {
            loss += value.getValue().getRight().intValue();
        }
        return loss;
    }

    public float winLossRatio() {
        if (this.totalLoss() == 0) {
            return this.totalWins();
        }
        return (float)this.totalWins() / (float)this.totalLoss();
    }

    public int eventWins() {
        int win = 0;
        for (AdventureEventData event : this.completedEvents) {
            if (!event.playerWon) continue;
            ++win;
        }
        return win;
    }

    public int eventLosses() {
        int loss = 0;
        for (AdventureEventData event : this.completedEvents) {
            if (event.playerWon) continue;
            ++loss;
        }
        return loss;
    }

    public float eventWinLossRatio() {
        if (this.eventLosses() == 0) {
            return this.eventWins();
        }
        return (float)this.eventWins() / (float)this.eventLosses();
    }

    public int eventMatchWins() {
        int win = 0;
        for (AdventureEventData event : this.completedEvents) {
            win += event.matchesWon;
        }
        return win;
    }

    public int eventMatchLosses() {
        int loss = 0;
        for (AdventureEventData event : this.completedEvents) {
            loss += event.matchesLost;
        }
        return loss;
    }

    public float eventMatchWinLossRatio() {
        if (this.eventMatchLosses() == 0) {
            return this.eventMatchWins();
        }
        return (float)this.eventMatchWins() / (float)this.eventMatchLosses();
    }

    public int getPlayTime() {
        return this.secondPlayed;
    }

    @Override
    public void load(SaveFileData data) {
        if (data != null && data.containsKey("winLossRecord")) {
            this.winLossRecord = (HashMap)data.readObject("winLossRecord");
        } else {
            this.winLossRecord.clear();
        }
        if (data != null && data.containsKey("completedEvents")) {
            this.completedEvents = (ArrayList)data.readObject("completedEvents");
            if (this.completedEvents == null) {
                this.completedEvents = new ArrayList<AdventureEventData>();
            }
        } else {
            this.completedEvents.clear();
        }
    }

    public void setResult(String enemy, boolean win) {
        if (!this.winLossRecord.containsKey(enemy)) {
            if (win) {
                this.winLossRecord.put(enemy, Pair.of(1, 0));
            } else {
                this.winLossRecord.put(enemy, Pair.of(0, 1));
            }
        } else if (win) {
            this.winLossRecord.put(enemy, Pair.of(this.winLossRecord.get(enemy).getLeft() + 1, this.winLossRecord.get(enemy).getRight()));
        } else {
            this.winLossRecord.put(enemy, Pair.of(this.winLossRecord.get(enemy).getLeft(), this.winLossRecord.get(enemy).getRight() + 1));
        }
    }

    @Override
    public SaveFileData save() {
        SaveFileData data = new SaveFileData();
        data.storeObject("winLossRecord", this.winLossRecord);
        data.storeObject("completedEvents", this.completedEvents);
        return data;
    }

    public void clear() {
        this.winLossRecord.clear();
    }

    public void setResult(AdventureEventData completedEvent) {
        this.completedEvents.add(completedEvent);
        AdventureQuestController.instance().updateEventComplete(completedEvent);
    }
}

