/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.data;

import com.badlogic.gdx.utils.Array;
import com.google.common.collect.Iterables;
import forge.StaticData;
import forge.adventure.data.ConfigData;
import forge.adventure.data.ItemData;
import forge.adventure.util.CardUtil;
import forge.adventure.util.Config;
import forge.adventure.util.Current;
import forge.adventure.util.Reward;
import forge.adventure.world.WorldSave;
import forge.deck.Deck;
import forge.item.PaperCard;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class RewardData
implements Serializable {
    private static final long serialVersionUID = 3158932532013393718L;
    public String type;
    public float probability;
    public int count;
    public int addMaxCount;
    public String cardName;
    public String itemName;
    public String[] itemNames;
    public String[] editions;
    public String[] colors;
    public String[] rarity;
    public String[] subTypes;
    public String[] cardTypes;
    public String[] superTypes;
    public int[] manaCosts;
    public String[] keyWords;
    public String colorType;
    public String cardText;
    public boolean matchAllSubTypes;
    public boolean matchAllColors;
    public RewardData[] cardUnion;
    public String[] deckNeeds;
    public RewardData[] rotation;
    public Deck cardPack;
    public String sourceDeck;
    public String minDate;
    private static Iterable<PaperCard> allCards;
    private static Iterable<PaperCard> allEnemyCards;

    public RewardData() {
    }

    public RewardData(RewardData rewardData) {
        if (rewardData == null) {
            return;
        }
        this.type = rewardData.type;
        this.probability = rewardData.probability;
        this.count = rewardData.count;
        this.addMaxCount = rewardData.addMaxCount;
        this.cardName = rewardData.cardName;
        this.itemName = rewardData.itemName;
        this.itemNames = rewardData.itemNames == null ? null : (String[])rewardData.itemNames.clone();
        this.editions = rewardData.editions == null ? null : (String[])rewardData.editions.clone();
        this.colors = rewardData.colors == null ? null : (String[])rewardData.colors.clone();
        this.rarity = rewardData.rarity == null ? null : (String[])rewardData.rarity.clone();
        this.subTypes = rewardData.subTypes == null ? null : (String[])rewardData.subTypes.clone();
        this.cardTypes = rewardData.cardTypes == null ? null : (String[])rewardData.cardTypes.clone();
        this.superTypes = rewardData.superTypes == null ? null : (String[])rewardData.superTypes.clone();
        this.manaCosts = rewardData.manaCosts == null ? null : (int[])rewardData.manaCosts.clone();
        this.keyWords = rewardData.keyWords == null ? null : (String[])rewardData.keyWords.clone();
        this.colorType = rewardData.colorType;
        this.cardText = rewardData.cardText;
        this.matchAllSubTypes = rewardData.matchAllSubTypes;
        this.matchAllColors = rewardData.matchAllColors;
        this.cardUnion = rewardData.cardUnion == null ? null : (RewardData[])rewardData.cardUnion.clone();
        this.rotation = rewardData.rotation == null ? null : (RewardData[])rewardData.rotation.clone();
        this.deckNeeds = rewardData.deckNeeds == null ? null : (String[])rewardData.deckNeeds.clone();
        this.cardPack = rewardData.cardPack;
        this.sourceDeck = rewardData.sourceDeck;
        this.minDate = rewardData.minDate;
    }

    private static void initializeAllCards() {
        ConfigData configData = Config.instance().getConfigData();
        RewardData legals = configData.legalCards;
        allCards = legals == null ? CardUtil.getFullCardPool(false) : Iterables.filter(CardUtil.getFullCardPool(false), new CardUtil.CardPredicate(legals, true));
        allCards = Iterables.filter(allCards, input -> {
            if (input == null) {
                return false;
            }
            if (Iterables.contains(input.getRules().getMainPart().getKeywords(), "Remove CARDNAME from your deck before playing if you're not playing for ante.")) {
                return false;
            }
            if (input.getRules().getAiHints().getRemNonCommanderDecks()) {
                return false;
            }
            if (configData.allowedEditions != null ? !Arrays.asList(configData.allowedEditions).contains(input.getEdition()) : Arrays.asList(configData.restrictedEditions).contains(input.getEdition())) {
                return false;
            }
            if (input.getRules().isCustom()) {
                return false;
            }
            return !Arrays.asList(configData.restrictedCards).contains(input.getName());
        });
        allEnemyCards = Iterables.filter(allCards, input -> {
            if (input == null) {
                return false;
            }
            return !input.getRules().getAiHints().getRemAIDecks();
        });
    }

    public static Iterable<PaperCard> getAllCards() {
        if (allCards == null) {
            RewardData.initializeAllCards();
        }
        return allCards;
    }

    public Array<Reward> generate(boolean isForEnemy, boolean useSeedlessRandom) {
        return this.generate(isForEnemy, null, useSeedlessRandom);
    }

    public Array<Reward> generate(boolean isForEnemy, boolean useSeedlessRandom, boolean isNoSell) {
        return this.generate(isForEnemy, null, useSeedlessRandom, isNoSell);
    }

    public Array<Reward> generate(boolean isForEnemy, Iterable<PaperCard> cards, boolean useSeedlessRandom) {
        return this.generate(isForEnemy, cards, useSeedlessRandom, false);
    }

    public Array<Reward> generate(boolean isForEnemy, Iterable<PaperCard> cards, boolean useSeedlessRandom, boolean isNoSell) {
        Random rewardRandom;
        boolean allCardVariants = Config.instance().getSettingData().useAllCardVariants;
        Random random = rewardRandom = useSeedlessRandom ? new Random() : WorldSave.getCurrentSave().getWorld().getRandom();
        if (allCards == null) {
            RewardData.initializeAllCards();
        }
        Array<Reward> ret = new Array<Reward>();
        if (this.probability == 0.0f || rewardRandom.nextFloat() <= this.probability) {
            int maxCount;
            if (this.type == null || this.type.isEmpty()) {
                this.type = "randomCard";
            }
            int addedCount = (maxCount = Math.round((float)this.addMaxCount * Current.player().getDifficulty().rewardMaxFactor)) > 0 ? rewardRandom.nextInt(maxCount) : 0;
            switch (this.type) {
                case "Union": {
                    HashSet<PaperCard> pool = new HashSet<PaperCard>();
                    for (RewardData r : this.cardUnion) {
                        if (r.cardName != null && !r.cardName.isEmpty()) {
                            PaperCard pc;
                            PaperCard paperCard = pc = allCardVariants ? CardUtil.getCardByName(r.cardName) : StaticData.instance().getCommonCards().getCard(r.cardName);
                            if (pc == null) continue;
                            pool.add(pc);
                            continue;
                        }
                        if (r.sourceDeck != null && !r.sourceDeck.isEmpty()) {
                            pool.addAll(CardUtil.getDeck(r.sourceDeck, false, false, "", false, false).getAllCardsInASinglePool().toFlatList());
                            continue;
                        }
                        pool.addAll(CardUtil.getPredicateResult(allCards, r));
                    }
                    ArrayList finalPool = new ArrayList(pool);
                    if (finalPool.size() <= 0) break;
                    for (int i = 0; i < this.count; ++i) {
                        if (allCardVariants) {
                            PaperCard cardTemplate = (PaperCard)finalPool.get(rewardRandom.nextInt(finalPool.size()));
                            PaperCard finalCard = CardUtil.getCardByName(cardTemplate.getCardName());
                            ret.add(new Reward(finalCard, isNoSell));
                            continue;
                        }
                        ret.add(new Reward((PaperCard)finalPool.get(rewardRandom.nextInt(finalPool.size())), isNoSell));
                    }
                    break;
                }
                case "card": 
                case "randomCard": {
                    if (this.cardName != null && !this.cardName.isEmpty()) {
                        if (allCardVariants) {
                            PaperCard card = CardUtil.getCardByName(this.cardName);
                            for (int i = 0; i < this.count + addedCount; ++i) {
                                ret.add(new Reward(CardUtil.getCardByNameAndEdition(this.cardName, card.getEdition()), isNoSell));
                            }
                        } else {
                            for (int i = 0; i < this.count + addedCount; ++i) {
                                ret.add(new Reward(StaticData.instance().getCommonCards().getCard(this.cardName), isNoSell));
                            }
                        }
                    } else if (this.sourceDeck != null && !this.sourceDeck.isEmpty()) {
                        for (PaperCard card : CardUtil.generateCards(CardUtil.getDeck(this.sourceDeck, false, false, "", false, false).getAllCardsInASinglePool().toFlatList(), this, this.count + addedCount, rewardRandom)) {
                            ret.add(new Reward(card, isNoSell));
                        }
                    } else {
                        for (PaperCard card : CardUtil.generateCards(isForEnemy ? allEnemyCards : allCards, this, this.count + addedCount, rewardRandom)) {
                            ret.add(new Reward(card, isNoSell));
                        }
                    }
                    break;
                }
                case "item": {
                    if (this.itemNames != null) {
                        for (int i = 0; i < this.count + addedCount; ++i) {
                            ret.add(new Reward(ItemData.getItem(this.itemNames[WorldSave.getCurrentSave().getWorld().getRandom().nextInt(this.itemNames.length)])));
                        }
                    } else {
                        if (this.itemName == null || this.itemName.isEmpty()) break;
                        for (int i = 0; i < this.count + addedCount; ++i) {
                            ret.add(new Reward(ItemData.getItem(this.itemName)));
                        }
                    }
                    break;
                }
                case "cardPack": {
                    if (this.cardPack == null) break;
                    if (isNoSell) {
                        this.cardPack.getTags().add("noSell");
                    }
                    ret.add(new Reward(this.cardPack, isNoSell));
                    break;
                }
                case "deckCard": {
                    if (cards == null) {
                        return ret;
                    }
                    for (PaperCard card : CardUtil.generateCards(cards, this, this.count + addedCount + Current.player().bonusDeckCards(), rewardRandom)) {
                        ret.add(new Reward(card, isNoSell));
                    }
                    break;
                }
                case "gold": {
                    ret.add(new Reward(this.count + addedCount));
                    break;
                }
                case "life": {
                    ret.add(new Reward(Reward.Type.Life, this.count + addedCount));
                    break;
                }
                case "mana": 
                case "shards": {
                    ret.add(new Reward(Reward.Type.Shards, this.count + addedCount));
                }
            }
        }
        return ret;
    }

    public static List<PaperCard> generateAllCards(Iterable<RewardData> dataList, boolean isForEnemy) {
        return RewardData.rewardsToCards(RewardData.generateAll(dataList, isForEnemy));
    }

    public static Iterable<Reward> generateAll(Iterable<RewardData> dataList, boolean isForEnemy) {
        Array<Reward> ret = new Array<Reward>();
        for (RewardData data : dataList) {
            ret.addAll(data.generate(isForEnemy, false));
        }
        return ret;
    }

    public static List<PaperCard> rewardsToCards(Iterable<Reward> dataList) {
        ArrayList<PaperCard> ret = new ArrayList<PaperCard>();
        boolean allCardVariants = Config.instance().getSettingData().useAllCardVariants;
        if (allCardVariants) {
            String basicLandEdition = "";
            for (Reward data : dataList) {
                PaperCard card = data.getCard();
                if (card.isVeryBasicLand()) {
                    if (basicLandEdition.isEmpty()) {
                        basicLandEdition = card.getEdition();
                    }
                    ret.add(CardUtil.getCardByNameAndEdition(card.getName(), basicLandEdition));
                    continue;
                }
                ret.add(card);
            }
        } else {
            for (Reward data : dataList) {
                ret.add(data.getCard());
            }
        }
        return ret;
    }
}

