/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.data;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import forge.adventure.data.DialogData;
import forge.adventure.util.Config;
import java.io.Serializable;

public class PointOfInterestData
implements Serializable {
    public String name;
    public String type;
    public int count;
    public String spriteAtlas;
    public String sprite;
    public String map;
    public float radiusFactor;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public boolean active = true;
    public String[] questTags = new String[0];
    public DialogData.ActionData.QuestFlag[] questFlagsToActivate = new DialogData.ActionData.QuestFlag[0];
    public String displayName;
    private static Array<PointOfInterestData> pointOfInterestList;

    public static Array<PointOfInterestData> getAllPointOfInterest() {
        if (pointOfInterestList == null) {
            Json json = new Json();
            FileHandle handle = Config.instance().getFile("world/points_of_interest.json");
            if (handle.exists()) {
                pointOfInterestList = json.fromJson(Array.class, PointOfInterestData.class, handle);
            }
        }
        return pointOfInterestList;
    }

    public static PointOfInterestData getPointOfInterest(String name) {
        for (PointOfInterestData data : new Array.ArrayIterator<PointOfInterestData>(PointOfInterestData.getAllPointOfInterest())) {
            if (!data.name.equals(name)) continue;
            return data;
        }
        return null;
    }

    public PointOfInterestData() {
    }

    public PointOfInterestData(PointOfInterestData other) {
        this.name = other.name;
        this.type = other.type;
        this.count = other.count;
        this.spriteAtlas = other.spriteAtlas;
        this.sprite = other.sprite;
        this.map = other.map;
        this.radiusFactor = other.radiusFactor;
        this.offsetX = other.offsetX;
        this.offsetY = other.offsetY;
        this.active = other.active;
        this.questTags = (String[])other.questTags.clone();
        this.displayName = other.displayName;
        this.questFlagsToActivate = other.questFlagsToActivate;
    }

    public String getDisplayName() {
        if (this.displayName == null || this.displayName.isEmpty()) {
            return this.name != null ? this.name : "";
        }
        return this.displayName;
    }
}

