/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.data;

import forge.adventure.data.RewardData;
import forge.adventure.util.CardUtil;
import forge.adventure.util.Config;
import forge.adventure.util.Current;
import forge.deck.Deck;
import forge.deck.DeckgenUtil;
import forge.game.GameFormat;
import forge.model.FModel;
import forge.util.Aggregates;
import forge.util.MyRandom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class EnemyData
implements Serializable {
    private static final long serialVersionUID = -3317270785183936320L;
    public String name;
    public String nameOverride;
    public String sprite;
    public String[] deck;
    public boolean copyPlayerDeck = false;
    public String ai;
    public boolean boss = false;
    public boolean flying = false;
    public boolean randomizeDeck = false;
    public float spawnRate;
    public float difficulty;
    public float speed;
    public float scale = 1.0f;
    public int life;
    public RewardData[] rewards;
    public String[] equipment;
    public String colors = "";
    public EnemyData nextEnemy;
    public int teamNumber = -1;
    public String[] questTags = new String[0];
    public float lifetime;
    public int gamesPerMatch = 1;

    public EnemyData() {
    }

    public EnemyData(EnemyData enemyData) {
        this.name = enemyData.name;
        this.sprite = enemyData.sprite;
        this.deck = enemyData.deck;
        this.ai = enemyData.ai;
        this.boss = enemyData.boss;
        this.flying = enemyData.flying;
        this.randomizeDeck = enemyData.randomizeDeck;
        this.spawnRate = enemyData.spawnRate;
        this.copyPlayerDeck = enemyData.copyPlayerDeck;
        this.difficulty = enemyData.difficulty;
        this.speed = enemyData.speed;
        this.scale = enemyData.scale;
        this.life = enemyData.life;
        this.equipment = enemyData.equipment;
        this.colors = enemyData.colors;
        this.teamNumber = enemyData.teamNumber;
        this.nextEnemy = enemyData.nextEnemy == null ? null : new EnemyData(enemyData.nextEnemy);
        this.nameOverride = enemyData.nameOverride == null ? "" : enemyData.nameOverride;
        this.questTags = (String[])enemyData.questTags.clone();
        this.lifetime = enemyData.lifetime;
        this.gamesPerMatch = enemyData.gamesPerMatch;
        if (enemyData.scale == 0.0f) {
            this.scale = 1.0f;
        }
        if (enemyData.rewards == null) {
            this.rewards = null;
        } else {
            this.rewards = new RewardData[enemyData.rewards.length];
            for (int i = 0; i < this.rewards.length; ++i) {
                this.rewards[i] = new RewardData(enemyData.rewards[i]);
            }
        }
    }

    public Deck generateDeck(boolean isFantasyMode, boolean useGeneticAI) {
        boolean canUseGeneticAI;
        boolean bl = canUseGeneticAI = useGeneticAI && this.life > 16;
        if (canUseGeneticAI && Config.instance().getSettingData().generateLDADecks) {
            GameFormat fmt = FModel.getFormats().getStandard();
            int rand = MyRandom.getRandom().nextInt(100);
            if (rand > 90) {
                fmt = FModel.getFormats().getLegacy();
            } else if (rand > 50) {
                fmt = FModel.getFormats().getModern();
            }
            return DeckgenUtil.buildLDACArchetypeDeck(fmt, true);
        }
        if (this.randomizeDeck) {
            return CardUtil.getDeck(Aggregates.random(this.deck), true, isFantasyMode, this.colors, this.life > 13, canUseGeneticAI);
        }
        return CardUtil.getDeck(this.deck[Current.player().getEnemyDeckNumber(this.getName(), this.deck.length)], true, isFantasyMode, this.colors, this.life > 13, canUseGeneticAI);
    }

    public String getName() {
        if (this.nameOverride != null && !this.nameOverride.isEmpty()) {
            return this.nameOverride;
        }
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        return "(Unnamed Enemy)";
    }

    public boolean match(EnemyData other) {
        if (this.equals(other)) {
            return true;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.questTags.length != other.questTags.length) {
            return false;
        }
        ArrayList<String> myQuestTags = new ArrayList<String>(Arrays.asList(this.questTags));
        ArrayList<String> otherQuestTags = new ArrayList<String>(Arrays.asList(other.questTags));
        myQuestTags.removeAll(otherQuestTags);
        return myQuestTags.isEmpty();
    }
}

