/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.data;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import forge.adventure.character.EnemySprite;
import forge.adventure.data.AdventureQuestStage;
import forge.adventure.data.DialogData;
import forge.adventure.data.EnemyData;
import forge.adventure.data.RewardData;
import forge.adventure.data.WorldData;
import forge.adventure.pointofintrest.PointOfInterest;
import forge.adventure.scene.GameScene;
import forge.adventure.scene.TileMapScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.MapStage;
import forge.adventure.util.AdventureQuestController;
import forge.adventure.util.AdventureQuestEvent;
import forge.adventure.util.Current;
import forge.adventure.world.WorldSave;
import forge.util.Aggregates;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class AdventureQuestData
implements Serializable {
    private int id;
    public boolean isTemplate = false;
    public String name = "";
    public String description = "";
    public String synopsis = "";
    public transient boolean completed = false;
    public transient boolean failed = false;
    private transient boolean prologueDisplayed = false;
    private transient boolean epilogueDisplayed = false;
    public DialogData offerDialog;
    public DialogData prologue;
    public DialogData epilogue;
    public DialogData failureDialog;
    public DialogData declinedDialog;
    public RewardData reward;
    public String rewardDescription = "";
    public AdventureQuestStage[] stages = new AdventureQuestStage[0];
    public String[] questSourceTags = new String[0];
    public String[] questEnemyTags = new String[0];
    public String[] questPOITags = new String[0];
    private transient EnemySprite targetEnemySprite = null;
    private PointOfInterest targetPoI = null;
    Dictionary<String, PointOfInterest> poiTokens = new Hashtable<String, PointOfInterest>();
    Dictionary<String, String> poiBiomeTokens = new Hashtable<String, String>();
    Dictionary<String, EnemyData> enemyTokens = new Hashtable<String, EnemyData>();
    Dictionary<String, String> otherTokens = new Hashtable<String, String>();
    public boolean storyQuest = false;
    public boolean isTracked = false;
    public boolean autoTrack = false;
    public String sourceID = "";

    public int getID() {
        if (this.isTemplate && this.id < 1) {
            this.id = AdventureQuestController.instance().getNextQuestID();
        }
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public RewardData getReward() {
        return this.reward;
    }

    public AdventureQuestData(AdventureQuestData data) {
        this.id = data.id;
        this.isTemplate = false;
        this.name = data.name;
        this.description = data.description;
        this.synopsis = data.synopsis;
        this.offerDialog = new DialogData(data.offerDialog);
        this.prologue = new DialogData(data.prologue);
        this.epilogue = new DialogData(data.epilogue);
        this.failureDialog = new DialogData(data.failureDialog);
        this.declinedDialog = new DialogData(data.declinedDialog);
        this.reward = new RewardData(data.reward);
        this.rewardDescription = data.rewardDescription;
        this.completed = data.completed;
        this.stages = new AdventureQuestStage[data.stages.length];
        for (int i = 0; i < this.stages.length; ++i) {
            this.stages[i] = new AdventureQuestStage(data.stages[i]);
        }
        this.questSourceTags = (String[])data.questSourceTags.clone();
        this.questPOITags = (String[])data.questPOITags.clone();
        this.questEnemyTags = (String[])data.questEnemyTags.clone();
        this.targetPoI = data.targetPoI;
        this.targetEnemySprite = data.targetEnemySprite;
        this.storyQuest = data.storyQuest;
        this.sourceID = data.sourceID;
        this.poiTokens = data.poiTokens;
        this.enemyTokens = data.enemyTokens;
        this.otherTokens = data.otherTokens;
        this.isTracked = data.isTracked;
    }

    public AdventureQuestData() {
        this.declinedDialog = new DialogData();
        this.declinedDialog.text = "Come back tomorrow and perhaps I'll have something that you'll actually be willing to do.";
        DialogData dismiss = new DialogData();
        dismiss.name = "(Catching the not so subtle hint, you leave.)";
        this.declinedDialog.options = new DialogData[1];
        this.declinedDialog.options[0] = dismiss;
    }

    public List<AdventureQuestStage> getActiveStages() {
        ArrayList<AdventureQuestStage> toReturn = new ArrayList<AdventureQuestStage>();
        for (AdventureQuestStage stage : this.stages) {
            if (stage.getStatus() != AdventureQuestController.QuestStatus.ACTIVE) continue;
            toReturn.add(stage);
        }
        return toReturn;
    }

    public List<AdventureQuestStage> getCompletedStages() {
        ArrayList<AdventureQuestStage> toReturn = new ArrayList<AdventureQuestStage>();
        for (AdventureQuestStage stage : this.stages) {
            if (stage.getStatus() != AdventureQuestController.QuestStatus.COMPLETE) continue;
            toReturn.add(stage);
        }
        return toReturn;
    }

    public List<Integer> getCompletedStageIDs() {
        ArrayList<Integer> toReturn = new ArrayList<Integer>();
        for (AdventureQuestStage stage : this.getCompletedStages()) {
            toReturn.add(stage.id);
        }
        return toReturn;
    }

    public PointOfInterest getTargetPOI() {
        for (AdventureQuestStage stage : this.getActiveStages()) {
            this.targetPoI = stage.getTargetPOI();
            if (this.targetPoI == null) continue;
            break;
        }
        return this.targetPoI;
    }

    public EnemySprite getTargetEnemySprite() {
        if (this.targetEnemySprite == null) {
            for (AdventureQuestStage stage : this.getActiveStages()) {
                this.targetEnemySprite = stage.getTargetSprite();
                if (this.targetEnemySprite == null) continue;
                break;
            }
        }
        return this.targetEnemySprite;
    }

    public void initialize() {
        this.poiTokens = new Hashtable<String, PointOfInterest>();
        for (AdventureQuestStage stage : this.stages) {
            this.initializeStage(stage);
        }
        this.replaceTokens();
    }

    public void initializeStage(AdventureQuestStage stage) {
        EnemyData target;
        PointOfInterest temp;
        if (stage == null || stage.objective == null) {
            return;
        }
        stage.initialize();
        switch (stage.objective) {
            case Arena: {
                stage.setTargetPOI(this.poiTokens, this.name);
                break;
            }
            case Clear: {
                stage.setTargetPOI(this.poiTokens, this.name);
                break;
            }
            case CompleteQuest: {
                stage.setTargetPOI(this.poiTokens, this.name);
            }
            case Defeat: {
                stage.setTargetPOI(this.poiTokens, this.name);
                if (stage.mixedEnemies) break;
                stage.setTargetEnemyData(this.generateTargetEnemyData(stage));
                break;
            }
            case Delivery: {
                stage.setTargetPOI(this.poiTokens, this.name);
                break;
            }
            case Escort: {
                stage.setTargetPOI(this.poiTokens, this.name);
                if (stage.mixedEnemies) break;
                stage.setTargetEnemyData(this.generateTargetEnemyData(stage));
                break;
            }
            case Fetch: {
                stage.setTargetPOI(this.poiTokens, this.name);
            }
            case Hunt: {
                stage.setTargetSprite(this.generateTargetEnemySprite(stage));
                break;
            }
            case Leave: {
                stage.setTargetPOI(this.poiTokens, this.name);
                break;
            }
            case MapFlag: {
                stage.setTargetPOI(this.poiTokens, this.name);
                break;
            }
            case Patrol: {
                break;
            }
            case QuestFlag: {
                stage.setTargetPOI(this.poiTokens, this.name);
                break;
            }
            case Rescue: {
                stage.setTargetPOI(this.poiTokens, this.name);
                break;
            }
            case Travel: {
                stage.setTargetPOI(this.poiTokens, this.name);
            }
        }
        if (stage.getTargetPOI() != null && ("cave".equalsIgnoreCase(stage.getTargetPOI().getData().type) || "dungeon".equalsIgnoreCase(stage.getTargetPOI().getData().type))) {
            WorldSave.getCurrentSave().getPointOfInterestChanges(stage.getTargetPOI().getID()).clearDeletedObjects();
        }
        if ((temp = stage.getTargetPOI()) != null) {
            this.poiTokens.put("$(poi_" + stage.id + ")", temp);
            this.poiBiomeTokens.put("$(biome_" + stage.id + ")", GameScene.instance().getBiomeByPosition(temp.getPosition()));
        }
        if ((target = stage.getTargetEnemyData()) != null) {
            this.enemyTokens.put("$(enemy_" + stage.id + ")", target);
        }
        this.otherTokens.put("$(playername)", Current.player().getName());
        this.otherTokens.put("$(currentbiome)", GameScene.instance().getAdventurePlayerLocation(false, true));
        this.otherTokens.put("$(playerrace)", Current.player().raceName());
    }

    public void replaceTokens() {
        this.replaceTokens(this.offerDialog);
        this.replaceTokens(this.prologue);
        this.replaceTokens(this.epilogue);
        this.replaceTokens(this.failureDialog);
        this.replaceTokens(this.declinedDialog);
        this.name = this.replaceTokens(this.name);
        this.description = this.replaceTokens(this.description);
        this.rewardDescription = this.replaceTokens(this.rewardDescription);
        for (AdventureQuestStage stage : this.stages) {
            this.replaceTokens(stage);
        }
    }

    private void replaceTokens(AdventureQuestStage stage) {
        this.replaceTokens(stage.prologue);
        this.replaceTokens(stage.epilogue);
        this.replaceTokens(stage.failureDialog);
        stage.name = this.replaceTokens(stage.name);
        stage.description = this.replaceTokens(stage.description);
    }

    private String replaceTokens(String data) {
        String key;
        Enumeration<String> e = this.poiTokens.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            data = data.replace(key, this.poiTokens.get(key).getDisplayName());
        }
        e = this.poiBiomeTokens.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            data = data.replace(key, this.poiBiomeTokens.get(key));
        }
        Enumeration<String> enemy = this.enemyTokens.keys();
        while (enemy.hasMoreElements()) {
            String enemyKey = enemy.nextElement();
            data = data.replace(enemyKey, this.enemyTokens.get(enemyKey).getName());
        }
        Enumeration<String> other = this.otherTokens.keys();
        while (other.hasMoreElements()) {
            key = other.nextElement();
            data = data.replace(key, this.otherTokens.get(key));
        }
        return data;
    }

    private void replaceTokens(DialogData data) {
        for (DialogData dialogData : data.options) {
            this.replaceTokens(dialogData);
        }
        Enumeration<String> e = this.poiTokens.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            data.text = data.text.replace(key, this.poiTokens.get(key).getDisplayName());
            data.name = data.name.replace(key, this.poiTokens.get(key).getDisplayName());
        }
        e = this.poiBiomeTokens.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            data.text = data.text.replace(key, this.poiBiomeTokens.get(key));
            data.name = data.name.replace(key, this.poiBiomeTokens.get(key));
        }
        e = this.enemyTokens.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            data.text = data.text.replace(key, this.enemyTokens.get(key).getName());
            data.name = data.name.replace(key, this.enemyTokens.get(key).getName());
        }
        Enumeration<String> other = this.otherTokens.keys();
        while (other.hasMoreElements()) {
            String key = other.nextElement();
            data.text = data.text.replace(key, this.otherTokens.get(key));
            data.name = data.name.replace(key, this.otherTokens.get(key));
        }
        for (Serializable serializable : data.action) {
            if (serializable == null || ((DialogData.ActionData)serializable).POIReference == null) continue;
            Enumeration<String> e2 = this.poiTokens.keys();
            while (e2.hasMoreElements()) {
                String key = e2.nextElement();
                ((DialogData.ActionData)serializable).POIReference = ((DialogData.ActionData)serializable).POIReference.replace(key, this.poiTokens.get(key).getID());
            }
        }
    }

    private EnemySprite generateTargetEnemySprite(AdventureQuestStage stage) {
        if (stage.objective == AdventureQuestController.ObjectiveTypes.Hunt) {
            EnemyData toUse = this.generateTargetEnemyData(stage);
            toUse.lifetime = stage.count3;
            EnemySprite toReturn = new EnemySprite(toUse);
            toReturn.questStageID = stage.stageID.toString();
            return toReturn;
        }
        return null;
    }

    private EnemyData generateTargetEnemyData(AdventureQuestStage stage) {
        ArrayList<EnemyData> matchesTags = new ArrayList<EnemyData>();
        for (EnemyData data : new Array.ArrayIterator<EnemyData>(WorldData.getAllEnemies())) {
            ArrayList<String> candidateTags = new ArrayList<String>(Arrays.asList(data.questTags));
            int tagCount = candidateTags.size();
            candidateTags.removeAll(stage.enemyExcludeTags);
            if (candidateTags.size() != tagCount) continue;
            candidateTags.removeAll(stage.enemyTags);
            if (candidateTags.size() != tagCount - stage.enemyTags.size()) continue;
            matchesTags.add(data);
        }
        if (matchesTags.isEmpty()) {
            return new EnemyData(Aggregates.random(WorldData.getAllEnemies()));
        }
        return new EnemyData((EnemyData)Aggregates.random(matchesTags));
    }

    public void updateStages(AdventureQuestEvent event) {
        boolean done = true;
        if (event.poi == null && MapStage.getInstance().isInMap()) {
            event.poi = TileMapScene.instance().rootPoint;
        }
        block4: for (AdventureQuestStage stage : this.stages) {
            switch (stage.getStatus()) {
                case ACTIVE: {
                    done = stage.handleEvent(event) == AdventureQuestController.QuestStatus.COMPLETE && done;
                    break;
                }
                case COMPLETE: {
                    continue block4;
                }
                default: {
                    done = false;
                }
            }
            this.failed |= stage.getStatus() == AdventureQuestController.QuestStatus.FAILED;
        }
        this.completed = done;
    }

    public DialogData getPrologue() {
        if (!this.prologueDisplayed) {
            this.prologueDisplayed = true;
            return this.prologue;
        }
        return null;
    }

    public DialogData getEpilogue() {
        if (!this.epilogueDisplayed) {
            this.epilogueDisplayed = true;
            return this.epilogue;
        }
        return null;
    }

    public void fail() {
        this.failed = true;
        this.isTracked = false;
    }

    public void activateNextStages() {
        boolean showNotification = false;
        for (AdventureQuestStage s2 : this.stages) {
            if (s2.getStatus() != AdventureQuestController.QuestStatus.INACTIVE) continue;
            s2.checkPrerequisites(this.getCompletedStageIDs());
            if (s2.getStatus() != AdventureQuestController.QuestStatus.ACTIVE) continue;
            AdventureQuestController.instance().addQuestSprites(s2);
            showNotification = true;
        }
        if (showNotification) {
            StringBuilder description = new StringBuilder();
            description.append("[!]").append(this.name).append("[]");
            for (AdventureQuestStage stage : this.getActiveStages()) {
                description.append("\n").append(stage.name).append("\n[/]").append(stage.description).append("[]");
            }
            GameHUD.getInstance().addNotification(description.toString());
        }
    }

    public PointOfInterest getClosestValidPOI(Vector2 pos) {
        ArrayList<PointOfInterest> validPOIs = new ArrayList<PointOfInterest>();
        for (AdventureQuestStage stage : this.getActiveStages()) {
            validPOIs.addAll(stage.getValidPOIs());
        }
        if (validPOIs.isEmpty()) {
            return null;
        }
        validPOIs.sort(Comparator.comparingInt(a -> (int)a.getPosition().dst(pos)));
        return (PointOfInterest)validPOIs.get(0);
    }

    class questUpdate {
        questUpdate() {
        }
    }
}

