/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.data;

import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.utils.Array;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import forge.Forge;
import forge.adventure.character.EnemySprite;
import forge.adventure.data.ConfigData;
import forge.adventure.data.EnemyData;
import forge.adventure.data.RewardData;
import forge.adventure.data.WorldData;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.scene.RewardScene;
import forge.adventure.util.AdventureEventController;
import forge.adventure.util.Config;
import forge.adventure.util.Current;
import forge.adventure.util.Reward;
import forge.card.CardEdition;
import forge.card.PrintSheet;
import forge.deck.Deck;
import forge.game.GameType;
import forge.gamemodes.limited.BoosterDraft;
import forge.gamemodes.limited.LimitedPoolType;
import forge.model.CardBlock;
import forge.model.FModel;
import forge.util.Aggregates;
import forge.util.MyRandom;
import forge.util.storage.IStorage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;

public class AdventureEventData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public transient BoosterDraft draft;
    public AdventureEventParticipant[] participants;
    public int rounds;
    public int currentRound;
    public AdventureEventRules eventRules = new AdventureEventRules();
    public AdventureEventReward[] rewards;
    public int eventOrigin;
    public String sourceID;
    public long eventSeed;
    public AdventureEventController.EventStyle style;
    public AdventureEventController.EventStatus eventStatus;
    public AdventureEventController.EventFormat format;
    private transient Random random = new Random();
    public Deck registeredDeck;
    public Deck draftedDeck;
    public List<Deck> jumpstartBoosters = new ArrayList<Deck>();
    public boolean isDraftComplete = false;
    public String description = "";
    public String[] packConfiguration = new String[0];
    public transient CardBlock cardBlock;
    public String cardBlockName;
    public boolean playerWon;
    public int matchesWon;
    public int matchesLost;
    private Deck[] rewardPacks;
    private static final Predicate<CardEdition> filterPioneer = FModel.getFormats().getPioneer().editionLegalPredicate;
    private static final Predicate<CardEdition> filterModern = FModel.getFormats().getModern().editionLegalPredicate;
    private static final Predicate<CardEdition> filterVintage = FModel.getFormats().getVintage().editionLegalPredicate;
    private static final Predicate<CardEdition> filterStandard = FModel.getFormats().getStandard().editionLegalPredicate;
    private transient AdventureEventHuman humanPlayerInstance;
    public AdventureEventParticipant nextOpponent = null;
    public Map<Integer, List<AdventureEventMatch>> matches = new HashMap<Integer, List<AdventureEventMatch>>();

    public AdventureEventData(AdventureEventData other) {
        this.participants = (AdventureEventParticipant[])other.participants.clone();
        this.rounds = other.rounds;
        this.eventRules = other.eventRules;
        this.rewards = (AdventureEventReward[])other.rewards.clone();
        this.eventOrigin = other.eventOrigin;
        this.sourceID = other.sourceID;
        this.eventSeed = other.eventSeed;
        this.style = other.style;
        this.random.setSeed(this.eventSeed);
        this.eventStatus = other.eventStatus;
        this.registeredDeck = other.registeredDeck;
        this.isDraftComplete = other.isDraftComplete;
        this.description = other.description;
        this.cardBlockName = other.cardBlockName;
        this.packConfiguration = other.packConfiguration;
        this.playerWon = other.playerWon;
        this.matchesWon = other.matchesWon;
        this.matchesLost = other.matchesLost;
    }

    public Deck[] getRewardPacks(int count) {
        Deck[] ret = new Deck[count];
        for (int i = 0; i < count; ++i) {
            ret[i] = AdventureEventController.instance().generateBooster(Aggregates.random(this.getCardBlock().getSets()).getCode());
        }
        return ret;
    }

    private Random getEventRandom() {
        if (this.random == null) {
            this.random = this.eventSeed > 0L ? new Random(this.eventSeed) : new Random();
        }
        return this.random;
    }

    public AdventureEventData(Long seed, AdventureEventController.EventFormat selectedFormat) {
        this.setEventSeed(seed);
        this.eventStatus = AdventureEventController.EventStatus.Available;
        this.registeredDeck = new Deck();
        this.format = selectedFormat;
        if (this.format.equals((Object)AdventureEventController.EventFormat.Draft)) {
            this.cardBlock = this.pickWeightedCardBlock();
            if (this.cardBlock == null) {
                return;
            }
            this.cardBlockName = this.cardBlock.getName();
            this.rewardPacks = this.getRewardPacks(3);
            this.generateParticipants(7);
            if (this.cardBlock != null) {
                this.packConfiguration = this.getBoosterConfiguration(this.cardBlock);
                this.rewards = new AdventureEventReward[4];
                AdventureEventReward r0 = new AdventureEventReward();
                AdventureEventReward r1 = new AdventureEventReward();
                AdventureEventReward r2 = new AdventureEventReward();
                AdventureEventReward r3 = new AdventureEventReward();
                r0.minWins = 0;
                r0.maxWins = 0;
                r0.cardRewards = new Deck[]{this.rewardPacks[0]};
                this.rewards[0] = r0;
                r1.minWins = 1;
                r1.maxWins = 3;
                r1.cardRewards = new Deck[]{this.rewardPacks[1], this.rewardPacks[2]};
                this.rewards[1] = r1;
                r2.minWins = 2;
                r2.maxWins = 3;
                r2.itemRewards = new String[]{"Challenge Coin"};
                this.rewards[2] = r2;
            }
        } else if (this.format.equals((Object)AdventureEventController.EventFormat.Jumpstart)) {
            int numPacksToPickFrom = 6;
            this.generateParticipants(7);
            this.cardBlock = this.pickJumpstartCardBlock();
            if (this.cardBlock == null) {
                return;
            }
            this.cardBlockName = this.cardBlock.getName();
            this.jumpstartBoosters = AdventureEventController.instance().getJumpstartBoosters(this.cardBlock, numPacksToPickFrom);
            this.packConfiguration = new String[]{this.cardBlock.getLandSet().getCode(), this.cardBlock.getLandSet().getCode(), this.cardBlock.getLandSet().getCode()};
            for (AdventureEventParticipant participant : this.participants) {
                List<Deck> availableOptions = AdventureEventController.instance().getJumpstartBoosters(this.cardBlock, numPacksToPickFrom);
                ArrayList chosenPacks = new ArrayList();
                HashMap themeMap = new HashMap();
                for (Deck option : availableOptions) {
                    String theme = option.getName().replaceAll("\\d$", "").trim();
                    if (!themeMap.containsKey(theme)) {
                        themeMap.put(theme, new ArrayList());
                    }
                    ((List)themeMap.get(theme)).add(option);
                }
                String themeAdded = "";
                boolean done = false;
                while (!done) {
                    block3: for (int i = this.packConfiguration.length - chosenPacks.size(); i > 1; --i) {
                        if (!themeAdded.isEmpty()) continue;
                        for (String theme : themeMap.keySet()) {
                            if (((List)themeMap.get(theme)).size() < i) continue;
                            themeAdded = theme;
                            continue block3;
                        }
                    }
                    if (themeAdded.isEmpty()) {
                        done = true;
                        continue;
                    }
                    chosenPacks.addAll(((List)themeMap.get(themeAdded)).subList(0, Math.min(((List)themeMap.get(themeAdded)).size(), this.packConfiguration.length - chosenPacks.size())));
                    availableOptions.removeAll((Collection)themeMap.get(themeAdded));
                    themeMap.remove(themeAdded);
                    themeAdded = "";
                }
                HashMap colorMap = new HashMap();
                for (Deck option : availableOptions) {
                    if (option.getTags().contains("black")) {
                        ((List)colorMap.getOrDefault("black", new ArrayList())).add(option);
                    }
                    if (option.getTags().contains("blue")) {
                        ((List)colorMap.getOrDefault("blue", new ArrayList())).add(option);
                    }
                    if (option.getTags().contains("green")) {
                        ((List)colorMap.getOrDefault("green", new ArrayList())).add(option);
                    }
                    if (option.getTags().contains("red")) {
                        ((List)colorMap.getOrDefault("red", new ArrayList())).add(option);
                    }
                    if (option.getTags().contains("white")) {
                        ((List)colorMap.getOrDefault("white", new ArrayList())).add(option);
                    }
                    if (option.getTags().contains("multicolor")) {
                        ((List)colorMap.getOrDefault("multicolor", new ArrayList())).add(option);
                    }
                    if (!option.getTags().contains("colorless")) continue;
                    ((List)colorMap.getOrDefault("colorless", new ArrayList())).add(option);
                }
                done = false;
                String colorAdded = "";
                while (!done) {
                    ArrayList<String> colorsAlreadyPicked = new ArrayList<String>();
                    for (Deck picked : chosenPacks) {
                        if (picked.getTags().contains("black")) {
                            colorsAlreadyPicked.add("black");
                        }
                        if (picked.getTags().contains("blue")) {
                            colorsAlreadyPicked.add("blue");
                        }
                        if (picked.getTags().contains("green")) {
                            colorsAlreadyPicked.add("green");
                        }
                        if (picked.getTags().contains("red")) {
                            colorsAlreadyPicked.add("red");
                        }
                        if (picked.getTags().contains("white")) {
                            colorsAlreadyPicked.add("white");
                        }
                        if (picked.getTags().contains("multicolor")) {
                            colorsAlreadyPicked.add("multicolor");
                        }
                        if (!picked.getTags().contains("colorless")) continue;
                        colorsAlreadyPicked.add("colorless");
                    }
                    block8: while (colorAdded.isEmpty() && colorsAlreadyPicked.size() > 0) {
                        String colorToTry = (String)Aggregates.removeRandom(colorsAlreadyPicked);
                        for (Deck toCheck : availableOptions) {
                            if (!toCheck.getTags().contains(colorToTry)) continue;
                            colorAdded = colorToTry;
                            chosenPacks.add(toCheck);
                            availableOptions.remove(toCheck);
                            continue block8;
                        }
                    }
                    if (this.packConfiguration.length > chosenPacks.size() && colorAdded.isEmpty() && !availableOptions.isEmpty()) {
                        chosenPacks.add(Aggregates.removeRandom(availableOptions));
                        colorAdded = "";
                        continue;
                    }
                    done = colorAdded.isEmpty() || this.packConfiguration.length <= chosenPacks.size();
                    colorAdded = "";
                }
                participant.registeredDeck = new Deck();
                for (Deck chosen : chosenPacks) {
                    participant.registeredDeck.getMain().addAllFlat(chosen.getMain().toFlatList());
                }
            }
            this.rewards = new AdventureEventReward[4];
            AdventureEventReward r0 = new AdventureEventReward();
            AdventureEventReward r1 = new AdventureEventReward();
            AdventureEventReward r2 = new AdventureEventReward();
            AdventureEventReward r3 = new AdventureEventReward();
            RewardData r0gold = new RewardData();
            r0gold.count = 100;
            r0gold.type = "gold";
            r0.rewards = new RewardData[]{r0gold};
            r0.minWins = 1;
            r0.maxWins = 1;
            this.rewards[0] = r0;
            RewardData r1gold = new RewardData();
            r1gold.count = 200;
            r1gold.type = "gold";
            r1.rewards = new RewardData[]{r1gold};
            r1.minWins = 2;
            r1.maxWins = 2;
            this.rewards[1] = r1;
            r2.minWins = 3;
            r2.maxWins = 3;
            RewardData r2gold = new RewardData();
            r2gold.count = 500;
            r2gold.type = "gold";
            r2.rewards = new RewardData[]{r2gold};
            this.rewards[2] = r2;
            r3.minWins = 0;
            r3.maxWins = 3;
            this.rewards[3] = r3;
        }
    }

    public void setEventSeed(long seed) {
        this.getEventRandom().setSeed(seed);
    }

    public CardBlock getCardBlock() {
        if (this.cardBlock == null) {
            this.cardBlock = FModel.getBlocks().get(this.cardBlockName);
        }
        return this.cardBlock;
    }

    public BoosterDraft getDraft() {
        if (this.format != AdventureEventController.EventFormat.Draft) {
            return null;
        }
        Random placeholder = MyRandom.getRandom();
        MyRandom.setRandom(this.getEventRandom());
        if (this.draft == null && (this.eventStatus == AdventureEventController.EventStatus.Available || this.eventStatus == AdventureEventController.EventStatus.Entered)) {
            this.draft = BoosterDraft.createDraft(LimitedPoolType.Block, this.getCardBlock(), this.packConfiguration);
        }
        if (this.packConfiguration == null) {
            this.packConfiguration = this.getBoosterConfiguration(this.getCardBlock());
        }
        MyRandom.setRandom(placeholder);
        return this.draft;
    }

    public static Predicate<CardEdition> selectSetPool() {
        int rollD100 = MyRandom.getRandom().nextInt(100);
        Predicate<CardEdition> rolledFilter = rollD100 < 30 ? filterStandard : (rollD100 < 60 ? filterPioneer : (rollD100 < 80 ? filterModern : filterVintage));
        return rolledFilter;
    }

    private CardBlock pickWeightedCardBlock() {
        CardEdition.Collection editions = FModel.getMagicDb().getEditions();
        IStorage<CardBlock> src = FModel.getBlocks();
        Predicate<CardEdition> filter = Predicates.and(CardEdition.Predicates.CAN_MAKE_BOOSTER, AdventureEventData.selectSetPool());
        ArrayList<CardEdition> allEditions = new ArrayList<CardEdition>();
        StreamSupport.stream(editions.spliterator(), false).filter(filter::apply).filter(CardEdition::hasBoosterTemplate).collect(Collectors.toList()).iterator().forEachRemaining(allEditions::add);
        ArrayList<String> restrictedDrafts = new ArrayList<String>();
        restrictedDrafts.add("LEA");
        restrictedDrafts.add("LEB");
        restrictedDrafts.add("2ED");
        restrictedDrafts.add("30A");
        allEditions.removeIf(q -> restrictedDrafts.contains(q.getCode()));
        ArrayList<CardBlock> legalBlocks = new ArrayList<CardBlock>();
        for (CardBlock b : src) {
            if (b.getSets().isEmpty() || b.getCntBoostersDraft() < 1) continue;
            boolean isOkay = true;
            block1: for (CardEdition c : b.getSets()) {
                if (!allEditions.contains(c)) {
                    isOkay = false;
                    break;
                }
                if (!c.hasBoosterTemplate()) {
                    isOkay = false;
                    break;
                }
                List<Pair<String, Integer>> slots = c.getBoosterTemplate().getSlots();
                int boosterSize = 0;
                for (Pair<String, Integer> slot : slots) {
                    boosterSize += slot.getRight().intValue();
                }
                isOkay = boosterSize > 11;
                for (PrintSheet ps : c.getPrintSheetsBySection()) {
                    if (!ps.containsCardNamed("Black Lotus", 1) && !ps.containsCardNamed("Mox Emerald", 1) && !ps.containsCardNamed("Mox Pearl", 1) && !ps.containsCardNamed("Mox Ruby", 1) && !ps.containsCardNamed("Mox Sapphire", 1) && !ps.containsCardNamed("Mox Jet", 1) && !ps.containsCardNamed("Ancestral Recall", 1) && !ps.containsCardNamed("Timetwister", 1) && !ps.containsCardNamed("Time Walk", 1)) continue;
                    isOkay = false;
                    continue block1;
                }
            }
            if (!isOkay) continue;
            legalBlocks.add(b);
        }
        ConfigData configData = Config.instance().getConfigData();
        if (configData.allowedEditions != null) {
            List<String> allowed = Arrays.asList(configData.allowedEditions);
            legalBlocks.removeIf(q -> !allowed.contains(q.getName()));
        } else {
            for (String restricted : configData.restrictedEditions) {
                legalBlocks.removeIf(q -> q.getName().equals(restricted));
            }
        }
        return legalBlocks.isEmpty() ? null : (CardBlock)Aggregates.random(legalBlocks);
    }

    private CardBlock pickJumpstartCardBlock() {
        IStorage<CardBlock> src = FModel.getBlocks();
        ArrayList<CardBlock> legalBlocks = new ArrayList<CardBlock>();
        for (CardBlock b : src) {
            if (!b.getName().toUpperCase().contains("JUMPSTART")) continue;
            legalBlocks.add(b);
        }
        ConfigData configData = Config.instance().getConfigData();
        if (configData.allowedEditions != null) {
            List<String> allowed = Arrays.asList(configData.allowedEditions);
            legalBlocks.removeIf(q -> !allowed.contains(q.getName()));
        } else {
            for (String restricted : configData.restrictedEditions) {
                legalBlocks.removeIf(q -> q.getName().equals(restricted));
            }
        }
        return legalBlocks.isEmpty() ? null : (CardBlock)Aggregates.random(legalBlocks);
    }

    public String[] getBoosterConfiguration(CardBlock selectedBlock) {
        Random placeholder = MyRandom.getRandom();
        MyRandom.setRandom(this.getEventRandom());
        String[] ret = new String[selectedBlock.getCntBoostersDraft()];
        for (int i = 0; i < selectedBlock.getCntBoostersDraft(); ++i) {
            ret[i] = i < selectedBlock.getNumberSets() ? selectedBlock.getSets().get(i).getCode() : Aggregates.random(selectedBlock.getSets()).getCode();
        }
        MyRandom.setRandom(placeholder);
        return ret;
    }

    public void startEvent() {
        if (this.eventStatus == AdventureEventController.EventStatus.Ready) {
            this.currentRound = 1;
            this.eventStatus = AdventureEventController.EventStatus.Started;
        }
    }

    public void generateParticipants(int numberOfOpponents) {
        this.participants = new AdventureEventParticipant[numberOfOpponents + 1];
        List<EnemyData> data = Aggregates.random(WorldData.getAllEnemies(), numberOfOpponents);
        data.removeIf(q -> q.nextEnemy != null);
        for (int i = 0; i < numberOfOpponents; ++i) {
            this.participants[i] = new AdventureEventParticipant().generate(data.get(i));
        }
        this.participants[numberOfOpponents] = this.getHumanPlayer();
    }

    public AdventureEventHuman getHumanPlayer() {
        if (this.humanPlayerInstance == null) {
            this.humanPlayerInstance = new AdventureEventHuman();
        }
        return this.humanPlayerInstance;
    }

    public List<AdventureEventMatch> getMatches(int round) {
        if (this.matches.containsKey(round)) {
            return this.matches.get(round);
        }
        List<Object> activePlayers = new ArrayList();
        if (this.style == AdventureEventController.EventStyle.Bracket) {
            if (round == 1) {
                activePlayers = Arrays.stream(this.participants).collect(Collectors.toList());
            } else {
                if (this.matches.get(round - 1) == null) {
                    return null;
                }
                for (int i = 0; i < this.matches.get(round - 1).size(); ++i) {
                    AdventureEventParticipant w = this.matches.get((Object)Integer.valueOf((int)(round - 1))).get((int)i).winner;
                    if (w == null) {
                        return null;
                    }
                    activePlayers.add(w);
                }
            }
            this.matches.put(round, new ArrayList());
            while (!activePlayers.isEmpty()) {
                AdventureEventMatch match = new AdventureEventMatch();
                match.p1 = (AdventureEventParticipant)activePlayers.remove(MyRandom.getRandom().nextInt(activePlayers.size()));
                if (!activePlayers.isEmpty()) {
                    match.p2 = (AdventureEventParticipant)activePlayers.remove(MyRandom.getRandom().nextInt(activePlayers.size()));
                }
                this.matches.get(round).add(match);
            }
        }
        return this.matches.get(this.currentRound);
    }

    public void giveRewards() {
        int wins = this.matchesWon;
        Array<Reward> ret = new Array<Reward>();
        if (this.format == AdventureEventController.EventFormat.Draft) {
            this.rewards[3] = new AdventureEventReward();
            this.rewards[3].minWins = 3;
            this.rewards[3].maxWins = 3;
            this.draftedDeck.setName("Drafted Deck");
            this.draftedDeck.setComment("Prize for placing 1st overall in draft event");
            this.rewards[3].cardRewards = new Deck[]{this.draftedDeck};
        } else if (this.format == AdventureEventController.EventFormat.Jumpstart) {
            this.rewards[3] = new AdventureEventReward();
            this.rewards[3].minWins = 0;
            this.rewards[3].maxWins = 3;
            this.registeredDeck.setName("Jumpstart Event Packs");
            this.rewards[3].cardRewards = new Deck[]{this.registeredDeck};
            this.rewards[3].isNoSell = true;
        }
        for (AdventureEventReward r : this.rewards) {
            RewardData data;
            if (r.minWins > wins || r.maxWins < wins) continue;
            for (Deck pack : r.cardRewards) {
                data = new RewardData();
                data.type = "cardPack";
                data.count = 1;
                data.cardPack = pack;
                ret.addAll(data.generate(false, true, r.isNoSell));
            }
            for (String item : r.itemRewards) {
                data = new RewardData();
                data.type = "item";
                data.count = 1;
                data.itemName = item;
                ret.addAll(data.generate(false, true));
            }
            for (RewardData data2 : r.rewards) {
                ret.addAll(data2.generate(false, true));
            }
        }
        if (ret.size > 0) {
            RewardScene.instance().loadRewards(ret, RewardScene.Type.Loot, null);
            Forge.switchScene(RewardScene.instance());
        }
        this.playerWon = this.matchesLost == 0 || this.matchesWon == this.rounds;
        this.eventStatus = AdventureEventController.EventStatus.Awarded;
    }

    public String getPairingDescription() {
        switch (this.eventRules.pairingStyle) {
            case Swiss: {
                return "swiss";
            }
            case SwissWithCut: {
                return "swiss (with cut)";
            }
            case RoundRobin: {
                return "round robin";
            }
            case SingleElimination: {
                return "single elimination";
            }
            case DoubleElimination: {
                return "double elimination";
            }
        }
        return "";
    }

    public String getDescription(PointOfInterestChanges changes) {
        if (this.format.equals((Object)AdventureEventController.EventFormat.Draft)) {
            this.description = "Event Type: Booster Draft\n";
            this.description = this.description + "Block: " + this.getCardBlock() + "\n";
            this.description = this.description + "Boosters: " + String.join((CharSequence)", ", this.packConfiguration) + "\n";
            this.description = this.description + "Competition Style: " + this.participants.length + " players, matches played as best of " + this.eventRules.gamesPerMatch + ", " + this.getPairingDescription() + "\n\n";
            this.description = this.description + String.format("Entry Fee (incl. reputation)\nGold %d[][+Gold][BLACK]\nMana Shards %d[][+Shards][BLACK]\n", Math.round((float)this.eventRules.goldToEnter * changes.getTownPriceModifier()), Math.round((float)this.eventRules.shardsToEnter * changes.getTownPriceModifier()));
            this.description = this.eventRules.acceptsBronzeChallengeCoin ? this.description + "Bronze Challenge Coin [][+BronzeChallengeCoin][BLACK]\n\n" : (this.eventRules.acceptsSilverChallengeCoin ? this.description + "Silver Challenge Coin [][+SilverChallengeCoin][BLACK]\n\n" : (this.eventRules.acceptsChallengeCoin ? this.description + "Gold Challenge Coin [][+ChallengeCoin][BLACK]\n\n" : this.description + "\n"));
            this.description = this.description + String.format("Prizes\nChampion: Keep drafted deck\n2+ round wins: Challenge Coin \n1+ round wins: %s Booster, %s Booster\n0 round wins: %s Booster", this.rewardPacks[0].getComment(), this.rewardPacks[1].getComment(), this.rewardPacks[2].getComment());
        } else if (this.format.equals((Object)AdventureEventController.EventFormat.Jumpstart)) {
            this.description = "Event Type: Jumpstart\n";
            this.description = this.description + "Block: " + this.getCardBlock() + "\n";
            this.description = this.description + "Competition Style: " + this.participants.length + " players, matches played as best of " + this.eventRules.gamesPerMatch + ", " + this.getPairingDescription() + "\n\n";
            this.description = this.description + String.format("Entry Fee (incl. reputation)\nGold %d[][+Gold][BLACK]\nMana Shards %d[][+Shards][BLACK]\n", Math.round((float)this.eventRules.goldToEnter * changes.getTownPriceModifier()), Math.round((float)this.eventRules.shardsToEnter * changes.getTownPriceModifier()));
            this.description = this.eventRules.acceptsBronzeChallengeCoin ? this.description + "Bronze Challenge Coin [][+BronzeChallengeCoin][BLACK]\n\n" : (this.eventRules.acceptsSilverChallengeCoin ? this.description + "Silver Challenge Coin [][+SilverChallengeCoin][BLACK]\n\n" : (this.eventRules.acceptsChallengeCoin ? this.description + "Gold Challenge Coin [][+ChallengeCoin][BLACK]\n\n" : this.description + "\n"));
            this.description = this.description + "Prizes\n3 round wins: 500 gold\n2 round wins: 200 gold\n1 round win: 100 gold\n";
            this.description = this.description + "Finishing event will award an unsellable copy of each card in your Jumpstart deck.";
        }
        return this.description;
    }

    static enum PairingStyle {
        SingleElimination,
        DoubleElimination,
        Swiss,
        SwissWithCut,
        RoundRobin;

    }

    public static class AdventureEventReward
    implements Serializable {
        private static final long serialVersionUID = -2605375040895115477L;
        public int minWins = -1;
        public int maxWins = -1;
        public Deck[] cardRewards = new Deck[0];
        public String[] itemRewards = new String[0];
        public RewardData[] rewards = new RewardData[0];
        public boolean isNoSell = false;
    }

    public static class AdventureEventMatch
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public AdventureEventParticipant p1;
        public AdventureEventParticipant p2;
        public AdventureEventParticipant winner;
        public int round;
    }

    public static class AdventureEventRules
    implements Serializable {
        private static final long serialVersionUID = -2902188278147984885L;
        public int goldToEnter;
        public int shardsToEnter;
        public boolean acceptsChallengeCoin = false;
        public boolean acceptsSilverChallengeCoin = false;
        public boolean acceptsBronzeChallengeCoin = false;
        public GameType gameType = GameType.AdventureEvent;
        public int startingLife = 20;
        public boolean allowsShards = false;
        public boolean allowsItems = false;
        public boolean allowsBlessings = false;
        public boolean allowsAddBasicLands = true;
        public int gamesPerMatch = 3;
        public PairingStyle pairingStyle = PairingStyle.SingleElimination;

        public AdventureEventRules() {
            this(AdventureEventController.EventFormat.Constructed, PairingStyle.SingleElimination, 1.0f);
        }

        public AdventureEventRules(AdventureEventController.EventFormat format, float localPriceModifier) {
            this(format, PairingStyle.SingleElimination, localPriceModifier);
        }

        public AdventureEventRules(AdventureEventController.EventFormat format, PairingStyle pairingStyle, float localPriceModifier) {
            int baseGoldEntry = 99999;
            int baseShardEntry = 9999;
            this.pairingStyle = pairingStyle;
            switch (format) {
                case Constructed: {
                    this.acceptsSilverChallengeCoin = true;
                    this.acceptsChallengeCoin = false;
                    this.acceptsBronzeChallengeCoin = false;
                    baseGoldEntry = 1500;
                    baseShardEntry = 25;
                    this.allowsAddBasicLands = false;
                    break;
                }
                case Draft: {
                    this.acceptsChallengeCoin = true;
                    this.acceptsSilverChallengeCoin = false;
                    this.acceptsBronzeChallengeCoin = false;
                    baseGoldEntry = 3000;
                    baseShardEntry = 50;
                    this.startingLife = 20;
                    this.allowsAddBasicLands = true;
                    break;
                }
                case Jumpstart: {
                    this.acceptsChallengeCoin = false;
                    this.acceptsSilverChallengeCoin = false;
                    this.acceptsBronzeChallengeCoin = true;
                    baseGoldEntry = 200;
                    baseShardEntry = 5;
                    this.startingLife = 15;
                    this.allowsAddBasicLands = false;
                }
            }
            this.goldToEnter = baseGoldEntry;
            this.shardsToEnter = baseShardEntry;
        }
    }

    public static class AdventureEventHuman
    extends AdventureEventParticipant {
        @Override
        public Deck getDeck() {
            return this.registeredDeck == null ? Current.player().getSelectedDeck() : this.registeredDeck;
        }

        @Override
        public String getName() {
            return Current.player().getName();
        }

        @Override
        public Image getAvatar() {
            return new Image(Current.player().avatar());
        }
    }

    public static class AdventureEventParticipant
    implements Serializable,
    Comparable<AdventureEventParticipant> {
        private static final long serialVersionUID = 1L;
        private transient EnemySprite sprite;
        String enemyDataName;
        Deck registeredDeck;
        public int wins;
        public int losses;

        public AdventureEventParticipant generate(EnemyData data) {
            AdventureEventParticipant ret = new AdventureEventParticipant();
            ret.enemyDataName = data.getName();
            ret.sprite = new EnemySprite(data);
            return ret;
        }

        public String getRecord() {
            return String.format("%d-%d", this.wins, this.losses);
        }

        private AdventureEventParticipant() {
        }

        public Deck getDeck() {
            return this.registeredDeck;
        }

        public String getName() {
            EnemyData enemyData = WorldData.getEnemy(this.enemyDataName);
            if (enemyData != null) {
                return enemyData.getName();
            }
            return "";
        }

        public Image getAvatar() {
            if (this.sprite == null) {
                EnemyData data = WorldData.getEnemy(this.enemyDataName);
                if (data == null) {
                    this.enemyDataName = Aggregates.random(WorldData.getAllEnemies()).getName();
                }
                this.sprite = new EnemySprite(WorldData.getEnemy(this.enemyDataName));
            }
            return this.sprite.getAvatar() == null ? new Image() : new Image(this.sprite.getAvatar());
        }

        public String getAtlasPath() {
            return this.sprite == null ? "" : this.sprite.getAtlasPath();
        }

        public EnemySprite getSprite() {
            if (this.sprite == null) {
                this.sprite = new EnemySprite(WorldData.getEnemy(this.enemyDataName));
            }
            return this.sprite;
        }

        @Override
        public int compareTo(AdventureEventParticipant other) {
            if (this.wins != other.wins) {
                return other.wins - this.wins;
            }
            return this.losses - other.losses;
        }

        public void setDeck(Deck deck) {
            this.registeredDeck = deck;
        }
    }
}

