/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.character;

import com.badlogic.gdx.utils.Array;
import forge.Forge;
import forge.adventure.character.MapActor;
import forge.adventure.data.ShopData;
import forge.adventure.scene.RewardScene;
import forge.adventure.stage.MapStage;
import forge.adventure.util.Reward;

public class ShopActor
extends MapActor {
    private final MapStage stage;
    private ShopData shopData;
    Array<Reward> rewardData;

    public ShopActor(MapStage stage, int id, Array<Reward> rewardData, ShopData data) {
        super(id);
        this.stage = stage;
        this.shopData = data;
        this.rewardData = rewardData;
    }

    public float getPriceModifier() {
        return this.stage.getChanges().getShopPriceModifier(this.objectId) * this.stage.getChanges().getTownPriceModifier();
    }

    public MapStage getMapStage() {
        return this.stage;
    }

    @Override
    public void onPlayerCollide() {
        this.stage.getPlayerSprite().stop();
        RewardScene.instance().loadRewards(this.rewardData, RewardScene.Type.Shop, this);
        Forge.switchScene(RewardScene.instance());
    }

    public boolean isUnlimited() {
        return this.shopData.unlimited;
    }

    @Override
    public String getName() {
        return this.shopData.name;
    }

    public String getDescription() {
        return this.shopData.description;
    }

    public int getRestockPrice() {
        return this.shopData.restockPrice;
    }

    public boolean canRestock() {
        return this.getRestockPrice() > 0;
    }

    public ShopData getShopData() {
        return this.shopData;
    }

    public void setRewardData(Array<Reward> data) {
        this.rewardData = data;
    }

    public Array<Reward> getRewardData() {
        return this.rewardData;
    }
}

