/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.character;

import com.badlogic.gdx.utils.Array;
import forge.adventure.character.CharacterSprite;
import forge.adventure.data.RewardData;
import forge.adventure.util.JSONStringLoader;
import forge.adventure.util.Reward;

public class RewardSprite
extends CharacterSprite {
    private static final String default_reward = "[\n\t\t{\n\t\t\t\"type\": \"gold\",\n\t\t\t\"count\": 10,\n\t\t\t\"addMaxCount\": 100,\n\t\t}\n\t]";
    private int id;
    private RewardData[] rewards = null;

    public RewardSprite(String data, String _sprite) {
        super(_sprite);
        if (data != null) {
            this.rewards = JSONStringLoader.parse(RewardData[].class, data, default_reward);
        } else {
            System.err.print("Reward data is null. Using a default reward.");
            this.rewards = JSONStringLoader.parse(RewardData[].class, default_reward, default_reward);
        }
    }

    public RewardSprite(int _id, String data, String _sprite) {
        this(data, _sprite);
        this.id = _id;
    }

    @Override
    void updateBoundingRect() {
        this.boundingRect.set(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public Array<Reward> getRewards() {
        Array<Reward> ret = new Array<Reward>();
        if (this.rewards == null) {
            return ret;
        }
        for (RewardData rdata : this.rewards) {
            ret.addAll(rdata.generate(false, true));
        }
        return ret;
    }

    @Override
    public int getId() {
        return this.id;
    }
}

