/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.character;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import forge.adventure.character.DialogActor;
import forge.adventure.pointofintrest.PointOfInterestChanges;
import forge.adventure.stage.MapStage;
import forge.adventure.util.AdventureQuestController;
import forge.adventure.util.MapDialog;

public class QuestActor
extends DialogActor {
    String POI_ID;
    PointOfInterestChanges changes;
    String questOrigin;

    public QuestActor(String POI_ID, PointOfInterestChanges changes, String questOrigin, MapStage stage, int id) {
        super(null, stage, id);
        this.POI_ID = POI_ID;
        this.changes = changes;
        this.questOrigin = questOrigin;
    }

    @Override
    public void onPlayerCollide() {
        this.questData = AdventureQuestController.instance().getQuestNPCResponse(this.POI_ID, this.changes, this.questOrigin);
        this.dialog = new MapDialog(this.questData.offerDialog, this.stage, this.objectId, this.questData);
        ChangeListener finished = new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                QuestActor.this.removeFromMap();
                QuestActor.this.dialog = null;
            }
        };
        this.dialog.addDialogCompleteListener(finished);
        if (this.dialog != null && this.dialog.activate()) {
            this.stage.resetPosition();
            this.stage.showDialog();
        }
    }
}

