/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.character;

import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.adventure.character.CharacterSprite;
import forge.adventure.player.AdventurePlayer;
import forge.adventure.scene.Scene;
import forge.adventure.stage.GameStage;
import forge.adventure.util.Config;
import forge.adventure.util.Current;

public class PlayerSprite
extends CharacterSprite {
    private final float playerSpeed;
    private final Vector2 direction = Vector2.Zero.cpy();
    private float playerSpeedModifier = 1.0f;
    private float playerSpeedEquipmentModifier = 1.0f;
    GameStage gameStage;

    public PlayerSprite(GameStage gameStage) {
        super(AdventurePlayer.current().spriteName());
        this.gameStage = gameStage;
        this.setOriginX(this.getWidth() / 2.0f);
        Current.player().onPlayerChanged(this::updatePlayer);
        this.playerSpeed = Config.instance().getConfigData().playerBaseSpeed;
        Current.player().onBlessing(() -> {
            this.playerSpeedEquipmentModifier = Current.player().equipmentSpeed();
        });
        Current.player().onEquipmentChanged(() -> {
            this.playerSpeedEquipmentModifier = Current.player().equipmentSpeed();
        });
    }

    private void updatePlayer() {
        this.load(AdventurePlayer.current().spriteName());
    }

    public void LoadPos() {
        this.setPosition(AdventurePlayer.current().getWorldPosX(), AdventurePlayer.current().getWorldPosY());
    }

    public void storePos() {
        AdventurePlayer.current().setWorldPosX(this.getX());
        AdventurePlayer.current().setWorldPosY(this.getY());
    }

    public Vector2 getMovementDirection() {
        return this.direction;
    }

    public void setMovementDirection(Vector2 dir) {
        this.direction.set(dir);
    }

    public void setMoveModifier(float speed) {
        this.playerSpeedModifier = speed;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (Forge.advFreezePlayerControls) {
            return;
        }
        this.direction.setLength(this.playerSpeed * delta * this.playerSpeedModifier * this.playerSpeedEquipmentModifier);
        Vector2 previousDirection = this.getMovementDirection().cpy();
        Scene previousScene = Forge.getCurrentScene();
        if (!this.direction.isZero()) {
            this.gameStage.prepareCollision(this.pos(), this.direction, this.boundingRect);
            this.direction.set(this.gameStage.adjustMovement(this.direction, this.boundingRect));
            this.moveBy(this.direction.x, this.direction.y);
            if (previousScene == Forge.getCurrentScene()) {
                this.direction.set(previousDirection.cpy());
            }
        }
    }

    public boolean isMoving() {
        return !this.direction.isZero();
    }

    public void stop() {
        this.direction.setZero();
        this.setAnimation(CharacterSprite.AnimationTypes.Idle);
    }

    public void setPosition(Vector2 oldPosition) {
        this.setPosition(oldPosition.x, oldPosition.y);
    }
}

