/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.character;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.utils.Array;
import forge.Forge;
import forge.adventure.character.EnemySprite;
import forge.adventure.character.PlayerSprite;
import forge.adventure.util.Config;
import forge.util.MyRandom;

public class MapActor
extends Actor {
    private boolean removeIfEffectsAreFinished;
    Texture debugTexture;
    protected float collisionHeight = 0.4f;
    final int objectId;
    Array<CurrentEffect> effects = new Array();
    final Rectangle boundingRect = new Rectangle();
    boolean isCollidingWithPlayer = false;
    boolean boundDebug = false;

    public void removeAfterEffects() {
        this.removeIfEffectsAreFinished = true;
    }

    public void removeEffect(String effectFly) {
        for (int i = 0; i < this.effects.size; ++i) {
            CurrentEffect currentEffect = this.effects.get(i);
            if (!currentEffect.path.equals(effectFly)) continue;
            for (ParticleEmitter emitter : currentEffect.effect.getEmitters()) {
                emitter.setContinuous(false);
            }
        }
    }

    public void playEffect(String path, float duration, boolean overlay, Vector2 offset) {
        FileHandle file = Config.instance().getFile(path);
        ParticleEffect effect = Forge.getAssets().getEffect(file);
        if (effect != null) {
            effect.setPosition(this.getCenter().x, this.getCenter().y);
            this.effects.add(new CurrentEffect(file, path, effect, offset, overlay));
            if (duration != 0.0f) {
                for (ParticleEmitter emitter : effect.getEmitters()) {
                    emitter.setContinuous(false);
                    emitter.duration = duration;
                    emitter.durationTimer = 0.0f;
                }
            }
        }
        effect.start();
    }

    public void playEffect(String path, float duration, boolean overlay) {
        this.playEffect(path, duration, overlay, Vector2.Zero);
    }

    public void playEffect(String path, float duration) {
        this.playEffect(path, duration, true, Vector2.Zero);
    }

    public void playEffect(String path) {
        this.playEffect(path, 0.0f, true, Vector2.Zero);
    }

    public MapActor(int objectId) {
        this.objectId = objectId;
    }

    public int getObjectId() {
        return this.objectId;
    }

    private Texture getDebugTexture() {
        if (this.debugTexture == null) {
            Pixmap pixmap = new Pixmap((int)this.getWidth(), (int)this.getHeight(), Pixmap.Format.RGBA8888);
            pixmap.setColor(MyRandom.getRandom().nextFloat(), MyRandom.getRandom().nextFloat(), MyRandom.getRandom().nextFloat(), 0.5f);
            pixmap.fillRectangle((int)(this.boundingRect.x - this.getX()), (int)(this.getHeight() - this.boundingRect.getHeight()) + (int)(this.boundingRect.y - this.getY()), (int)this.boundingRect.getWidth(), (int)this.boundingRect.getHeight());
            this.debugTexture = new Texture(pixmap);
            pixmap.dispose();
        }
        return this.debugTexture;
    }

    protected void onPlayerCollide() {
    }

    public void setBoundDebug(boolean debug) {
        this.boundDebug = debug;
    }

    @Override
    public void draw(Batch batch, float alpha) {
        if (this.boundDebug) {
            batch.draw(this.getDebugTexture(), this.getX(), this.getY());
        }
        for (CurrentEffect effect : this.effects) {
            if (!effect.overlay) continue;
            effect.effect.draw(batch);
        }
    }

    protected void beforeDraw(Batch batch, float parentAlpha) {
        for (CurrentEffect effect : this.effects) {
            if (effect.overlay) continue;
            effect.effect.draw(batch);
        }
    }

    private Vector2 getCenter() {
        float scale = 1.0f;
        if (this instanceof EnemySprite) {
            scale = ((EnemySprite)this).getData().scale;
        }
        return new Vector2(this.getX() + this.getWidth() * scale / 2.0f, this.getY() + this.getHeight() * scale / 2.0f);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        for (int i = 0; i < this.effects.size; ++i) {
            CurrentEffect effect = this.effects.get(i);
            effect.effect.update(delta);
            effect.effect.setPosition(this.getCenter().x + effect.offset.x, this.getCenter().y + effect.offset.y);
            if (!effect.effect.isComplete()) continue;
            this.effects.removeIndex(i);
            --i;
            Forge.getAssets().manager().unload(effect.fileHandle.path());
        }
        if (this.effects.size == 0 && this.removeIfEffectsAreFinished && this.getParent() != null) {
            this.getParent().removeActor(this);
        }
    }

    @Override
    protected void positionChanged() {
        super.positionChanged();
        this.updateBoundingRect();
    }

    @Override
    protected void sizeChanged() {
        super.sizeChanged();
        this.updateBoundingRect();
    }

    void updateBoundingRect() {
        this.boundingRect.set(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public Rectangle boundingRect() {
        return this.boundingRect;
    }

    public boolean collideWithPlayer(PlayerSprite other) {
        boolean newIsColliding = this.collideWith(other);
        if (newIsColliding) {
            if (!this.isCollidingWithPlayer) {
                this.onPlayerCollide();
            }
            this.isCollidingWithPlayer = true;
        } else {
            this.isCollidingWithPlayer = false;
        }
        return this.isCollidingWithPlayer;
    }

    public boolean collideWith(Rectangle other) {
        if (this.getCollisionHeight() == 0.0f) {
            return false;
        }
        return this.boundingRect().overlaps(other);
    }

    public int getId() {
        return this.objectId;
    }

    public boolean collideWith(MapActor other) {
        return this.collideWith(other.boundingRect());
    }

    public boolean collideWith(Actor other) {
        return this.boundingRect.x < other.getX() + other.getWidth() && this.boundingRect.x + this.boundingRect.width > other.getX() && this.boundingRect.y < other.getY() + other.getHeight() && this.boundingRect.y + this.boundingRect.height > other.getY();
    }

    public float getCollisionHeight() {
        return this.collisionHeight;
    }

    public void resetCollisionHeight() {
        this.collisionHeight = 0.4f;
    }

    public void clearCollisionHeight() {
        this.collisionHeight = 0.0f;
    }

    static class CurrentEffect {
        private final String path;
        private FileHandle fileHandle;
        public ParticleEffect effect;
        public Vector2 offset;
        public boolean overlay = true;

        public CurrentEffect(FileHandle file, String path, ParticleEffect effect, Vector2 offset, boolean overlay) {
            this.fileHandle = file;
            this.path = path;
            this.effect = effect;
            this.offset = offset;
            this.overlay = overlay;
        }
    }
}

