/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.character;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import forge.adventure.character.CharacterSprite;
import forge.adventure.data.AdventureQuestData;
import forge.adventure.stage.MapStage;
import forge.adventure.util.MapDialog;

public class DialogActor
extends CharacterSprite {
    protected final MapStage stage;
    private final TextureRegion textureRegion;
    protected MapDialog dialog;
    public AdventureQuestData questData;

    public DialogActor(MapStage stage, int id, String S, TextureRegion textureRegion) {
        super(id, "");
        this.stage = stage;
        this.dialog = new MapDialog(S, stage, id);
        this.textureRegion = textureRegion;
    }

    public DialogActor(MapStage stage, int id, String S, String sprite) {
        super(id, sprite);
        this.stage = stage;
        this.dialog = new MapDialog(S, stage, id);
        this.textureRegion = null;
    }

    public DialogActor(AdventureQuestData data, MapStage stage, int id) {
        super(id, "");
        this.stage = stage;
        this.textureRegion = null;
        this.questData = data;
    }

    public void removeFromMap() {
        this.dialog = null;
    }

    @Override
    public void onPlayerCollide() {
        if (this.dialog != null && this.dialog.activate()) {
            this.stage.resetPosition();
            this.stage.showDialog();
        }
    }

    @Override
    public void draw(Batch batch, float alpha) {
        if (this.textureRegion != null) {
            batch.draw(this.textureRegion, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        } else {
            super.draw(batch, alpha);
        }
    }
}

