/*
 * Decompiled with CFR 0.152.
 */
package forge.adventure.character;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.utils.Array;
import forge.adventure.character.EnemySprite;
import forge.adventure.character.MapActor;
import forge.adventure.data.DialogData;
import forge.adventure.stage.SpriteGroup;
import forge.adventure.util.Config;
import java.util.HashMap;

public class CharacterSprite
extends MapActor {
    private final HashMap<AnimationTypes, HashMap<AnimationDirections, Animation<TextureRegion>>> animations = new HashMap();
    float timer;
    private Animation<TextureRegion> currentAnimation = null;
    private AnimationTypes currentAnimationType = AnimationTypes.Idle;
    private AnimationDirections currentAnimationDir = AnimationDirections.None;
    private final Array<Sprite> avatar = new Array();
    public boolean hidden = false;
    public boolean inactive = false;
    private String atlasPath;
    private float wakeTimer = 0.0f;
    public DialogData.ConditionData[] spawnConditions = new DialogData.ConditionData[0];

    public CharacterSprite(int id, String path) {
        super(id);
        this.collisionHeight = 0.4f;
        this.atlasPath = path;
        this.load(path);
    }

    public CharacterSprite(String path) {
        this(0, path);
    }

    @Override
    void updateBoundingRect() {
        this.boundingRect.set(this.getX() + 4.0f, this.getY(), this.getWidth() - 6.0f, this.getHeight() * this.collisionHeight);
    }

    protected void load(String path) {
        HashMap<Object, Object> dirs;
        if (path == null || path.isEmpty()) {
            return;
        }
        this.animations.clear();
        for (AnimationTypes stand : AnimationTypes.values()) {
            if (stand == AnimationTypes.Avatar) {
                this.avatar.addAll(Config.instance().getAnimatedSprites(path, stand.toString()));
                continue;
            }
            dirs = new HashMap();
            for (AnimationDirections dir : AnimationDirections.values()) {
                Array<Sprite> anim = dir == AnimationDirections.None ? Config.instance().getAnimatedSprites(path, stand.toString()) : Config.instance().getAnimatedSprites(path, stand.toString() + dir.toString());
                if (anim.size == 0) continue;
                dirs.put((Object)dir, new Animation<Sprite>(0.2f, anim));
                if ((double)this.getWidth() != 0.0) continue;
                this.setWidth(anim.first().getWidth());
                this.setHeight(anim.first().getHeight());
            }
            this.animations.put(stand, dirs);
        }
        for (AnimationTypes stand : AnimationTypes.values()) {
            if (stand == AnimationTypes.Avatar) continue;
            dirs = this.animations.get((Object)stand);
            if (!dirs.containsKey((Object)AnimationDirections.None) && dirs.containsKey((Object)AnimationDirections.Right)) {
                dirs.put((Object)AnimationDirections.None, (Animation)dirs.get((Object)AnimationDirections.Right));
            }
            if (!dirs.containsKey((Object)AnimationDirections.Right) && dirs.containsKey((Object)AnimationDirections.None)) {
                dirs.put((Object)AnimationDirections.Right, (Animation)dirs.get((Object)AnimationDirections.None));
            }
            if (!dirs.containsKey((Object)AnimationDirections.Left) && dirs.containsKey((Object)AnimationDirections.Right)) {
                dirs.put((Object)AnimationDirections.Left, CharacterSprite.FlipAnimation((Animation)dirs.get((Object)AnimationDirections.Right)));
            }
            if (dirs.containsKey((Object)AnimationDirections.Left) && !dirs.containsKey((Object)AnimationDirections.Right)) {
                dirs.put((Object)AnimationDirections.Right, CharacterSprite.FlipAnimation((Animation)dirs.get((Object)AnimationDirections.Left)));
            }
            if (!dirs.containsKey((Object)AnimationDirections.LeftUp) && dirs.containsKey((Object)AnimationDirections.Left)) {
                dirs.put((Object)AnimationDirections.LeftUp, (Animation)dirs.get((Object)AnimationDirections.Left));
            }
            if (!dirs.containsKey((Object)AnimationDirections.LeftDown) && dirs.containsKey((Object)AnimationDirections.Left)) {
                dirs.put((Object)AnimationDirections.LeftDown, (Animation)dirs.get((Object)AnimationDirections.Left));
            }
            if (!dirs.containsKey((Object)AnimationDirections.RightDown) && dirs.containsKey((Object)AnimationDirections.Right)) {
                dirs.put((Object)AnimationDirections.RightDown, (Animation)dirs.get((Object)AnimationDirections.Right));
            }
            if (!dirs.containsKey((Object)AnimationDirections.RightUp) && dirs.containsKey((Object)AnimationDirections.Right)) {
                dirs.put((Object)AnimationDirections.RightUp, (Animation)dirs.get((Object)AnimationDirections.Right));
            }
            if (!dirs.containsKey((Object)AnimationDirections.Up) && dirs.containsKey((Object)AnimationDirections.Right)) {
                dirs.put((Object)AnimationDirections.Up, (Animation)dirs.get((Object)AnimationDirections.Right));
            }
            if (dirs.containsKey((Object)AnimationDirections.Down) || !dirs.containsKey((Object)AnimationDirections.Left)) continue;
            dirs.put((Object)AnimationDirections.Down, (Animation)dirs.get((Object)AnimationDirections.Left));
        }
        this.setAnimation(AnimationTypes.Idle);
        this.setDirection(AnimationDirections.Right);
    }

    public static Animation<TextureRegion> FlipAnimation(Animation<TextureRegion> anim) {
        TextureRegion[] texReg = anim.getKeyFrames();
        Array<TextureRegion> newReg = new Array<TextureRegion>();
        for (TextureRegion reg : texReg) {
            TextureRegion cpy = new TextureRegion(reg);
            cpy.flip(true, false);
            newReg.add(cpy);
        }
        return new Animation<TextureRegion>(anim.getFrameDuration(), newReg);
    }

    public void setAnimation(AnimationTypes type) {
        if (this.currentAnimationType != type) {
            this.currentAnimationType = type;
            this.updateAnimation();
        }
    }

    private void updateAnimation() {
        AnimationTypes aniType = this.currentAnimationType;
        AnimationDirections aniDir = this.currentAnimationDir;
        if (!this.animations.containsKey((Object)aniType)) {
            aniType = AnimationTypes.Idle;
        }
        if (!this.animations.containsKey((Object)aniType)) {
            return;
        }
        HashMap<AnimationDirections, Animation<TextureRegion>> dirs = this.animations.get((Object)aniType);
        if (!dirs.containsKey((Object)aniDir)) {
            aniDir = AnimationDirections.Right;
        }
        if (!dirs.containsKey((Object)aniDir)) {
            return;
        }
        this.currentAnimation = dirs.get((Object)aniDir);
    }

    public void setDirection(AnimationDirections dir) {
        if (this.currentAnimationDir != dir) {
            this.currentAnimationDir = dir;
            this.updateAnimation();
        }
    }

    @Override
    protected void positionChanged() {
        Group parent = this.getParent();
        if (parent instanceof SpriteGroup) {
            ((SpriteGroup)parent).UpdateActorZ(this);
        }
        super.positionChanged();
    }

    @Override
    public void moveBy(float x, float y) {
        this.moveBy(x, y, 0.0f);
    }

    public void moveBy(float x, float y, float delta) {
        if (this.inactive) {
            return;
        }
        if (this.hidden) {
            if (this.animations.containsKey((Object)AnimationTypes.Wake)) {
                this.setAnimation(AnimationTypes.Wake);
                this.wakeTimer = 0.0f;
                this.hidden = false;
            } else {
                return;
            }
        }
        if (this.currentAnimationType == AnimationTypes.Wake && this.wakeTimer <= this.currentAnimation.getAnimationDuration()) {
            this.wakeTimer += delta;
            return;
        }
        super.moveBy(x, y);
        if (x == 0.0f && y == 0.0f) {
            return;
        }
        Vector2 vec = new Vector2(x, y);
        float degree = vec.angleDeg();
        if (!this.hidden) {
            this.setAnimation(AnimationTypes.Walk);
        }
        if ((double)degree < 22.5) {
            this.setDirection(AnimationDirections.Right);
        } else if ((double)degree < 67.5) {
            this.setDirection(AnimationDirections.RightUp);
        } else if ((double)degree < 112.5) {
            this.setDirection(AnimationDirections.Up);
        } else if ((double)degree < 157.5) {
            this.setDirection(AnimationDirections.LeftUp);
        } else if ((double)degree < 202.5) {
            this.setDirection(AnimationDirections.Left);
        } else if ((double)degree < 247.5) {
            this.setDirection(AnimationDirections.LeftDown);
        } else if ((double)degree < 292.5) {
            this.setDirection(AnimationDirections.Down);
        } else if ((double)degree < 337.5) {
            this.setDirection(AnimationDirections.RightDown);
        } else {
            this.setDirection(AnimationDirections.Right);
        }
    }

    public Vector2 pos() {
        return new Vector2(this.getX(), this.getY());
    }

    @Override
    public void act(float delta) {
        this.timer += delta;
        super.act(delta);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        if (this.currentAnimation == null || this.hidden || this.inactive) {
            return;
        }
        super.draw(batch, parentAlpha);
        this.beforeDraw(batch, parentAlpha);
        TextureRegion currentFrame = this.currentAnimationType.equals((Object)AnimationTypes.Wake) ? this.currentAnimation.getKeyFrame(this.wakeTimer, false) : this.currentAnimation.getKeyFrame(this.timer, true);
        float scale = 1.0f;
        if (this instanceof EnemySprite) {
            scale = ((EnemySprite)this).getData().scale;
        }
        this.setHeight((float)currentFrame.getRegionHeight() * scale);
        this.setWidth((float)currentFrame.getRegionWidth() * scale);
        Color oldColor = batch.getColor().cpy();
        batch.setColor(this.getColor());
        batch.draw(currentFrame, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        batch.setColor(oldColor);
        super.draw(batch, parentAlpha);
    }

    public Sprite getAvatar() {
        if (this.avatar == null || this.avatar.isEmpty()) {
            return null;
        }
        return this.avatar.first();
    }

    public String getAtlasPath() {
        return this.atlasPath;
    }

    public Sprite getAvatar(int index) {
        return this.avatar.get(index);
    }

    public static enum AnimationDirections {
        None,
        Right,
        RightDown,
        Down,
        LeftDown,
        Left,
        LeftUp,
        Up,
        RightUp;

    }

    public static enum AnimationTypes {
        Idle,
        Walk,
        Death,
        Attack,
        Hit,
        Avatar,
        Hidden,
        Wake;

    }
}

