/*
 * Decompiled with CFR 0.152.
 */
package forge;

public class Shaders {
    public static final String vertexShader = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main()\n{\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projTrans * a_position;\n}\n";
    public static final String vertPixelateShader = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\n\nuniform mat4 u_projTrans;\n\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n    v_color = a_color;\n    v_texCoords = a_texCoord0;\n    gl_Position = u_projTrans * a_position;\n}";
    public static final String fragPixelateSimple = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\n\nuniform sampler2D u_texture;\nvarying vec2 v_texCoords;\nuniform vec2 u_resolution;\nuniform float u_time;\nuniform float u_cellSize;\n\nvoid main()\n{\n    float t = u_time;\n    \n\tvec2 uv = v_texCoords;\n    \n    float res = floor((pow(t,1.4)) * u_cellSize) * 2.0 + 0.01;\n    \n    uv *= u_resolution.xy / res;\n    uv = floor(uv);\n    uv /= u_resolution.xy / res;\n    \n    uv += res * 0.002;\n    vec4 texColor = texture2D(u_texture, uv);\n    //texColor.g *= (1.-t);\n    //texColor.b *= (1.-t);\n\tgl_FragColor = texColor * clamp(1.4 - t, 1.0, 1.0);\n}";
    public static final String fragPortal = "#ifdef GL_ES\n#define LOWP lowp\n#define PI 3.14159\nprecision mediump float;\n#else\n#define LOWP \n#define PI 3.14159\n#endif\n\nuniform sampler2D u_texture;\nvarying vec2 v_texCoords;\nuniform vec2 u_resolution;\nuniform float u_time;\nuniform float u_opaque;\n\nvoid main()\n{\n    vec2 uv = v_texCoords;\n    \n    float t1 = u_time;\n    if (t1>1.25)\n        t1=0.0;\n    t1 = clamp(t1,0.0,1.0);\n    float nt = fract(t1);\n\n    float eRad = 1.5 * nt;\n    float eAng = (2. * PI) * (nt*4.5);\n\n    vec2 centre = vec2(.5,.5);\n    uv -= centre;\n    float len = length(uv * vec2(u_resolution.x / u_resolution.y, 1.));\n    float ang = atan(uv.y, uv.x) + eAng * smoothstep(eRad, 0., len);\n    float rad = length(uv);\n    \n    vec3 col1 = texture2D(u_texture, vec2(rad * cos(ang), rad * sin(ang)) + centre ).xyz;    \n    float nt2 = (len*2.0) - (nt*2.0);\n    nt2 = mix(1.0,nt2-nt,nt);\n    nt2 = clamp(nt2,0.0,1.0);\n   \tvec3 col2 = texture2D(u_texture,uv+ centre).xyz;  \n    col2 = vec3(0.0);\n    \n    vec4 col3 =  vec4(mix(col2,col1,nt2), 1.);\n    if (u_opaque < 1.)        col3.a *= nt2;\n    gl_FragColor = col3;\n}";
    public static final String fragNoiseFade = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nuniform sampler2D u_texture;\nvarying vec2 v_texCoords;\nuniform float u_time;\n\nvoid main()\n{\n\tvec2 uv = v_texCoords;\n    LOWP vec4 orig = texture2D(u_texture, uv);\n    float th = u_time;\n    \n    float tex = ((orig.r -.5) + 2. * uv.x ) / 3.;\n    float mask = smoothstep( th - .1, th, tex);\n    float dist = smoothstep( th - .3, th + .05, tex);\n    float col = pow( smoothstep( th - .2, th + .15, tex), 3.);\n    \n    LOWP vec3 color = vec4(orig.rgb, uv * (.7 + pow(dist, 2.) * .3 )).rgb;\n    LOWP vec3 discolor = color * vec3( 0.5, 0.4, 0.3 );\n    \n\tgl_FragColor = vec4( mix(discolor, color, col) * mask, 1.0);\n}";
    public static final String fragRoundedRect = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nuniform vec2 u_resolution;\nuniform float edge_radius;\nuniform float u_gray;\nLOWP vec4 color = vec4(1.0,1.0,1.0,1.0);\nfloat gradientIntensity = 0.5;\n\nvoid main() {\n    vec2 uv = v_texCoords;\n    vec2 uv_base_center = uv * 2.0 - 1.0;\n\n    vec2 half_resolution = u_resolution.xy * 0.5;\n    vec2 abs_rounded_center = half_resolution.xy - edge_radius;\n    vec2 abs_pixel_coord = vec2( abs(uv_base_center.x * half_resolution.x), abs(uv_base_center.y * half_resolution.y) );\n\n    float alpha = 1.0;\n    LOWP vec4 col = color * texture2D(u_texture, uv);\n    if (abs_pixel_coord.x > abs_rounded_center.x && abs_pixel_coord.y > abs_rounded_center.y) {\n         float r = length(abs_pixel_coord - abs_rounded_center);\n         alpha = smoothstep(edge_radius, edge_radius - gradientIntensity, r);\n         \n    }\n    if (u_gray > 0.0) {\n        LOWP float grey = dot( col.rgb, vec3(0.22, 0.707, 0.071) );\n        LOWP vec3 blendedColor = mix(col.rgb, vec3(grey), 1.0);\n        col = vec4(blendedColor.rgb, col.a);\n    }\n    gl_FragColor = col*alpha;\n}";
    public static final String fragHueShift = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nuniform float u_time;\n\nvec3 hs(vec3 c, float s) {\n    vec3 m=vec3(cos(s),s=sin(s)*.5774,-s);\n    return c*mat3(m+=(1.-m.x)/3.,m.zxy,m.yzx);\n}\n\nvoid main() {\n\tvec2 uv = v_texCoords;\n    vec4 orig = texture2D(u_texture, uv);\n    vec3 col = texture2D(u_texture, uv).rgb;\n    vec4 col2 = vec4(hs(col, u_time), 1.);\n    //multiply the original texture alpha to render only opaque shifted colors \n    col2.a *= orig.a;\n    gl_FragColor = col2;\n}";
    public static final String fragRipple = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nuniform sampler2D u_texture;\nvarying vec2 v_texCoords;\nuniform float u_time;\nuniform float u_bias;\n\nvoid main() {\n    vec2 uv = v_texCoords;\n    float len = length(uv - vec2(.5)) * 50.;\n    vec2 s = normalize(uv) * ( sin((len - u_time * 10.))) * (.01 * u_time);\n    LOWP vec4 tex = texture2D(u_texture, uv + s);\n    gl_FragColor = mix(vec4(0.0, 0.0, 0.0, 1.0), tex, u_bias);\n}";
    public static final String fragChromaticAbberation = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nuniform float u_time;\n\nvoid main() {\n\tvec2 uv = v_texCoords;\n\tfloat amount = 0.0;\n\tamount = (1.0 + sin(u_time*6.0)) * 0.5;\n\tamount *= 1.0 + sin(u_time*16.0) * 0.5;\n\tamount *= 1.0 + sin(u_time*19.0) * 0.5;\n\tamount *= 1.0 + sin(u_time*27.0) * 0.5;\n\tamount = pow(amount, 3.0);\n\tamount *= 0.05;\n    vec3 col;\n    col.r = texture2D(u_texture, vec2(uv.x+amount,uv.y)).r;\n    col.g = texture2D(u_texture, uv ).g;\n    col.b = texture2D(u_texture, vec2(uv.x-amount,uv.y)).b;\n\tcol *= (1.0 - amount * 0.5);\n    gl_FragColor = vec4(col,1.0);\n}";
    public static final String fragPixelateShader = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nuniform sampler2D u_texture;\nuniform float u_cellSize;\nuniform vec2 u_resolution;\nuniform float u_yflip;\nuniform float u_bias;\n\nvoid main() {\n\tvec2 p = floor(gl_FragCoord.xy/u_cellSize) * u_cellSize;\n\tvec2 p2 = p/u_resolution.xy;\n\tvec4 texColor;\n\tif (u_yflip > 0)\n\t    texColor = texture2D(u_texture, vec2(p2.x, 1.-p2.y));\n\telse\n\t    texColor = texture2D(u_texture, p2);\n\tgl_FragColor = mix(vec4(0.0, 0.0, 0.0, 1.0), texColor, u_bias);\n}";
    public static final String fragPixelateShaderWarp = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\n\nuniform float u_time;\nuniform float u_speed;\nuniform float u_amount;\nuniform float u_cellSize;\nuniform vec2 u_resolution;\nuniform vec2 u_viewport;\nuniform vec2 u_position;\n\nfloat random2d(vec2 n) {\n    return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);\n}\n\nfloat randomRange (in vec2 seed, in float min, in float max) {\n    return min + random2d(seed) * (max - min);\n}\n\nfloat insideRange(float v, float bottom, float top) {\n   return step(bottom, v) - step(top, v);\n}\n\nvoid main()\n{\n    float time = floor(u_time * u_speed * 60.0);\n\n    vec3 outCol = texture2D(u_texture, v_texCoords).rgb;\n\n    float maxOffset = u_amount/2.0;\n    for (float i = 0.0; i < 2.0; i += 1.0) {\n        float sliceY = random2d(vec2(time, 2345.0 + float(i)));\n        float sliceH = random2d(vec2(time, 9035.0 + float(i))) * 0.25;\n        float hOffset = randomRange(vec2(time, 9625.0 + float(i)), -maxOffset, maxOffset);\n        vec2 uvOff = v_texCoords;\n        uvOff.x += hOffset;\n        if (insideRange(v_texCoords.y, sliceY, fract(sliceY+sliceH)) == 1.0){\n            outCol = texture2D(u_texture, uvOff).rgb;\n        }\n    }\n\n    float maxColOffset = u_amount / 6.0;\n    float rnd = random2d(vec2(time , 9545.0));\n    vec2 colOffset = vec2(randomRange(vec2(time , 9545.0), -maxColOffset, maxColOffset),\n                       randomRange(vec2(time , 7205.0), -maxColOffset, maxColOffset));\n    if (rnd < 0.33) {\n        outCol.r = texture2D(u_texture, v_texCoords + colOffset).r;\n    } else if (rnd < 0.66) {\n        outCol.g = texture2D(u_texture, v_texCoords + colOffset).g;\n    } else {\n        outCol.b = texture2D(u_texture, v_texCoords + colOffset).b;\n    }\n\n\tvec2 p = floor(gl_FragCoord.xy/u_cellSize) * u_cellSize;\n\tvec4 texColor = texture2D(u_texture, p/u_resolution.xy);\n    gl_FragColor = mix(vec4(outCol, 1.0), texColor, 0.6);\n}";
    public static final String fragmentShaderRGBA = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nvoid main()\n{\n   vec4 tgt = texture2D( u_texture, v_texCoords );\n   gl_FragColor = clamp(vec4(tgt.rgb * pow((v_color.rgb + 0.1) * 1.666, vec3(1.5)), v_color.a * tgt.a), 0.0, 1.0);\n}";
    public static final String fragmentShaderMultiplyRGBA = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nvoid main()\n{\n   vec4 tgt = texture2D(u_texture, v_texCoords);\n   gl_FragColor = clamp(vec4(tgt.rgb * v_color.rgb * 2.0, v_color.a * tgt.a), 0.0, 1.0);\n}";
    public static final String fragmentShaderHigherContrastRGBA = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst float contrast =    1.5   ;\nvec3 barronSpline(vec3 x, float shape) {\n        const float turning = 0.5;\n        vec3 d = turning - x;\n        return mix(\n          ((1. - turning) * (x - 1.)) / (1. - (x + shape * d)) + 1.,\n          (turning * x) / (1.0e-20 + (x + shape * d)),\n          step(0.0, d));\n}\nvoid main()\n{\n  vec4 tgt = texture2D( u_texture, v_texCoords );\n  tgt.rgb = barronSpline(clamp(tgt.rgb + v_color.rgb, 0.0, 1.0), contrast);\n  tgt.a *= v_color.a;\n  gl_FragColor = tgt;\n}";
    public static final String fragmentShaderLowerContrastRGBA = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst float contrast =    1.5   ;\nvec3 barronSpline(vec3 x, float shape) {\n        const float turning = 0.5;\n        vec3 d = turning - x;\n        return mix(\n          ((1. - turning) * (x - 1.)) / (1. - (x + shape * d)) + 1.,\n          (turning * x) / (1.0e-20 + (x + shape * d)),\n          step(0.0, d));\n}\nvoid main()\n{\n  vec4 tgt = texture2D( u_texture, v_texCoords );\n  tgt.rgb = barronSpline(clamp(tgt.rgb + v_color.rgb, 0.0, 1.0), contrast);\n  tgt.a *= v_color.a;\n  gl_FragColor = tgt;\n}".replace("   1.5   ", "0.5");
    public static final String fragmentShaderYCwCm = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst vec3 bright = vec3(0.375, 0.5, 0.125);\nvoid main()\n{\n   vec4 tgt = texture2D( u_texture, v_texCoords );\n////use the following line to match the color exactly\n   vec3 ycc = vec3(v_color.r - 0.5 + dot(tgt.rgb, bright), ((v_color.g - 0.5) * 2.0 + tgt.r - tgt.b), ((v_color.b - 0.5) * 2.0 + tgt.g - tgt.b));\n////use the following line to increase contrast\n//   vec3 ycc = vec3(v_color.r * dot(sin(tgt.rgb * 1.5707963267948966) * sqrt(tgt.rgb), bright), ((v_color.g - 0.5) * 2.0 + tgt.r - tgt.b), ((v_color.b - 0.5) * 2.0 + tgt.g - tgt.b));\n////use the following line to increase contrast more\n//   vec3 ycc = vec3(v_color.r * pow(dot(tgt.rgb, bright), 1.25), ((v_color.g - 0.5) * 2.0 + tgt.r - tgt.b), ((v_color.b - 0.5) * 2.0 + tgt.g - tgt.b));\n   gl_FragColor = vec4( (clamp(mat3(1.0, 1.0, 1.0, 0.625, -0.375, -0.375, -0.5, 0.5, -0.5) * ycc, 0.0, 1.0)), v_color.a * tgt.a);\n}";
    public static final String fragmentShaderHigherContrast = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst float contrast =    1.375   ; // You can make contrast a uniform if you want.\nconst vec3 bright = vec3(0.375, 0.5, 0.125) * (4.0 / 3.0);\nvoid main()\n{\n   vec4 tgt = texture2D( u_texture, v_texCoords );\n   vec3 ycc = vec3(v_color.r - 0.5 + pow(dot(tgt.rgb, bright), contrast) * 0.75, ((v_color.g - 0.5) * 2.0 + tgt.r - tgt.b), ((v_color.b - 0.5) * 2.0 + tgt.g - tgt.b));\n   gl_FragColor = vec4( (clamp(mat3(1.0, 1.0, 1.0, 0.625, -0.375, -0.375, -0.5, 0.5, -0.5) * ycc, 0.0, 1.0)), v_color.a * tgt.a);\n}";
    public static final String fragmentShaderLowerContrast = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst float contrast =    1.375   ; // You can make contrast a uniform if you want.\nconst vec3 bright = vec3(0.375, 0.5, 0.125) * (4.0 / 3.0);\nvoid main()\n{\n   vec4 tgt = texture2D( u_texture, v_texCoords );\n   vec3 ycc = vec3(v_color.r - 0.5 + pow(dot(tgt.rgb, bright), contrast) * 0.75, ((v_color.g - 0.5) * 2.0 + tgt.r - tgt.b), ((v_color.b - 0.5) * 2.0 + tgt.g - tgt.b));\n   gl_FragColor = vec4( (clamp(mat3(1.0, 1.0, 1.0, 0.625, -0.375, -0.375, -0.5, 0.5, -0.5) * ycc, 0.0, 1.0)), v_color.a * tgt.a);\n}".replace("   1.375   ", "0.625");
    public static String fragmentShaderIPT = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nvoid main()\n{\n    vec4 tgt = texture2D( u_texture, v_texCoords );\n    vec4 adj = v_color;\n    adj.yz = adj.yz * 2.0 - 0.5;\n    vec3 ipt = (mat3(0.189786, 0.669665 , 0.286498, 0.576951, -0.73741 , 0.655205, 0.233221, 0.0681367, -0.941748)\n         * (tgt.rgb)) + adj.xyz - 0.5;\n    ipt.x = clamp(ipt.x, 0.0, 1.0);\n    ipt.yz = clamp(ipt.yz, -1.0, 1.0);\n    vec3 back = mat3(0.999779, 1.00015, 0.999769, 1.07094, -0.377744, 0.0629496, 0.324891, 0.220439, -0.809638) * ipt;\n    gl_FragColor = vec4(clamp(back, 0.0, 1.0), adj.a * tgt.a);\n}";
    public static String fragmentShaderIPT_HQ = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst vec3 forward = vec3(0.43);\nconst vec3 reverse = vec3(1.0 / 0.43);\nvoid main()\n{\n  vec4 tgt = texture2D( u_texture, v_texCoords );\n  vec3 ipt = mat3(0.40000, 4.45500, 0.80560, 0.40000, -4.8510, 0.35720, 0.20000, 0.39600, -1.1628) *             pow(mat3(0.313921, 0.151693, 0.017753, 0.639468, 0.748209, 0.109468, 0.0465970, 0.1000044, 0.8729690) \n             * (tgt.rgb * tgt.rgb), forward);\n  ipt.x = clamp(ipt.x + v_color.x - 0.55, 0.0, 1.0);\n  ipt.yz = clamp(ipt.yz + v_color.yz * 2.0 - 1.0, -1.0, 1.0);\n  ipt = mat3(1.0, 1.0, 1.0, 0.097569, -0.11388, 0.032615, 0.205226, 0.133217, -0.67689) * ipt;\n  gl_FragColor = vec4(sqrt(clamp(                 mat3(5.432622, -1.10517, 0.028104, -4.67910, 2.311198, -0.19466, 0.246257, -0.20588, 1.166325) *\n                 (sign(ipt) * pow(abs(ipt), reverse)),                 0.0, 1.0)), v_color.a * tgt.a);\n}";
    public static String fragmentShaderOklab = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst vec3 forward = vec3(1.0 / 3.0);\nfloat toOklab(float L) {\n        const float shape = 0.64516133, turning = 0.95;\n        float d = turning - L;\n        float r = mix(\n          ((1. - turning) * (L - 1.)) / (1. - (L + shape * d)) + 1.,\n          (turning * L) / (1.0e-20 + (L + shape * d)),\n          step(0.0, d));\n        return r * r;\n}\nfloat fromOklab(float L) {\n        const float shape = 1.55, turning = 0.95;\n        L = sqrt(L);\n        float d = turning - L;\n        return mix(\n          ((1. - turning) * (L - 1.)) / (1. - (L + shape * d)) + 1.,\n          (turning * L) / (1.0e-20 + (L + shape * d)),\n          step(0.0, d));\n}\nvoid main()\n{\n  vec4 tgt = texture2D( u_texture, v_texCoords );\n  vec3 lab = mat3(+0.2104542553, +1.9779984951, +0.0259040371, +0.7936177850, -2.4285922050, +0.7827717662, -0.0040720468, +0.4505937099, -0.8086757660) *             pow(mat3(0.4121656120, 0.2118591070, 0.0883097947, 0.5362752080, 0.6807189584, 0.2818474174, 0.0514575653, 0.1074065790, 0.6302613616) \n             * (tgt.rgb * tgt.rgb), forward);\n  lab.x = fromOklab(clamp(toOklab(lab.x) + v_color.r - 0.5, 0.0, 1.0));\n  lab.yz = clamp(lab.yz + v_color.gb * 2.0 - 1.0, -1.0, 1.0);\n  lab = mat3(1.0, 1.0, 1.0, +0.3963377774, -0.1055613458, -0.0894841775, +0.2158037573, -0.0638541728, -1.2914855480) * lab;\n  gl_FragColor = vec4(sqrt(clamp(                 mat3(+4.0767245293, -1.2681437731, -0.0041119885, -3.3072168827, +2.6093323231, -0.7034763098, +0.2307590544, -0.3411344290, +1.7068625689) *\n                 (lab * lab * lab),                 0.0, 1.0)), v_color.a * tgt.a);\n}";
    public static final String vertexShaderHSI = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\nconst vec3 yellow  = vec3( 0.16155326,0.020876605,-0.26078433 );\nconst vec3 magenta = vec3(-0.16136102,0.122068435,-0.070396   );\nconst vec3 cyan    = vec3( 0.16420607,0.3481738,   0.104959644);\nvoid main()\n{\n    v_color = a_color;\n    v_color.a = a_color.a * (255.0/254.0);\n    vec3 hsi = v_color.rgb;\n    v_color.x = (hsi.z - 0.5) * 0.9999;\n    hsi.x *= 6.28318;\n    hsi.y *= 0.5;\n    v_color.y = cos(hsi.x) * hsi.y;\n    v_color.z = sin(hsi.x) * hsi.y;\n    float crMid = dot(cyan.yz, v_color.yz);\n    float mgMid = dot(magenta.yz, v_color.yz);\n    float ybMid = dot(yellow.yz, v_color.yz);\n    float crScale = (v_color.x - 0.5 + step(crMid, 0.0)) * cyan.x / (0.00001 - crMid);\n    float mgScale = (v_color.x + 0.5 - step(mgMid, 0.0)) * magenta.x / (0.00001 - mgMid);\n    float ybScale = (v_color.x - 0.5 + step(ybMid, 0.0)) * yellow.x / (0.00001 - ybMid);\n    float scale = 4.0 * min(crScale, min(mgScale, ybScale));\n    v_color.yz *= scale * length(v_color.yz) / cos(3.14159 * v_color.x);\n    v_color.xyz += 0.5;\n    v_texCoords = a_texCoord0;\n    gl_Position =  u_projTrans * a_position;\n}\n";
    public static String fragmentShaderHSI = fragmentShaderIPT;
    public static final String partialCodeHSL = "const float eps = 1.0e-10;\n////Call this to go from the official HSL hue distribution (where blue is opposite yellow) to a\n////different distribution that matches primary colors in painting (where purple is opposite yellow).\n//float official2primaries(float hue) {\n//    return  hue * (  2.137\n//          + hue * (  0.542\n//          + hue * (-15.141\n//          + hue * ( 30.120\n//          + hue * (-22.541\n//          + hue *   5.883)))));\n//}\n////Call this to go to the official HSL hue distribution (where blue is opposite yellow) from a\n////different distribution that matches primary colors in painting (where purple is opposite yellow).\n//float primaries2official(float hue) {\n//    return  hue * (  0.677\n//          + hue * ( -0.123\n//          + hue * (-11.302\n//          + hue * ( 46.767\n//          + hue * (-58.493\n//          + hue *   23.474)))));\n//}\nvec4 rgb2hsl(vec4 c)\n{\n    const vec4 J = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\n    vec4 p = mix(vec4(c.bg, J.wz), vec4(c.gb, J.xy), step(c.b, c.g));\n    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\n    float d = q.x - min(q.w, q.y);\n    float l = q.x * (1.0 - 0.5 * d / (q.x + eps));\n    return vec4(abs(q.z + (q.w - q.y) / (6.0 * d + eps)), (q.x - l) / (min(l, 1.0 - l) + eps), l, c.a);\n}\n\nvec4 hsl2rgb(vec4 c)\n{\n    const vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\n    vec3 p = abs(fract(c.x + K.xyz) * 6.0 - K.www);\n    float v = (c.z + c.y * min(c.z, 1.0 - c.z));\n    return vec4(v * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), 2.0 * (1.0 - c.z / (v + eps))), c.w);\n}";
    public static final String partialCodeHSLStretched = "const float eps = 1.0e-10;\nfloat official2primaries(float hue) {\n    return (sqrt(hue + 0.050625) - 0.225) * 1.25;\n}\nfloat primaries2official(float hue) {\n    return pow(hue * 0.8 + 0.225, 2.0) - 0.050625;\n}\nvec4 rgb2hsl(vec4 c)\n{\n    const vec4 J = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\n    vec4 p = mix(vec4(c.bg, J.wz), vec4(c.gb, J.xy), step(c.b, c.g));\n    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\n\n    float d = q.x - min(q.w, q.y);\n    float l = q.x * (1.0 - 0.5 * d / (q.x + eps));\n    return vec4(official2primaries(abs(q.z + (q.w - q.y) / (6.0 * d + eps))), (q.x - l) / (min(l, 1.0 - l) + eps), l, c.a);\n}\n\nvec4 hsl2rgb(vec4 c)\n{\n    const vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\n    vec3 p = abs(fract(primaries2official(c.x) + K.xyz) * 6.0 - K.www);\n    float v = (c.z + c.y * min(c.z, 1.0 - c.z));\n    return vec4(v * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), 2.0 * (1.0 - c.z / (v + eps))), c.w);\n}";
    public static final String partialHueRodrigues = "vec3 applyHue(vec3 rgb, float hue)\n{\n    vec3 k = vec3(0.57735);\n    float c = cos(hue);\n    //Rodrigues' rotation formula\n    return rgb * c + cross(k, rgb) * sin(hue) + k * dot(k, rgb) * (1.0 - c);\n}\n";
    public static final String fragmentShaderHSL = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst float eps = 1.0e-10;\n////Call this to go from the official HSL hue distribution (where blue is opposite yellow) to a\n////different distribution that matches primary colors in painting (where purple is opposite yellow).\n//float official2primaries(float hue) {\n//    return  hue * (  2.137\n//          + hue * (  0.542\n//          + hue * (-15.141\n//          + hue * ( 30.120\n//          + hue * (-22.541\n//          + hue *   5.883)))));\n//}\n////Call this to go to the official HSL hue distribution (where blue is opposite yellow) from a\n////different distribution that matches primary colors in painting (where purple is opposite yellow).\n//float primaries2official(float hue) {\n//    return  hue * (  0.677\n//          + hue * ( -0.123\n//          + hue * (-11.302\n//          + hue * ( 46.767\n//          + hue * (-58.493\n//          + hue *   23.474)))));\n//}\nvec4 rgb2hsl(vec4 c)\n{\n    const vec4 J = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\n    vec4 p = mix(vec4(c.bg, J.wz), vec4(c.gb, J.xy), step(c.b, c.g));\n    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\n    float d = q.x - min(q.w, q.y);\n    float l = q.x * (1.0 - 0.5 * d / (q.x + eps));\n    return vec4(abs(q.z + (q.w - q.y) / (6.0 * d + eps)), (q.x - l) / (min(l, 1.0 - l) + eps), l, c.a);\n}\n\nvec4 hsl2rgb(vec4 c)\n{\n    const vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\n    vec3 p = abs(fract(c.x + K.xyz) * 6.0 - K.www);\n    float v = (c.z + c.y * min(c.z, 1.0 - c.z));\n    return vec4(v * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), 2.0 * (1.0 - c.z / (v + eps))), c.w);\n}void main()\n{\n   vec4 tgt = texture2D( u_texture, v_texCoords );\n   vec4 hsl = rgb2hsl(tgt);\n   hsl.x = fract((fract(v_color.x + 0.5 - hsl.x) - 0.5) * v_color.w + hsl.x);\n   hsl.yz = mix(hsl.yz, v_color.yz, v_color.w);\n   gl_FragColor = hsl2rgb(hsl);\n}";
    public static final String fragmentShaderRotateHSL = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst float eps = 1.0e-10;\n////Call this to go from the official HSL hue distribution (where blue is opposite yellow) to a\n////different distribution that matches primary colors in painting (where purple is opposite yellow).\n//float official2primaries(float hue) {\n//    return  hue * (  2.137\n//          + hue * (  0.542\n//          + hue * (-15.141\n//          + hue * ( 30.120\n//          + hue * (-22.541\n//          + hue *   5.883)))));\n//}\n////Call this to go to the official HSL hue distribution (where blue is opposite yellow) from a\n////different distribution that matches primary colors in painting (where purple is opposite yellow).\n//float primaries2official(float hue) {\n//    return  hue * (  0.677\n//          + hue * ( -0.123\n//          + hue * (-11.302\n//          + hue * ( 46.767\n//          + hue * (-58.493\n//          + hue *   23.474)))));\n//}\nvec4 rgb2hsl(vec4 c)\n{\n    const vec4 J = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\n    vec4 p = mix(vec4(c.bg, J.wz), vec4(c.gb, J.xy), step(c.b, c.g));\n    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\n    float d = q.x - min(q.w, q.y);\n    float l = q.x * (1.0 - 0.5 * d / (q.x + eps));\n    return vec4(abs(q.z + (q.w - q.y) / (6.0 * d + eps)), (q.x - l) / (min(l, 1.0 - l) + eps), l, c.a);\n}\n\nvec4 hsl2rgb(vec4 c)\n{\n    const vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\n    vec3 p = abs(fract(c.x + K.xyz) * 6.0 - K.www);\n    float v = (c.z + c.y * min(c.z, 1.0 - c.z));\n    return vec4(v * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), 2.0 * (1.0 - c.z / (v + eps))), c.w);\n}void main()\n{\n   vec4 tgt = texture2D( u_texture, v_texCoords );\n   vec4 hsl = rgb2hsl(tgt);\n   hsl.x = fract(v_color.x + hsl.x + 0.5);\n   hsl.yz = clamp(hsl.yz * v_color.yz * 2.0, 0.0, 1.0);\n   gl_FragColor = hsl2rgb(hsl);\n}";
    public static final String vertexShaderHSLC = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\nvarying float v_lightFix;\n\nvoid main()\n{\n   v_color = a_color;\n   v_texCoords = a_texCoord0;\n   v_color.a = pow(v_color.a * (255.0/254.0) + 0.5, 1.709);\n   v_lightFix = 1.0 + pow(v_color.a, 1.41421356);\n   gl_Position =  u_projTrans * a_position;\n}\n";
    public static final String fragmentShaderHSLC = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying float v_lightFix;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nvec3 applyHue(vec3 rgb, float hue)\n{\n    vec3 k = vec3(0.57735);\n    float c = cos(hue);\n    //Rodrigues' rotation formula\n    return rgb * c + cross(k, rgb) * sin(hue) + k * dot(k, rgb) * (1.0 - c);\n}\nvoid main()\n{\n    float hue = 6.2831853 * (v_color.x - 0.5);\n    float saturation = v_color.y * 2.0;\n    float brightness = v_color.z - 0.5;\n    vec4 tgt = texture2D( u_texture, v_texCoords );\n    tgt.rgb = applyHue(tgt.rgb, hue);\n    tgt.rgb = vec3(\n     (0.5 * pow(dot(tgt.rgb, vec3(0.375, 0.5, 0.125)), v_color.w) * v_lightFix + brightness),\n     ((tgt.r - tgt.b) * saturation),\n     ((tgt.g - tgt.b) * saturation));\n    gl_FragColor = clamp(vec4(\n     dot(tgt.rgb, vec3(1.0, 0.625, -0.5)),\n     dot(tgt.rgb, vec3(1.0, -0.375, 0.5)),\n     dot(tgt.rgb, vec3(1.0, -0.375, -0.5)),\n     tgt.a), 0.0, 1.0);\n}";
    public static final String fragmentShaderHSLA = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nvec3 applyHue(vec3 rgb, float hue)\n{\n    vec3 k = vec3(0.57735);\n    float c = cos(hue);\n    //Rodrigues' rotation formula\n    return rgb * c + cross(k, rgb) * sin(hue) + k * dot(k, rgb) * (1.0 - c);\n}\nvoid main()\n{\n    float hue = 6.2831853 * (v_color.x - 0.5);\n    float saturation = v_color.y * 2.0;\n    float brightness = v_color.z - 0.5;\n    vec4 tgt = texture2D( u_texture, v_texCoords );\n    tgt.rgb = applyHue(tgt.rgb, hue);\n    tgt.rgb = vec3(\n     (dot(tgt.rgb, vec3(0.375, 0.5, 0.125)) + brightness),\n     ((tgt.r - tgt.b) * saturation),\n     ((tgt.g - tgt.b) * saturation));\n    gl_FragColor = clamp(vec4(\n     dot(tgt.rgb, vec3(1.0, 0.625, -0.5)),\n     dot(tgt.rgb, vec3(1.0, -0.375, 0.5)),\n     dot(tgt.rgb, vec3(1.0, -0.375, -0.5)),\n     tgt.a * v_color.w), 0.0, 1.0);\n}";
    public static final String fragmentShaderHSLC2 = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying float v_lightFix;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst float eps = 1.0e-10;\n////Call this to go from the official HSL hue distribution (where blue is opposite yellow) to a\n////different distribution that matches primary colors in painting (where purple is opposite yellow).\n//float official2primaries(float hue) {\n//    return  hue * (  2.137\n//          + hue * (  0.542\n//          + hue * (-15.141\n//          + hue * ( 30.120\n//          + hue * (-22.541\n//          + hue *   5.883)))));\n//}\n////Call this to go to the official HSL hue distribution (where blue is opposite yellow) from a\n////different distribution that matches primary colors in painting (where purple is opposite yellow).\n//float primaries2official(float hue) {\n//    return  hue * (  0.677\n//          + hue * ( -0.123\n//          + hue * (-11.302\n//          + hue * ( 46.767\n//          + hue * (-58.493\n//          + hue *   23.474)))));\n//}\nvec4 rgb2hsl(vec4 c)\n{\n    const vec4 J = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\n    vec4 p = mix(vec4(c.bg, J.wz), vec4(c.gb, J.xy), step(c.b, c.g));\n    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\n    float d = q.x - min(q.w, q.y);\n    float l = q.x * (1.0 - 0.5 * d / (q.x + eps));\n    return vec4(abs(q.z + (q.w - q.y) / (6.0 * d + eps)), (q.x - l) / (min(l, 1.0 - l) + eps), l, c.a);\n}\n\nvec4 hsl2rgb(vec4 c)\n{\n    const vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\n    vec3 p = abs(fract(c.x + K.xyz) * 6.0 - K.www);\n    float v = (c.z + c.y * min(c.z, 1.0 - c.z));\n    return vec4(v * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), 2.0 * (1.0 - c.z / (v + eps))), c.w);\n}void main()\n{\n    float hue = (v_color.x - 0.5);\n    float saturation = v_color.y * 2.0;\n    float brightness = v_color.z - 0.5;\n    vec4 tgt = texture2D( u_texture, v_texCoords );\n    tgt = rgb2hsl(tgt);\n    tgt.r = fract(tgt.r + hue);\n    tgt = hsl2rgb(tgt);\n    tgt.rgb = vec3(\n     (0.5 * pow(dot(tgt.rgb, vec3(0.375, 0.5, 0.125)), v_color.w) * v_lightFix + brightness),\n     ((tgt.r - tgt.b) * saturation),\n     ((tgt.g - tgt.b) * saturation));\n    gl_FragColor = clamp(vec4(\n     dot(tgt.rgb, vec3(1.0, 0.625, -0.5)),\n     dot(tgt.rgb, vec3(1.0, -0.375, 0.5)),\n     dot(tgt.rgb, vec3(1.0, -0.375, -0.5)),\n     tgt.a), 0.0, 1.0);\n}";
    public static final String fragmentShaderHSLC3 = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying float v_lightFix;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nvec3 applyHue(vec3 rgb, float hue)\n{\n    vec3 k = vec3(0.57735);\n    float c = cos(hue);\n    //Rodrigues' rotation formula\n    return rgb * c + cross(k, rgb) * sin(hue) + k * dot(k, rgb) * (1.0 - c);\n}\nvoid main()\n{\n    float hue = 6.2831853 * (v_color.x - 0.5);\n    float saturation = v_color.y * 2.0;\n    float brightness = v_color.z - 0.5;\n    vec4 tgt = texture2D( u_texture, v_texCoords );\n    tgt.rgb = applyHue(tgt.rgb, hue);\n    tgt.rgb = vec3(\n     (0.5 * pow(dot(tgt.rgb, vec3(0.375, 0.5, 0.125)), v_color.w) * v_lightFix),\n     ((tgt.r - tgt.b) * saturation),\n     ((tgt.g - tgt.b) * saturation));\n    tgt.r = sin((tgt.r + brightness) * 6.2831853) * 0.5 + 0.5;\n    gl_FragColor = clamp(vec4(\n     dot(tgt.rgb, vec3(1.0, 0.625, -0.5)),\n     dot(tgt.rgb, vec3(1.0, -0.375, 0.5)),\n     dot(tgt.rgb, vec3(1.0, -0.375, -0.5)),\n     tgt.a), 0.0, 1.0);\n}";
    public static final String fragmentShaderHSL4 = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst float eps = 1.0e-10;\n////Call this to go from the official HSL hue distribution (where blue is opposite yellow) to a\n////different distribution that matches primary colors in painting (where purple is opposite yellow).\n//float official2primaries(float hue) {\n//    return  hue * (  2.137\n//          + hue * (  0.542\n//          + hue * (-15.141\n//          + hue * ( 30.120\n//          + hue * (-22.541\n//          + hue *   5.883)))));\n//}\n////Call this to go to the official HSL hue distribution (where blue is opposite yellow) from a\n////different distribution that matches primary colors in painting (where purple is opposite yellow).\n//float primaries2official(float hue) {\n//    return  hue * (  0.677\n//          + hue * ( -0.123\n//          + hue * (-11.302\n//          + hue * ( 46.767\n//          + hue * (-58.493\n//          + hue *   23.474)))));\n//}\nvec4 rgb2hsl(vec4 c)\n{\n    const vec4 J = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\n    vec4 p = mix(vec4(c.bg, J.wz), vec4(c.gb, J.xy), step(c.b, c.g));\n    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\n    float d = q.x - min(q.w, q.y);\n    float l = q.x * (1.0 - 0.5 * d / (q.x + eps));\n    return vec4(abs(q.z + (q.w - q.y) / (6.0 * d + eps)), (q.x - l) / (min(l, 1.0 - l) + eps), l, c.a);\n}\n\nvec4 hsl2rgb(vec4 c)\n{\n    const vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\n    vec3 p = abs(fract(c.x + K.xyz) * 6.0 - K.www);\n    float v = (c.z + c.y * min(c.z, 1.0 - c.z));\n    return vec4(v * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), 2.0 * (1.0 - c.z / (v + eps))), c.w);\n}void main()\n{\n    float hue = v_color.x - 0.5;\n    float saturation = v_color.y * 2.0;\n    float brightness = v_color.z - 0.5;\n    vec4 tgt = texture2D( u_texture, v_texCoords );\n    tgt = rgb2hsl(tgt);\n    tgt.x = fract(tgt.x + hue);\n    tgt.y = clamp(tgt.y * saturation, 0.0, 1.0);\n    tgt.z = clamp(brightness + tgt.z, 0.0, 1.0);\n    gl_FragColor = hsl2rgb(tgt);\n}";
    public static final String fragmentShaderHSLP = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst float eps = 1.0e-10;\n////Call this to go from the official HSL hue distribution (where blue is opposite yellow) to a\n////different distribution that matches primary colors in painting (where purple is opposite yellow).\n//float official2primaries(float hue) {\n//    return  hue * (  2.137\n//          + hue * (  0.542\n//          + hue * (-15.141\n//          + hue * ( 30.120\n//          + hue * (-22.541\n//          + hue *   5.883)))));\n//}\n////Call this to go to the official HSL hue distribution (where blue is opposite yellow) from a\n////different distribution that matches primary colors in painting (where purple is opposite yellow).\n//float primaries2official(float hue) {\n//    return  hue * (  0.677\n//          + hue * ( -0.123\n//          + hue * (-11.302\n//          + hue * ( 46.767\n//          + hue * (-58.493\n//          + hue *   23.474)))));\n//}\nvec4 rgb2hsl(vec4 c)\n{\n    const vec4 J = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\n    vec4 p = mix(vec4(c.bg, J.wz), vec4(c.gb, J.xy), step(c.b, c.g));\n    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\n    float d = q.x - min(q.w, q.y);\n    float l = q.x * (1.0 - 0.5 * d / (q.x + eps));\n    return vec4(abs(q.z + (q.w - q.y) / (6.0 * d + eps)), (q.x - l) / (min(l, 1.0 - l) + eps), l, c.a);\n}\n\nvec4 hsl2rgb(vec4 c)\n{\n    const vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\n    vec3 p = abs(fract(c.x + K.xyz) * 6.0 - K.www);\n    float v = (c.z + c.y * min(c.z, 1.0 - c.z));\n    return vec4(v * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), 2.0 * (1.0 - c.z / (v + eps))), c.w);\n}void main()\n{\n   vec4 tgt = texture2D( u_texture, v_texCoords );\n   vec4 hsl = rgb2hsl(tgt);\n   hsl.x *= 6.2831853;\n   hsl.xy = vec2(cos(hsl.x), sin(hsl.x)) * hsl.y;\n   vec3 tint = vec3(cos(v_color.x * 6.2831853) * v_color.y, sin(v_color.x * 6.2831853) * v_color.y * 2.0, v_color.z);\n   hsl.xyz = mix(hsl.xyz, tint, v_color.w);\n   hsl.xy = vec2(fract(atan(hsl.y, hsl.x) / 6.2831853), length(hsl.xy));\n   gl_FragColor = hsl2rgb(hsl);\n}";
    public static final String fragmentShaderReplacement = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nuniform vec4 u_search;\nuniform vec4 u_replace;\nvoid main()\n{\n   vec4 tgt = texture2D(u_texture, v_texCoords);\n   float curve = smoothstep(0.0, 1.0, 1.25 - distance(tgt.rgb, u_search.rgb) * 2.0);\n   gl_FragColor = vec4(mix(tgt.rgb, u_replace.rgb, curve), tgt.a) * v_color;\n}";
    public static String fragmentShaderFlatLightness = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\n#define TARGET_LIGHTNESS 0.5 \n#define SATURATION_CHANGE 1.0 \nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nvoid main()\n{\n    vec4 tgt = texture2D( u_texture, v_texCoords );\n    vec3 ipt = (mat3(0.189786, 0.669665 , 0.286498, 0.576951, -0.73741 , 0.655205, 0.233221, 0.0681367, -0.941748)\n         * (tgt.rgb * v_color.rgb));\n    ipt.x = TARGET_LIGHTNESS;\n//    ipt.x = (ipt.x - 0.5) * 0.25 + TARGET_LIGHTNESS;\n    ipt.yz *= SATURATION_CHANGE;\n    vec3 back = clamp(mat3(0.999779, 1.00015, 0.999769, 1.07094, -0.377744, 0.0629496, 0.324891, 0.220439, -0.809638) * ipt, 0.0, 1.0);\n    gl_FragColor = vec4(back, v_color.a * tgt.a);\n}";
    public static String fragmentShaderConfigurableContrast = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nvoid main()\n{\n    vec4 tgt = texture2D( u_texture, v_texCoords );\n    vec3 ipt = (mat3(0.189786, 0.669665 , 0.286498, 0.576951, -0.73741 , 0.655205, 0.233221, 0.0681367, -0.941748)\n         * tgt.rgb);\n    ipt.x = (ipt.x - 0.5) * v_color.b + v_color.r;\n    ipt.yz *= v_color.g * 2.0;\n    vec3 back = clamp(mat3(0.999779, 1.00015, 0.999769, 1.07094, -0.377744, 0.0629496, 0.324891, 0.220439, -0.809638) * ipt, 0.0, 1.0);\n    gl_FragColor = vec4(back, v_color.a * tgt.a);\n}";
    public static String vertexShaderDayNight = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nuniform float u_timeOfDay;\nvarying vec4 v_color;\nvarying vec4 v_tweak;\nvarying vec2 v_texCoords;\nvarying float v_lightFix;\nconst vec3 forward = vec3(1.0 / 3.0);\n\nvoid main()\n{\n   float st = sin(1.5707963 * sin(0.2617994 * u_timeOfDay)); // Whenever st is very high or low... \n   float ct = sin(1.5707963 * cos(0.2617994 * u_timeOfDay)); // ...ct is close to 0, and vice versa. \n   float dd = ct * ct; // Positive, small; used for dawn and dusk. \n   v_color = a_color;\n   v_color.w = v_color.w * (255.0/254.0);\n   vec3 oklab = mat3(+0.2104542553, +1.9779984951, +0.0259040371, +0.7936177850, -2.4285922050, +0.7827717662, -0.0040720468, +0.4505937099, -0.8086757660) *     pow(mat3(0.4121656120, 0.2118591070, 0.0883097947, 0.5362752080, 0.6807189584, 0.2818474174, 0.0514575653, 0.1074065790, 0.6302613616) \n     * (v_color.rgb * v_color.rgb), forward);\n   // The next four lines make use of the time-based variables st, ct, and dd. Edit to fit. \n   v_color.x = clamp(oklab.x + (0.0625 * st), 0.0, 1.0);\n   v_color.yz = clamp(oklab.yz + vec2(0.0625 * dd + 0.03125 * st, 0.1 * st), -1.0, 1.0) * ((dd + 0.25) * 0.5);\n   v_tweak = vec4(0.2 * st + 0.5);\n   v_tweak.w = pow((1.0 - 0.125 * st), 1.709);\n   v_lightFix = 1.0 + pow(v_tweak.w, 1.41421356);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projTrans * a_position;\n}\n";
    public static String fragmentShaderDayNight = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nvarying LOWP vec4 v_tweak;\nvarying float v_lightFix;\nuniform sampler2D u_texture;\nconst vec3 forward = vec3(1.0 / 3.0);\nuniform float u_time;\nuniform float u_bias;\nvoid main()\n{\n  vec2 uv = v_texCoords;\n  float len = length(uv - vec2(.5)) * 50.;\n  vec2 s = normalize(uv) * ( sin((len - u_time * 10.))) * (.01 * u_time);\n  vec4 tgt = texture2D( u_texture, uv + s);\n  vec3 lab = mat3(+0.2104542553, +1.9779984951, +0.0259040371, +0.7936177850, -2.4285922050, +0.7827717662, -0.0040720468, +0.4505937099, -0.8086757660) *             pow(mat3(0.4121656120, 0.2118591070, 0.0883097947, 0.5362752080, 0.6807189584, 0.2818474174, 0.0514575653, 0.1074065790, 0.6302613616) \n             * (tgt.rgb * tgt.rgb), forward);\n  lab.x = clamp(pow(lab.x, v_tweak.w) * v_lightFix * v_tweak.x + v_color.x - 1.0, 0.0, 1.0);\n  lab.yz = clamp((lab.yz * v_tweak.yz + v_color.yz) * 1.5, -1.0, 1.0);\n  lab = mat3(1.0, 1.0, 1.0, +0.3963377774, -0.1055613458, -0.0894841775, +0.2158037573, -0.0638541728, -1.2914855480) * lab;\n  vec4 daynight = vec4(sqrt(clamp(                 mat3(+4.0767245293, -1.2681437731, -0.0041119885, -3.3072168827, +2.6093323231, -0.7034763098, +0.2307590544, -0.3411344290, +1.7068625689) *\n                 (lab * lab * lab),                 0.0, 1.0)), v_color.a * tgt.a);\n  gl_FragColor = mix(vec4(0.,0.,0.,1.), daynight, u_bias);\n}";
    public static String fragmentShaderCielab = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst vec3 forward = vec3(1.0 / 3.0);\nconst vec3 sRGBFrom = vec3(2.4);\nconst vec3 sRGBThresholdFrom = vec3(0.04045);\nconst vec3 sRGBTo = vec3(1.0 / 2.4);\nconst vec3 sRGBThresholdTo = vec3(0.0031308);\nconst vec3 epsilon = vec3(0.00885645);\nvec3 linear(vec3 t){ return mix(pow((t + 0.055) * (1.0 / 1.055), sRGBFrom), t * (1.0/12.92), step(t, sRGBThresholdFrom)); }\nvec3 sRGB(vec3 t){ return mix(1.055 * pow(t, sRGBTo) - 0.055, 12.92*t, step(t, sRGBThresholdTo)); }\nfloat xyzF(float t){ return mix(pow(t,1./3.), 7.787037 * t + 0.139731, step(t, 0.00885645)); }\nvec3 xyzF(vec3 t){ return mix(pow(t, forward), 7.787037 * t + 0.139731, step(t, epsilon)); }\nfloat xyzR(float t){ return mix(t*t*t , 0.1284185 * (t - 0.139731), step(t, 0.20689655)); }\nvec3 rgb2lab(vec3 c)\n{\n    c *= mat3(0.4124, 0.3576, 0.1805,\n              0.2126, 0.7152, 0.0722,\n              0.0193, 0.1192, 0.9505);\n    c = xyzF(c);\n    vec3 lab = vec3(max(0.,1.16*c.y - 0.16), (c.x - c.y) * 5.0, (c.y - c.z) * 2.0); \n    return lab;\n}\nvec3 lab2rgb(vec3 c)\n{\n    float lg = 1./1.16*(c.x + 0.16);\n    vec3 xyz = vec3(xyzR(lg + c.y * 0.2),\n                    xyzR(lg),\n                    xyzR(lg - c.z * 0.5));\n    vec3 rgb = xyz*mat3( 3.2406, -1.5372,-0.4986,\n                        -0.9689,  1.8758, 0.0415,\n                         0.0557, -0.2040, 1.0570);\n    return rgb;\n}\nvoid main()\n{\n  vec4 tgt = texture2D( u_texture, v_texCoords );\n  vec3 lab = rgb2lab(linear(tgt.rgb));\n  lab.x = lab.x + v_color.r - 0.5372549;\n  lab.yz = lab.yz + (v_color.gb - 0.5) * 2.0;\n  gl_FragColor = vec4(sRGB(clamp(lab2rgb(lab), 0.0, 1.0)), v_color.a * tgt.a);\n}";
    public static String fragmentShaderColorize = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst vec3 forward = vec3(1.0 / 3.0);\nvoid main()\n{\n  vec4 tgt = texture2D( u_texture, v_texCoords );\n//// Ugly repeated matrix math to convert from RGB to Oklab. Oklab keeps lightness separate from hue and saturation.\n  vec3 base = mat3(+0.2104542553, +1.9779984951, +0.0259040371, +0.7936177850, -2.4285922050, +0.7827717662, -0.0040720468, +0.4505937099, -0.8086757660) *              pow(mat3(0.4121656120, 0.2118591070, 0.0883097947, 0.5362752080, 0.6807189584, 0.2818474174, 0.0514575653, 0.1074065790, 0.6302613616) \n              * (tgt.rgb * tgt.rgb), forward);\n  vec3 tint = mat3(+0.2104542553, +1.9779984951, +0.0259040371, +0.7936177850, -2.4285922050, +0.7827717662, -0.0040720468, +0.4505937099, -0.8086757660) *              pow(mat3(0.4121656120, 0.2118591070, 0.0883097947, 0.5362752080, 0.6807189584, 0.2818474174, 0.0514575653, 0.1074065790, 0.6302613616) \n              * (v_color.rgb * v_color.rgb), forward);\n//// Sharply increases lightness contrast, to counteract the gray-ing caused by averaging base and tint lightness.\n  tint.x = (tint.x + base.x) - 1.0;\n  tint.x = sign(tint.x) * pow(abs(tint.x), 0.7) * 0.5 + 0.5;\n//// Uncomment these next 3 lines if you want the original image to contribute some color, if it has any.\n  float blen = length(base.yz);\n  blen *= blen;\n  tint.yz = clamp(tint.yz * (0.7 + blen) + base.yz * (0.3 - blen), -1.0, 1.0);\n//// Reverse the Oklab conversion to get back to RGB. Uses the batch color's alpha normally.\n  tint = mat3(1.0, 1.0, 1.0, +0.3963377774, -0.1055613458, -0.0894841775, +0.2158037573, -0.0638541728, -1.2914855480) * tint;\n  gl_FragColor = vec4(sqrt(clamp(                 mat3(+4.0767245293, -1.2681437731, -0.0041119885, -3.3072168827, +2.6093323231, -0.7034763098, +0.2307590544, -0.3411344290, +1.7068625689) *\n                 (tint * tint * tint),                 0.0, 1.0)), v_color.a * tgt.a);\n}";
    public static String fragmentShaderColorizeOklab = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst vec3 forward = vec3(1.0 / 3.0);\nvoid main()\n{\n  vec4 tgt = texture2D( u_texture, v_texCoords );\n  vec3 base = mat3(+0.2104542553, +1.9779984951, +0.0259040371, +0.7936177850, -2.4285922050, +0.7827717662, -0.0040720468, +0.4505937099, -0.8086757660) *              pow(mat3(0.4121656120, 0.2118591070, 0.0883097947, 0.5362752080, 0.6807189584, 0.2818474174, 0.0514575653, 0.1074065790, 0.6302613616) \n              * (tgt.rgb * tgt.rgb), forward);\n  vec2 tint = v_color.gb - 0.5;\n  base.x = clamp(base.x, 0.0, 1.0);\n  float blen = length(base.yz);\n  blen *= blen;\n  base.gb = clamp(tint * (v_color.r + blen) + base.yz * (1.0 - v_color.r - blen), -1.0, 1.0);\n  base = mat3(1.0, 1.0, 1.0, +0.3963377774, -0.1055613458, -0.0894841775, +0.2158037573, -0.0638541728, -1.2914855480) * base;\n  gl_FragColor = vec4(sqrt(clamp(                 mat3(+4.0767245293, -1.2681437731, -0.0041119885, -3.3072168827, +2.6093323231, -0.7034763098, +0.2307590544, -0.3411344290, +1.7068625689) *\n                 (base * base * base),                 0.0, 1.0)), v_color.a * tgt.a);\n}";
    public static final String fragmentShaderInvertedRGB = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nvoid main()\n{\n   vec4 tgt = texture2D(u_texture, v_texCoords);\n   gl_FragColor = vec4(1.0 - tgt.rgb * v_color.rgb, v_color.a * tgt.a);\n}";
    public static String fragmentShaderInvertedLightness = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst vec3 forward = vec3(1.0 / 3.0);\nfloat toOklab(float L) {\n        const float shape = 0.64516133, turning = 0.95;\n        float d = turning - L;\n        float r = mix(\n          ((1. - turning) * (L - 1.)) / (1. - (L + shape * d)) + 1.,\n          (turning * L) / (1.0e-20 + (L + shape * d)),\n          step(0.0, d));\n        return r * r;\n}\nfloat fromOklab(float L) {\n        const float shape = 1.55, turning = 0.95;\n        L = sqrt(L);\n        float d = turning - L;\n        return mix(\n          ((1. - turning) * (L - 1.)) / (1. - (L + shape * d)) + 1.,\n          (turning * L) / (1.0e-20 + (L + shape * d)),\n          step(0.0, d));\n}\nvoid main()\n{\n  vec4 tgt = texture2D( u_texture, v_texCoords ) * v_color;\n  vec3 lab = mat3(+0.2104542553, +1.9779984951, +0.0259040371, +0.7936177850, -2.4285922050, +0.7827717662, -0.0040720468, +0.4505937099, -0.8086757660) *             pow(mat3(0.4121656120, 0.2118591070, 0.0883097947, 0.5362752080, 0.6807189584, 0.2818474174, 0.0514575653, 0.1074065790, 0.6302613616) \n             * (tgt.rgb * tgt.rgb), forward);\n  lab.x = fromOklab(1.0 - toOklab(lab.x));\n  lab = mat3(1.0, 1.0, 1.0, +0.3963377774, -0.1055613458, -0.0894841775, +0.2158037573, -0.0638541728, -1.2914855480) * lab;\n  gl_FragColor = vec4(sqrt(clamp(                 mat3(+4.0767245293, -1.2681437731, -0.0041119885, -3.3072168827, +2.6093323231, -0.7034763098, +0.2307590544, -0.3411344290, +1.7068625689) *\n                 (lab * lab * lab),                 0.0, 1.0)), tgt.a);\n}";
    public static String fragmentShaderInvertedChroma = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst vec3 forward = vec3(1.0 / 3.0);\nvoid main()\n{\n  vec4 tgt = texture2D( u_texture, v_texCoords ) * v_color;\n  vec3 lab = mat3(+0.2104542553, +1.9779984951, +0.0259040371, +0.7936177850, -2.4285922050, +0.7827717662, -0.0040720468, +0.4505937099, -0.8086757660) *             pow(mat3(0.4121656120, 0.2118591070, 0.0883097947, 0.5362752080, 0.6807189584, 0.2818474174, 0.0514575653, 0.1074065790, 0.6302613616) \n             * (tgt.rgb * tgt.rgb), forward);\n  lab.yz = -lab.yz;\n  lab = mat3(1.0, 1.0, 1.0, +0.3963377774, -0.1055613458, -0.0894841775, +0.2158037573, -0.0638541728, -1.2914855480) * lab;\n  gl_FragColor = vec4(sqrt(clamp(                 mat3(+4.0767245293, -1.2681437731, -0.0041119885, -3.3072168827, +2.6093323231, -0.7034763098, +0.2307590544, -0.3411344290, +1.7068625689) *\n                 (lab * lab * lab),                 0.0, 1.0)), tgt.a);\n}";
    public static String fragmentShaderDoubleSaturation = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying LOWP vec4 v_color;\nuniform sampler2D u_texture;\nconst vec3 forward = vec3(1.0 / 3.0);\nvoid main()\n{\n  vec4 tgt = texture2D( u_texture, v_texCoords ) * v_color;\n  vec3 lab = mat3(+0.2104542553, +1.9779984951, +0.0259040371, +0.7936177850, -2.4285922050, +0.7827717662, -0.0040720468, +0.4505937099, -0.8086757660) *             pow(mat3(0.4121656120, 0.2118591070, 0.0883097947, 0.5362752080, 0.6807189584, 0.2818474174, 0.0514575653, 0.1074065790, 0.6302613616) \n             * (tgt.rgb * tgt.rgb), forward);\n  lab.yz *=   2.000  ;\n  lab = mat3(1.0, 1.0, 1.0, +0.3963377774, -0.1055613458, -0.0894841775, +0.2158037573, -0.0638541728, -1.2914855480) * lab;\n  gl_FragColor = vec4(sqrt(clamp(                 mat3(+4.0767245293, -1.2681437731, -0.0041119885, -3.3072168827, +2.6093323231, -0.7034763098, +0.2307590544, -0.3411344290, +1.7068625689) *\n                 (lab * lab * lab),                 0.0, 1.0)), tgt.a);\n}";
    public static final String vertexShaderHsluv = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\nconst vec3 epsilon = vec3(0.0088564516790356308);\nconst float kappa = 9.032962962;\nconst mat3 m =         mat3(+3.240969941904521, -1.537383177570093, -0.498610760293000,\n              -0.969243636280870, +1.875967501507720, +0.041555057407175,\n              +0.055630079696993, -0.203976958888970, +1.056971514242878);\nfloat intersectLength (float sn, float cs, float line1, float line2) {\n    return line2 / (sn - line1 * cs);\n}\nfloat chromaLimit(float hue, float lightness) {\n        float sn = sin(hue);\n        float cs = cos(hue);\n        float sub1 = (lightness + 0.16) / 1.16;\n        sub1 *= sub1 * sub1;\n        float sub2 = sub1 > epsilon.x ? sub1 : lightness / kappa;\n        float mn = 1.0e20;\n        vec3 ms = m[0] * sub2;\n        float msy, top1, top2, bottom, length;\n        msy = ms.y;\n        top1 = 2845.17 * ms.x - 948.39 * ms.z;\n        top2 = (8384.22 * ms.z + 7698.60 * msy + 7317.18 * ms.x) * lightness;\n        bottom = (6322.60 * ms.z - 1264.52 * msy);\n        length = intersectLength(sn, cs, top1 / bottom, top2 / bottom);\n        if (length >= 0.) mn = min(mn, length);\n        msy -= 1.0;\n        top1 = 2845.17 * ms.x - 948.39 * ms.z;\n        top2 = (8384.22 * ms.z + 7698.60 * msy + 7317.18 * ms.x) * lightness;\n        bottom = (6322.60 * ms.z - 1264.52 * msy);\n        length = intersectLength(sn, cs, top1 / bottom, top2 / bottom);\n        if (length >= 0.) mn = min(mn, length);\n        ms = m[1] * sub2;\n        msy = ms.y;\n        top1 = 2845.17 * ms.x - 948.39 * ms.z;\n        top2 = (8384.22 * ms.z + 7698.60 * msy + 7317.18 * ms.x) * lightness;\n        bottom = (6322.60 * ms.z - 1264.52 * msy);\n        length = intersectLength(sn, cs, top1 / bottom, top2 / bottom);\n        if (length >= 0.) mn = min(mn, length);\n        msy -= 1.0;\n        top1 = 2845.17 * ms.x - 948.39 * ms.z;\n        top2 = (8384.22 * ms.z + 7698.60 * msy + 7317.18 * ms.x) * lightness;\n        bottom = (6322.60 * ms.z - 1264.52 * msy);\n        length = intersectLength(sn, cs, top1 / bottom, top2 / bottom);\n        if (length >= 0.) mn = min(mn, length);\n        ms = m[2] * sub2;\n        msy = ms.y;\n        top1 = 2845.17 * ms.x - 948.39 * ms.z;\n        top2 = (8384.22 * ms.z + 7698.60 * msy + 7317.18 * ms.x) * lightness;\n        bottom = (6322.60 * ms.z - 1264.52 * msy);\n        length = intersectLength(sn, cs, top1 / bottom, top2 / bottom);\n        if (length >= 0.) mn = min(mn, length);\n        msy -= 1.0;\n        top1 = 2845.17 * ms.x - 948.39 * ms.z;\n        top2 = (8384.22 * ms.z + 7698.60 * msy + 7317.18 * ms.x) * lightness;\n        bottom = (6322.60 * ms.z - 1264.52 * msy);\n        length = intersectLength(sn, cs, top1 / bottom, top2 / bottom);\n        if (length >= 0.) mn = min(mn, length);\n        return mn;\n}\nvec3 hsl2luv(vec3 c)\n{\n    float L = c.z;\n    float C = chromaLimit(c.x, L) * c.y;\n    float U = cos(c.x) * C;\n    float V = sin(c.x) * C;\n    return vec3(L, U, V);\n}\nvoid main()\n{\n   v_color = a_color;\n   v_color.w = v_color.w * (255.0/254.0);\n   v_color.x *= 6.2831;\n   v_color.rgb = hsl2luv(v_color.rgb);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projTrans * a_position;\n}\n";
    public static String fragmentShaderHsluv = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying vec2 v_texCoords;\nvarying vec4 v_color;\nuniform sampler2D u_texture;\nconst vec3 forward = vec3(1.0 / 3.0);\nconst vec3 sRGBFrom = vec3(2.4);\nconst vec3 sRGBThresholdFrom = vec3(0.04045);\nconst vec3 sRGBTo = vec3(1.0 / 2.4);\nconst vec3 sRGBThresholdTo = vec3(0.0031308);\nconst vec3 epsilon = vec3(0.0088564516790356308);\nconst float kappa = 9.032962962;\nconst vec2 refUV = vec2(0.19783000664283681, 0.468319994938791);\nconst mat3 m =         mat3(+3.240969941904521, -1.537383177570093, -0.498610760293000,\n              -0.969243636280870, +1.875967501507720, +0.041555057407175,\n              +0.055630079696993, -0.203976958888970, +1.056971514242878);\nconst mat3 mInv =\n         mat3(0.41239079926595948 , 0.35758433938387796, 0.180480788401834290,\n              0.21263900587151036 , 0.71516867876775593, 0.072192315360733715,\n              0.019330818715591851, 0.11919477979462599, 0.950532152249660580);\nvec3 linear(vec3 t){ return mix(pow((t + 0.055) * (1.0 / 1.055), sRGBFrom), t * (1.0/12.92), step(t, sRGBThresholdFrom)); }\nvec3 sRGB(vec3 t){ return mix(1.055 * pow(t, sRGBTo) - 0.055, 12.92*t, step(t, sRGBThresholdTo)); }\nfloat xyzF(float t){ return mix(pow(t,1./3.), 7.787037 * t + 0.139731, step(t, epsilon.x)); }\nvec3 xyzF(vec3 t){ return mix(pow(t, forward), 7.787037 * t + 0.139731, step(t, epsilon)); }\nfloat xyzR(float t){ return mix(t*t*t , 0.1284185 * (t - 0.139731), step(t, 0.20689655)); }\nfloat intersectLength (float sn, float cs, float line1, float line2) {\n    return line2 / (sn - line1 * cs);\n}\nfloat chromaLimit(float hue, float lightness) {\n        float sn = sin(hue);\n        float cs = cos(hue);\n        float sub1 = (lightness + 0.16) / 1.16;\n        sub1 *= sub1 * sub1;\n        float sub2 = sub1 > epsilon.x ? sub1 : lightness / kappa;\n        float mn = 1.0e20;\n        vec3 ms = m[0] * sub2;\n        float msy, top1, top2, bottom, length;\n        msy = ms.y;\n        top1 = 2845.17 * ms.x - 948.39 * ms.z;\n        top2 = (8384.22 * ms.z + 7698.60 * msy + 7317.18 * ms.x) * lightness;\n        bottom = (6322.60 * ms.z - 1264.52 * msy);\n        length = intersectLength(sn, cs, top1 / bottom, top2 / bottom);\n        if (length >= 0.) mn = min(mn, length);\n        msy -= 1.0;\n        top1 = 2845.17 * ms.x - 948.39 * ms.z;\n        top2 = (8384.22 * ms.z + 7698.60 * msy + 7317.18 * ms.x) * lightness;\n        bottom = (6322.60 * ms.z - 1264.52 * msy);\n        length = intersectLength(sn, cs, top1 / bottom, top2 / bottom);\n        if (length >= 0.) mn = min(mn, length);\n        ms = m[1] * sub2;\n        msy = ms.y;\n        top1 = 2845.17 * ms.x - 948.39 * ms.z;\n        top2 = (8384.22 * ms.z + 7698.60 * msy + 7317.18 * ms.x) * lightness;\n        bottom = (6322.60 * ms.z - 1264.52 * msy);\n        length = intersectLength(sn, cs, top1 / bottom, top2 / bottom);\n        if (length >= 0.) mn = min(mn, length);\n        msy -= 1.0;\n        top1 = 2845.17 * ms.x - 948.39 * ms.z;\n        top2 = (8384.22 * ms.z + 7698.60 * msy + 7317.18 * ms.x) * lightness;\n        bottom = (6322.60 * ms.z - 1264.52 * msy);\n        length = intersectLength(sn, cs, top1 / bottom, top2 / bottom);\n        if (length >= 0.) mn = min(mn, length);\n        ms = m[2] * sub2;\n        msy = ms.y;\n        top1 = 2845.17 * ms.x - 948.39 * ms.z;\n        top2 = (8384.22 * ms.z + 7698.60 * msy + 7317.18 * ms.x) * lightness;\n        bottom = (6322.60 * ms.z - 1264.52 * msy);\n        length = intersectLength(sn, cs, top1 / bottom, top2 / bottom);\n        if (length >= 0.) mn = min(mn, length);\n        msy -= 1.0;\n        top1 = 2845.17 * ms.x - 948.39 * ms.z;\n        top2 = (8384.22 * ms.z + 7698.60 * msy + 7317.18 * ms.x) * lightness;\n        bottom = (6322.60 * ms.z - 1264.52 * msy);\n        length = intersectLength(sn, cs, top1 / bottom, top2 / bottom);\n        if (length >= 0.) mn = min(mn, length);\n        return mn;\n}\nvec3 rgb2luv(vec3 c)\n{\n    c *= mInv;    float L = max(0.,1.16*pow(c.y, 1.0 / 3.0) - 0.16);\n    vec2 uv;\n    if(L < 0.0001) uv = vec2(0.0);\n    else uv = 13. * L * (vec2(4., 9.) * c.xy / (c.x + 15. * c.y + 3. * c.z) - refUV);\n    return vec3(L, uv);\n}\nfloat forwardLight(float L) {\n        const float shape = 0.8528, turning = 0.1;\n        float d = turning - L;\n        return mix(\n          ((1. - turning) * (L - 1.)) / (1. - (L + shape * d)) + 1.,\n          (turning * L) / (1.0e-20 + (L + shape * d)),\n          step(0.0, d));\n}\nfloat reverseLight(float L) {\n        const float shape = 1.1726, turning = 0.1;\n        float d = turning - L;\n        return mix(\n          ((1. - turning) * (L - 1.)) / (1. - (L + shape * d)) + 1.,\n          (turning * L) / (1.0e-20 + (L + shape * d)),\n          step(0.0, d));\n}\nvec3 luv2rgb(vec3 c)\n{\n    float L = reverseLight(c.x);\n    float U = c.y;\n    float V = c.z;\n    float lim = chromaLimit(atan(V, U), L);\n    float len = length(vec2(U,V));\n    if(len > lim) {\n      lim /= len;\n      U *= lim;\n      V *= lim;\n    }\n    if (L <= 0.0001) {\n        return vec3(0.0);\n    } else if(L >= 0.9999) {\n        return vec3(1.0);\n    } else {\n      if (L <= 0.08) {\n        c.y = L / kappa;\n      } else {\n        c.y = (L + 0.16) / 1.16;\n        c.y *= c.y * c.y;\n      }\n    }\n    float iL = 1. / (13.0 * L);\n    float varU = U * iL + refUV.x;\n    float varV = V * iL + refUV.y;\n    c.x = 2.25 * varU * c.y / varV;\n    c.z = (3. / varV - 5.) * c.y - (c.x / 3.);\n    vec3 rgb = c * m;\n    return rgb;\n}\nvoid main()\n{\n  vec4 tgt = texture2D( u_texture, v_texCoords );\n  vec3 luv = rgb2luv(linear(tgt.rgb));\n  luv.x = forwardLight(clamp(luv.x + v_color.x - 0.5372549, 0.0, 1.0));\n  luv.yz = (luv.yz) + (v_color.yz);\n  gl_FragColor = vec4(sRGB(clamp(luv2rgb(luv), 0.0, 1.0)), v_color.a * tgt.a);\n}";
}

