/*
 * Decompiled with CFR 0.152.
 */
package forge;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.TimeUtils;

public class FrameRate
implements Disposable {
    long lastTimeCounted = TimeUtils.millis();
    int cardsLoaded = 0;
    int allocT = 0;
    private float sinceChange = 0.0f;
    private float frameRate = Gdx.graphics.getFramesPerSecond();
    private BitmapFont font = new BitmapFont();
    private SpriteBatch batch = new SpriteBatch();
    private OrthographicCamera cam = new OrthographicCamera(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());

    public void resize(int screenWidth, int screenHeight) {
        this.cam = new OrthographicCamera(screenWidth, screenHeight);
        this.cam.translate(screenWidth / 2, screenHeight / 2);
        this.cam.update();
        this.batch.setProjectionMatrix(this.cam.combined);
    }

    public void update(int loadedCardSize, float toAlloc) {
        this.allocT = (int)toAlloc;
        this.cardsLoaded = loadedCardSize;
        long delta = TimeUtils.timeSinceMillis(this.lastTimeCounted);
        this.lastTimeCounted = TimeUtils.millis();
        this.sinceChange += (float)delta;
        if (this.sinceChange >= 1000.0f) {
            this.sinceChange = 0.0f;
            this.frameRate = Gdx.graphics.getFramesPerSecond();
        }
    }

    public void render() {
        this.batch.begin();
        this.font.draw((Batch)this.batch, (int)this.frameRate + " FPS | " + this.cardsLoaded + " cards re/loaded | " + this.allocT + " MB", 3.0f, (float)(Gdx.graphics.getHeight() - 3));
        this.batch.end();
    }

    @Override
    public void dispose() {
        this.font.dispose();
        this.batch.dispose();
    }
}

