/*
 * Decompiled with CFR 0.152.
 */
package forge;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerAdapter;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.Controllers;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import forge.FrameRate;
import forge.Graphics;
import forge.GuiMobile;
import forge.ImageKeys;
import forge.adventure.scene.DeckSelectScene;
import forge.adventure.scene.DuelScene;
import forge.adventure.scene.ForgeScene;
import forge.adventure.scene.PlayerStatisticScene;
import forge.adventure.scene.QuestLogScene;
import forge.adventure.scene.RewardScene;
import forge.adventure.scene.Scene;
import forge.adventure.scene.SpellSmithScene;
import forge.adventure.scene.StartScene;
import forge.adventure.stage.GameHUD;
import forge.adventure.stage.MapStage;
import forge.adventure.util.Config;
import forge.adventure.world.WorldSave;
import forge.animation.ForgeAnimation;
import forge.assets.Assets;
import forge.assets.AssetsDownloader;
import forge.assets.FSkin;
import forge.assets.FSkinFont;
import forge.assets.ImageCache;
import forge.error.ExceptionHandler;
import forge.gamemodes.limited.BoosterDraft;
import forge.gui.FThreads;
import forge.gui.GuiBase;
import forge.gui.error.BugReporter;
import forge.interfaces.IDeviceAdapter;
import forge.localinstance.properties.ForgeConstants;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.screens.ClosingScreen;
import forge.screens.FScreen;
import forge.screens.SplashScreen;
import forge.screens.TransitionScreen;
import forge.screens.home.AdventureScreen;
import forge.screens.home.HomeScreen;
import forge.screens.home.NewGameMenu;
import forge.screens.match.MatchController;
import forge.screens.match.MatchScreen;
import forge.sound.MusicPlaylist;
import forge.sound.SoundSystem;
import forge.toolbox.FContainer;
import forge.toolbox.FDialog;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FGestureAdapter;
import forge.toolbox.FOptionPane;
import forge.toolbox.FOverlay;
import forge.util.Callback;
import forge.util.CardTranslation;
import forge.util.FileUtil;
import forge.util.Localizer;
import forge.util.Utils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;

public class Forge
implements ApplicationListener {
    public static final String CURRENT_VERSION = "1.6.65-SNAPSHOT";
    private static ApplicationListener app = null;
    static Scene currentScene = null;
    static Array<Scene> lastScene = new Array();
    private static float animationTimeout;
    static Batch animationBatch;
    static TextureRegion lastScreenTexture;
    private static boolean sceneWasSwapped;
    public static boolean advFreezePlayerControls;
    private static Clipboard clipboard;
    private static IDeviceAdapter deviceAdapter;
    private static int screenWidth;
    private static int screenHeight;
    private static Graphics graphics;
    private static FrameRate frameRate;
    private static FScreen currentScreen;
    private static ControllerListener controllerListener;
    private static boolean hasGamepad;
    public static Texture lastPreview;
    protected static SplashScreen splashScreen;
    protected static ClosingScreen closingScreen;
    protected static TransitionScreen transitionScreen;
    public static KeyInputAdapter keyInputAdapter;
    private static boolean exited;
    public boolean needsUpdate = false;
    public static boolean advStartup;
    public static boolean safeToClose;
    public static boolean magnify;
    public static boolean magnifyToggle;
    public static boolean magnifyShowDetails;
    public static String cursorName;
    private static int continuousRenderingCount;
    private static final Deque<FScreen> Dscreens;
    private static boolean textureFiltering;
    private static boolean destroyThis;
    public static String extrawide;
    public static float heigtModifier;
    private static boolean isloadingaMatch;
    public static boolean autoAIDeckSelection;
    public static boolean showFPS;
    public static boolean allowCardBG;
    public static boolean altPlayerLayout;
    public static boolean altZoneTabs;
    public static boolean animatedCardTapUntap;
    public static String enableUIMask;
    public static String selector;
    public static boolean enablePreloadExtendedArt;
    public static boolean isTabletDevice;
    public static String locale;
    public Assets assets;
    public static boolean hdbuttons;
    public static boolean hdstart;
    public static boolean isPortraitMode;
    public static boolean gameInProgress;
    public static boolean disposeTextures;
    public static boolean isMobileAdventureMode;
    public static int cacheSize;
    public static int totalDeviceRAM;
    public static int androidVersion;
    public static boolean autoCache;
    public static int lastButtonIndex;
    public static String CJK_Font;
    public static int hoveredCount;
    public static boolean afterDBloaded;
    public static int mouseButtonID;
    public static InputProcessor inputProcessor;
    private static Cursor cursor0;
    private static Cursor cursor1;
    private static Cursor cursor2;
    private static Cursor cursorA0;
    private static Cursor cursorA1;
    private static Cursor cursorA2;
    public static boolean forcedEnglishonCJKMissing;
    public static boolean createNewAdventureMap;
    private static Localizer localizer;
    public static float mouseMovedX;
    public static float mouseMovedY;

    public static ApplicationListener getApp(Clipboard clipboard0, IDeviceAdapter deviceAdapter0, String assetDir0, boolean value, boolean androidOrientation, int totalRAM, boolean isTablet, int AndroidAPI, String AndroidRelease, String deviceName) {
        app = new Forge();
        if (GuiBase.getInterface() == null) {
            clipboard = clipboard0;
            deviceAdapter = deviceAdapter0;
            GuiBase.setUsingAppDirectory(assetDir0.contains("forge.app"));
            GuiBase.setInterface(new GuiMobile(assetDir0));
            GuiBase.enablePropertyConfig(value);
            isPortraitMode = androidOrientation;
            totalDeviceRAM = totalRAM;
            isTabletDevice = isTablet;
            androidVersion = AndroidAPI;
        }
        GuiBase.setDeviceInfo(deviceName, AndroidRelease, AndroidAPI, totalRAM);
        return app;
    }

    private Forge() {
    }

    private ForgePreferences getForgePreferences() {
        return GuiBase.getForgePrefs();
    }

    public static Localizer getLocalizer() {
        if (localizer == null) {
            localizer = Localizer.getInstance();
        }
        return localizer;
    }

    @Override
    public void create() {
        boolean landscapeMode;
        ExceptionHandler.registerErrorHandling();
        GuiBase.setIsAndroid(Gdx.app.getType() == Application.ApplicationType.Android);
        if (!GuiBase.isAndroid() || androidVersion > 25 && totalDeviceRAM > 3400) {
            allowCardBG = true;
        }
        this.assets = new Assets();
        graphics = new Graphics();
        splashScreen = new SplashScreen();
        frameRate = new FrameRate();
        animationBatch = new SpriteBatch();
        inputProcessor = new MainInputProcessor();
        screenWidth = Gdx.app.getGraphics().getWidth();
        screenHeight = Gdx.app.getGraphics().getHeight();
        Gdx.input.setInputProcessor(inputProcessor);
        Gdx.input.setCatchKey(4, true);
        destroyThis = true;
        if (Files.exists(Paths.get(ForgeConstants.DEFAULT_SKINS_DIR + "adv_bg_texture.jpg", new String[0]), new LinkOption[0])) {
            selector = this.getForgePreferences().getPref(ForgePreferences.FPref.UI_SELECTOR_MODE);
        }
        boolean bl = GuiBase.isAndroid() ? !isPortraitMode : (landscapeMode = screenWidth > screenHeight);
        if (this.getForgePreferences().getPrefBoolean(ForgePreferences.FPref.UI_LANDSCAPE_MODE) != landscapeMode) {
            this.getForgePreferences().setPref(ForgePreferences.FPref.UI_LANDSCAPE_MODE, landscapeMode);
            this.getForgePreferences().save();
        }
        String skinName = FileUtil.doesFileExist(ForgeConstants.MAIN_PREFS_FILE) ? this.getForgePreferences().getPref(ForgePreferences.FPref.UI_SKIN) : "default";
        FSkin.loadLight(skinName, splashScreen);
        textureFiltering = this.getForgePreferences().getPrefBoolean(ForgePreferences.FPref.UI_LIBGDX_TEXTURE_FILTERING);
        showFPS = this.getForgePreferences().getPrefBoolean(ForgePreferences.FPref.UI_SHOW_FPS);
        autoAIDeckSelection = this.getForgePreferences().getPrefBoolean(ForgePreferences.FPref.UI_AUTO_AIDECK_SELECTION);
        altPlayerLayout = this.getForgePreferences().getPrefBoolean(ForgePreferences.FPref.UI_ALT_PLAYERINFOLAYOUT);
        altZoneTabs = this.getForgePreferences().getPrefBoolean(ForgePreferences.FPref.UI_ALT_PLAYERZONETABS);
        animatedCardTapUntap = this.getForgePreferences().getPrefBoolean(ForgePreferences.FPref.UI_ANIMATED_CARD_TAPUNTAP);
        enableUIMask = this.getForgePreferences().getPref(ForgePreferences.FPref.UI_ENABLE_BORDER_MASKING);
        if (this.getForgePreferences().getPref(ForgePreferences.FPref.UI_ENABLE_BORDER_MASKING).equals("true")) {
            enableUIMask = "Full";
        } else if (this.getForgePreferences().getPref(ForgePreferences.FPref.UI_ENABLE_BORDER_MASKING).equals("false")) {
            enableUIMask = "Off";
        }
        enablePreloadExtendedArt = this.getForgePreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_PRELOAD_EXTENDED_ART);
        locale = this.getForgePreferences().getPref(ForgePreferences.FPref.UI_LANGUAGE);
        autoCache = this.getForgePreferences().getPrefBoolean(ForgePreferences.FPref.UI_AUTO_CACHE_SIZE);
        disposeTextures = this.getForgePreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_DISPOSE_TEXTURES);
        CJK_Font = this.getForgePreferences().getPref(ForgePreferences.FPref.UI_CJK_FONT);
        if (autoCache && totalDeviceRAM > 5000) {
            cacheSize = totalDeviceRAM > 10000 ? 600 : 400;
        }
        ImageCache.initCache(cacheSize);
        FThreads.invokeInBackgroundThread(() -> {
            AssetsDownloader.checkForUpdates(splashScreen);
            if (exited) {
                return;
            }
            safeToClose = false;
            ImageKeys.setIsLibGDXPort(GuiBase.getInterface().isLibgdxPort());
            FModel.initialize(splashScreen.getProgressBar(), null);
            splashScreen.getProgressBar().setDescription(Forge.getLocalizer().getMessage("lblLoadingFonts", new Object[0]));
            FSkinFont.preloadAll(locale);
            splashScreen.getProgressBar().setDescription(Forge.getLocalizer().getMessage("lblLoadingCardTranslations", new Object[0]));
            CardTranslation.preloadTranslation(locale, ForgeConstants.LANG_DIR);
            splashScreen.getProgressBar().setDescription(Forge.getLocalizer().getMessage("lblFinishingStartup", new Object[0]));
            if (enablePreloadExtendedArt) {
                if (autoCache) {
                    splashScreen.getProgressBar().setDescription(Forge.getLocalizer().getMessage("lblPreloadExtendedArt", new Object[0]) + "\nDetected RAM: " + totalDeviceRAM + "MB. Cache size: " + cacheSize);
                } else {
                    splashScreen.getProgressBar().setDescription(Forge.getLocalizer().getMessage("lblPreloadExtendedArt", new Object[0]));
                }
            } else if (autoCache) {
                splashScreen.getProgressBar().setDescription(Forge.getLocalizer().getMessage("lblFinishingStartup", new Object[0]) + "\nDetected RAM: " + totalDeviceRAM + "MB. Cache size: " + cacheSize);
            } else {
                splashScreen.getProgressBar().setDescription(Forge.getLocalizer().getMessage("lblFinishingStartup", new Object[0]));
            }
            Gdx.app.postRunnable(() -> {
                this.afterDbLoaded();
                this.preloadExtendedArt();
            });
        });
    }

    public static boolean hasGamepad() {
        if (isMobileAdventureMode) {
            return hasGamepad && Forge.isLandscapeMode();
        }
        return false;
    }

    public static InputProcessor getInputProcessor() {
        return inputProcessor;
    }

    public static Graphics getGraphics() {
        return graphics;
    }

    public static Scene getCurrentScene() {
        return currentScene;
    }

    private void preloadExtendedArt() {
        if (!enablePreloadExtendedArt || !enableUIMask.equals("Full")) {
            return;
        }
        List<String> borderlessCardlistkeys = FileUtil.readFile(ForgeConstants.BORDERLESS_CARD_LIST_FILE);
        if (borderlessCardlistkeys.isEmpty()) {
            return;
        }
        ArrayList<String> filteredkeys = new ArrayList<String>();
        for (String cardname : borderlessCardlistkeys) {
            File image = new File(ForgeConstants.CACHE_CARD_PICS_DIR + ForgeConstants.PATH_SEPARATOR + cardname + ".jpg");
            if (!image.exists()) continue;
            filteredkeys.add(cardname);
        }
        if (!filteredkeys.isEmpty()) {
            ImageCache.preloadCache(filteredkeys);
        }
    }

    private void preloadBoosterDrafts() {
        BoosterDraft.initializeCustomDrafts();
    }

    public static void openHomeScreen(int index, FScreen lastMatch) {
        Forge.openScreen(HomeScreen.instance);
        HomeScreen.instance.openMenu(index);
        if (lastMatch != null) {
            try {
                Dscreens.remove(lastMatch);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void openHomeDefault() {
        Forge.getLocalizer().setEnglish(forcedEnglishonCJKMissing);
        GuiBase.setIsAdventureMode(false);
        Forge.openHomeScreen(-1, null);
        isMobileAdventureMode = false;
        MusicPlaylist.invalidateMusicPlaylist();
        SoundSystem.instance.setBackgroundMusic(MusicPlaylist.MENUS);
        if (Forge.isLandscapeMode()) {
            NewGameMenu.getPreferredScreen().open();
        }
        Forge.stopContinuousRendering();
    }

    public static void openAdventure() {
        Forge.getLocalizer().setEnglish(forcedEnglishonCJKMissing);
        Forge.startContinuousRendering();
        GuiBase.setIsAdventureMode(true);
        advStartup = false;
        isMobileAdventureMode = true;
        if (GuiBase.isAndroid()) {
            altZoneTabs = true;
        }
        Forge.setCursor(null, "0");
        if (!GuiBase.isAndroid() || !Forge.getDeviceAdapter().getGamepads().isEmpty()) {
            Forge.enableControllerListener();
        }
        Forge.loadAdventureResources(true);
    }

    private static void loadAdventureResources(boolean startScene) {
        try {
            Config.instance().loadResources();
            SpellSmithScene.instance().loadEditions();
            GameHUD.getInstance().stopAudio();
            if (startScene) {
                MusicPlaylist.invalidateMusicPlaylist();
                SoundSystem.instance.setBackgroundMusic(MusicPlaylist.MENUS);
                Forge.switchScene(StartScene.instance());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void afterDbLoaded() {
        try {
            FileHandle transitionFile = Config.instance().getFile("ui/transition.png");
            FileHandle titleBGFile = Forge.isLandscapeMode() ? Config.instance().getFile("ui/title_bg.png") : Config.instance().getFile("ui/title_bg_portrait.png");
            FileHandle vsIcon = Config.instance().getFile("ui/vs.png");
            if (vsIcon.exists()) {
                Forge.getAssets().fallback_skins().put("vs", new Texture(vsIcon));
            }
            if (transitionFile.exists()) {
                Forge.getAssets().fallback_skins().put("transition", new Texture(transitionFile));
            }
            if (titleBGFile.exists()) {
                Forge.getAssets().fallback_skins().put("title", new Texture(titleBGFile));
            }
            AdventureScreen.preload();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        destroyThis = false;
        Gdx.input.setCatchKey(82, true);
        afterDBloaded = true;
        Forge.adjustHeightModifier(Forge.getScreenWidth(), Forge.getScreenHeight());
        FThreads.invokeInBackgroundThread(() -> FThreads.invokeInEdtLater(() -> {
            FSkin.loadFull(splashScreen);
            FThreads.invokeInBackgroundThread(() -> {
                this.preloadBoosterDrafts();
                FThreads.invokeInEdtLater(() -> {
                    if (selector.equals("Adventure")) {
                        Forge.loadAdventureResources(false);
                        isMobileAdventureMode = true;
                    }
                    Forge.setTransitionScreen(new TransitionScreen(() -> {
                        if (createNewAdventureMap) {
                            Forge.openAdventure();
                            Forge.clearSplashScreen();
                        } else if (selector.equals("Classic")) {
                            Forge.openHomeDefault();
                            Forge.clearSplashScreen();
                        } else if (selector.equals("Adventure")) {
                            Forge.openAdventure();
                            Forge.clearSplashScreen();
                        } else if (splashScreen != null) {
                            splashScreen.setShowModeSelector(true);
                        } else {
                            Forge.openHomeDefault();
                            Forge.clearSplashScreen();
                        }
                        safeToClose = true;
                        Forge.clearTransitionScreen();
                    }, Forge.takeScreenshot(), false, false, true, false));
                });
            });
        }));
    }

    public static void setCursor(TextureRegion textureRegion, String name) {
        if (GuiBase.isAndroid()) {
            return;
        }
        if (isMobileAdventureMode) {
            if (cursorA0 != null && Objects.equals(name, "0")) {
                Forge.setGdxCursor(cursorA0);
                return;
            }
            if (cursorA1 != null && Objects.equals(name, "1")) {
                Forge.setGdxCursor(cursorA1);
                return;
            }
            if (cursorA2 != null && Objects.equals(name, "2")) {
                Forge.setGdxCursor(cursorA2);
                return;
            }
            String path = "skin/cursor" + name + ".png";
            Pixmap pm = new Pixmap(Config.instance().getFile(path));
            if (name == "0") {
                cursorA0 = Gdx.graphics.newCursor(pm, 0, 0);
                Forge.setGdxCursor(cursorA0);
            } else if (name == "1") {
                cursorA1 = Gdx.graphics.newCursor(pm, 0, 0);
                Forge.setGdxCursor(cursorA1);
            } else {
                cursorA2 = Gdx.graphics.newCursor(pm, 0, 0);
                Forge.setGdxCursor(cursorA2);
            }
            pm.dispose();
            return;
        }
        if (!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_MAGNIFIER) && name != "0") {
            return;
        }
        if (currentScreen != null && !currentScreen.toString().toLowerCase().contains("match") && name != "0") {
            return;
        }
        if (textureRegion == null) {
            return;
        }
        if (cursor0 != null && name == "0") {
            Forge.setGdxCursor(cursor0);
            return;
        }
        if (cursor1 != null && name == "1") {
            Forge.setGdxCursor(cursor1);
            return;
        }
        if (cursor2 != null && name == "2") {
            Forge.setGdxCursor(cursor2);
            return;
        }
        TextureData textureData = textureRegion.getTexture().getTextureData();
        if (!textureData.isPrepared()) {
            textureData.prepare();
        }
        Pixmap pm = new Pixmap(textureRegion.getRegionWidth(), textureRegion.getRegionHeight(), textureData.getFormat());
        pm.drawPixmap(textureData.consumePixmap(), 0, 0, textureRegion.getRegionX(), textureRegion.getRegionY(), textureRegion.getRegionWidth(), textureRegion.getRegionHeight());
        if (name == "0") {
            cursor0 = Gdx.graphics.newCursor(pm, 0, 0);
            Forge.setGdxCursor(cursor0);
        } else if (name == "1") {
            cursor1 = Gdx.graphics.newCursor(pm, 0, 0);
            Forge.setGdxCursor(cursor1);
        } else {
            cursor2 = Gdx.graphics.newCursor(pm, 0, 0);
            Forge.setGdxCursor(cursor2);
        }
        cursorName = name;
        pm.dispose();
    }

    static void setGdxCursor(Cursor c) {
        Gdx.graphics.setCursor(c);
    }

    public static Clipboard getClipboard() {
        return clipboard;
    }

    public static IDeviceAdapter getDeviceAdapter() {
        return deviceAdapter;
    }

    public static void startContinuousRendering() {
        if (++continuousRenderingCount == 1) {
            Gdx.graphics.setContinuousRendering(true);
        }
    }

    public static void stopContinuousRendering() {
        if (continuousRenderingCount > 0 && --continuousRenderingCount == 0) {
            Gdx.graphics.setContinuousRendering(false);
        }
    }

    public static void setHeightModifier(float height) {
        heigtModifier = height;
    }

    public static float getHeightModifier() {
        return heigtModifier;
    }

    public static void adjustHeightModifier(float DisplayW, float DisplayH) {
        if (Forge.isLandscapeMode()) {
            float aspectratio = DisplayW / DisplayH;
            if (aspectratio > 1.82f) {
                Forge.setHeightModifier(200.0f);
                extrawide = "extrawide";
            } else if (aspectratio > 1.7f) {
                Forge.setHeightModifier(100.0f);
                extrawide = "wide";
            }
        }
    }

    public static void setForcedEnglishonCJKMissing() {
        if (!forcedEnglishonCJKMissing) {
            forcedEnglishonCJKMissing = true;
            Forge.getLocalizer().setEnglish(forcedEnglishonCJKMissing);
            System.err.println("Forge switches to English due to an error generating CJK Fonts. Language: " + locale);
        }
    }

    public static void showMenu() {
        if (isMobileAdventureMode) {
            return;
        }
        if (currentScreen == null) {
            return;
        }
        Forge.endKeyInput();
        if (FOverlay.getTopOverlay() == null) {
            currentScreen.showMenu();
        }
    }

    public static boolean onHomeScreen() {
        return Dscreens.size() == 1;
    }

    public static void back() {
        Forge.back(false);
    }

    public static void back(final boolean clearlastMatch) {
        if (isMobileAdventureMode) {
            return;
        }
        final FScreen lastMatch = currentScreen;
        if (destroyThis && Forge.isLandscapeMode()) {
            return;
        }
        if (Dscreens.size() < 2 || currentScreen == HomeScreen.instance && isPortraitMode) {
            Forge.exit(false);
            return;
        }
        currentScreen.onClose(new Callback<Boolean>(){

            @Override
            public void run(Boolean result) {
                if (result.booleanValue()) {
                    Dscreens.pollFirst();
                    Forge.setCurrentScreen((FScreen)Dscreens.peekFirst());
                    if (clearlastMatch) {
                        try {
                            Dscreens.remove(lastMatch);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public static void setBackScreen(FScreen screen0, boolean replace) {
        Dscreens.remove(screen0);
        int index = Dscreens.size() - 1;
        if (index > 0) {
            Dscreens.addLast(screen0);
            if (replace) {
                Dscreens.removeFirst();
            }
        }
    }

    public static void restart(boolean silent) {
        if (exited) {
            return;
        }
        Callback<Boolean> callback = new Callback<Boolean>(){

            @Override
            public void run(Boolean result) {
                if (result.booleanValue()) {
                    exited = true;
                    Forge.exitAnimation(true);
                }
            }
        };
        if (silent) {
            callback.run(true);
        } else {
            FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblAreYouSureYouWishRestartForge", new Object[0]), Forge.getLocalizer().getMessage("lblRestartForge", new Object[0]), Forge.getLocalizer().getMessage("lblRestart", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0]), callback);
        }
    }

    public static void exit(boolean silent) {
        if (exited) {
            return;
        }
        ArrayList<String> options = new ArrayList<String>();
        options.add(Forge.getLocalizer().getMessage("lblExit", new Object[0]));
        options.add(Forge.getLocalizer().getMessage("lblCancel", new Object[0]));
        Callback<Integer> callback = new Callback<Integer>(){

            @Override
            public void run(Integer result) {
                if (result == 0) {
                    exited = true;
                    Forge.exitAnimation(false);
                }
            }
        };
        if (silent) {
            callback.run(0);
        } else {
            FOptionPane.showOptionDialog(Forge.getLocalizer().getMessage("lblAreYouSureYouWishExitForge", new Object[0]), "", FOptionPane.QUESTION_ICON, options, 0, callback);
        }
    }

    public static void openScreen(FScreen screen0) {
        Forge.openScreen(screen0, false);
    }

    public static void openScreen(final FScreen screen0, final boolean replaceBackScreen) {
        if (currentScreen == screen0) {
            return;
        }
        if (currentScreen == null) {
            Dscreens.addFirst(screen0);
            Forge.setCurrentScreen(screen0);
            return;
        }
        currentScreen.onSwitchAway(new Callback<Boolean>(){

            @Override
            public void run(Boolean result) {
                if (result.booleanValue()) {
                    if (replaceBackScreen && !Dscreens.isEmpty()) {
                        Dscreens.removeFirst();
                    }
                    if (Dscreens.peekFirst() != screen0) {
                        Dscreens.addFirst(screen0);
                    }
                    Forge.setCurrentScreen(screen0);
                    if (screen0 instanceof MatchScreen && !isMobileAdventureMode) {
                        if (magnifyToggle) {
                            Forge.setCursor(FSkin.getCursor().get(1), "1");
                        } else {
                            Forge.setCursor(FSkin.getCursor().get(2), "2");
                        }
                    }
                }
            }
        });
    }

    public static boolean isTextureFilteringEnabled() {
        return textureFiltering;
    }

    public static boolean isLandscapeMode() {
        if (GuiBase.isAndroid()) {
            return !isPortraitMode;
        }
        return screenWidth > screenHeight;
    }

    public static boolean isLoadingaMatch() {
        return isloadingaMatch;
    }

    public static void setLoadingaMatch(boolean value) {
        isloadingaMatch = value;
    }

    public static int getScreenWidth() {
        return screenWidth;
    }

    public static int getScreenHeight() {
        return screenHeight;
    }

    public static FScreen getCurrentScreen() {
        return currentScreen;
    }

    public static void clearCurrentScreen() {
        currentScreen = null;
    }

    public static void switchToClassic() {
        Forge.setTransitionScreen(new TransitionScreen(() -> {
            ImageCache.disposeTextures();
            isMobileAdventureMode = false;
            GuiBase.setIsAdventureMode(false);
            Forge.setCursor(FSkin.getCursor().get(0), "0");
            altZoneTabs = FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ALT_PLAYERZONETABS);
            Gdx.input.setInputProcessor(Forge.getInputProcessor());
            Forge.clearTransitionScreen();
            Forge.openHomeDefault();
            exited = false;
        }, Forge.takeScreenshot(), false, false));
    }

    public static void switchToAdventure() {
        Forge.setTransitionScreen(new TransitionScreen(() -> {
            ImageCache.disposeTextures();
            Forge.clearCurrentScreen();
            Forge.clearTransitionScreen();
            Forge.openAdventure();
            exited = false;
        }, null, false, true));
    }

    public static void setTransitionScreen(TransitionScreen screen) {
        transitionScreen = screen;
    }

    public static void clearTransitionScreen() {
        Forge.clearTransitionScreen(false);
    }

    public static void clearTransitionScreen(boolean disableMatchTransition) {
        if (transitionScreen != null) {
            if (disableMatchTransition) {
                transitionScreen.disableMatchTransition();
                transitionScreen = null;
            }
            if (!disableMatchTransition && transitionScreen.isMatchTransition()) {
                return;
            }
            transitionScreen = null;
        }
    }

    public static void clearSplashScreen() {
        splashScreen = null;
    }

    public static TextureRegion takeScreenshot() {
        FThreads.invokeInEdtNowOrLater(() -> {
            if (lastScreenTexture != null) {
                lastScreenTexture.getTexture().dispose();
            }
            Texture texture = new Texture(Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), Pixmap.Format.RGB888);
            Gdx.gl.glEnable(3553);
            Gdx.gl.glActiveTexture(33984);
            texture.bind();
            Gdx.gl.glCopyTexImage2D(3553, 0, 6407, 0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight(), 0);
            Gdx.gl.glDisable(3553);
            lastScreenTexture = new TextureRegion(texture, 0, Gdx.graphics.getHeight(), Gdx.graphics.getWidth(), -Gdx.graphics.getHeight());
        });
        return lastScreenTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setCurrentScreen(FScreen screen0) {
        String toNewScreen = screen0 != null ? screen0.toString() : "";
        String previousScreen = currentScreen != null ? currentScreen.toString() : "";
        gameInProgress = toNewScreen.toLowerCase().contains("match") || previousScreen.toLowerCase().contains("match");
        boolean dispose = toNewScreen.toLowerCase().contains("homescreen") && disposeTextures;
        try {
            Forge.endKeyInput();
            ForgeAnimation.endAll();
            currentScreen = screen0;
            currentScreen.setSize(screenWidth, screenHeight);
            currentScreen.onActivate();
        }
        catch (Exception ex) {
            graphics.end();
            if (BugReporter.isSentryEnabled()) {
                BugReporter.reportException(ex);
            }
        }
        finally {
            if (dispose) {
                ImageCache.disposeTextures();
            }
        }
    }

    @Override
    public void render() {
        if (showFPS) {
            frameRate.update(ImageCache.counter, Forge.getAssets().manager().getMemoryInMegabytes());
        }
        try {
            ImageCache.allowSingleLoad();
            ForgeAnimation.advanceAll();
            Gdx.gl.glClear(16384);
            FContainer screen = currentScreen;
            if (closingScreen != null) {
                screen = closingScreen;
            } else if (transitionScreen != null) {
                screen = transitionScreen;
            } else if (screen == null && (screen = splashScreen) == null) {
                if (isMobileAdventureMode) {
                    try {
                        float delta = Gdx.graphics.getDeltaTime();
                        float transitionTime = 0.12f;
                        if (sceneWasSwapped) {
                            sceneWasSwapped = false;
                            animationTimeout = transitionTime;
                            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                            Gdx.gl.glClear(16384);
                            return;
                        }
                        if (animationTimeout >= 0.0f) {
                            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                            Gdx.gl.glClear(16384);
                            animationBatch.begin();
                            animationBatch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                            animationBatch.draw(lastScreenTexture, 0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
                            animationBatch.setColor(1.0f, 1.0f, 1.0f, 1.0f - 1.0f / transitionTime * (animationTimeout -= delta));
                            animationBatch.draw(Forge.getAssets().fallback_skins().get("transition"), 0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
                            animationBatch.draw(Forge.getAssets().fallback_skins().get("transition"), 0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
                            animationBatch.end();
                            if (animationTimeout < 0.0f) {
                                currentScene.render();
                                Forge.storeScreen();
                                Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                                Gdx.gl.glClear(16384);
                            } else {
                                return;
                            }
                        }
                        if (animationTimeout >= -transitionTime) {
                            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                            Gdx.gl.glClear(16384);
                            animationBatch.begin();
                            animationBatch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                            animationBatch.draw(lastScreenTexture, 0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
                            animationBatch.setColor(1.0f, 1.0f, 1.0f, 1.0f / transitionTime * ((animationTimeout -= delta) + transitionTime));
                            animationBatch.draw(Forge.getAssets().fallback_skins().get("transition"), 0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
                            animationBatch.draw(Forge.getAssets().fallback_skins().get("transition"), 0.0f, 0.0f, (float)Gdx.graphics.getWidth(), (float)Gdx.graphics.getHeight());
                            animationBatch.end();
                            return;
                        }
                        currentScene.render();
                        currentScene.act(delta);
                    }
                    catch (IllegalStateException | NullPointerException runtimeException) {
                        // empty catch block
                    }
                }
                if (showFPS) {
                    frameRate.render();
                }
                return;
            }
            graphics.begin(screenWidth, screenHeight);
            screen.screenPos.setSize(screenWidth, screenHeight);
            if (screen.getRotate180()) {
                graphics.startRotateTransform((float)screenWidth / 2.0f, (float)screenHeight / 2.0f, 180.0f);
            }
            screen.draw(graphics);
            if (screen.getRotate180()) {
                graphics.endTransform();
            }
            for (FOverlay overlay : FOverlay.getOverlays()) {
                if (!overlay.isVisibleOnScreen(currentScreen)) continue;
                overlay.screenPos.setSize(screenWidth, screenHeight);
                overlay.setSize(screenWidth, screenHeight);
                if (overlay.getRotate180()) {
                    graphics.startRotateTransform((float)screenWidth / 2.0f, (float)screenHeight / 2.0f, 180.0f);
                }
                overlay.draw(graphics);
                if (!overlay.getRotate180()) continue;
                graphics.endTransform();
            }
            if (this.needsUpdate && Forge.getAssets().manager().update()) {
                this.needsUpdate = false;
            }
            graphics.end();
        }
        catch (Exception ex) {
            graphics.end();
            if (BugReporter.isSentryEnabled()) {
                BugReporter.reportException(ex);
            }
            ex.printStackTrace();
        }
        if (showFPS) {
            frameRate.render();
        }
    }

    public static void delayedSwitchBack() {
        FThreads.invokeInBackgroundThread(() -> FThreads.invokeInEdtLater(() -> {
            Forge.clearTransitionScreen();
            Forge.clearCurrentScreen();
            Forge.switchToLast();
        }));
    }

    @Override
    public void resize(int width, int height) {
        block6: {
            try {
                if (currentScreen != null) {
                    currentScreen.setSize(width, height);
                } else if (splashScreen != null) {
                    splashScreen.setSize(width, height);
                }
                if (currentScene != null) {
                    currentScene.resize(width, height);
                }
            }
            catch (Exception ex) {
                if (!BugReporter.isSentryEnabled()) break block6;
                BugReporter.reportException(ex);
            }
        }
    }

    @Override
    public void pause() {
        if (MatchController.getHostedMatch() != null) {
            MatchController.getHostedMatch().pause();
        }
    }

    @Override
    public void resume() {
        try {
            Texture.setAssetManager(Forge.getAssets().manager());
            this.needsUpdate = true;
        }
        catch (Exception e) {
            this.needsUpdate = false;
            e.printStackTrace();
        }
        if (MatchController.getHostedMatch() != null) {
            MatchController.getHostedMatch().resume();
        }
    }

    @Override
    public void dispose() {
        if (currentScreen != null) {
            currentScreen.onClose(null);
            currentScreen = null;
        }
        FOverlay.hideAll();
        Dscreens.clear();
        graphics.dispose();
        SoundSystem.instance.dispose();
        MapStage.getInstance().disposeWorld();
        try {
            ExceptionHandler.unregisterErrorHandling();
            lastPreview.dispose();
            this.assets.dispose();
            AdventureScreen.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Assets getAssets() {
        return ((Forge)Gdx.app.getApplicationListener()).assets;
    }

    public static boolean switchScene(Scene newScene) {
        return Forge.switchScene(newScene, false);
    }

    public static boolean switchScene(Scene newScene, boolean skipPreview) {
        if ((newScene instanceof RewardScene || newScene instanceof SpellSmithScene || newScene instanceof DeckSelectScene || newScene instanceof PlayerStatisticScene || newScene instanceof QuestLogScene) && !(currentScene instanceof ForgeScene) && !skipPreview) {
            WorldSave.getCurrentSave().header.createPreview();
        }
        if (currentScene != null) {
            int i;
            if (!currentScene.leave()) {
                return false;
            }
            if (lastScene.contains(currentScene, false) && (i = lastScene.indexOf(currentScene, false)) > -1) {
                lastScene.setSize(i);
            }
            lastScene.add(currentScene);
        }
        Forge.storeScreen();
        sceneWasSwapped = true;
        currentScene = newScene;
        currentScene.enter();
        if (currentScene instanceof DuelScene) {
            Forge.clearTransitionScreen(true);
        }
        return true;
    }

    protected static void storeScreen() {
        if (!(currentScene instanceof ForgeScene)) {
            Forge.takeScreenshot();
        }
    }

    public static Scene switchToLast() {
        if (Forge.lastScene.size != 0) {
            Forge.storeScreen();
            currentScene = lastScene.get(Forge.lastScene.size - 1);
            currentScene.enter();
            sceneWasSwapped = true;
            lastScene.removeIndex(Forge.lastScene.size - 1);
            return currentScene;
        }
        return null;
    }

    public static void log(Object message) {
        System.out.println(message);
    }

    public static void startKeyInput(KeyInputAdapter adapter, boolean numeric) {
        if (keyInputAdapter == adapter) {
            return;
        }
        if (keyInputAdapter != null) {
            keyInputAdapter.onInputEnd();
        }
        keyInputAdapter = adapter;
        Gdx.input.setOnscreenKeyboardVisible(true, numeric ? Input.OnscreenKeyboardType.NumberPad : Input.OnscreenKeyboardType.Default);
    }

    public static boolean endKeyInput() {
        if (keyInputAdapter == null) {
            return false;
        }
        keyInputAdapter.onInputEnd();
        keyInputAdapter = null;
        MainInputProcessor.keyTyped = false;
        MainInputProcessor.lastKeyTyped = '\u0000';
        Gdx.input.setOnscreenKeyboardVisible(false);
        return true;
    }

    public static void exitAnimation(boolean restart) {
        if (transitionScreen != null) {
            return;
        }
        if (closingScreen == null) {
            closingScreen = new ClosingScreen(restart);
        }
    }

    public static void enableControllerListener() {
        if (controllerListener == null) {
            controllerListener = new ControllerAdapter(){

                @Override
                public void connected(Controller controller) {
                    Gdx.app.log("Controller", "Controller connected: " + controller.getName() + "/" + controller.getUniqueId());
                    hasGamepad = true;
                    if (controller.canVibrate()) {
                        controller.startVibration(200, 1.0f);
                    }
                }

                @Override
                public void disconnected(Controller controller) {
                    Gdx.app.log("Controller", "Controller disconnected: " + controller.getName() + "/" + controller.getUniqueId());
                    hasGamepad = false;
                }

                @Override
                public boolean buttonDown(Controller controller, int buttonIndex) {
                    hasGamepad = true;
                    this.translateButtons(controller, buttonIndex, true);
                    return super.buttonDown(controller, buttonIndex);
                }

                @Override
                public boolean buttonUp(Controller controller, int buttonIndex) {
                    hasGamepad = true;
                    this.translateButtons(controller, buttonIndex, false);
                    return super.buttonUp(controller, buttonIndex);
                }

                @Override
                public boolean axisMoved(Controller controller, int axisIndex, float value) {
                    hasGamepad = true;
                    this.translateAxis(controller, axisIndex, value);
                    return super.axisMoved(controller, axisIndex, value);
                }

                private void translateAxis(Controller controller, int axisIndex, float value) {
                    if (!Forge.hasGamepad()) {
                        return;
                    }
                    FContainer container = FOverlay.getTopOverlay();
                    if (container == null) {
                        container = currentScreen;
                    }
                    if (container != null && currentScreen instanceof MatchScreen) {
                        if (4 == axisIndex && value == 1.0f) {
                            container.keyDown(66);
                        }
                        if (5 == axisIndex && value == 1.0f) {
                            container.keyDown(111);
                        }
                        if (controller.getMapping().axisLeftY == axisIndex && value == 1.0f) {
                            container.keyDown(93);
                        }
                    }
                }

                private void translateButtons(Controller controller, int buttonIndex, boolean keyDown) {
                    if (!Forge.hasGamepad()) {
                        return;
                    }
                    if (!keyDown) {
                        return;
                    }
                    FContainer container = FOverlay.getTopOverlay();
                    if (container == null) {
                        container = currentScreen;
                    }
                    if (container != null) {
                        if (currentScreen instanceof MatchScreen) {
                            if (controller.getMapping().buttonL2 == buttonIndex) {
                                container.keyDown(66);
                            }
                            if (controller.getMapping().buttonR2 == buttonIndex) {
                                container.keyDown(111);
                            }
                            if (controller.getMapping().buttonX == buttonIndex) {
                                container.keyDown(99);
                            }
                            if (controller.getMapping().buttonY == buttonIndex) {
                                container.keyDown(100);
                            }
                            if (controller.getMapping().buttonR1 == buttonIndex) {
                                container.keyDown(103);
                            }
                            if (controller.getMapping().buttonL1 == buttonIndex) {
                                container.keyDown(102);
                            }
                            if (controller.getMapping().buttonDpadDown == buttonIndex) {
                                container.keyDown(20);
                            }
                            if (controller.getMapping().buttonDpadLeft == buttonIndex) {
                                container.keyDown(21);
                            }
                            if (controller.getMapping().buttonDpadRight == buttonIndex) {
                                container.keyDown(22);
                            }
                            if (controller.getMapping().buttonDpadUp == buttonIndex) {
                                container.keyDown(19);
                            }
                            if (controller.getMapping().buttonA == buttonIndex) {
                                container.keyDown(96);
                            }
                            if (controller.getMapping().buttonB == buttonIndex) {
                                container.keyDown(97);
                            }
                            if (controller.getMapping().buttonBack == buttonIndex) {
                                container.keyDown(109);
                            }
                        } else {
                            if (controller.getMapping().buttonDpadDown == buttonIndex) {
                                container.keyDown(20);
                            }
                            if (controller.getMapping().buttonDpadLeft == buttonIndex) {
                                container.keyDown(21);
                            }
                            if (controller.getMapping().buttonDpadRight == buttonIndex) {
                                container.keyDown(22);
                            }
                            if (controller.getMapping().buttonDpadUp == buttonIndex) {
                                container.keyDown(19);
                            }
                            if (controller.getMapping().buttonBack == buttonIndex) {
                                container.keyDown(109);
                            }
                            if (controller.getMapping().buttonB == buttonIndex) {
                                container.keyDown(97);
                            }
                            if (controller.getMapping().buttonA == buttonIndex) {
                                container.keyDown(96);
                            }
                            if (controller.getMapping().buttonX == buttonIndex) {
                                container.keyDown(99);
                            }
                            if (controller.getMapping().buttonY == buttonIndex) {
                                container.keyDown(100);
                            }
                            if (controller.getMapping().buttonR1 == buttonIndex) {
                                container.keyDown(103);
                            }
                            if (controller.getMapping().buttonL1 == buttonIndex) {
                                container.keyDown(102);
                            }
                        }
                    }
                }
            };
        }
        Controllers.addListener(controllerListener);
        if (Controllers.getCurrent() != null) {
            System.out.println("Gamepad: " + Controllers.getCurrent().getName());
        }
    }

    static {
        sceneWasSwapped = false;
        advFreezePlayerControls = false;
        hasGamepad = false;
        lastPreview = null;
        advStartup = false;
        safeToClose = true;
        magnify = false;
        magnifyToggle = true;
        magnifyShowDetails = false;
        cursorName = "";
        continuousRenderingCount = 1;
        Dscreens = new ArrayDeque<FScreen>();
        textureFiltering = false;
        destroyThis = false;
        extrawide = "default";
        heigtModifier = 0.0f;
        isloadingaMatch = false;
        autoAIDeckSelection = false;
        showFPS = false;
        allowCardBG = false;
        altPlayerLayout = false;
        altZoneTabs = false;
        animatedCardTapUntap = false;
        enableUIMask = "Crop";
        selector = "Default";
        enablePreloadExtendedArt = false;
        isTabletDevice = false;
        locale = "en-US";
        hdbuttons = false;
        hdstart = false;
        isPortraitMode = false;
        gameInProgress = false;
        disposeTextures = false;
        isMobileAdventureMode = false;
        cacheSize = 300;
        totalDeviceRAM = 0;
        androidVersion = 0;
        autoCache = false;
        lastButtonIndex = 0;
        CJK_Font = "";
        hoveredCount = 0;
        afterDBloaded = false;
        mouseButtonID = 0;
        forcedEnglishonCJKMissing = false;
        createNewAdventureMap = false;
        mouseMovedX = 0.0f;
        mouseMovedY = 0.0f;
    }

    private static class MainInputProcessor
    extends FGestureAdapter {
        private static final List<FDisplayObject> potentialListeners = new ArrayList<FDisplayObject>();
        private static char lastKeyTyped;
        private static boolean keyTyped;
        private static boolean shiftKeyDown;

        private MainInputProcessor() {
        }

        @Override
        public boolean keyDown(int keyCode) {
            if (keyCode == 82) {
                Forge.showMenu();
                return true;
            }
            if (keyCode == 59 || keyCode == 60) {
                shiftKeyDown = true;
            }
            if (keyCode == 21) {
                this.touchDown(0, 0, 0, 0);
                return this.fling(1000.0f, 0.0f);
            }
            if (keyCode == 22) {
                this.touchDown(0, 0, 0, 0);
                return this.fling(-1000.0f, 0.0f);
            }
            if (keyCode == 19) {
                this.touchDown(0, 0, 0, 0);
                return this.fling(0.0f, -1000.0f);
            }
            if (keyCode == 20) {
                this.touchDown(0, 0, 0, 0);
                return this.fling(0.0f, 1000.0f);
            }
            if (keyCode == 4) {
                if (destroyThis && !isMobileAdventureMode || splashScreen != null && splashScreen.isShowModeSelector()) {
                    Forge.exitAnimation(false);
                } else if (Forge.onHomeScreen() && Forge.isLandscapeMode()) {
                    Forge.back();
                }
            }
            if (keyInputAdapter == null) {
                if (KeyInputAdapter.isModifierKey(keyCode)) {
                    return false;
                }
                FContainer container = FOverlay.getTopOverlay();
                if (container == null && (container = currentScreen) == null) {
                    return false;
                }
                return ((FContainer)container).keyDown(keyCode);
            }
            return keyInputAdapter.keyDown(keyCode);
        }

        @Override
        public boolean keyUp(int keyCode) {
            keyTyped = false;
            if (keyCode == 59 || keyCode == 60) {
                shiftKeyDown = false;
            }
            if (keyInputAdapter != null) {
                return keyInputAdapter.keyUp(keyCode);
            }
            return false;
        }

        @Override
        public boolean keyTyped(char ch) {
            if (!(keyInputAdapter == null || ch < ' ' || ch > '~' || lastKeyTyped == ch && keyTyped)) {
                keyTyped = true;
                lastKeyTyped = ch;
                return keyInputAdapter.keyTyped(ch);
            }
            return false;
        }

        private void updatePotentialListeners(float x, float y) {
            potentialListeners.clear();
            for (FOverlay overlay : FOverlay.getOverlaysTopDown()) {
                if (!overlay.isVisibleOnScreen(currentScreen)) continue;
                overlay.buildTouchListeners(x, y, potentialListeners);
                if (!overlay.preventInputBehindOverlay()) continue;
                return;
            }
            if (currentScreen != null) {
                currentScreen.buildTouchListeners(x, y, potentialListeners);
            }
            if (splashScreen != null) {
                splashScreen.buildTouchListeners(x, y, potentialListeners);
            }
        }

        @Override
        public boolean touchDown(int x, int y, int pointer, int button) {
            if (transitionScreen != null) {
                boolean isFDialog;
                boolean bl = isFDialog = FOverlay.getTopOverlay() != null && FOverlay.getTopOverlay() instanceof FDialog;
                if (!isFDialog) {
                    return false;
                }
            }
            if (pointer == 0) {
                this.updatePotentialListeners(x, y);
                if (!(keyInputAdapter == null || keyInputAdapter.allowTouchInput() && potentialListeners.contains(keyInputAdapter.getOwner()))) {
                    Forge.endKeyInput();
                }
            }
            mouseButtonID = button;
            return super.touchDown(x, y, pointer, button);
        }

        @Override
        public boolean press(float x, float y) {
            try {
                for (FDisplayObject listener : potentialListeners) {
                    if (!listener.press(listener.screenToLocalX(x), listener.screenToLocalY(y))) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                BugReporter.reportException(ex);
                return true;
            }
        }

        @Override
        public boolean release(float x, float y) {
            try {
                for (FDisplayObject listener : potentialListeners) {
                    if (!listener.release(listener.screenToLocalX(x), listener.screenToLocalY(y))) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                BugReporter.reportException(ex);
                return true;
            }
        }

        @Override
        public boolean longPress(float x, float y) {
            try {
                for (FDisplayObject listener : potentialListeners) {
                    if (!listener.longPress(listener.screenToLocalX(x), listener.screenToLocalY(y))) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                BugReporter.reportException(ex);
                return true;
            }
        }

        @Override
        public boolean tap(float x, float y, int count) {
            if (shiftKeyDown && this.flick(x, y)) {
                return true;
            }
            try {
                for (FDisplayObject listener : potentialListeners) {
                    if (!listener.tap(listener.screenToLocalX(x), listener.screenToLocalY(y), count)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                BugReporter.reportException(ex);
                return true;
            }
        }

        @Override
        public boolean flick(float x, float y) {
            try {
                for (FDisplayObject listener : potentialListeners) {
                    if (!listener.flick(listener.screenToLocalX(x), listener.screenToLocalY(y))) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                BugReporter.reportException(ex);
                return true;
            }
        }

        @Override
        public boolean fling(float velocityX, float velocityY) {
            try {
                for (FDisplayObject listener : potentialListeners) {
                    if (!listener.fling(velocityX, velocityY)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                BugReporter.reportException(ex);
                return true;
            }
        }

        @Override
        public boolean pan(float x, float y, float deltaX, float deltaY, boolean moreVertical) {
            try {
                for (FDisplayObject listener : potentialListeners) {
                    if (!listener.pan(listener.screenToLocalX(x), listener.screenToLocalY(y), deltaX, deltaY, moreVertical)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                BugReporter.reportException(ex);
                return true;
            }
        }

        @Override
        public boolean panStop(float x, float y) {
            try {
                for (FDisplayObject listener : potentialListeners) {
                    if (!listener.panStop(listener.screenToLocalX(x), listener.screenToLocalY(y))) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                BugReporter.reportException(ex);
                return true;
            }
        }

        @Override
        public boolean zoom(float x, float y, float amount) {
            try {
                for (FDisplayObject listener : potentialListeners) {
                    if (!listener.zoom(listener.screenToLocalX(x), listener.screenToLocalY(y), amount)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                BugReporter.reportException(ex);
                return true;
            }
        }

        @Override
        public boolean mouseMoved(int screenX, int screenY) {
            magnify = true;
            mouseMovedX = screenX;
            mouseMovedY = screenY;
            hasGamepad = false;
            if (GuiBase.isAndroid()) {
                return true;
            }
            hoveredCount = 0;
            try {
                for (FDisplayObject listener : potentialListeners) {
                    listener.setHovered(false);
                }
            }
            catch (Exception ex) {
                BugReporter.reportException(ex);
            }
            this.updatePotentialListeners(screenX, screenY);
            return true;
        }

        @Override
        public boolean scrolled(float amountX, float amountY) {
            this.updatePotentialListeners(mouseMovedX, mouseMovedY);
            if (KeyInputAdapter.isCtrlKeyDown()) {
                return this.zoom(mouseMovedX, mouseMovedY, -Utils.AVG_FINGER_WIDTH * amountY);
            }
            boolean handled = KeyInputAdapter.isShiftKeyDown() ? this.pan(mouseMovedX, mouseMovedY, -Utils.AVG_FINGER_WIDTH * amountX, 0.0f, false) : this.pan(mouseMovedX, mouseMovedY, 0.0f, -Utils.AVG_FINGER_HEIGHT * amountY, true);
            if (this.panStop(mouseMovedX, mouseMovedY)) {
                handled = true;
            }
            return handled;
        }
    }

    public static abstract class KeyInputAdapter {
        public abstract FDisplayObject getOwner();

        public abstract boolean allowTouchInput();

        public abstract boolean keyTyped(char var1);

        public abstract boolean keyDown(int var1);

        public abstract void onInputEnd();

        public boolean keyUp(int keyCode) {
            return false;
        }

        public static boolean isCtrlKeyDown() {
            return Gdx.input.isKeyPressed(129) || Gdx.input.isKeyPressed(130);
        }

        public static boolean isShiftKeyDown() {
            return Gdx.input.isKeyPressed(59) || Gdx.input.isKeyPressed(60);
        }

        public static boolean isAltKeyDown() {
            return Gdx.input.isKeyPressed(57) || Gdx.input.isKeyPressed(58);
        }

        public static boolean isModifierKey(int keyCode) {
            switch (keyCode) {
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 129: 
                case 130: {
                    return true;
                }
            }
            return false;
        }
    }
}

