/*
 * Decompiled with CFR 0.152.
 */
package forge;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class FTrace {
    private static long appStartTime;
    private static Map<String, FTrace> traces;
    private final String name;
    private long startTime;
    private long totalTime;

    public static void initialize() {
        appStartTime = new Date().getTime();
    }

    public static FTrace get(String name0) {
        FTrace trace = traces.computeIfAbsent(name0, FTrace::new);
        return trace;
    }

    public static String formatTimestamp(Date timestamp) {
        return new SimpleDateFormat("hh:mm:ss.SSS").format(timestamp);
    }

    public static void dump() {
        if (traces.isEmpty()) {
            return;
        }
        long appTotalTime = new Date().getTime() - appStartTime;
        NumberFormat percent = NumberFormat.getPercentInstance();
        System.out.println();
        System.out.println("Forge total time - " + appTotalTime + "ms");
        for (FTrace trace : traces.values()) {
            System.out.println(trace.name + " total time - " + trace.totalTime + "ms (" + percent.format((double)trace.totalTime / (double)appTotalTime) + ")");
        }
        traces.clear();
    }

    private FTrace(String name0) {
        this.name = name0;
    }

    public void start() {
        if (this.startTime > 0L) {
            return;
        }
        Date now = new Date();
        this.startTime = now.getTime();
        System.out.println(this.name + " start - " + FTrace.formatTimestamp(now));
    }

    public void end() {
        if (this.startTime == 0L) {
            return;
        }
        Date now = new Date();
        long elapsed = now.getTime() - this.startTime;
        this.startTime = 0L;
        this.totalTime += elapsed;
        System.out.println(this.name + " end - " + FTrace.formatTimestamp(now) + " (" + elapsed + "ms)");
    }

    static {
        traces = new HashMap<String, FTrace>();
    }
}

