/*
 * Decompiled with CFR 0.152.
 */
package forge;

import com.badlogic.gdx.graphics.Texture;
import forge.assets.ImageCache;
import forge.game.card.CardView;
import forge.gui.GuiBase;
import forge.item.InventoryItem;
import forge.screens.match.MatchController;
import forge.util.ImageFetcher;

public abstract class CachedCardImage
implements ImageFetcher.Callback {
    protected final String key;
    static final ImageFetcher fetcher = GuiBase.getInterface().getImageFetcher();

    public CachedCardImage(CardView card) {
        this.key = card.getCurrentState().getImageKey(MatchController.instance.getLocalPlayers());
        this.fetch();
    }

    public CachedCardImage(InventoryItem ii) {
        this.key = ii.getImageKey(false);
        this.fetch();
    }

    public CachedCardImage(String key) {
        this.key = key;
        this.fetch();
    }

    public void fetch() {
        if (!ImageCache.imageKeyFileExists(this.key)) {
            fetcher.fetchImage(this.key, this);
        }
    }

    public Texture getImage() {
        return ImageCache.getImage(this.key, true);
    }

    public Texture getImage(String mykey) {
        return ImageCache.getImage(mykey, true);
    }

    @Override
    public abstract void onImageFetched();
}

