/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntArray;
import com.github.tommyettinger.textra.utils.Palette;

public class ColorUtils {
    private static final IntArray mixing = new IntArray(4);

    public static int hsl2rgb(float h2, float s2, float l, float a) {
        float x = Math.min(Math.max(Math.abs(h2 * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        float y = h2 + 0.6666667f;
        float z = h2 + 0.33333334f;
        y -= (float)((int)y);
        z -= (float)((int)z);
        y = Math.min(Math.max(Math.abs(y * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        z = Math.min(Math.max(Math.abs(z * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        float v = l + s2 * Math.min(l, 1.0f - l);
        float d = 2.0f * (1.0f - l / (v + 1.0E-10f));
        return Color.rgba8888(v * MathUtils.lerp(1.0f, x, d), v * MathUtils.lerp(1.0f, y, d), v * MathUtils.lerp(1.0f, z, d), a);
    }

    public static int rgb2hsl(float r, float g2, float b, float a) {
        float w;
        float z;
        float y;
        float x;
        if (g2 < b) {
            x = b;
            y = g2;
            z = -1.0f;
            w = 0.6666667f;
        } else {
            x = g2;
            y = b;
            z = 0.0f;
            w = -0.33333334f;
        }
        if (r < x) {
            z = w;
            w = r;
        } else {
            w = x;
            x = r;
        }
        float d = x - Math.min(w, y);
        float l = x * (1.0f - 0.5f * d / (x + 1.0E-10f));
        return Color.rgba8888(Math.abs(z + (w - y) / (6.0f * d + 1.0E-10f)), (x - l) / (Math.min(l, 1.0f - l) + 1.0E-10f), l, a);
    }

    public static int hsb2rgb(float h2, float s2, float b, float a) {
        float x = Math.min(Math.max(Math.abs(h2 * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        float y = h2 + 0.6666667f;
        float z = h2 + 0.33333334f;
        y -= (float)((int)y);
        z -= (float)((int)z);
        y = Math.min(Math.max(Math.abs(y * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        z = Math.min(Math.max(Math.abs(z * 6.0f - 3.0f) - 1.0f, 0.0f), 1.0f);
        return Color.rgba8888(b * MathUtils.lerp(1.0f, x, s2), b * MathUtils.lerp(1.0f, y, s2), b * MathUtils.lerp(1.0f, z, s2), a);
    }

    public static int rgb2hsb(float r, float g2, float b, float a) {
        float n;
        float v = Math.max(Math.max(r, g2), b);
        float c = v - (n = Math.min(Math.min(r, g2), b));
        float h2 = c == 0.0f ? 0.0f : (v == r ? (g2 - b) / c / 6.0f : (v == g2 ? ((b - r) / c + 2.0f) / 6.0f : ((r - g2) / c + 4.0f) / 6.0f));
        return Color.rgba8888(h2, v == 0.0f ? 0.0f : c / v, v, a);
    }

    public static float channel(int color, int channel) {
        return (float)(color >>> 24 - ((channel & 3) << 3) & 0xFF) / 255.0f;
    }

    public static int channelInt(int color, int channel) {
        return color >>> 24 - ((channel & 3) << 3) & 0xFF;
    }

    public static int lerpColors(int s2, int e, float change) {
        int sA = s2 & 0xFE;
        int sB = s2 >>> 8 & 0xFF;
        int sG = s2 >>> 16 & 0xFF;
        int sR = s2 >>> 24 & 0xFF;
        int eA = e & 0xFE;
        int eB = e >>> 8 & 0xFF;
        int eG = e >>> 16 & 0xFF;
        int eR = e >>> 24 & 0xFF;
        return ((int)((float)sR + change * (float)(eR - sR)) & 0xFF) << 24 | ((int)((float)sG + change * (float)(eG - sG)) & 0xFF) << 16 | ((int)((float)sB + change * (float)(eB - sB)) & 0xFF) << 8 | (int)((float)sA + change * (float)(eA - sA)) & 0xFE;
    }

    public static int mix(int[] colors, int offset, int size) {
        int end = offset + size;
        if (colors == null || colors.length < end || offset < 0 || size <= 0) {
            return 256;
        }
        int result = 256;
        while (colors[offset] == 256) {
            ++offset;
        }
        if (offset < end) {
            result = colors[offset];
        }
        int i = offset + 1;
        int o = end;
        int denom = 2;
        while (i < o) {
            if (colors[i] != 256) {
                result = ColorUtils.lerpColors(result, colors[i], 1.0f / (float)denom);
            } else {
                --denom;
            }
            ++i;
            ++denom;
        }
        return result;
    }

    public static int lighten(int start, float change) {
        int r = start >>> 24;
        int g2 = start >>> 16 & 0xFF;
        int b = start >>> 8 & 0xFF;
        int a = start & 0xFE;
        return ((int)((float)r + (float)(255 - r) * change) & 0xFF) << 24 | ((int)((float)g2 + (float)(255 - g2) * change) & 0xFF) << 16 | ((int)((float)b + (float)(255 - b) * change) & 0xFF) << 8 | a;
    }

    public static int darken(int start, float change) {
        int r = start >>> 24;
        int g2 = start >>> 16 & 0xFF;
        int b = start >>> 8 & 0xFF;
        int a = start & 0xFE;
        float ch = 1.0f - change;
        return ((int)((float)r * ch) & 0xFF) << 24 | ((int)((float)g2 * ch) & 0xFF) << 16 | ((int)((float)b * ch) & 0xFF) << 8 | a;
    }

    public static int dullen(int start, float change) {
        float rc = 0.32627f;
        float gc = 0.3678f;
        float bc = 0.30593002f;
        int r = start >>> 24;
        int g2 = start >>> 16 & 0xFF;
        int b = start >>> 8 & 0xFF;
        int a = start & 0xFE;
        float ch = 1.0f - change;
        float rw = change * 0.32627f;
        float gw = change * 0.3678f;
        float bw = change * 0.30593002f;
        return (int)Math.min(Math.max((float)r * (rw + ch) + (float)g2 * rw + (float)b * rw, 0.0f), 255.0f) << 24 | (int)Math.min(Math.max((float)r * gw + (float)g2 * (gw + ch) + (float)b * gw, 0.0f), 255.0f) << 16 | (int)Math.min(Math.max((float)r * bw + (float)g2 * bw + (float)b * (bw + ch), 0.0f), 255.0f) << 8 | a;
    }

    public static int enrich(int start, float change) {
        float rc = -0.32627f;
        float gc = -0.3678f;
        float bc = -0.30593002f;
        int r = start >>> 24;
        int g2 = start >>> 16 & 0xFF;
        int b = start >>> 8 & 0xFF;
        int a = start & 0xFE;
        float ch = 1.0f + change;
        float rw = change * -0.32627f;
        float gw = change * -0.3678f;
        float bw = change * -0.30593002f;
        return (int)Math.min(Math.max((float)r * (rw + ch) + (float)g2 * rw + (float)b * rw, 0.0f), 255.0f) << 24 | (int)Math.min(Math.max((float)r * gw + (float)g2 * (gw + ch) + (float)b * gw, 0.0f), 255.0f) << 16 | (int)Math.min(Math.max((float)r * bw + (float)g2 * bw + (float)b * (bw + ch), 0.0f), 255.0f) << 8 | a;
    }

    public static int offset(int color, float power) {
        return ColorUtils.lerpColors(color, color ^ 0x80808000, power);
    }

    public static int offsetLightness(int color, float power) {
        int light = (color >>> 24) * 3 + (color >>> 14 & 0x3FC) + (color >>> 8 & 0xFF);
        if (light < 808) {
            return ColorUtils.lighten(color, power);
        }
        return ColorUtils.darken(color, power);
    }

    public static int multiplyAlpha(int color, float multiplier) {
        return color & 0xFFFFFF00 | Math.min(Math.max((int)((float)(color & 0xFF) * multiplier), 0), 255);
    }

    public static int[][] multiplyAllAlpha(int[][] colors, float multiplier) {
        for (int x = 0; x < colors.length; ++x) {
            for (int y = 0; y < colors[x].length; ++y) {
                colors[x][y] = ColorUtils.multiplyAlpha(colors[x][y], multiplier);
            }
        }
        return colors;
    }

    public static int describe(String description) {
        float lightness = 0.0f;
        float saturation = 0.0f;
        String[] terms = description.split("[^a-zA-Z_]+");
        mixing.clear();
        block56: for (String term : terms) {
            if (term == null || term.isEmpty()) continue;
            int len = term.length();
            switch (term.charAt(0)) {
                case 'L': 
                case 'l': {
                    if (len > 2 && (term.charAt(2) == 'g' || term.charAt(2) == 'G')) {
                        switch (len) {
                            case 9: {
                                lightness += 0.2f;
                            }
                            case 8: {
                                lightness += 0.2f;
                            }
                            case 7: {
                                lightness += 0.2f;
                            }
                            case 5: {
                                lightness += 0.2f;
                            }
                        }
                        continue block56;
                    }
                    mixing.add(Palette.NAMED.get(term, 256));
                    continue block56;
                }
                case 'B': 
                case 'b': {
                    if (len > 3 && (term.charAt(3) == 'g' || term.charAt(3) == 'G')) {
                        switch (len) {
                            case 10: {
                                lightness += 0.2f;
                                saturation += 0.2f;
                            }
                            case 9: {
                                lightness += 0.2f;
                                saturation += 0.2f;
                            }
                            case 8: {
                                lightness += 0.2f;
                                saturation += 0.2f;
                            }
                            case 6: {
                                lightness += 0.2f;
                                saturation += 0.2f;
                            }
                        }
                        continue block56;
                    }
                    mixing.add(Palette.NAMED.get(term, 256));
                    continue block56;
                }
                case 'P': 
                case 'p': {
                    if (len > 2 && (term.charAt(2) == 'l' || term.charAt(2) == 'L')) {
                        switch (len) {
                            case 7: 
                            case 8: {
                                lightness += 0.2f;
                                saturation -= 0.2f;
                            }
                            case 6: {
                                lightness += 0.2f;
                                saturation -= 0.2f;
                            }
                            case 5: {
                                lightness += 0.2f;
                                saturation -= 0.2f;
                            }
                            case 4: {
                                lightness += 0.2f;
                                saturation -= 0.2f;
                            }
                        }
                        continue block56;
                    }
                    mixing.add(Palette.NAMED.get(term, 256));
                    continue block56;
                }
                case 'W': 
                case 'w': {
                    if (len > 3 && (term.charAt(3) == 'k' || term.charAt(3) == 'K')) {
                        switch (len) {
                            case 8: {
                                lightness -= 0.2f;
                                saturation -= 0.2f;
                            }
                            case 7: {
                                lightness -= 0.2f;
                                saturation -= 0.2f;
                            }
                            case 6: {
                                lightness -= 0.2f;
                                saturation -= 0.2f;
                            }
                            case 4: {
                                lightness -= 0.2f;
                                saturation -= 0.2f;
                            }
                        }
                        continue block56;
                    }
                    mixing.add(Palette.NAMED.get(term, 256));
                    continue block56;
                }
                case 'R': 
                case 'r': {
                    if (len > 1 && (term.charAt(1) == 'i' || term.charAt(1) == 'I')) {
                        switch (len) {
                            case 8: {
                                saturation += 0.2f;
                            }
                            case 7: {
                                saturation += 0.2f;
                            }
                            case 6: {
                                saturation += 0.2f;
                            }
                            case 4: {
                                saturation += 0.2f;
                            }
                        }
                        continue block56;
                    }
                    mixing.add(Palette.NAMED.get(term, 256));
                    continue block56;
                }
                case 'D': 
                case 'd': {
                    if (len > 1 && (term.charAt(1) == 'a' || term.charAt(1) == 'A')) {
                        switch (len) {
                            case 8: {
                                lightness -= 0.2f;
                            }
                            case 7: {
                                lightness -= 0.2f;
                            }
                            case 6: {
                                lightness -= 0.2f;
                            }
                            case 4: {
                                lightness -= 0.2f;
                            }
                        }
                        continue block56;
                    }
                    if (len > 1 && (term.charAt(1) == 'u' || term.charAt(1) == 'U')) {
                        switch (len) {
                            case 8: {
                                saturation -= 0.2f;
                            }
                            case 7: {
                                saturation -= 0.2f;
                            }
                            case 6: {
                                saturation -= 0.2f;
                            }
                            case 4: {
                                saturation -= 0.2f;
                            }
                        }
                        continue block56;
                    }
                    if (len > 3 && (term.charAt(3) == 'p' || term.charAt(3) == 'P')) {
                        switch (len) {
                            case 8: {
                                lightness -= 0.2f;
                                saturation += 0.2f;
                            }
                            case 7: {
                                lightness -= 0.2f;
                                saturation += 0.2f;
                            }
                            case 6: {
                                lightness -= 0.2f;
                                saturation += 0.2f;
                            }
                            case 4: {
                                lightness -= 0.2f;
                                saturation += 0.2f;
                            }
                        }
                        continue block56;
                    }
                    mixing.add(Palette.NAMED.get(term, 256));
                    continue block56;
                }
                default: {
                    mixing.add(Palette.NAMED.get(term, 256));
                }
            }
        }
        int result = ColorUtils.mix(ColorUtils.mixing.items, 0, ColorUtils.mixing.size);
        if (result == 256) {
            return result;
        }
        if (lightness > 0.0f) {
            result = ColorUtils.lighten(result, lightness);
        } else if (lightness < 0.0f) {
            result = ColorUtils.darken(result, -lightness);
        }
        if (saturation > 0.0f) {
            result = ColorUtils.enrich(result, saturation);
        } else if (saturation < 0.0f) {
            result = ColorUtils.dullen(result, -saturation);
        }
        return result;
    }
}

