/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntFloatMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TypingLabel;

public class SquashEffect
extends Effect {
    private static final float DEFAULT_INTENSITY = 0.125f;
    private float intensity = 4.0f;
    private boolean elastic = false;
    private final IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    public SquashEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.intensity = 1.0f / this.paramAsFloat(params[0], 0.25f);
        }
        if (params.length > 1) {
            this.elastic = this.paramAsBoolean(params[1]);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float realIntensity = this.intensity * (this.elastic ? 3.0f : 1.0f) * 0.125f;
        float timePassed = this.timePassedByGlyphIndex.getAndIncrement(localIndex, 0.0f, delta);
        float progress = MathUtils.clamp(timePassed / realIntensity, 0.0f, 1.0f);
        Font font = this.label.getFont();
        if (progress < 0.4f) {
            float interpolatedValue = 1.0f - Interpolation.sine.apply(progress * 2.5f) * 0.5f;
            this.label.offsets.incr(globalIndex << 1, font.mapping.get((int)((char)((int)glyph)), (Font.GlyphRegion)font.defaultValue).xAdvance * (0.125f - 0.125f * interpolatedValue));
            this.label.sizing.incr(globalIndex << 1, 1.0f - interpolatedValue);
            this.label.sizing.incr(globalIndex << 1 | 1, interpolatedValue - 1.0f);
        } else {
            Interpolation interpolation = this.elastic ? Interpolation.swingOut : Interpolation.sine;
            float interpolatedValue = interpolation.apply((progress - 0.4f) * 1.666f) * 0.5f + 0.5f;
            this.label.offsets.incr(globalIndex << 1, font.mapping.get((int)((char)((int)glyph)), (Font.GlyphRegion)font.defaultValue).xAdvance * (0.125f - 0.125f * interpolatedValue));
            this.label.sizing.incr(globalIndex << 1, 1.0f - interpolatedValue);
            this.label.sizing.incr(globalIndex << 1 | 1, interpolatedValue - 1.0f);
        }
    }
}

