/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntFloatMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class SpinEffect
extends Effect {
    private static final float DEFAULT_INTENSITY = 1.0f;
    private float intensity = 1.0f;
    private float rotations = 1.0f;
    private boolean elastic = false;
    private final IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    public SpinEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.intensity = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.rotations = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.elastic = this.paramAsBoolean(params[2]);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float realIntensity = this.intensity * (this.elastic ? 3.0f : 1.0f) * 1.0f;
        float timePassed = this.timePassedByGlyphIndex.getAndIncrement(localIndex, 0.0f, delta);
        float progress = MathUtils.clamp(timePassed / realIntensity, 0.0f, 1.0f);
        Interpolation interpolation = this.elastic ? Interpolation.bounceOut : Interpolation.pow3Out;
        float interpolatedValue = interpolation.apply(progress) * 360.0f * this.rotations;
        this.label.rotations.incr(globalIndex, interpolatedValue);
    }
}

