/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntFloatMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TypingLabel;

public class CarouselEffect
extends Effect {
    private static final float DEFAULT_FREQUENCY = 0.5f;
    private float frequency = 1.0f;
    private final IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    public CarouselEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.frequency = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.duration = this.paramAsFloat(params[1], Float.POSITIVE_INFINITY);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float timePassed = this.timePassedByGlyphIndex.getAndIncrement(localIndex, 0.0f, delta) - delta;
        if (timePassed >= this.duration) {
            timePassed = 0.0f;
        }
        float progress = timePassed * 360.0f * this.frequency * 0.5f;
        float s2 = MathUtils.sinDeg(progress);
        Font font = this.label.getFont();
        this.label.sizing.incr(globalIndex << 1, s2 - 1.0f);
        this.label.offsets.incr(globalIndex << 1, font.mapping.get((int)((char)((int)glyph)), (Font.GlyphRegion)font.defaultValue).xAdvance * (0.125f * s2));
    }
}

