/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.CharArray;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntFloatMap;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.LongArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.OrderedMap;
import com.github.tommyettinger.textra.ColorLookup;
import com.github.tommyettinger.textra.Layout;
import com.github.tommyettinger.textra.Line;
import com.github.tommyettinger.textra.TypingConfig;
import com.github.tommyettinger.textra.utils.BlockUtils;
import com.github.tommyettinger.textra.utils.CaseInsensitiveIntMap;
import java.util.Arrays;
import regexodus.Category;

public class Font
implements Disposable {
    public IntMap<GlyphRegion> mapping;
    public CaseInsensitiveIntMap nameLookup;
    public IntMap<String> namesByCharCode;
    public GlyphRegion defaultValue;
    public Array<TextureRegion> parents;
    public DistanceFieldType distanceField;
    public boolean isMono;
    public IntFloatMap kerning;
    public float actualCrispness = 1.0f;
    public float distanceFieldCrispness = 1.0f;
    public float cellWidth = 1.0f;
    public float cellHeight = 1.0f;
    public float originalCellWidth = 1.0f;
    public float originalCellHeight = 1.0f;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float descent = 0.0f;
    public char solidBlock = (char)9608;
    public FontFamily family;
    public ColorLookup colorLookup = ColorLookup.DESCRIPTIVE;
    public boolean integerPosition = false;
    public String name = "Unnamed Font";
    public Texture whiteBlock = null;
    public static final long BOLD = 0x40000000L;
    public static final long OBLIQUE = 0x20000000L;
    public static final long UNDERLINE = 0x10000000L;
    public static final long STRIKETHROUGH = 0x8000000L;
    public static final long SUBSCRIPT = 0x2000000L;
    public static final long MIDSCRIPT = 0x4000000L;
    public static final long SUPERSCRIPT = 0x6000000L;
    public static final long ALTERNATE = 0x1000000L;
    public static final long ALTERNATE_MODES_MASK = 0x1E00000L;
    public static final long SMALL_CAPS = 0x1100000L;
    public static final long JOSTLE = 0x1000000L;
    public static final long BLACK_OUTLINE = 0x1200000L;
    public static final long WHITE_OUTLINE = 0x1400000L;
    public static final long DROP_SHADOW = 0x1600000L;
    public static final long SHINY = 0x1800000L;
    public static final long ERROR = 0x1A00000L;
    public static final long WARN = 0x1C00000L;
    public static final long NOTE = 0x1E00000L;
    public float PACKED_BLACK = NumberUtils.intBitsToFloat(-33554432);
    public float PACKED_WHITE = Color.WHITE_FLOAT_BITS;
    public float PACKED_ERROR_COLOR = -4.253659E37f;
    public float PACKED_WARN_COLOR = -4.812999E37f;
    public float PACKED_NOTE_COLOR = -1.2264254E38f;
    private final float[] vertices = new float[20];
    private final Layout tempLayout = new Layout();
    private final LongArray glyphBuffer = new LongArray(128);
    private final CharArray breakChars = CharArray.with('\t', '\r', ' ', '-', '\u00ad', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u200b', '\u2010', '\u2012', '\u2013', '\u2014', '\u2027');
    private final CharArray spaceChars = CharArray.with('\t', '\r', ' ', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u200b');
    public static final String vertexShader = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n\tv_color = a_color;\n\tv_color.a = v_color.a * (255.0/254.0);\n\tv_texCoords = a_texCoord0;\n\tgl_Position =  u_projTrans * a_position;\n}\n";
    public static final String sdfFragmentShader = "#ifdef GL_ES\n\tprecision mediump float;\n\tprecision mediump int;\n#endif\n\nuniform sampler2D u_texture;\nuniform float u_smoothing;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n\tif (u_smoothing > 0.0) {\n\t\tfloat smoothing = 0.25 / u_smoothing;\n\t\tvec4 color = texture2D(u_texture, v_texCoords);\n\t\tfloat alpha = smoothstep(0.5 - smoothing, 0.5 + smoothing, color.a);\n\t\tgl_FragColor = vec4(v_color.rgb * color.rgb, alpha * v_color.a);\n\t} else {\n\t\tgl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n\t}\n}\n";
    public static final String msdfFragmentShader = "#ifdef GL_ES\nprecision mediump float;\n#endif\n#if __VERSION__ >= 130\n#define TEXTURE texture\n#else\n#define TEXTURE texture2D\n#endif\nuniform sampler2D u_texture;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\nuniform float u_smoothing;\nuniform float u_weight;\nfloat median(float r, float g, float b) {\n    return max(min(r, g), min(max(r, g), b));\n}\nfloat linearstep(float a, float b, float x) {\n    return clamp((x - a) / (b - a), 0.0, 1.0);\n}\nvoid main() {\n    vec4 msdf = TEXTURE(u_texture, v_texCoords);\n    float distance = u_smoothing * (median(msdf.r, msdf.g, msdf.b) + u_weight - 0.5);\n    float glyphAlpha = clamp(distance + 0.5, 0.0, 1.0);\n    gl_FragColor = vec4(v_color.rgb, glyphAlpha * v_color.a);\n}";
    public ShaderProgram shader = null;
    private static final int[] hexCodes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    public static long longFromHex(CharSequence cs, int start, int end) {
        int h2;
        int len;
        int lim = 16;
        if (cs == null || start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0L;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            len = -1;
            h2 = 0;
            lim = 17;
        } else if (c == '+') {
            len = 1;
            h2 = 0;
            lim = 17;
        } else {
            if (c > 'f' || (h2 = hexCodes[c]) < 0) {
                return 0L;
            }
            len = 1;
        }
        long data = h2;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            c = cs.charAt(i);
            if (c > 'f' || (h2 = hexCodes[c]) < 0) {
                return data * (long)len;
            }
            data <<= 4;
            data |= (long)h2;
        }
        return data * (long)len;
    }

    public static int intFromHex(CharSequence cs, int start, int end) {
        int h2;
        int len;
        int lim = 8;
        if (cs == null || start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            len = -1;
            h2 = 0;
            lim = 9;
        } else if (c == '+') {
            len = 1;
            h2 = 0;
            lim = 9;
        } else {
            if (c > 'f' || (h2 = hexCodes[c]) < 0) {
                return 0;
            }
            len = 1;
        }
        int data = h2;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            c = cs.charAt(i);
            if (c > 'f' || (h2 = hexCodes[c]) < 0) {
                return data * len;
            }
            data <<= 4;
            data |= h2;
        }
        return data * len;
    }

    public static int intFromDec(CharSequence cs, int start, int end) {
        int h2;
        int len;
        int lim = 10;
        if (cs == null || start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            len = -1;
            lim = 11;
            h2 = 0;
        } else if (c == '+') {
            len = 1;
            lim = 11;
            h2 = 0;
        } else {
            if (c > 'f' || (h2 = hexCodes[c]) < 0 || h2 > 9) {
                return 0;
            }
            len = 1;
        }
        int data = h2;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            c = cs.charAt(i);
            if (c > 'f' || (h2 = hexCodes[c]) < 0 || h2 > 9) {
                return data * len;
            }
            data = data * 10 + h2;
        }
        return data * len;
    }

    public static float floatFromDec(CharSequence cs, int start, int end) {
        int h2;
        int len;
        float decimal = 1.0f;
        boolean foundPoint = false;
        if (cs == null || start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0.0f;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            len = -1;
            h2 = 0;
        } else if (c == '+') {
            len = 1;
            h2 = 0;
        } else {
            if (c > 'f' || (h2 = hexCodes[c]) < 0 || h2 > 9) {
                return 0.0f;
            }
            len = 1;
        }
        int data = h2;
        for (int i = start + 1; i < end; ++i) {
            c = cs.charAt(i);
            if (c == '.') {
                foundPoint = true;
                continue;
            }
            if (c > 'f' || (h2 = hexCodes[c]) < 0 || h2 > 9) {
                return (float)(data * len) / decimal;
            }
            if (foundPoint) {
                decimal *= 10.0f;
            }
            data = data * 10 + h2;
        }
        return (float)(data * len) / decimal;
    }

    private static int indexAfter(String text, String search, int from) {
        return (from = text.indexOf(search, from)) < 0 ? text.length() : from + search.length();
    }

    public static String safeSubstring(String source, int beginIndex, int endIndex) {
        if (source == null || source.isEmpty()) {
            return "";
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex < 0 || endIndex > source.length()) {
            endIndex = source.length();
        }
        if (beginIndex >= endIndex) {
            return "";
        }
        return source.substring(beginIndex, endIndex);
    }

    public static boolean isLowerCase(char c) {
        return Category.Ll.contains(c);
    }

    public static boolean isUpperCase(char c) {
        return Category.Lu.contains(c);
    }

    public ColorLookup getColorLookup() {
        return this.colorLookup;
    }

    public Font setColorLookup(ColorLookup lookup) {
        if (lookup != null) {
            this.colorLookup = lookup;
        }
        return this;
    }

    public Font() {
        this(new BitmapFont(), 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName) {
        this(fntName, DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName, DistanceFieldType distanceField) {
        this(fntName, distanceField, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName, String textureName) {
        this(fntName, textureName, DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName, String textureName, DistanceFieldType distanceField) {
        this(fntName, textureName, distanceField, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public Font(Font toCopy) {
        this.distanceField = toCopy.distanceField;
        this.isMono = toCopy.isMono;
        this.actualCrispness = toCopy.actualCrispness;
        this.distanceFieldCrispness = toCopy.distanceFieldCrispness;
        this.parents = new Array<TextureRegion>(toCopy.parents);
        this.cellWidth = toCopy.cellWidth;
        this.cellHeight = toCopy.cellHeight;
        this.scaleX = toCopy.scaleX;
        this.scaleY = toCopy.scaleY;
        this.originalCellWidth = toCopy.originalCellWidth;
        this.originalCellHeight = toCopy.originalCellHeight;
        this.descent = toCopy.descent;
        this.mapping = new IntMap(toCopy.mapping.size);
        for (IntMap.Entry<GlyphRegion> entry : toCopy.mapping) {
            if (entry.value == null) continue;
            this.mapping.put(entry.key, new GlyphRegion((GlyphRegion)entry.value));
        }
        if (toCopy.nameLookup != null) {
            this.nameLookup = new CaseInsensitiveIntMap(toCopy.nameLookup);
        }
        if (toCopy.namesByCharCode != null) {
            this.namesByCharCode = new IntMap<String>(toCopy.namesByCharCode);
        }
        this.defaultValue = toCopy.defaultValue;
        this.kerning = toCopy.kerning == null ? null : new IntFloatMap(toCopy.kerning);
        this.solidBlock = toCopy.solidBlock;
        this.name = toCopy.name;
        this.integerPosition = toCopy.integerPosition;
        if (toCopy.family != null) {
            int n;
            void var3_5;
            this.family = new FontFamily(toCopy.family);
            Font[] connected = this.family.connected;
            boolean bl = false;
            while (var3_5 < connected.length) {
                Font f = connected[var3_5];
                if (f == toCopy) {
                    connected[var3_5] = this;
                    break;
                }
                ++var3_5;
            }
            if (toCopy.name != null && (n = this.family.fontAliases.remove(toCopy.name, -1)) != -1 && this.name != null) {
                this.family.fontAliases.put(this.name, n);
            }
        }
        this.PACKED_BLACK = toCopy.PACKED_BLACK;
        this.PACKED_WHITE = toCopy.PACKED_WHITE;
        this.PACKED_ERROR_COLOR = toCopy.PACKED_ERROR_COLOR;
        this.PACKED_WARN_COLOR = toCopy.PACKED_WARN_COLOR;
        this.PACKED_NOTE_COLOR = toCopy.PACKED_NOTE_COLOR;
        if (toCopy.shader != null) {
            this.shader = toCopy.shader;
        }
        if (toCopy.colorLookup != null) {
            this.colorLookup = toCopy.colorLookup;
        }
        this.whiteBlock = toCopy.whiteBlock;
    }

    public Font(String fntName, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(String fntName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = new ShaderProgram(vertexShader, sdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        this.loadFNT(fntName, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(String fntName, String textureName, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureName, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, String textureName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureName, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(String fntName, String textureName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        FileHandle textureHandle;
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = new ShaderProgram(vertexShader, sdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        if ((textureHandle = Gdx.files.internal(textureName)).exists() || (textureHandle = Gdx.files.local(textureName)).exists()) {
            this.parents = Array.with(new TextureRegion(new Texture(textureHandle)));
            if (distanceField == DistanceFieldType.SDF || distanceField == DistanceFieldType.MSDF) {
                this.parents.first().getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        } else {
            throw new RuntimeException("Missing texture file: " + textureName);
        }
        this.loadFNT(fntName, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(String fntName, TextureRegion textureRegion, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegion, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, TextureRegion textureRegion, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegion, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(String fntName, TextureRegion textureRegion, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = new ShaderProgram(vertexShader, sdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        this.parents = Array.with(textureRegion);
        if (distanceField == DistanceFieldType.SDF || distanceField == DistanceFieldType.MSDF) {
            textureRegion.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
        this.loadFNT(fntName, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(String fntName, Array<TextureRegion> textureRegions, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegions, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, Array<TextureRegion> textureRegions, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegions, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(String fntName, Array<TextureRegion> textureRegions, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = new ShaderProgram(vertexShader, sdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        this.parents = textureRegions;
        if ((distanceField == DistanceFieldType.SDF || distanceField == DistanceFieldType.MSDF) && textureRegions != null) {
            for (TextureRegion parent : textureRegions) {
                parent.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        }
        this.loadFNT(fntName, xAdjust, yAdjust, widthAdjust, heightAdjust, makeGridGlyphs);
    }

    public Font(BitmapFont bmFont) {
        this(bmFont, DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, false);
    }

    public Font(BitmapFont bmFont, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(bmFont, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(BitmapFont bmFont, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(bmFont, distanceField, xAdjust, yAdjust, widthAdjust, heightAdjust, false);
    }

    public Font(BitmapFont bmFont, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = new ShaderProgram(vertexShader, sdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textratypist", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        this.parents = bmFont.getRegions();
        if ((distanceField == DistanceFieldType.SDF || distanceField == DistanceFieldType.MSDF) && this.parents != null) {
            for (TextureRegion parent : this.parents) {
                parent.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        }
        BitmapFont.BitmapFontData data = bmFont.getData();
        this.mapping = new IntMap(128);
        int minWidth = Integer.MAX_VALUE;
        this.descent = bmFont.getDescent();
        yAdjust += this.descent + bmFont.getLineHeight() * 0.5f;
        for (BitmapFont.Glyph[] page : data.glyphs) {
            if (page == null) continue;
            for (BitmapFont.Glyph glyph : page) {
                byte k;
                int i;
                byte[] kern;
                int b;
                if (glyph == null) continue;
                int x = glyph.srcX;
                int y = glyph.srcY;
                int w = glyph.width;
                int h2 = glyph.height;
                int a = glyph.xadvance;
                minWidth = Math.min(minWidth, a);
                this.cellWidth = Math.max((float)a, this.cellWidth);
                this.cellHeight = Math.max((float)h2 + heightAdjust, this.cellHeight);
                GlyphRegion gr = new GlyphRegion(bmFont.getRegion(glyph.page), (float)x, (float)y, (float)w, (float)h2);
                if (glyph.id == 10) {
                    a = 0;
                    gr.offsetX = 0.0f;
                } else {
                    gr.offsetX = makeGridGlyphs && BlockUtils.isBlockGlyph(glyph.id) ? Float.NaN : (float)glyph.xoffset + xAdjust;
                }
                gr.offsetY = (float)(-h2 - glyph.yoffset) + yAdjust;
                gr.xAdvance = (float)a + widthAdjust;
                this.mapping.put(glyph.id & 0xFFFF, gr);
                if (glyph.kerning != null) {
                    if (this.kerning == null) {
                        this.kerning = new IntFloatMap(128);
                    }
                    for (b = 0; b < glyph.kerning.length; ++b) {
                        kern = glyph.kerning[b];
                        if (kern == null) continue;
                        for (i = 0; i < 512; ++i) {
                            k = kern[i];
                            if (k != 0) {
                                this.kerning.put(glyph.id << 16 | (b << 9 | i), k);
                            }
                            if ((b << 9 | i) != 91) continue;
                            this.kerning.put(glyph.id << 16 | 2, k);
                        }
                    }
                }
                if ((glyph.id & 0xFFFF) != 91) continue;
                this.mapping.put(2, gr);
                if (glyph.kerning == null) continue;
                for (b = 0; b < glyph.kerning.length; ++b) {
                    kern = glyph.kerning[b];
                    if (kern == null) continue;
                    for (i = 0; i < 512; ++i) {
                        k = kern[i];
                        if (k == 0) continue;
                        this.kerning.put(0x20000 | (b << 9 | i), k);
                    }
                }
            }
        }
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = this.mapping.get(10);
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
        }
        if (this.mapping.containsKey(32)) {
            this.mapping.put(13, this.mapping.get(32));
        }
        this.solidBlock = (char)(this.mapping.containsKey(9608) ? 9608 : 65535);
        if (makeGridGlyphs) {
            GlyphRegion block = this.mapping.get(this.solidBlock, null);
            if (block == null) {
                Pixmap temp = new Pixmap(3, 3, Pixmap.Format.RGBA8888);
                temp.setColor(Color.WHITE);
                temp.fill();
                this.whiteBlock = new Texture(3, 3, Pixmap.Format.RGBA8888);
                this.whiteBlock.draw(temp, 0, 0);
                this.solidBlock = (char)9608;
                block = new GlyphRegion(new TextureRegion(this.whiteBlock, 1, 1, 1, 1));
                this.mapping.put(this.solidBlock, block);
                temp.dispose();
            }
            for (int i = 9472; i < 9472 + BlockUtils.BOX_DRAWING.length; ++i) {
                GlyphRegion gr = new GlyphRegion(block);
                gr.offsetX = Float.NaN;
                gr.xAdvance = this.cellWidth;
                gr.offsetY = this.cellHeight;
                this.mapping.put(i, gr);
            }
        } else if (!this.mapping.containsKey(this.solidBlock)) {
            Pixmap temp = new Pixmap(3, 3, Pixmap.Format.RGBA8888);
            temp.setColor(Color.WHITE);
            temp.fill();
            this.whiteBlock = new Texture(3, 3, Pixmap.Format.RGBA8888);
            this.whiteBlock.draw(temp, 0, 0);
            this.solidBlock = (char)9608;
            this.mapping.put(this.solidBlock, new GlyphRegion(new TextureRegion(this.whiteBlock, 1, 1, 1, 1)));
            temp.dispose();
        }
        this.defaultValue = this.mapping.get(data.missingGlyph == null ? 32 : data.missingGlyph.id, this.mapping.get(32, this.mapping.values().next()));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight;
        this.isMono = (float)minWidth == this.cellWidth && this.kerning == null;
        this.integerPosition = bmFont.usesIntegerPositions();
        this.scale(bmFont.getScaleX(), bmFont.getScaleY());
    }

    public Font(String prefix, String fntName, boolean ignoredSadConsoleFlag) {
        this.distanceField = DistanceFieldType.STANDARD;
        this.loadSad(prefix == null ? "" : prefix, fntName);
    }

    protected void loadFNT(String fntName, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust, boolean makeGridGlyphs) {
        int idx;
        FileHandle fntHandle = Gdx.files.internal(fntName);
        if (!fntHandle.exists() && !(fntHandle = Gdx.files.local(fntName)).exists()) {
            throw new RuntimeException("Missing font file: " + fntName);
        }
        String fnt = fntHandle.readString("UTF8");
        int n = idx = Font.indexAfter(fnt, "lineHeight=", 0);
        idx = Font.indexAfter(fnt, "base=", idx);
        float rawLineHeight = Font.floatFromDec(fnt, n, idx);
        int n2 = idx;
        idx = Font.indexAfter(fnt, "pages=", idx);
        float baseline = Font.floatFromDec(fnt, n2, idx);
        this.descent = baseline - rawLineHeight;
        if (this.distanceField == DistanceFieldType.STANDARD) {
            yAdjust += this.descent;
        }
        int n3 = idx;
        idx = Font.indexAfter(fnt, "\npage id=", idx);
        int pages = Font.intFromDec(fnt, n3, idx);
        if (this.parents == null || this.parents.size < pages) {
            if (this.parents == null) {
                this.parents = new Array(true, pages, TextureRegion.class);
            } else {
                this.parents.clear();
            }
            for (int i = 0; i < pages; ++i) {
                idx = Font.indexAfter(fnt, "file=\"", idx);
                String textureName = fnt.substring(idx, idx = fnt.indexOf(34, idx));
                FileHandle textureHandle = Gdx.files.internal(textureName);
                if (textureHandle.exists() || (textureHandle = Gdx.files.local(textureName)).exists()) {
                    this.parents.add(new TextureRegion(new Texture(textureHandle)));
                    if (this.distanceField != DistanceFieldType.SDF && this.distanceField != DistanceFieldType.MSDF) continue;
                    this.parents.peek().getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                    continue;
                }
                throw new RuntimeException("Missing texture file: " + textureName);
            }
        }
        int n4 = Font.indexAfter(fnt, "\nchars count=", idx);
        idx = n4;
        idx = Font.indexAfter(fnt, "\nchar id=", idx);
        int size = Font.intFromDec(fnt, n4, idx);
        this.mapping = new IntMap(size);
        float minWidth = 2.1474836E9f;
        for (int i = 0; i < size && idx != fnt.length(); ++i) {
            int n5 = idx;
            idx = Font.indexAfter(fnt, " x=", idx);
            int c = Font.intFromDec(fnt, n5, idx);
            int n6 = idx;
            idx = Font.indexAfter(fnt, " y=", idx);
            float x = Font.floatFromDec(fnt, n6, idx);
            int n7 = idx;
            idx = Font.indexAfter(fnt, " width=", idx);
            float y = Font.floatFromDec(fnt, n7, idx);
            int n8 = idx;
            idx = Font.indexAfter(fnt, " height=", idx);
            float w = Font.floatFromDec(fnt, n8, idx);
            int n9 = idx;
            idx = Font.indexAfter(fnt, " xoffset=", idx);
            float h2 = Font.floatFromDec(fnt, n9, idx);
            int n10 = idx;
            idx = Font.indexAfter(fnt, " yoffset=", idx);
            float xo = Font.floatFromDec(fnt, n10, idx);
            int n11 = idx;
            idx = Font.indexAfter(fnt, " xadvance=", idx);
            float yo = Font.floatFromDec(fnt, n11, idx);
            int n12 = idx;
            idx = Font.indexAfter(fnt, " page=", idx);
            float a = Font.floatFromDec(fnt, n12, idx);
            int n13 = idx;
            idx = Font.indexAfter(fnt, "\nchar id=", idx);
            int p = Font.intFromDec(fnt, n13, idx);
            if (c != 9608) {
                minWidth = Math.min(minWidth, a);
            }
            GlyphRegion gr = new GlyphRegion(this.parents.get(p), x, y, w, h2);
            if (c == 10) {
                a = 0.0f;
                gr.offsetX = 0.0f;
            } else {
                gr.offsetX = makeGridGlyphs && BlockUtils.isBlockGlyph(c) ? Float.NaN : xo + xAdjust;
            }
            gr.offsetY = yo + yAdjust;
            gr.xAdvance = a + widthAdjust;
            this.cellWidth = Math.max(a, this.cellWidth);
            this.cellHeight = Math.max(h2 + heightAdjust, this.cellHeight);
            this.mapping.put(c, gr);
            if (c != 91) continue;
            this.mapping.put(2, gr);
        }
        idx = Font.indexAfter(fnt, "\nkernings count=", 0);
        if (idx < fnt.length()) {
            int n14 = idx;
            idx = Font.indexAfter(fnt, "\nkerning first=", idx);
            int kernings = Font.intFromDec(fnt, n14, idx);
            this.kerning = new IntFloatMap(kernings);
            for (int i = 0; i < kernings; ++i) {
                int n15 = idx;
                idx = Font.indexAfter(fnt, " second=", idx);
                int first = Font.intFromDec(fnt, n15, idx);
                int n16 = idx;
                idx = Font.indexAfter(fnt, " amount=", idx);
                int second = Font.intFromDec(fnt, n16, idx);
                int n17 = idx;
                idx = Font.indexAfter(fnt, "\nkerning first=", idx);
                float amount = Font.floatFromDec(fnt, n17, idx);
                this.kerning.put(first << 16 | second, amount);
                if (first == 91) {
                    this.kerning.put(0x20000 | second, amount);
                }
                if (second != 91) continue;
                this.kerning.put(first << 16 | 2, amount);
            }
        }
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = this.mapping.get(10);
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
            gr.xAdvance = 0.0f;
        }
        if (this.mapping.containsKey(32)) {
            this.mapping.put(13, this.mapping.get(32));
        }
        this.solidBlock = (char)(this.mapping.containsKey(9608) ? 9608 : 65535);
        if (makeGridGlyphs) {
            GlyphRegion block = this.mapping.get(this.solidBlock, null);
            if (block == null) {
                Pixmap temp = new Pixmap(3, 3, Pixmap.Format.RGBA8888);
                temp.setColor(Color.WHITE);
                temp.fill();
                this.whiteBlock = new Texture(3, 3, Pixmap.Format.RGBA8888);
                this.whiteBlock.draw(temp, 0, 0);
                this.solidBlock = (char)9608;
                block = new GlyphRegion(new TextureRegion(this.whiteBlock, 1, 1, 1, 1));
                this.mapping.put(this.solidBlock, block);
                temp.dispose();
            }
            for (int i = 9472; i < 9472 + BlockUtils.BOX_DRAWING.length; ++i) {
                GlyphRegion gr = new GlyphRegion(block);
                gr.offsetX = Float.NaN;
                gr.xAdvance = this.cellWidth;
                gr.offsetY = this.cellHeight;
                this.mapping.put(i, gr);
            }
        } else if (!this.mapping.containsKey(this.solidBlock)) {
            Pixmap temp = new Pixmap(3, 3, Pixmap.Format.RGBA8888);
            temp.setColor(Color.WHITE);
            temp.fill();
            this.whiteBlock = new Texture(3, 3, Pixmap.Format.RGBA8888);
            this.whiteBlock.draw(temp, 0, 0);
            this.solidBlock = (char)9608;
            this.mapping.put(this.solidBlock, new GlyphRegion(new TextureRegion(this.whiteBlock, 1, 1, 1, 1)));
            temp.dispose();
        }
        this.defaultValue = this.mapping.get(32, this.mapping.get(0));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight;
        this.isMono = minWidth == this.cellWidth && this.kerning == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadSad(String prefix, String fntName) {
        TextureRegion parent;
        JsonReader reader = new JsonReader();
        FileHandle fntHandle = Gdx.files.internal(prefix + fntName);
        if (!fntHandle.exists() && !(fntHandle = Gdx.files.local(prefix + fntName)).exists()) {
            throw new RuntimeException("Missing font file: " + prefix + fntName);
        }
        JsonValue fnt = reader.parse(fntHandle);
        int pages = 1;
        if (this.parents == null || this.parents.size == 0) {
            if (this.parents == null) {
                this.parents = new Array(true, pages, TextureRegion.class);
            }
            String textureName = fnt.getString("FilePath");
            FileHandle textureHandle = Gdx.files.internal(prefix + textureName);
            if (!textureHandle.exists() && !(textureHandle = Gdx.files.local(prefix + textureName)).exists()) throw new RuntimeException("Missing texture file: " + prefix + textureName);
            parent = new TextureRegion(new Texture(textureHandle));
            this.parents.add(parent);
        } else {
            parent = this.parents.first();
        }
        int columns = fnt.getInt("Columns");
        int padding = fnt.getInt("GlyphPadding");
        this.cellHeight = fnt.getInt("GlyphHeight");
        this.cellWidth = fnt.getInt("GlyphWidth");
        this.descent = Math.round(this.cellHeight * -0.25f);
        int rows = (parent.getRegionHeight() - padding) / ((int)this.cellHeight + padding);
        int size = rows * columns;
        this.mapping = new IntMap(size + 1);
        int c = 0;
        for (int y = 0; y < rows; ++y) {
            int x = 0;
            while (x < columns) {
                GlyphRegion gr = new GlyphRegion(parent, (float)(x * ((int)this.cellWidth + padding) + padding), (float)(y * ((int)this.cellHeight + padding) + padding), (float)((int)this.cellWidth), (float)((int)this.cellHeight));
                gr.offsetX = 0.0f;
                gr.offsetY = this.cellHeight * 0.5f;
                gr.xAdvance = c == 10 ? 0.0f : this.cellWidth;
                this.mapping.put(c, gr);
                if (c == 91) {
                    if (this.mapping.containsKey(2)) {
                        this.mapping.put(size, this.mapping.get(2));
                    }
                    this.mapping.put(2, gr);
                }
                ++x;
                ++c;
            }
        }
        this.solidBlock = (char)fnt.getInt("SolidGlyphIndex");
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = this.mapping.get(10);
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
            gr.xAdvance = 0.0f;
        }
        if (this.mapping.containsKey(32)) {
            this.mapping.put(13, this.mapping.get(32));
        }
        this.defaultValue = this.mapping.get(32, this.mapping.get(0));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight;
        this.isMono = true;
    }

    public int kerningPair(char first, char second) {
        return first << 16 | second & 0xFFFF;
    }

    public Font scale(float horizontal, float vertical) {
        this.scaleX *= horizontal;
        this.scaleY *= vertical;
        this.cellWidth *= horizontal;
        this.cellHeight *= vertical;
        return this;
    }

    public Font scaleTo(float width, float height) {
        this.scaleX = width / this.originalCellWidth;
        this.scaleY = height / this.originalCellHeight;
        this.cellWidth = width;
        this.cellHeight = height;
        return this;
    }

    public Font adjustLineHeight(float multiplier) {
        this.cellHeight *= multiplier;
        this.originalCellHeight *= multiplier;
        return this;
    }

    public Font adjustCellWidth(float multiplier) {
        this.cellWidth *= multiplier;
        this.originalCellWidth *= multiplier;
        return this;
    }

    public Font fitCell(float width, float height, boolean center) {
        this.cellWidth = width;
        this.cellHeight = height;
        float wsx = width / this.scaleX;
        IntMap.Values<GlyphRegion> vs = this.mapping.values();
        if (center) {
            while (vs.hasNext) {
                GlyphRegion g2 = vs.next();
                g2.offsetX += (wsx - g2.xAdvance) * 0.5f;
                g2.xAdvance = wsx;
            }
        } else {
            while (vs.hasNext) {
                vs.next().xAdvance = wsx;
            }
        }
        this.isMono = true;
        this.kerning = null;
        return this;
    }

    public Font setTextureFilter() {
        return this.setTextureFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
    }

    public Font setTextureFilter(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
        for (TextureRegion parent : this.parents) {
            parent.getTexture().setFilter(minFilter, magFilter);
        }
        return this;
    }

    public Font useIntegerPositions(boolean integer) {
        this.integerPosition = integer;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Font setName(String name) {
        this.name = name;
        return this;
    }

    public float getCrispness() {
        return this.distanceFieldCrispness;
    }

    public Font setCrispness(float crispness) {
        this.distanceFieldCrispness = crispness;
        return this;
    }

    public Font multiplyCrispness(float multiplier) {
        this.distanceFieldCrispness *= multiplier;
        return this;
    }

    public Font addImage(String character, TextureRegion region, float offsetX, float offsetY, float xAdvance) {
        if (character != null && !character.isEmpty()) {
            this.mapping.put(character.charAt(character.length() - 1), new GlyphRegion(region, offsetX, offsetY, xAdvance));
        }
        return this;
    }

    public Font addImage(String character, TextureRegion region) {
        if (character != null && !character.isEmpty()) {
            this.mapping.put(character.charAt(character.length() - 1), new GlyphRegion(region));
        }
        return this;
    }

    public Font addAtlas(TextureAtlas atlas) {
        return this.addAtlas(atlas, "", "", 0.0f, 0.0f, 0.0f);
    }

    public Font addAtlas(TextureAtlas atlas, float offsetXChange, float offsetYChange, float xAdvanceChange) {
        return this.addAtlas(atlas, "", "", offsetXChange, offsetYChange, xAdvanceChange);
    }

    public Font addAtlas(TextureAtlas atlas, String prepend, String append, float offsetXChange, float offsetYChange, float xAdvanceChange) {
        Array<TextureAtlas.AtlasRegion> regions = atlas.getRegions();
        if (this.nameLookup == null) {
            this.nameLookup = new CaseInsensitiveIntMap(regions.size, 0.5f);
        } else {
            this.nameLookup.ensureCapacity(regions.size);
        }
        if (this.namesByCharCode == null) {
            this.namesByCharCode = new IntMap(regions.size >> 1, 0.5f);
        } else {
            this.namesByCharCode.ensureCapacity(regions.size >> 1);
        }
        if (prepend == null) {
            prepend = "";
        }
        if (append == null) {
            append = "";
        }
        int start = 57344 + this.namesByCharCode.size;
        TextureAtlas.AtlasRegion previous = regions.first();
        GlyphRegion gr = new GlyphRegion(previous, previous.offsetX + offsetXChange, previous.offsetY + offsetYChange, (float)previous.originalWidth + xAdvanceChange);
        this.mapping.put(start, gr);
        String name = prepend + previous.name + append;
        this.nameLookup.put(name, start);
        this.namesByCharCode.put(start, name);
        int i = start;
        for (int a = 1; i < 63488 && a < regions.size; ++a) {
            TextureAtlas.AtlasRegion region = regions.get(a);
            if (previous.getRegionX() == region.getRegionX() && previous.getRegionY() == region.getRegionY()) {
                name = prepend + region.name + append;
                this.nameLookup.put(name, i);
                char f = previous.name.charAt(0);
                if (f >= '\ud800' && f < '\ue000') continue;
                this.namesByCharCode.put(i, name);
                continue;
            }
            previous = region;
            gr = new GlyphRegion(region, region.offsetX + offsetXChange, region.offsetY + offsetYChange, (float)region.originalWidth + xAdvanceChange);
            this.mapping.put(++i, gr);
            name = prepend + region.name + append;
            this.nameLookup.put(name, i);
            this.namesByCharCode.put(i, name);
        }
        return this;
    }

    public int atlasLookup(String name) {
        if (this.nameLookup == null) {
            return -1;
        }
        return this.nameLookup.get(name, -1);
    }

    public void enableShader(Batch batch) {
        if (this.distanceField == DistanceFieldType.MSDF) {
            if (batch.getShader() != this.shader) {
                batch.setShader(this.shader);
                this.shader.setUniformf("u_weight", 0.0f);
                this.shader.setUniformf("u_smoothing", 2.0f * this.distanceFieldCrispness);
            }
        } else if (this.distanceField == DistanceFieldType.SDF) {
            if (batch.getShader() != this.shader) {
                batch.setShader(this.shader);
                float scale = Math.max(this.cellHeight / this.originalCellHeight, this.cellWidth / this.originalCellWidth) * 0.5f + 0.125f;
                this.shader.setUniformf("u_smoothing", this.actualCrispness / scale);
            }
        } else {
            batch.setShader(null);
        }
    }

    public void drawText(Batch batch, CharSequence text, float x, float y) {
        this.drawText(batch, text, x, y, -2);
    }

    public void drawText(Batch batch, CharSequence text, float x, float y, int color) {
        batch.setPackedColor(NumberUtils.intToFloatColor(Integer.reverseBytes(color)));
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            GlyphRegion current = this.mapping.get(text.charAt(i));
            batch.draw(current, x + current.offsetX * this.scaleX, y + current.offsetY * this.scaleY, (float)current.getRegionWidth() * this.scaleX, (float)current.getRegionHeight() * this.scaleY);
            x += (float)current.getRegionWidth() * this.scaleX;
        }
    }

    public void drawBlocks(Batch batch, int[][] colors, float x, float y) {
        this.drawBlocks(batch, this.solidBlock, colors, x, y);
    }

    public void drawBlocks(Batch batch, char blockChar, int[][] colors, float x, float y) {
        TextureRegion block = this.mapping.get(blockChar);
        if (block == null) {
            return;
        }
        Texture parent = block.getTexture();
        float ipw = 1.0f / (float)parent.getWidth();
        float iph = 1.0f / (float)parent.getHeight();
        float u = block.getU();
        float v = block.getV();
        float u2 = block.getU() + ipw;
        float v2 = block.getV() + iph;
        this.vertices[0] = x += 0.00390625f;
        this.vertices[1] = y += 0.00390625f;
        this.vertices[3] = u;
        this.vertices[4] = v;
        this.vertices[5] = x;
        this.vertices[6] = y + this.cellHeight;
        this.vertices[8] = u;
        this.vertices[9] = v2;
        this.vertices[10] = x + this.cellWidth;
        this.vertices[11] = y + this.cellHeight;
        this.vertices[13] = u2;
        this.vertices[14] = v2;
        this.vertices[15] = x + this.cellWidth;
        this.vertices[16] = y;
        this.vertices[18] = u2;
        this.vertices[19] = v;
        int xn = colors.length;
        int yn = colors[0].length;
        for (int xi = 0; xi < xn; ++xi) {
            for (int yi = 0; yi < yn; ++yi) {
                if ((colors[xi][yi] & 0xFE) != 0) {
                    this.vertices[12] = this.vertices[17] = NumberUtils.intBitsToFloat(Integer.reverseBytes(colors[xi][yi] & 0xFFFFFFFE));
                    this.vertices[7] = this.vertices[17];
                    this.vertices[2] = this.vertices[17];
                    this.drawVertices(batch, parent, this.vertices);
                }
                this.vertices[1] = this.vertices[16] = this.vertices[16] + this.cellHeight;
                this.vertices[6] = this.vertices[11] = this.vertices[11] + this.cellHeight;
            }
            this.vertices[0] = this.vertices[5] = this.vertices[5] + this.cellWidth;
            this.vertices[10] = this.vertices[15] = this.vertices[15] + this.cellWidth;
            this.vertices[1] = this.vertices[16] = y;
            this.vertices[6] = this.vertices[11] = y + this.cellHeight;
        }
    }

    protected void drawBlockSequence(Batch batch, float[] sequence, TextureRegion block, float color, float x, float y) {
        this.drawBlockSequence(batch, sequence, block, color, x, y, this.cellWidth, this.cellHeight);
    }

    protected void drawBlockSequence(Batch batch, float[] sequence, TextureRegion block, float color, float x, float y, float width, float height) {
        Texture parent = block.getTexture();
        float ipw = 1.0f / (float)parent.getWidth();
        float iph = 1.0f / (float)parent.getHeight();
        float u = block.getU();
        float v = block.getV();
        float u2 = u + ipw;
        float v2 = v - iph;
        for (int b = 0; b < sequence.length; b += 4) {
            float startX = x + sequence[b] * width;
            float startY = y + sequence[b + 1] * height;
            float sizeX = sequence[b + 2] * width;
            float sizeY = sequence[b + 3] * height;
            this.vertices[0] = startX;
            this.vertices[1] = startY;
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[5] = startX;
            this.vertices[6] = startY + sizeY;
            this.vertices[7] = color;
            this.vertices[8] = u;
            this.vertices[9] = v2;
            this.vertices[10] = startX + sizeX;
            this.vertices[11] = startY + sizeY;
            this.vertices[12] = color;
            this.vertices[13] = u2;
            this.vertices[14] = v2;
            this.vertices[15] = startX + sizeX;
            this.vertices[16] = startY;
            this.vertices[17] = color;
            this.vertices[18] = u2;
            this.vertices[19] = v;
            this.drawVertices(batch, parent, this.vertices);
        }
    }

    protected void drawBlockSequence(Batch batch, float[] sequence, TextureRegion block, float color, float x, float y, float width, float height, float rotation) {
        Texture parent = block.getTexture();
        float ipw = 1.0f / (float)parent.getWidth();
        float iph = 1.0f / (float)parent.getHeight();
        float u = block.getU();
        float v = block.getV();
        float u2 = u + ipw;
        float v2 = v - iph;
        float sn = MathUtils.sinDeg(rotation);
        float cs = MathUtils.cosDeg(rotation);
        for (int b = 0; b < sequence.length; b += 4) {
            float startX = sequence[b] * width;
            float startY = sequence[b + 1] * height;
            float sizeX = sequence[b + 2] * width;
            float sizeY = sequence[b + 3] * height;
            float p0x = startX;
            float p0y = startY + sizeY;
            float p1x = startX;
            float p1y = startY;
            float p2x = startX + sizeX;
            float p2y = startY;
            this.vertices[0] = x + cs * p0x - sn * p0y;
            this.vertices[5] = x + cs * p1x - sn * p1y;
            this.vertices[10] = x + cs * p2x - sn * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sn * p0x + cs * p0y;
            this.vertices[6] = y + sn * p1x + cs * p1y;
            this.vertices[11] = y + sn * p2x + cs * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[7] = color;
            this.vertices[8] = u;
            this.vertices[9] = v2;
            this.vertices[12] = color;
            this.vertices[13] = u2;
            this.vertices[14] = v2;
            this.vertices[17] = color;
            this.vertices[18] = u2;
            this.vertices[19] = v;
            this.drawVertices(batch, parent, this.vertices);
        }
    }

    protected void drawFancyLine(Batch batch, long mode, float x, float y, float width, float xPx, float yPx, float rotation) {
        TextureRegion block = this.mapping.get(this.solidBlock);
        Texture parent = block.getTexture();
        float ipw = 1.0f / (float)parent.getWidth();
        float iph = 1.0f / (float)parent.getHeight();
        float u = block.getU();
        float v = block.getV();
        float u2 = u + ipw;
        float v2 = v - iph;
        float sn = MathUtils.sinDeg(rotation);
        float cs = MathUtils.cosDeg(rotation);
        float color = mode == 0x1A00000L ? this.PACKED_ERROR_COLOR : (mode == 0x1C00000L ? this.PACKED_WARN_COLOR : this.PACKED_NOTE_COLOR);
        int index = 0;
        float startX = 0.0f;
        float shiftY = 0.0f;
        while (startX <= width) {
            float p2y;
            float p2x;
            float p1y;
            float p1x;
            float p0y;
            float p0x;
            float shiftX = startX;
            if (mode == 0x1A00000L) {
                shiftY = (float)(index & true) * yPx;
                p0x = shiftX;
                p0y = shiftY + yPx;
                p1x = shiftX;
                p1y = shiftY;
                p2x = shiftX + xPx;
                p2y = shiftY;
            } else if (mode == 0x1C00000L) {
                shiftY = (float)(~index & 1) * yPx;
                p0x = shiftX += (float)(~index & 1) * xPx;
                p0y = shiftY + yPx;
                p1x = shiftX;
                p1y = shiftY;
                p2x = shiftX + xPx;
                p2y = shiftY;
            } else {
                shiftY = (float)(index >>> 1 & 1) * yPx;
                p0x = shiftX;
                p0y = shiftY + yPx;
                p1x = shiftX;
                p1y = shiftY;
                p2x = shiftX + xPx;
                p2y = shiftY;
            }
            this.vertices[0] = x + cs * p0x - sn * p0y;
            this.vertices[5] = x + cs * p1x - sn * p1y;
            this.vertices[10] = x + cs * p2x - sn * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sn * p0x + cs * p0y;
            this.vertices[6] = y + sn * p1x + cs * p1y;
            this.vertices[11] = y + sn * p2x + cs * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            this.vertices[2] = color;
            this.vertices[3] = u;
            this.vertices[4] = v;
            this.vertices[7] = color;
            this.vertices[8] = u;
            this.vertices[9] = v2;
            this.vertices[12] = color;
            this.vertices[13] = u2;
            this.vertices[14] = v2;
            this.vertices[17] = color;
            this.vertices[18] = u2;
            this.vertices[19] = v;
            this.drawVertices(batch, parent, this.vertices);
            startX += xPx;
            ++index;
        }
    }

    public int drawMarkupText(Batch batch, String text, float x, float y) {
        Layout layout = this.tempLayout;
        layout.clear();
        this.markup(text, this.tempLayout);
        int lines = layout.lines();
        int drawn = 0;
        for (int ln = 0; ln < lines; ++ln) {
            Line line = layout.getLine(ln);
            int n = line.glyphs.size;
            drawn += n;
            if (this.kerning != null) {
                int kern = -1;
                for (int i = 0; i < n; ++i) {
                    long glyph = line.glyphs.get(i);
                    kern = kern << 16 | (int)(glyph & 0xFFFFL);
                    float amt = this.kerning.get(kern, 0.0f);
                    x += this.drawGlyph(batch, glyph, x + amt, y) + amt;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    x += this.drawGlyph(batch, line.glyphs.get(i), x, y);
                }
            }
            y -= this.cellHeight;
        }
        return drawn;
    }

    public float drawGlyphs(Batch batch, Layout glyphs, float x, float y) {
        return this.drawGlyphs(batch, glyphs, x, y, 8);
    }

    public float drawGlyphs(Batch batch, Layout glyphs, float x, float y, int align) {
        float drawn = 0.0f;
        int lines = glyphs.lines();
        for (int ln = 0; ln < lines; ++ln) {
            Line l = glyphs.getLine(ln);
            drawn += this.drawGlyphs(batch, l, x, y -= l.height, align);
        }
        return drawn;
    }

    public float drawGlyphs(Batch batch, Layout glyphs, float x, float y, int align, float rotation, float originX, float originY) {
        float drawn = 0.0f;
        float sn = MathUtils.sinDeg(rotation);
        float cs = MathUtils.cosDeg(rotation);
        int lines = glyphs.lines();
        for (int ln = 0; ln < lines; ++ln) {
            Line l = glyphs.getLine(ln);
            drawn += this.drawGlyphs(batch, l, x += sn * l.height, y -= cs * l.height, align, rotation, originX, originY);
        }
        return drawn;
    }

    public float drawGlyphs(Batch batch, Line glyphs, float x, float y) {
        if (glyphs == null) {
            return 0.0f;
        }
        return this.drawGlyphs(batch, glyphs, x, y, 8);
    }

    public float drawGlyphs(Batch batch, Line glyphs, float x, float y, int align) {
        float originX;
        float f = Align.isRight(align) ? glyphs.width : (originX = Align.isCenterHorizontal(align) ? glyphs.width * 0.5f : 0.0f);
        float originY = Align.isTop(align) ? glyphs.height : (Align.isCenterVertical(align) ? glyphs.height * 0.5f : 0.0f);
        return this.drawGlyphs(batch, glyphs, x, y, align, 0.0f, originX, originY);
    }

    public float drawGlyphs(Batch batch, Line glyphs, float x, float y, int align, float rotation, float originX, float originY) {
        if (glyphs == null || glyphs.glyphs.size == 0) {
            return 0.0f;
        }
        float drawn = 0.0f;
        float cs = MathUtils.cosDeg(rotation);
        float sn = MathUtils.sinDeg(rotation);
        float worldOriginX = x + originX;
        float worldOriginY = y + originY;
        float fx = -originX;
        float fy = -originY;
        x = cs * fx - sn * fy + worldOriginX;
        y = sn * fx + cs * fy + worldOriginY;
        if (Align.isCenterHorizontal(align)) {
            x -= cs * (glyphs.width * 0.5f);
            y -= sn * (glyphs.width * 0.5f);
        } else if (Align.isRight(align)) {
            x -= cs * glyphs.width;
            y -= sn * glyphs.width;
        }
        int kern = -1;
        float xChange = 0.0f;
        float yChange = 0.0f;
        boolean curly = false;
        boolean initial = true;
        int n = glyphs.glyphs.size;
        for (int i = 0; i < n; ++i) {
            long glyph = glyphs.glyphs.get(i);
            char ch = (char)glyph;
            if (curly) {
                if (ch == '}') {
                    curly = false;
                    continue;
                }
                if (ch != '{') continue;
                curly = false;
            } else if (ch == '{') {
                curly = true;
                continue;
            }
            Font font = null;
            if (this.family != null) {
                font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
            }
            if (font == null) {
                font = this;
            }
            float yy = y + 0.25f * (cs * font.cellHeight + sn * font.cellWidth);
            if (font.kerning != null) {
                kern = kern << 16 | (int)(glyph & 0xFFFFL);
                float amt = font.kerning.get(kern, 0.0f) * font.scaleX * ((glyph & 0x1000000L) != 0L ? 4.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L)) * 0.25f;
                xChange += cs * amt;
                yChange += sn * amt;
            }
            if (initial) {
                float ox = font.mapping.get((int)((int)(glyph & 0xFFFFL)), (GlyphRegion)font.defaultValue).offsetX * font.scaleX * ((glyph & 0x1000000L) != 0L ? 4.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L)) * 0.25f;
                if (ox < 0.0f) {
                    xChange -= cs * ox;
                    yChange -= sn * ox;
                }
                initial = false;
            }
            float single = this.drawGlyph(batch, glyph, x + xChange, yy + yChange, rotation);
            xChange += cs * single;
            yChange += sn * single;
            drawn += single;
        }
        return drawn;
    }

    public static float xAdvance(Font font, float scale, long glyph) {
        GlyphRegion tr;
        if (glyph >>> 32 == 0L) {
            return 0.0f;
        }
        char ch = (char)glyph;
        if ((glyph & 0x1100000L) == 0x1100000L) {
            ch = Category.caseUp(ch);
        }
        if ((tr = font.mapping.get(ch)) == null) {
            return 0.0f;
        }
        float changedW = tr.xAdvance * scale;
        if (!font.isMono && (glyph & 0x6000000L) != 0L) {
            changedW *= 0.5f;
        }
        return changedW;
    }

    public float xAdvance(long glyph) {
        GlyphRegion tr;
        if (glyph >>> 32 == 0L) {
            return 0.0f;
        }
        char ch = (char)glyph;
        if ((glyph & 0x1100000L) == 0x1100000L) {
            ch = Category.caseUp(ch);
        }
        if ((tr = this.mapping.get(ch)) == null) {
            return 0.0f;
        }
        float scale = ch >= '\ue000' && ch < '\uf800' ? ((glyph & 0x1000000L) != 0L ? 4.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L)) * 0.25f * this.cellHeight / tr.xAdvance : this.scaleX * ((glyph & 0x1000000L) != 0L ? 4.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L)) * 0.25f;
        float changedW = tr.xAdvance * scale;
        if (!this.isMono) {
            changedW += tr.offsetX * scale;
            if ((glyph & 0x6000000L) != 0L) {
                changedW *= 0.5f;
            }
        }
        return changedW;
    }

    public float measureWidth(Line line) {
        float drawn = 0.0f;
        LongArray glyphs = line.glyphs;
        boolean curly = false;
        boolean initial = true;
        int kern = -1;
        int n = glyphs.size;
        for (int i = 0; i < n; ++i) {
            float ox;
            float changedW;
            float scaleX;
            float scale;
            GlyphRegion tr;
            long glyph = glyphs.get(i);
            char ch = (char)glyph;
            if ((glyph & 0x1100000L) == 0x1100000L) {
                ch = Category.caseUp(ch);
            }
            if (curly) {
                if (ch == '}') {
                    curly = false;
                    continue;
                }
                if (ch != '{') continue;
                curly = false;
            } else if (ch == '{') {
                curly = true;
                continue;
            }
            Font font = null;
            if (this.family != null) {
                font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
            }
            if (font == null) {
                font = this;
            }
            if ((tr = font.mapping.get(ch)) == null) continue;
            if (font.kerning != null) {
                kern = kern << 16 | ch;
                scale = (glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
                scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / tr.xAdvance : font.scaleX * scale * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63));
                float amt = font.kerning.get(kern, 0.0f) * scaleX;
                changedW = tr.xAdvance * scaleX;
                if (initial) {
                    ox = font.mapping.get((int)((int)(glyph & 0xFFFFL)), (GlyphRegion)font.defaultValue).offsetX * scaleX;
                    if (ox < 0.0f) {
                        changedW -= ox;
                    }
                    initial = false;
                }
                drawn += changedW + amt;
                continue;
            }
            float f = scale = (glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
            scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / tr.xAdvance : font.scaleX * scale * ((glyph & 0x6000000L) != 0L && !font.isMono ? 0.5f : 1.0f);
            changedW = tr.xAdvance * scaleX;
            if (font.isMono) {
                changedW += tr.offsetX * scaleX;
            } else if (initial) {
                ox = font.mapping.get((int)((int)(glyph & 0xFFFFL)), (GlyphRegion)font.defaultValue).offsetX * scaleX;
                if (ox < 0.0f) {
                    changedW -= ox;
                }
                initial = false;
            }
            drawn += changedW;
        }
        return drawn;
    }

    public float calculateSize(Line line) {
        float drawn = 0.0f;
        LongArray glyphs = line.glyphs;
        boolean curly = false;
        boolean initial = true;
        int kern = -1;
        line.height = 0.0f;
        int n = glyphs.size;
        for (int i = 0; i < n; ++i) {
            float ox;
            float changedW;
            float scaleX;
            float scale;
            GlyphRegion tr;
            long glyph = glyphs.get(i);
            char ch = (char)glyph;
            if ((glyph & 0x1100000L) == 0x1100000L) {
                ch = Category.caseUp(ch);
            }
            if (curly) {
                if (ch == '}') {
                    curly = false;
                    continue;
                }
                if (ch != '{') continue;
                curly = false;
            } else if (ch == '{') {
                curly = true;
                continue;
            }
            Font font = null;
            if (this.family != null) {
                font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
            }
            if (font == null) {
                font = this;
            }
            if ((tr = font.mapping.get(ch)) == null) continue;
            if (font.kerning != null) {
                kern = kern << 16 | ch;
                scale = (glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
                scaleX = ch >= '\ue000' && ch < '\uf800' ? scale * font.cellHeight / tr.xAdvance : font.scaleX * scale * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63));
                line.height = Math.max(line.height, font.cellHeight * scale);
                float amt = font.kerning.get(kern, 0.0f) * scaleX;
                changedW = Font.xAdvance(font, scaleX, glyph);
                if (initial) {
                    ox = font.mapping.get((int)((int)(glyph & 0xFFFFL)), (GlyphRegion)font.defaultValue).offsetX * scaleX;
                    if (ox < 0.0f) {
                        changedW -= ox;
                    }
                    initial = false;
                }
                drawn += changedW + amt;
                continue;
            }
            scale = (glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
            line.height = Math.max(line.height, font.cellHeight * scale);
            scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / tr.xAdvance : font.scaleX * scale * ((glyph & 0x6000000L) != 0L && !font.isMono ? 0.5f : 1.0f);
            changedW = Font.xAdvance(font, scaleX, glyph);
            if (font.isMono) {
                changedW += tr.offsetX * scaleX;
            } else if (initial) {
                ox = font.mapping.get((int)((int)(glyph & 0xFFFFL)), (GlyphRegion)font.defaultValue).offsetX * scaleX;
                if (ox < 0.0f) {
                    changedW -= ox;
                }
                initial = false;
            }
            drawn += changedW;
        }
        line.width = drawn;
        return drawn;
    }

    public float calculateSize(Layout layout) {
        float w = 0.0f;
        float currentHeight = 0.0f;
        for (int ln = 0; ln < layout.lines(); ++ln) {
            float drawn = 0.0f;
            Line line = layout.getLine(ln);
            LongArray glyphs = line.glyphs;
            boolean curly = false;
            boolean initial = true;
            int kern = -1;
            line.height = currentHeight;
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                float ox;
                float changedW;
                float scaleX;
                float scale;
                GlyphRegion tr;
                long glyph = glyphs.get(i);
                char ch = (char)glyph;
                if ((glyph & 0x1100000L) == 0x1100000L) {
                    ch = Category.caseUp(ch);
                }
                if (curly) {
                    if (ch == '}') {
                        curly = false;
                        continue;
                    }
                    if (ch != '{') continue;
                    curly = false;
                } else if (ch == '{') {
                    curly = true;
                    continue;
                }
                Font font = null;
                if (this.family != null) {
                    font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
                }
                if (font == null) {
                    font = this;
                }
                if ((tr = font.mapping.get(ch)) == null) continue;
                float f = scale = (glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
                if (font.kerning != null) {
                    kern = kern << 16 | ch;
                    scaleX = ch >= '\ue000' && ch < '\uf800' ? scale * font.cellHeight / tr.xAdvance : font.scaleX * scale * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63));
                    currentHeight = font.cellHeight * scale;
                    line.height = Math.max(line.height, currentHeight);
                    float amt = font.kerning.get(kern, 0.0f) * scaleX;
                    changedW = tr.xAdvance * scaleX;
                    if (initial) {
                        ox = font.mapping.get((int)((int)(glyph & 0xFFFFL)), (GlyphRegion)font.defaultValue).offsetX * scaleX;
                        if (ox < 0.0f) {
                            changedW -= ox;
                        }
                        initial = false;
                    }
                    drawn += changedW + amt;
                    continue;
                }
                currentHeight = font.cellHeight * scale;
                line.height = Math.max(line.height, currentHeight);
                scaleX = ch >= '\ue000' && ch < '\uf800' ? scale * font.cellHeight / tr.xAdvance : font.scaleX * scale * ((glyph & 0x6000000L) != 0L && !font.isMono ? 0.5f : 1.0f);
                changedW = tr.xAdvance * scaleX;
                if (font.isMono) {
                    changedW += tr.offsetX * scaleX;
                } else if (initial) {
                    ox = font.mapping.get((int)((int)(glyph & 0xFFFFL)), (GlyphRegion)font.defaultValue).offsetX * scaleX;
                    if (ox < 0.0f) {
                        changedW -= ox;
                    }
                    initial = false;
                }
                drawn += changedW;
            }
            line.width = drawn;
            w = Math.max(w, drawn);
        }
        return w;
    }

    /*
     * Unable to fully structure code
     */
    public float calculateXAdvances(Line line, FloatArray advances) {
        advances.clear();
        glyphs = line.glyphs;
        advances.ensureCapacity(line.glyphs.size + 1);
        curly = false;
        initial = true;
        kern = -1;
        total = 0.0f;
        line.height = 0.0f;
        n = glyphs.size;
        for (i = 0; i < n; ++i) {
            glyph = glyphs.get(i);
            ch = (char)glyph;
            if (!curly) ** GOTO lbl24
            if (ch == '}') {
                curly = false;
                advances.add(0.0f);
                continue;
            }
            if (ch == '{') {
                curly = false;
            } else {
                advances.add(0.0f);
                continue;
lbl24:
                // 1 sources

                if (ch == '{') {
                    curly = true;
                    advances.add(0.0f);
                    continue;
                }
            }
            font = null;
            if (this.family != null) {
                font = this.family.connected[(int)(glyph >>> 16 & 15L)];
            }
            if (font == null) {
                font = this;
            }
            if ((tr = font.mapping.get(ch)) == null) {
                advances.add(0.0f);
                continue;
            }
            if (font.kerning != null) {
                kern = kern << 16 | ch;
                scale = (glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 15L) + 1L) * 0.25f;
                scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / tr.xAdvance : font.scaleX * scale * (1.0f + 0.5f * (float)(-(glyph & 0x6000000L) >> 63));
                line.height = Math.max(line.height, font.cellHeight * scale);
                amt = font.kerning.get(kern, 0.0f) * scaleX;
                changedW = Font.xAdvance(font, scaleX, glyph);
                if (initial) {
                    ox = font.mapping.get((int)((int)(glyph & 65535L)), (GlyphRegion)font.defaultValue).offsetX * scaleX;
                    if (ox < 0.0f) {
                        changedW -= ox;
                    }
                    initial = false;
                }
                advances.add(total);
                total += changedW + amt;
                continue;
            }
            scale = (glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 15L) + 1L) * 0.25f;
            line.height = Math.max(line.height, font.cellHeight * scale);
            scaleX = (char)glyph >= '\ue000' && (char)glyph < '\uf800' ? scale * font.cellHeight / tr.xAdvance : font.scaleX * scale * ((glyph & 0x6000000L) != 0L && font.isMono == false ? 0.5f : 1.0f);
            changedW = Font.xAdvance(font, scaleX, glyph);
            if (font.isMono) {
                changedW += tr.offsetX * scaleX;
            } else if (initial) {
                ox = font.mapping.get((int)((int)(glyph & 65535L)), (GlyphRegion)font.defaultValue).offsetX * scaleX;
                if (ox < 0.0f) {
                    changedW -= ox;
                }
                initial = false;
            }
            advances.add(total);
            total += changedW;
        }
        return total;
    }

    protected float handleIntegerPosition(float p) {
        return this.integerPosition ? (float)MathUtils.round(p) : p;
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y) {
        return this.drawGlyph(batch, glyph, x, y, 0.0f, 1.0f, 1.0f, 0);
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y, float rotation) {
        return this.drawGlyph(batch, glyph, x, y, rotation, 1.0f, 1.0f, 0);
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y, float rotation, float sizingX, float sizingY) {
        return this.drawGlyph(batch, glyph, x, y, rotation, sizingX, sizingY, 0);
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y, float rotation, float sizingX, float sizingY, int backgroundColor) {
        float xa;
        int xi;
        int widthAdj;
        long script;
        float scaleX;
        float scaleY;
        float fsy;
        float fsx;
        float scale;
        float sin = MathUtils.sinDeg(rotation);
        float cos = MathUtils.cosDeg(rotation);
        Font font = null;
        if (this.family != null) {
            font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
        }
        if (font == null) {
            font = this;
        }
        char c = (char)glyph;
        boolean squashed = false;
        boolean jostled = false;
        if ((glyph & 0x1100000L) == 0x1100000L) {
            squashed = c != (c = Category.caseUp(c));
            glyph = glyph & 0xFFFFFFFFFFFF0000L | (long)c;
        } else {
            jostled = (glyph & 0x1E00000L) == 0x1000000L;
        }
        GlyphRegion tr = font.mapping.get(c);
        if (tr == null) {
            return 0.0f;
        }
        if (squashed) {
            sizingY *= 0.7f;
        }
        float color = NumberUtils.intBitsToFloat((int)(batch.getColor().a * (float)(glyph >>> 33 & 0x7FL)) << 25 | (int)(batch.getColor().r * (float)(glyph >>> 56)) | (int)(batch.getColor().g * (float)(glyph >>> 48 & 0xFFL)) << 8 | (int)(batch.getColor().b * (float)(glyph >>> 40 & 0xFFL)) << 16);
        float f = scale = (glyph & 0x1000000L) != 0L ? 1.0f : (float)((glyph + 0x300000L >>> 20 & 0xFL) + 1L) * 0.25f;
        if (c >= '\ue000' && c < '\uf800') {
            fsy = fsx = font.cellHeight / tr.xAdvance;
            scaleX = scaleY = scale * fsx;
        } else {
            fsx = font.scaleX;
            scaleX = fsx * scale;
            fsy = font.scaleY;
            scaleY = fsy * scale;
        }
        float osx = font.scaleX * scale;
        float osy = font.scaleY * scale;
        float centerX = tr.xAdvance * font.scaleX * scaleX * 0.5f;
        float centerY = font.cellHeight * scaleY * 0.5f;
        float oCenterX = tr.xAdvance * font.scaleX * osx * 0.5f;
        float oCenterY = font.cellHeight * osy * 0.5f;
        float ox = x;
        float oy = y += font.descent * font.scaleY * 2.0f - font.descent * osy;
        float ix = font.handleIntegerPosition(x + oCenterX);
        float iy = font.handleIntegerPosition(y + oCenterY);
        float xShift = x + oCenterX - ix;
        float yShift = y + oCenterY - iy;
        x = this.handleIntegerPosition(ix - xShift);
        y = this.handleIntegerPosition(iy - yShift);
        centerX -= xShift * 0.5f;
        centerY -= yShift * 0.5f;
        if (tr.offsetX != tr.offsetX) {
            if (backgroundColor != 0) {
                this.drawBlockSequence(batch, BlockUtils.BOX_DRAWING[136], font.mapping.get(this.solidBlock, tr), NumberUtils.intToFloatColor(Integer.reverseBytes(backgroundColor)), x, y - font.descent * scaleY - font.cellHeight * scale * sizingY * 0.5f, font.cellWidth * sizingX, font.cellHeight * scale * sizingY, rotation);
            }
            float[] boxes = BlockUtils.BOX_DRAWING[c - 9472];
            this.drawBlockSequence(batch, boxes, font.mapping.get(this.solidBlock, tr), color, x, y - font.descent * scaleY - font.cellHeight * scale * sizingY * 0.5f, font.cellWidth * sizingX, font.cellHeight * scale * sizingY, rotation);
            return font.cellWidth;
        }
        Texture tex = tr.getTexture();
        float scaledHeight = font.cellHeight * scale * sizingY;
        float x0 = 0.0f;
        float x1 = 0.0f;
        float x2 = 0.0f;
        float y0 = 0.0f;
        float y1 = 0.0f;
        float y2 = 0.0f;
        float iw = 1.0f / (float)tex.getWidth();
        float w = (float)tr.getRegionWidth() * scaleX * sizingX;
        float xAdvance = tr.xAdvance;
        float changedW = xAdvance * scaleX;
        float xc = tr.offsetX * scaleX - centerX * sizingX;
        float trrh = tr.getRegionHeight();
        float h2 = trrh * scaleY * sizingY;
        float yt = (font.cellHeight * 0.5f - (trrh + tr.offsetY) * fsy) * scale * sizingY;
        float xPx = 2.0f / ((float)Gdx.graphics.getBackBufferWidth() * batch.getProjectionMatrix().val[0]);
        float yPx = 2.0f / ((float)Gdx.graphics.getBackBufferHeight() * batch.getProjectionMatrix().val[5]);
        float u = tr.getU();
        float v = tr.getV();
        float u2 = tr.getU2();
        float v2 = tr.getV2();
        if (c >= '\ue000' && c < '\uf800') {
            yt = this.handleIntegerPosition(yt - font.descent * osy * 0.5f);
        }
        if ((glyph & 0x20000000L) != 0L) {
            x0 += h2 * 0.2f;
            x1 -= h2 * 0.2f;
            x2 -= h2 * 0.2f;
        }
        if ((script = glyph & 0x6000000L) == 0x6000000L) {
            w *= 0.5f;
            h2 *= 0.5f;
            yt *= 0.625f;
            y1 += scaledHeight * 0.375f;
            y2 += scaledHeight * 0.375f;
            y0 += scaledHeight * 0.375f;
            if (!font.isMono) {
                changedW *= 0.5f;
            }
        } else if (script == 0x2000000L) {
            w *= 0.5f;
            h2 *= 0.5f;
            yt *= 0.625f;
            y1 -= scaledHeight * 0.375f;
            y2 -= scaledHeight * 0.375f;
            y0 -= scaledHeight * 0.375f;
            if (!font.isMono) {
                changedW *= 0.5f;
            }
        } else if (script == 0x4000000L) {
            w *= 0.5f;
            h2 *= 0.5f;
            yt *= 0.625f;
            if (!font.isMono) {
                changedW *= 0.5f;
            }
        }
        if (backgroundColor != 0) {
            this.drawBlockSequence(batch, BlockUtils.BOX_DRAWING[136], font.mapping.get(font.solidBlock, tr), NumberUtils.intToFloatColor(Integer.reverseBytes(backgroundColor)), x - (xAdvance * scaleX * (sizingX - 0.5f) + tr.offsetX * scaleX) * 0.5f, y - (font.cellHeight * scale + font.descent * osy) * 0.5f * sizingY, xAdvance * scaleX * sizingX + 5.0f, font.cellHeight * scale * sizingY, rotation);
        }
        if (jostled) {
            int code = NumberUtils.floatToIntBits(x * 1.8191725f + y * 1.6710436f + (float)c * 1.5497005f) & 0xFFFFFF;
            xc += (float)(code % 5) - 2.0f;
            y += (float)((code >>> 6) % 5) - 2.0f;
        }
        float p0x = xc + x0;
        float p0y = yt + y0 + h2;
        float p1x = xc + x1;
        float p1y = yt + y1;
        float p2x = xc + x2 + w;
        float p2y = yt + y2;
        this.vertices[3] = u;
        this.vertices[4] = v;
        this.vertices[8] = u;
        this.vertices[9] = v2;
        this.vertices[13] = u2;
        this.vertices[14] = v2;
        this.vertices[18] = u2;
        this.vertices[19] = v;
        if ((glyph & 0x1E00000L) == 0x1600000L) {
            float shadow;
            this.vertices[2] = shadow = -3.134651E-39f;
            this.vertices[7] = shadow;
            this.vertices[12] = shadow;
            this.vertices[17] = shadow;
            this.vertices[0] = x + cos * p0x - sin * p0y + 1.0f;
            this.vertices[5] = x + cos * p1x - sin * p1y + 1.0f;
            this.vertices[10] = x + cos * p2x - sin * p2y + 1.0f;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sin * p0x + cos * p0y - 2.0f;
            this.vertices[6] = y + sin * p1x + cos * p1y - 2.0f;
            this.vertices[11] = y + sin * p2x + cos * p2y - 2.0f;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            this.drawVertices(batch, tex, this.vertices);
        } else if ((glyph & 0x1E00000L) == 0x1200000L || (glyph & 0x1E00000L) == 0x1400000L) {
            float outline;
            this.vertices[2] = outline = (glyph & 0x1E00000L) == 0x1200000L ? this.PACKED_BLACK : this.PACKED_WHITE;
            this.vertices[7] = outline;
            this.vertices[12] = outline;
            this.vertices[17] = outline;
            widthAdj = (glyph & 0x40000000L) != 0L ? 2 : 1;
            for (xi = -widthAdj; xi <= widthAdj; ++xi) {
                xa = (float)xi * xPx;
                for (int yi = -1; yi <= 1; ++yi) {
                    if (xi == 0 && yi == 0) continue;
                    float ya = (float)yi * yPx;
                    this.vertices[0] = this.handleIntegerPosition(x + cos * p0x - sin * p0y + xa);
                    this.vertices[5] = this.handleIntegerPosition(x + cos * p1x - sin * p1y + xa);
                    this.vertices[10] = this.handleIntegerPosition(x + cos * p2x - sin * p2y + xa);
                    this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                    this.vertices[1] = this.handleIntegerPosition(y + sin * p0x + cos * p0y + ya);
                    this.vertices[6] = this.handleIntegerPosition(y + sin * p1x + cos * p1y + ya);
                    this.vertices[11] = this.handleIntegerPosition(y + sin * p2x + cos * p2y + ya);
                    this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                    this.drawVertices(batch, tex, this.vertices);
                }
            }
        } else if ((glyph & 0x1E00000L) == 0x1800000L) {
            float shine;
            this.vertices[2] = shine = this.PACKED_WHITE;
            this.vertices[7] = shine;
            this.vertices[12] = shine;
            this.vertices[17] = shine;
            widthAdj = (glyph & 0x40000000L) != 0L ? 1 : 0;
            for (xi = -widthAdj; xi <= widthAdj; ++xi) {
                xa = (float)xi * xPx;
                float ya = 1.5f * yPx;
                this.vertices[0] = x + cos * p0x - sin * p0y + xa;
                this.vertices[5] = x + cos * p1x - sin * p1y + xa;
                this.vertices[10] = x + cos * p2x - sin * p2y + xa;
                this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                this.vertices[1] = y + sin * p0x + cos * p0y + ya;
                this.vertices[6] = y + sin * p1x + cos * p1y + ya;
                this.vertices[11] = y + sin * p2x + cos * p2y + ya;
                this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                this.drawVertices(batch, tex, this.vertices);
            }
        }
        this.vertices[2] = color;
        this.vertices[7] = color;
        this.vertices[12] = color;
        this.vertices[17] = color;
        this.vertices[0] = this.handleIntegerPosition(x + cos * p0x - sin * p0y);
        this.vertices[5] = this.handleIntegerPosition(x + cos * p1x - sin * p1y);
        this.vertices[10] = this.handleIntegerPosition(x + cos * p2x - sin * p2y);
        this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
        this.vertices[1] = this.handleIntegerPosition(y + sin * p0x + cos * p0y);
        this.vertices[6] = this.handleIntegerPosition(y + sin * p1x + cos * p1y);
        this.vertices[11] = this.handleIntegerPosition(y + sin * p2x + cos * p2y);
        this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
        this.drawVertices(batch, tex, this.vertices);
        if ((glyph & 0x40000000L) != 0L) {
            this.vertices[0] = x + cos * (p0x += 1.0f) - sin * p0y;
            this.vertices[5] = x + cos * (p1x += 1.0f) - sin * p1y;
            this.vertices[10] = x + cos * (p2x += 1.0f) - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sin * p0x + cos * p0y;
            this.vertices[6] = y + sin * p1x + cos * p1y;
            this.vertices[11] = y + sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            this.drawVertices(batch, tex, this.vertices);
            this.vertices[0] = x + cos * (p0x -= 2.0f) - sin * p0y;
            this.vertices[5] = x + cos * (p1x -= 2.0f) - sin * p1y;
            this.vertices[10] = x + cos * (p2x -= 2.0f) - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sin * p0x + cos * p0y;
            this.vertices[6] = y + sin * p1x + cos * p1y;
            this.vertices[11] = y + sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            this.drawVertices(batch, tex, this.vertices);
            this.vertices[0] = x + cos * (p0x += 0.5f) - sin * p0y;
            this.vertices[5] = x + cos * (p1x += 0.5f) - sin * p1y;
            this.vertices[10] = x + cos * (p2x += 0.5f) - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sin * p0x + cos * p0y;
            this.vertices[6] = y + sin * p1x + cos * p1y;
            this.vertices[11] = y + sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            this.drawVertices(batch, tex, this.vertices);
            this.vertices[0] = x + cos * (p0x += 1.0f) - sin * p0y;
            this.vertices[5] = x + cos * (p1x += 1.0f) - sin * p1y;
            this.vertices[10] = x + cos * (p2x += 1.0f) - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = y + sin * p0x + cos * p0y;
            this.vertices[6] = y + sin * p1x + cos * p1y;
            this.vertices[11] = y + sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            this.drawVertices(batch, tex, this.vertices);
        }
        if ((glyph & 0x10000000L) != 0L) {
            ix = font.handleIntegerPosition(ox + oCenterX);
            iy = font.handleIntegerPosition(oy + oCenterY);
            xShift = ox + oCenterX - ix;
            yShift = oy + oCenterY - iy;
            x = this.handleIntegerPosition(ix - xShift);
            y = this.handleIntegerPosition(iy - yShift);
            centerX = oCenterX - xShift * 0.5f;
            centerY = oCenterY - yShift * 0.5f;
            GlyphRegion under = font.mapping.get(9472);
            if (under != null && under.offsetX != under.offsetX) {
                p0x = -centerX;
                p0y = -0.8125f * font.cellHeight * scale * sizingY;
                this.drawBlockSequence(batch, BlockUtils.BOX_DRAWING[0], font.mapping.get(font.solidBlock, tr), color, x + cos * p0x - sin * p0y, y + (sin * p0x + cos * p0y), xAdvance * scaleX + 2.0f, font.cellHeight * scale * sizingY, rotation);
            } else {
                under = font.mapping.get(95);
                if (under != null) {
                    trrh = under.getRegionHeight();
                    h2 = trrh * osy * sizingY;
                    yt = (font.cellHeight * 0.5f - (trrh + under.offsetY) * font.scaleY) * scale * sizingY;
                    if (c >= '\ue000' && c < '\uf800') {
                        yt = this.handleIntegerPosition(yt - font.descent * osy * 0.5f);
                    }
                    float underU = (under.getU() + under.getU2()) * 0.5f - iw;
                    float underV = under.getV();
                    float underU2 = underU + iw;
                    float underV2 = under.getV2();
                    xc = under.offsetX * osx - centerX * scale;
                    x0 = -osx * under.offsetX - scale;
                    this.vertices[2] = color;
                    this.vertices[3] = underU;
                    this.vertices[4] = underV;
                    this.vertices[7] = color;
                    this.vertices[8] = underU;
                    this.vertices[9] = underV2;
                    this.vertices[12] = color;
                    this.vertices[13] = underU2;
                    this.vertices[14] = underV2;
                    this.vertices[17] = color;
                    this.vertices[18] = underU2;
                    this.vertices[19] = underV;
                    p0x = xc + x0 - scale;
                    p0y = yt + y0 + h2;
                    p1x = xc + x0 - scale;
                    p1y = yt + y1;
                    p2x = xc + x0 + changedW + scale;
                    p2y = yt + y2;
                    this.vertices[0] = x + cos * p0x - sin * p0y;
                    this.vertices[5] = x + cos * p1x - sin * p1y;
                    this.vertices[10] = x + cos * p2x - sin * p2y;
                    this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                    this.vertices[1] = y + sin * p0x + cos * p0y;
                    this.vertices[6] = y + sin * p1x + cos * p1y;
                    this.vertices[11] = y + sin * p2x + cos * p2y;
                    this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                    this.drawVertices(batch, under.getTexture(), this.vertices);
                }
            }
        }
        if ((glyph & 0x8000000L) != 0L) {
            ix = font.handleIntegerPosition(ox + oCenterX);
            iy = font.handleIntegerPosition(oy + oCenterY);
            xShift = ox + oCenterX - ix;
            yShift = oy + oCenterY - iy;
            x = this.handleIntegerPosition(ix - xShift);
            y = this.handleIntegerPosition(iy - yShift);
            centerX = oCenterX - xShift * 0.5f;
            centerY = oCenterY - yShift * 0.5f;
            GlyphRegion dash = font.mapping.get(9472);
            if (dash != null && dash.offsetX != dash.offsetX) {
                p0x = -centerX;
                p0y = -0.45f * font.cellHeight * scale;
                this.drawBlockSequence(batch, BlockUtils.BOX_DRAWING[0], font.mapping.get(font.solidBlock, tr), color, x + cos * p0x - sin * p0y, y + (sin * p0x + cos * p0y), xAdvance * scaleX + 2.0f, font.cellHeight * scale * sizingY, rotation);
            } else {
                dash = font.mapping.get(45);
                if (dash != null) {
                    trrh = dash.getRegionHeight();
                    h2 = trrh * osy * sizingY;
                    yt = (font.cellHeight * 0.5f - (trrh + dash.offsetY) * font.scaleY) * scale * sizingY;
                    if (c >= '\ue000' && c < '\uf800') {
                        yt = this.handleIntegerPosition(yt - font.descent * osy * 0.5f);
                    }
                    float dashU = (dash.getU() + dash.getU2()) * 0.5f - iw;
                    float dashV = dash.getV();
                    float dashU2 = dashU + iw;
                    float dashV2 = dash.getV2();
                    xc = dash.offsetX * osx - centerX * scale;
                    x0 = -osx * dash.offsetX - scale;
                    this.vertices[2] = color;
                    this.vertices[3] = dashU;
                    this.vertices[4] = dashV;
                    this.vertices[7] = color;
                    this.vertices[8] = dashU;
                    this.vertices[9] = dashV2;
                    this.vertices[12] = color;
                    this.vertices[13] = dashU2;
                    this.vertices[14] = dashV2;
                    this.vertices[17] = color;
                    this.vertices[18] = dashU2;
                    this.vertices[19] = dashV;
                    p0x = xc + x0 - scale;
                    p0y = yt + y0 + h2;
                    p1x = xc + x0 - scale;
                    p1y = yt + y1;
                    p2x = xc + x0 + changedW + scale;
                    p2y = yt + y2;
                    this.vertices[0] = x + cos * p0x - sin * p0y;
                    this.vertices[5] = x + cos * p1x - sin * p1y;
                    this.vertices[10] = x + cos * p2x - sin * p2y;
                    this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
                    this.vertices[1] = y + sin * p0x + cos * p0y;
                    this.vertices[6] = y + sin * p1x + cos * p1y;
                    this.vertices[11] = y + sin * p2x + cos * p2y;
                    this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
                    this.drawVertices(batch, dash.getTexture(), this.vertices);
                }
            }
        }
        if ((glyph & 0x1E00000L) >= 0x1A00000L) {
            p0x = -centerX;
            p0y = -3.0f * centerY;
            this.drawFancyLine(batch, glyph & 0x1E00000L, x + cos * p0x - sin * p0y, y + (sin * p0x + cos * p0y), xAdvance * scaleX, xPx, yPx, rotation);
        }
        return changedW;
    }

    public Layout markup(String text, Layout appendTo) {
        long baseColor;
        long color;
        boolean capitalize = false;
        boolean previousWasLetter = false;
        boolean capsLock = false;
        boolean lowerCase = false;
        boolean initial = true;
        int scale = 3;
        int fontIndex = -1;
        Font font = this;
        long COLOR_MASK = -4294967296L;
        long current = color = (baseColor = Long.reverseBytes(NumberUtils.floatToIntBits(appendTo.getBaseColor())) & 0xFFFFFFFE00000000L);
        if (appendTo.font == null || !appendTo.font.equals(this)) {
            appendTo.clear();
            appendTo.font(this);
        }
        appendTo.peekLine().height = 0.0f;
        float targetWidth = appendTo.getTargetWidth();
        int kern = -1;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            float w;
            char showCh;
            float ox;
            int c;
            float scaleX = font.scaleX * (float)(scale + 1) * 0.25f;
            if (text.charAt(i) == '{' && i + 1 < n && text.charAt(i + 1) != '{') {
                char after;
                int start = i;
                int sizeChange = -1;
                int fontChange = -1;
                int innerSquareStart = -1;
                int innerSquareEnd = -1;
                int end = text.indexOf(125, i);
                if (end == -1) {
                    end = text.length();
                }
                int eq = end;
                while (i < n && i <= end) {
                    c = text.charAt(i);
                    if (c == 91 && i < end && text.charAt(i + 1) == '+') {
                        innerSquareStart = i;
                    } else if (innerSquareStart == -1) {
                        appendTo.add(current | (long)c);
                    }
                    if (c == 93) {
                        int len;
                        innerSquareEnd = i;
                        if (innerSquareStart != -1 && font.nameLookup != null && (len = innerSquareEnd - innerSquareStart) >= 2) {
                            c = font.nameLookup.get(Font.safeSubstring(text, innerSquareStart + 2, innerSquareEnd), 43);
                            innerSquareStart = -1;
                            appendTo.add(current | (long)c);
                        }
                    }
                    if (c == 64) {
                        fontChange = i;
                    } else if (c == 37) {
                        sizeChange = i;
                    } else if (c == 63) {
                        sizeChange = -1;
                    } else if (c == 94) {
                        sizeChange = -1;
                    } else if (c == 61) {
                        eq = Math.min(eq, i);
                    }
                    ++i;
                }
                char c2 = after = eq + 1 >= end ? (char)'\u0000' : text.charAt(eq + 1);
                if (start + 1 == end || "RESET".equalsIgnoreCase(Font.safeSubstring(text, start + 1, end))) {
                    scale = 3;
                    font = this;
                    fontIndex = 0;
                    current &= 0xFFFFFFFFF9FFFFFFL;
                } else if (after == '^' || after == '=' || after == '.') {
                    switch (after) {
                        case '^': {
                            if ((current & 0x6000000L) == 0x6000000L) {
                                current &= 0xFFFFFFFFF9FFFFFFL;
                                break;
                            }
                            current |= 0x6000000L;
                            break;
                        }
                        case '.': {
                            if ((current & 0x6000000L) == 0x2000000L) {
                                current &= 0xFFFFFFFFFDFFFFFFL;
                                break;
                            }
                            current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                            break;
                        }
                        case '=': {
                            if ((current & 0x6000000L) == 0x4000000L) {
                                current &= 0xFFFFFFFFFBFFFFFFL;
                                break;
                            }
                            current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                        }
                    }
                } else if (fontChange >= 0 && this.family != null) {
                    fontIndex = this.family.fontAliases.get(Font.safeSubstring(text, fontChange + 1, end), -1);
                    if (fontIndex == -1) {
                        font = this;
                        fontIndex = 0;
                    } else {
                        font = this.family.connected[fontIndex];
                        if (font == null) {
                            font = this;
                            fontIndex = 0;
                        }
                    }
                } else if (sizeChange >= 0) {
                    scale = sizeChange + 1 == end ? (eq + 1 == sizeChange ? 3 : (Font.intFromDec(text, eq + 1, sizeChange) - 24) / 25 & 0xF) : (Font.intFromDec(text, sizeChange + 1, end) - 24) / 25 & 0xF;
                }
                current = current & 0xFFFFFFFFFF00FFFFL | (long)((scale - 3 & 0xF) << 20) | (long)((fontIndex & 0xF) << 16);
                --i;
                continue;
            }
            if (text.charAt(i) == '[') {
                float w2;
                int len;
                c = 91;
                if (++i < n) {
                    char c3 = text.charAt(i);
                    c = c3;
                    if (c3 != '[' && c != 43) {
                        if (c == 93) {
                            color = baseColor;
                            current = color & 0xFFFFFFFFF9FFFFFFL;
                            scale = 3;
                            font = this;
                            capitalize = false;
                            capsLock = false;
                            lowerCase = false;
                            continue;
                        }
                        int len2 = text.indexOf(93, i) - i;
                        if (len2 < 0) break;
                        switch (c) {
                            case 42: {
                                current ^= 0x40000000L;
                                break;
                            }
                            case 47: {
                                current ^= 0x20000000L;
                                break;
                            }
                            case 94: {
                                if ((current & 0x6000000L) == 0x6000000L) {
                                    current &= 0xFFFFFFFFF9FFFFFFL;
                                    break;
                                }
                                current |= 0x6000000L;
                                break;
                            }
                            case 46: {
                                if ((current & 0x6000000L) == 0x2000000L) {
                                    current &= 0xFFFFFFFFFDFFFFFFL;
                                    break;
                                }
                                current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                                break;
                            }
                            case 61: {
                                if ((current & 0x6000000L) == 0x4000000L) {
                                    current &= 0xFFFFFFFFFBFFFFFFL;
                                    break;
                                }
                                current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                                break;
                            }
                            case 95: {
                                current ^= 0x10000000L;
                                break;
                            }
                            case 126: {
                                current ^= 0x8000000L;
                                break;
                            }
                            case 59: {
                                capitalize = !capitalize;
                                capsLock = false;
                                lowerCase = false;
                                break;
                            }
                            case 33: {
                                capsLock = !capsLock;
                                capitalize = false;
                                lowerCase = false;
                                break;
                            }
                            case 44: {
                                lowerCase = !lowerCase;
                                capitalize = false;
                                capsLock = false;
                                break;
                            }
                            case 37: {
                                if (len2 >= 2) {
                                    if (text.charAt(i + 1) == '?' || text.charAt(i + 1) == '^') {
                                        long modes;
                                        long l = modes = text.charAt(i + 1) == '^' ? 0x1100000L : 0x1000000L;
                                        if (len2 >= 5) {
                                            char ch = Category.caseUp(text.charAt(i + 2));
                                            if (ch == 'B') {
                                                modes |= 0x1200000L;
                                            } else if (ch == 'W') {
                                                modes = Category.caseUp(text.charAt(i + 3)) == 'H' ? (modes |= 0x1400000L) : (modes |= 0x1C00000L);
                                            } else if (ch == 'S') {
                                                if (Category.caseUp(text.charAt(i + 4)) == 'I') {
                                                    modes |= 0x1800000L;
                                                } else if (Category.caseUp(text.charAt(i + 3)) == 'H') {
                                                    modes |= 0x1600000L;
                                                }
                                            } else if (ch == 'D') {
                                                modes |= 0x1600000L;
                                            } else if (ch == 'E') {
                                                modes |= 0x1A00000L;
                                            } else if (ch == 'N') {
                                                modes |= 0x1E00000L;
                                            }
                                        }
                                        current = current & (0xFFFFFFFFFE0FFFFFL ^ (current & 0x1000000L) >>> 4) ^ modes;
                                        scale = 3;
                                        break;
                                    }
                                    scale = (Font.intFromDec(text, i + 1, i + len2) - 24) / 25 & 0xF;
                                    current = current & 0xFFFFFFFFFE0FFFFFL | (long)((scale - 3 & 0xF) << 20);
                                    break;
                                }
                                current &= 0xFFFFFFFFFE0FFFFFL;
                                scale = 3;
                                break;
                            }
                            case 35: {
                                color = len2 >= 7 && len2 < 9 ? Font.longFromHex(text, i + 1, i + 7) << 40 | 0xFE00000000L : (len2 >= 9 ? Font.longFromHex(text, i + 1, i + 9) << 32 & 0xFFFFFFFE00000000L : baseColor);
                                current = current & 0xFFFFFFFFL | color;
                                break;
                            }
                            case 64: {
                                if (this.family == null) {
                                    font = this;
                                    fontIndex = 0;
                                    break;
                                }
                                fontIndex = this.family.fontAliases.get(Font.safeSubstring(text, i + 1, i + len2), 0);
                                current = current & 0xFFFFFFFFFFF0FFFFL | ((long)fontIndex & 0xFL) << 16;
                                font = this.family.connected[fontIndex & 0xF];
                                if (font != null) break;
                                font = this;
                                break;
                            }
                            case 124: {
                                int lookupColor = this.colorLookup.getRgba(Font.safeSubstring(text, i + 1, i + len2)) & 0xFFFFFFFE;
                                color = lookupColor == 256 ? baseColor : (long)lookupColor << 32;
                                current = current & 0xFFFFFFFFL | color;
                                break;
                            }
                            default: {
                                int gdxColor = this.colorLookup.getRgba(Font.safeSubstring(text, i, i + len2)) & 0xFFFFFFFE;
                                color = gdxColor == 256 ? baseColor : (long)gdxColor << 32;
                                current = current & 0xFFFFFFFFL | color;
                            }
                        }
                        i += len2;
                        continue;
                    }
                }
                if (c == 43 && font.nameLookup != null && (len = text.indexOf(93, i) - i) >= 0) {
                    c = font.nameLookup.get(Font.safeSubstring(text, i + 1, i + len), 43);
                    i += len;
                    scaleX = (float)(scale + 1) * 0.25f * font.cellHeight / font.mapping.get((int)c, (GlyphRegion)font.defaultValue).xAdvance;
                }
                if (font.kerning == null) {
                    w2 = appendTo.peekLine().width += Font.xAdvance(font, scaleX, current | (long)c);
                    if (initial) {
                        float ox2 = font.mapping.get((int)c, (GlyphRegion)font.defaultValue).offsetX * scaleX;
                        if (ox2 < 0.0f) {
                            w2 = appendTo.peekLine().width -= ox2;
                        }
                        initial = false;
                    }
                } else {
                    kern = kern << 16 | c;
                    w2 = appendTo.peekLine().width += Font.xAdvance(font, scaleX, current | (long)c) + font.kerning.get(kern, 0.0f) * scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63));
                    if (initial) {
                        float ox3 = font.mapping.get((int)c, (GlyphRegion)font.defaultValue).offsetX * scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63));
                        if (ox3 < 0.0f) {
                            w2 = appendTo.peekLine().width -= ox3;
                        }
                        initial = false;
                    }
                }
                if (c == 91) {
                    appendTo.add(current | 2L);
                } else {
                    appendTo.add(current | (long)c);
                }
                if (targetWidth > 0.0f && w2 > targetWidth) {
                    Line earlier = appendTo.peekLine();
                    Line later = appendTo.pushLine();
                    if (later == null) {
                        if (!this.handleEllipsis(appendTo)) continue;
                        return appendTo;
                    }
                    for (int j = earlier.glyphs.size - 2; j >= 0; --j) {
                        long curr = earlier.glyphs.get(j);
                        if (curr >>> 32 != 0L && Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)curr) < 0) continue;
                        int leading = 0;
                        while (j > 0 && ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0)) {
                            ++leading;
                            --j;
                        }
                        this.glyphBuffer.clear();
                        float change = 0.0f;
                        float changeNext = 0.0f;
                        if (font.kerning == null) {
                            boolean curly = false;
                            for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                                curr = earlier.glyphs.get(k);
                                if (curly) {
                                    this.glyphBuffer.add(curr);
                                    if ((char)curr == '{') {
                                        curly = false;
                                    } else {
                                        if ((char)curr != '}') continue;
                                        curly = false;
                                        continue;
                                    }
                                }
                                if ((char)curr == '{') {
                                    this.glyphBuffer.add(curr);
                                    curly = true;
                                    continue;
                                }
                                float adv = Font.xAdvance(font, scaleX, curr);
                                change += adv;
                                if (--leading >= 0) continue;
                                this.glyphBuffer.add(curr);
                                changeNext += adv;
                                if (this.glyphBuffer.size != 1) continue;
                                float ox4 = font.mapping.get((int)((char)((int)curr)), (GlyphRegion)font.defaultValue).offsetX * scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63));
                                if (ox4 < 0.0f) {
                                    changeNext -= ox4;
                                }
                                initial = false;
                            }
                        } else {
                            int k2 = (int)earlier.glyphs.get(j);
                            int k3 = -1;
                            boolean curly = false;
                            for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                                curr = earlier.glyphs.get(k);
                                if (curly) {
                                    this.glyphBuffer.add(curr);
                                    if ((char)curr == '{') {
                                        curly = false;
                                    } else {
                                        if ((char)curr != '}') continue;
                                        curly = false;
                                        continue;
                                    }
                                }
                                if ((char)curr == '{') {
                                    this.glyphBuffer.add(curr);
                                    curly = true;
                                    continue;
                                }
                                k2 = k2 << 16 | (char)curr;
                                float adv = Font.xAdvance(font, scaleX, curr);
                                change += adv + font.kerning.get(k2, 0.0f) * scaleX * (1.0f + 0.5f * (float)(-(curr & 0x6000000L) >> 63));
                                if (--leading >= 0) continue;
                                k3 = k3 << 16 | (char)curr;
                                changeNext += adv + font.kerning.get(k3, 0.0f) * scaleX * (1.0f + 0.5f * (float)(-(curr & 0x6000000L) >> 63));
                                this.glyphBuffer.add(curr);
                                if (this.glyphBuffer.size != 1) continue;
                                ox = font.mapping.get((int)((char)((int)curr)), (GlyphRegion)font.defaultValue).offsetX * scaleX * (1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63));
                                if (ox < 0.0f) {
                                    changeNext -= ox;
                                }
                                initial = false;
                            }
                        }
                        if (earlier.width - change > targetWidth) continue;
                        earlier.glyphs.truncate(j + 1);
                        earlier.glyphs.add(32L);
                        later.width = changeNext;
                        earlier.width -= change;
                        later.glyphs.addAll(this.glyphBuffer);
                        later.height = Math.max(later.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                        break;
                    }
                    if (!later.glyphs.isEmpty()) continue;
                    appendTo.lines.pop();
                    continue;
                }
                appendTo.peekLine().height = Math.max(appendTo.peekLine().height, font.cellHeight * (float)(scale + 1) * 0.25f);
                continue;
            }
            char ch = text.charAt(i);
            if (Font.isLowerCase(ch)) {
                if (capitalize && !previousWasLetter || capsLock) {
                    ch = Category.caseUp(ch);
                }
                previousWasLetter = true;
            } else if (Font.isUpperCase(ch)) {
                if (capitalize && previousWasLetter || lowerCase) {
                    ch = Category.caseDown(ch);
                }
                previousWasLetter = true;
            } else {
                previousWasLetter = false;
            }
            char c4 = showCh = (current & 0x1100000L) == 0x1100000L ? Category.caseUp(ch) : ch;
            if (ch >= '\ue000' && ch < '\uf800') {
                scaleX = (float)(scale + 1) * 0.25f * font.cellHeight / font.mapping.get((int)ch, (GlyphRegion)font.defaultValue).xAdvance;
            }
            if (font.kerning == null) {
                w = appendTo.peekLine().width += Font.xAdvance(font, scaleX, current | (long)showCh);
            } else {
                kern = kern << 16 | showCh;
                w = appendTo.peekLine().width += Font.xAdvance(font, scaleX, current | (long)showCh) + font.kerning.get(kern, 0.0f) * scaleX * (1.0f + 0.5f * (float)(-((current | (long)showCh) & 0x6000000L) >> 63));
            }
            if (initial) {
                float ox5 = font.mapping.get((int)showCh, (GlyphRegion)font.defaultValue).offsetX * scaleX;
                if (!this.isMono) {
                    ox5 *= 1.0f + 0.5f * (float)(-(current & 0x6000000L) >> 63);
                }
                if (ox5 < 0.0f) {
                    w = appendTo.peekLine().width -= ox5;
                }
                initial = false;
            }
            if (ch == '\n') {
                appendTo.peekLine().height = Math.max(appendTo.peekLine().height, font.cellHeight * (float)(scale + 1) * 0.25f);
                initial = true;
            }
            appendTo.add(current | (long)ch);
            if (targetWidth > 0.0f && w > targetWidth || appendTo.atLimit) {
                Line later;
                Line earlier = appendTo.peekLine();
                if (appendTo.lines.size >= appendTo.maxLines) {
                    later = null;
                } else {
                    later = new Line();
                    later.height = 0.0f;
                    appendTo.lines.add(later);
                    initial = true;
                }
                if (later == null) {
                    if (!this.handleEllipsis(appendTo)) continue;
                    return appendTo;
                }
                for (int j = earlier.glyphs.size - 2; j >= 0; --j) {
                    long curr = earlier.glyphs.get(j);
                    if (curr >>> 32 != 0L && Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)curr) < 0) continue;
                    int leading = 0;
                    while (j > 0 && ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0)) {
                        ++leading;
                        --j;
                    }
                    this.glyphBuffer.clear();
                    float change = 0.0f;
                    float changeNext = 0.0f;
                    if (font.kerning == null) {
                        boolean curly = false;
                        for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                            curr = earlier.glyphs.get(k);
                            char c5 = showCh = (curr & 0x1100000L) == 0x1100000L ? Category.caseUp((char)curr) : (char)curr;
                            if (curly) {
                                this.glyphBuffer.add(curr);
                                if ((char)curr == '{') {
                                    curly = false;
                                } else {
                                    if ((char)curr != '}') continue;
                                    curly = false;
                                    continue;
                                }
                            }
                            if (showCh == '{') {
                                this.glyphBuffer.add(curr);
                                curly = true;
                                continue;
                            }
                            float adv = Font.xAdvance(font, scaleX, curr);
                            change += adv;
                            if (--leading >= 0) continue;
                            this.glyphBuffer.add(curr);
                            changeNext += adv;
                            if (this.glyphBuffer.size != 1) continue;
                            ox = font.mapping.get((int)showCh, (GlyphRegion)font.defaultValue).offsetX * scaleX * (this.isMono || (curr & 0x6000000L) == 0L ? 1.0f : 0.5f);
                            if (ox < 0.0f) {
                                changeNext -= ox;
                            }
                            initial = false;
                        }
                    } else {
                        int k2 = (int)earlier.glyphs.get(j);
                        kern = -1;
                        boolean curly = false;
                        for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                            curr = earlier.glyphs.get(k);
                            char c6 = showCh = (curr & 0x1100000L) == 0x1100000L ? Category.caseUp((char)curr) : (char)curr;
                            if (curly) {
                                this.glyphBuffer.add(curr);
                                if ((char)curr == '{') {
                                    curly = false;
                                } else {
                                    if ((char)curr != '}') continue;
                                    curly = false;
                                    continue;
                                }
                            }
                            if (showCh == '{') {
                                this.glyphBuffer.add(curr);
                                curly = true;
                                continue;
                            }
                            k2 = k2 << 16 | showCh;
                            float adv = Font.xAdvance(font, scaleX, curr);
                            change += adv + font.kerning.get(k2, 0.0f) * scaleX * (this.isMono || (curr & 0x6000000L) == 0L ? 1.0f : 0.5f);
                            if (--leading >= 0) continue;
                            kern = kern << 16 | showCh;
                            changeNext += adv + font.kerning.get(kern, 0.0f) * scaleX * (this.isMono || (curr & 0x6000000L) == 0L ? 1.0f : 0.5f);
                            this.glyphBuffer.add(curr);
                            if (this.glyphBuffer.size != 1) continue;
                            float ox6 = font.mapping.get((int)showCh, (GlyphRegion)font.defaultValue).offsetX * scaleX * (this.isMono || (curr & 0x6000000L) == 0L ? 1.0f : 0.5f);
                            if (ox6 < 0.0f) {
                                changeNext -= ox6;
                            }
                            initial = false;
                        }
                    }
                    if (earlier.width - change > targetWidth) continue;
                    earlier.glyphs.truncate(j + 1);
                    earlier.glyphs.add(32L);
                    later.width = changeNext;
                    earlier.width -= change;
                    later.glyphs.addAll(this.glyphBuffer);
                    later.height = Math.max(later.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                    break;
                }
                if (!later.glyphs.isEmpty()) continue;
                appendTo.lines.pop();
                continue;
            }
            appendTo.peekLine().height = Math.max(appendTo.peekLine().height, font.cellHeight * (float)(scale + 1) * 0.25f);
        }
        return appendTo;
    }

    protected boolean handleEllipsis(Layout appendTo) {
        Font font = null;
        Line earlier = appendTo.peekLine();
        String ellipsis = appendTo.ellipsis == null ? "" : appendTo.ellipsis;
        for (int j = earlier.glyphs.size - 2; j >= 0; --j) {
            long curr = earlier.glyphs.get(j);
            if (curr >>> 32 != 0L && Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)curr) < 0) continue;
            while (j > 0 && ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0)) {
                --j;
            }
            if (this.family != null) {
                font = this.family.connected[(int)(curr >>> 16 & 0xFL)];
            }
            if (font == null) {
                font = this;
            }
            float change = 0.0f;
            if (font.kerning == null) {
                float adv;
                boolean curly = false;
                for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                    curr = earlier.glyphs.get(k);
                    if (this.family != null) {
                        font = this.family.connected[(int)(curr >>> 16 & 0xFL)];
                    }
                    if (font == null) {
                        font = this;
                    }
                    if (curly) {
                        if ((char)curr == '{') {
                            curly = false;
                        } else {
                            if ((char)curr != '}') continue;
                            curly = false;
                            continue;
                        }
                    }
                    if ((char)curr == '{') {
                        curly = true;
                        continue;
                    }
                    adv = Font.xAdvance(font, this.scaleX, curr);
                    change += adv;
                }
                for (int e = 0; e < ellipsis.length(); ++e) {
                    curr = curr & 0xFFFFFFFFFFFF0000L | (long)ellipsis.charAt(e);
                    adv = Font.xAdvance(font, this.scaleX, curr);
                    change -= adv;
                }
            } else {
                float adv;
                int k2 = (int)earlier.glyphs.get(j);
                int kern = -1;
                boolean curly = false;
                for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                    curr = earlier.glyphs.get(k);
                    if (this.family != null) {
                        font = this.family.connected[(int)(curr >>> 16 & 0xFL)];
                    }
                    if (font == null) {
                        font = this;
                    }
                    if (curly) {
                        if ((char)curr == '{') {
                            curly = false;
                        } else {
                            if ((char)curr != '}') continue;
                            curly = false;
                            continue;
                        }
                    }
                    if ((char)curr == '{') {
                        curly = true;
                        continue;
                    }
                    k2 = k2 << 16 | (char)curr;
                    adv = Font.xAdvance(font, this.scaleX, curr);
                    change += adv + font.kerning.get(k2, 0.0f) * this.scaleX * (this.isMono || (curr & 0x6000000L) == 0L ? 1.0f : 0.5f);
                }
                for (int e = 0; e < ellipsis.length(); ++e) {
                    curr = curr & 0xFFFFFFFFFFFF0000L | (long)ellipsis.charAt(e);
                    k2 = k2 << 16 | (char)curr;
                    adv = Font.xAdvance(font, this.scaleX, curr);
                    change -= adv + font.kerning.get(k2, 0.0f) * this.scaleX * (this.isMono || (curr & 0x6000000L) == 0L ? 1.0f : 0.5f);
                }
            }
            if (earlier.width - change > appendTo.targetWidth) continue;
            earlier.glyphs.truncate(j + 1);
            for (int e = 0; e < ellipsis.length(); ++e) {
                earlier.glyphs.add(curr & 0xFFFFFFFFFFFF0000L | (long)ellipsis.charAt(e));
            }
            earlier.width -= change;
            return true;
        }
        return false;
    }

    public long markupGlyph(char chr, String markup) {
        return Font.markupGlyph(chr, markup, this.colorLookup, this.family);
    }

    public long markupGlyph(String markup) {
        long baseColor;
        long color;
        boolean capitalize = false;
        boolean capsLock = false;
        boolean lowerCase = false;
        int scale = 3;
        int fontIndex = -1;
        long COLOR_MASK = -4294967296L;
        long current = color = (baseColor = -8589934592L);
        Font font = this;
        int n = markup.length();
        for (int i = 0; i <= n; ++i) {
            int c;
            if (i == n) {
                return current | 0x20L;
            }
            if (markup.charAt(i) == '{' && i + 1 < n && markup.charAt(i + 1) != '{') {
                char after;
                int start = i;
                int sizeChange = -1;
                int fontChange = -1;
                int innerSquareStart = -1;
                int innerSquareEnd = -1;
                int end = markup.indexOf(125, i);
                if (end == -1) {
                    end = markup.length();
                }
                int eq = end;
                while (i < n && i <= end) {
                    c = markup.charAt(i);
                    if (c == 91 && i < end && markup.charAt(i + 1) == '+') {
                        innerSquareStart = i;
                    } else if (innerSquareStart == -1) {
                        current |= (long)c;
                    }
                    if (c == 93) {
                        int len;
                        innerSquareEnd = i;
                        if (innerSquareStart != -1 && font.nameLookup != null && (len = innerSquareEnd - innerSquareStart) >= 2) {
                            c = font.nameLookup.get(Font.safeSubstring(markup, innerSquareStart + 2, innerSquareEnd), 43);
                            innerSquareStart = -1;
                            current |= (long)c;
                        }
                    }
                    if (c == 64) {
                        fontChange = i;
                    } else if (c == 37) {
                        sizeChange = i;
                    } else if (c == 63) {
                        sizeChange = -1;
                    } else if (c == 94) {
                        sizeChange = -1;
                    } else if (c == 61) {
                        eq = Math.min(eq, i);
                    }
                    ++i;
                }
                char c2 = after = eq + 1 >= end ? (char)'\u0000' : markup.charAt(eq + 1);
                if (start + 1 == end || "RESET".equalsIgnoreCase(Font.safeSubstring(markup, start + 1, end))) {
                    scale = 3;
                    fontIndex = 0;
                    current &= 0xFFFFFFFFF9FFFFFFL;
                } else if (after == '^' || after == '=' || after == '.') {
                    switch (after) {
                        case '^': {
                            if ((current & 0x6000000L) == 0x6000000L) {
                                current &= 0xFFFFFFFFF9FFFFFFL;
                                break;
                            }
                            current |= 0x6000000L;
                            break;
                        }
                        case '.': {
                            if ((current & 0x6000000L) == 0x2000000L) {
                                current &= 0xFFFFFFFFFDFFFFFFL;
                                break;
                            }
                            current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                            break;
                        }
                        case '=': {
                            if ((current & 0x6000000L) == 0x4000000L) {
                                current &= 0xFFFFFFFFFBFFFFFFL;
                                break;
                            }
                            current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                        }
                    }
                } else if (fontChange >= 0 && this.family != null) {
                    fontIndex = this.family.fontAliases.get(Font.safeSubstring(markup, fontChange + 1, end), -1);
                    if (fontIndex == -1) {
                        fontIndex = 0;
                    } else if (this.family.connected[fontIndex] == null) {
                        fontIndex = 0;
                    } else {
                        font = this.family.connected[fontIndex];
                    }
                } else if (sizeChange >= 0) {
                    scale = sizeChange + 1 == end ? (eq + 1 == sizeChange ? 3 : (Font.intFromDec(markup, eq + 1, sizeChange) - 24) / 25 & 0xF) : (Font.intFromDec(markup, sizeChange + 1, end) - 24) / 25 & 0xF;
                }
                current = current & 0xFFFFFFFFFF00FFFFL | (long)((scale - 3 & 0xF) << 20) | (long)((fontIndex & 0xF) << 16);
                --i;
                continue;
            }
            if (markup.charAt(i) == '[') {
                int len;
                c = 91;
                if (++i < n) {
                    char c3 = markup.charAt(i);
                    c = c3;
                    if (c3 != '[' && c != 43) {
                        if (c == 93) {
                            color = baseColor;
                            current = color & 0xFFFFFFFFF9FFFFFFL;
                            scale = 3;
                            capitalize = false;
                            capsLock = false;
                            lowerCase = false;
                            continue;
                        }
                        int len2 = markup.indexOf(93, i) - i;
                        if (len2 < 0) break;
                        switch (c) {
                            case 42: {
                                current ^= 0x40000000L;
                                break;
                            }
                            case 47: {
                                current ^= 0x20000000L;
                                break;
                            }
                            case 94: {
                                if ((current & 0x6000000L) == 0x6000000L) {
                                    current &= 0xFFFFFFFFF9FFFFFFL;
                                    break;
                                }
                                current |= 0x6000000L;
                                break;
                            }
                            case 46: {
                                if ((current & 0x6000000L) == 0x2000000L) {
                                    current &= 0xFFFFFFFFFDFFFFFFL;
                                    break;
                                }
                                current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                                break;
                            }
                            case 61: {
                                if ((current & 0x6000000L) == 0x4000000L) {
                                    current &= 0xFFFFFFFFFBFFFFFFL;
                                    break;
                                }
                                current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                                break;
                            }
                            case 95: {
                                current ^= 0x10000000L;
                                break;
                            }
                            case 126: {
                                current ^= 0x8000000L;
                                break;
                            }
                            case 59: {
                                capitalize = !capitalize;
                                capsLock = false;
                                lowerCase = false;
                                break;
                            }
                            case 33: {
                                capsLock = !capsLock;
                                capitalize = false;
                                lowerCase = false;
                                break;
                            }
                            case 44: {
                                lowerCase = !lowerCase;
                                capitalize = false;
                                capsLock = false;
                                break;
                            }
                            case 37: {
                                if (len2 >= 2) {
                                    if (markup.charAt(i + 1) == '?' || markup.charAt(i + 1) == '^') {
                                        long modes;
                                        long l = modes = markup.charAt(i + 1) == '^' ? 0x1100000L : 0x1000000L;
                                        if (len2 >= 5) {
                                            char ch = Category.caseUp(markup.charAt(i + 2));
                                            if (ch == 'B') {
                                                modes |= 0x1200000L;
                                            } else if (ch == 'W') {
                                                modes = Category.caseUp(markup.charAt(i + 3)) == 'H' ? (modes |= 0x1400000L) : (modes |= 0x1C00000L);
                                            } else if (ch == 'S') {
                                                if (Category.caseUp(markup.charAt(i + 4)) == 'I') {
                                                    modes |= 0x1800000L;
                                                } else if (Category.caseUp(markup.charAt(i + 3)) == 'H') {
                                                    modes |= 0x1600000L;
                                                }
                                            } else if (ch == 'D') {
                                                modes |= 0x1600000L;
                                            } else if (ch == 'E') {
                                                modes |= 0x1A00000L;
                                            } else if (ch == 'N') {
                                                modes |= 0x1E00000L;
                                            }
                                        }
                                        current = current & (0xFFFFFFFFFE0FFFFFL ^ (current & 0x1000000L) >>> 4) ^ modes;
                                        scale = 3;
                                        break;
                                    }
                                    scale = (Font.intFromDec(markup, i + 1, i + len2) - 24) / 25 & 0xF;
                                    current = current & 0xFFFFFFFFFE0FFFFFL | (long)((scale - 3 & 0xF) << 20);
                                    break;
                                }
                                current &= 0xFFFFFFFFFE0FFFFFL;
                                scale = 3;
                                break;
                            }
                            case 35: {
                                color = len2 >= 7 && len2 < 9 ? Font.longFromHex(markup, i + 1, i + 7) << 40 | 0xFE00000000L : (len2 >= 9 ? Font.longFromHex(markup, i + 1, i + 9) << 32 & 0xFFFFFFFE00000000L : baseColor);
                                current = current & 0xFFFFFFFFL | color;
                                break;
                            }
                            case 64: {
                                if (this.family == null) {
                                    fontIndex = 0;
                                    break;
                                }
                                fontIndex = this.family.fontAliases.get(Font.safeSubstring(markup, i + 1, i + len2), 0);
                                font = this.family.connected[fontIndex];
                                current = current & 0xFFFFFFFFFFF0FFFFL | ((long)fontIndex & 0xFL) << 16;
                                break;
                            }
                            case 124: {
                                int lookupColor = this.colorLookup.getRgba(Font.safeSubstring(markup, i + 1, i + len2)) & 0xFFFFFFFE;
                                color = lookupColor == 256 ? baseColor : (long)lookupColor << 32;
                                current = current & 0xFFFFFFFFL | color;
                                break;
                            }
                            default: {
                                int gdxColor = this.colorLookup.getRgba(Font.safeSubstring(markup, i, i + len2)) & 0xFFFFFFFE;
                                color = gdxColor == 256 ? baseColor : (long)gdxColor << 32;
                                current = current & 0xFFFFFFFFL | color;
                            }
                        }
                        i += len2;
                        continue;
                    }
                }
                if (c == 43 && font.nameLookup != null && (len = markup.indexOf(93, i) - i) >= 0) {
                    c = font.nameLookup.get(Font.safeSubstring(markup, i + 1, i + len), 43);
                }
                if (c == 91) {
                    return current | 2L;
                }
                return current | (long)c;
            }
            char ch = markup.charAt(i);
            if (Font.isLowerCase(ch)) {
                if (capitalize || capsLock) {
                    ch = Category.caseUp(ch);
                }
            } else if (Font.isUpperCase(ch) && lowerCase) {
                ch = Category.caseDown(ch);
            }
            return current | (long)ch;
        }
        return current | 0x20L;
    }

    public static long markupGlyph(char chr, String markup, ColorLookup colorLookup) {
        return Font.markupGlyph(chr, markup, colorLookup, null);
    }

    public static long markupGlyph(char chr, String markup, ColorLookup colorLookup, FontFamily family) {
        long baseColor;
        long color;
        boolean capsLock = false;
        boolean lowerCase = false;
        long COLOR_MASK = -4294967296L;
        long current = color = (baseColor = 0xFFFFFFFE00000000L | (long)chr);
        int n = markup.length();
        block15: for (int i = 0; i < n; ++i) {
            char c;
            if (markup.charAt(i) != '[' || ++i >= n || (c = markup.charAt(i)) == '[') continue;
            if (c == ']') {
                current = color = baseColor;
                capsLock = false;
                lowerCase = false;
                continue;
            }
            int len = markup.indexOf(93, i) - i;
            if (len < 0) break;
            switch (c) {
                case '*': {
                    current ^= 0x40000000L;
                    continue block15;
                }
                case '/': {
                    current ^= 0x20000000L;
                    continue block15;
                }
                case '^': {
                    if ((current & 0x6000000L) == 0x6000000L) {
                        current &= 0xFFFFFFFFF9FFFFFFL;
                        continue block15;
                    }
                    current |= 0x6000000L;
                    continue block15;
                }
                case '.': {
                    if ((current & 0x6000000L) == 0x2000000L) {
                        current &= 0xFFFFFFFFFDFFFFFFL;
                        continue block15;
                    }
                    current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                    continue block15;
                }
                case '=': {
                    if ((current & 0x6000000L) == 0x4000000L) {
                        current &= 0xFFFFFFFFFBFFFFFFL;
                        continue block15;
                    }
                    current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                    continue block15;
                }
                case '_': {
                    current ^= 0x10000000L;
                    continue block15;
                }
                case '~': {
                    current ^= 0x8000000L;
                    continue block15;
                }
                case '!': 
                case ';': {
                    capsLock = !capsLock;
                    lowerCase = false;
                    continue block15;
                }
                case ',': {
                    lowerCase = !lowerCase;
                    capsLock = false;
                    continue block15;
                }
                case '%': {
                    if (len >= 2) {
                        if (markup.charAt(i + 1) == '?' || markup.charAt(i + 1) == '^') {
                            long modes;
                            long l = modes = markup.charAt(i + 1) == '^' ? 0x1100000L : 0x1000000L;
                            if (len >= 5) {
                                char ch = Category.caseUp(markup.charAt(i + 2));
                                if (ch == 'B') {
                                    modes |= 0x1200000L;
                                } else if (ch == 'W') {
                                    modes = Category.caseUp(markup.charAt(i + 3)) == 'H' ? (modes |= 0x1400000L) : (modes |= 0x1C00000L);
                                } else if (ch == 'S') {
                                    if (Category.caseUp(markup.charAt(i + 4)) == 'I') {
                                        modes |= 0x1800000L;
                                    } else if (Category.caseUp(markup.charAt(i + 3)) == 'H') {
                                        modes |= 0x1600000L;
                                    }
                                } else if (ch == 'D') {
                                    modes |= 0x1600000L;
                                } else if (ch == 'E') {
                                    modes |= 0x1A00000L;
                                } else if (ch == 'N') {
                                    modes |= 0x1E00000L;
                                }
                            }
                            current = current & (0xFFFFFFFFFE0FFFFFL ^ (current & 0x1000000L) >>> 4) ^ modes;
                            continue block15;
                        }
                        current = current & 0xFFFFFFFFFE0FFFFFL | (long)((((Font.intFromDec(markup, i + 1, i + len) - 24) / 25 & 0xF) - 3 & 0xF) << 20);
                        continue block15;
                    }
                    current &= 0xFFFFFFFFFE0FFFFFL;
                    continue block15;
                }
                case '@': {
                    if (family == null) continue block15;
                    int fontIndex = family.fontAliases.get(Font.safeSubstring(markup, i + 1, i + len), 0);
                    current = current & 0xFFFFFFFFFFF0FFFFL | ((long)fontIndex & 0xFL) << 16;
                    continue block15;
                }
                case '#': {
                    color = len >= 7 && len < 9 ? Font.longFromHex(markup, i + 1, i + 7) << 40 | 0xFE00000000L : (len >= 9 ? Font.longFromHex(markup, i + 1, i + 9) << 32 & 0xFFFFFFFE00000000L : baseColor);
                    current = current & 0xFFFFFFFFL | color;
                    continue block15;
                }
                case '|': {
                    int lookupColor = colorLookup.getRgba(Font.safeSubstring(markup, i + 1, i + len)) & 0xFFFFFFFE;
                    color = lookupColor == 256 ? baseColor : (long)lookupColor << 32;
                    current = current & 0xFFFFFFFFL | color;
                    continue block15;
                }
                default: {
                    int gdxColor = colorLookup.getRgba(Font.safeSubstring(markup, i, i + len)) & 0xFFFFFFFE;
                    color = gdxColor == 256 ? baseColor : (long)gdxColor << 32;
                    current = current & 0xFFFFFFFFL | color;
                }
            }
        }
        return current;
    }

    public Layout regenerateLayout(Layout changing) {
        if (changing.font == null) {
            return changing;
        }
        if (!changing.font.equals(this)) {
            changing.font = this;
        }
        Font font = null;
        float targetWidth = changing.getTargetWidth();
        int oldLength = changing.lines.size;
        Line firstLine = changing.getLine(0);
        for (int i = 1; i < oldLength; ++i) {
            firstLine.glyphs.addAll(changing.getLine((int)i).glyphs);
        }
        changing.lines.truncate(1);
        block1: for (int ln = 0; ln < changing.lines(); ++ln) {
            Line line = changing.getLine(ln);
            line.height = 0.0f;
            float drawn = 0.0f;
            int breakPoint = -2;
            int spacingPoint = -2;
            int spacingSpan = 0;
            LongArray glyphs = line.glyphs;
            int kern = -1;
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                long[] arr;
                int nextSize;
                int cutoff;
                float ox;
                float changedW;
                GlyphRegion tr;
                Line next;
                float scaleX;
                int scale;
                long glyph = glyphs.get(i);
                char ch = (char)glyph;
                if ((glyph & 0x1100000L) == 0x1100000L) {
                    ch = Category.caseUp(ch);
                }
                if (this.family != null) {
                    font = this.family.connected[(int)(glyph >>> 16 & 0xFL)];
                }
                if (font == null) {
                    font = this;
                }
                if (font.kerning == null) {
                    scale = (int)((glyph & 0x1000000L) != 0L ? 3L : glyph + 0x300000L >>> 20 & 0xFL);
                    line.height = Math.max(line.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                    scaleX = ch >= '\ue000' && ch < '\uf800' ? (float)(scale + 1) * 0.25f * font.cellHeight / font.mapping.get((int)ch, (GlyphRegion)font.defaultValue).xAdvance : font.scaleX * (float)(scale + 1) * 0.25f;
                    if (ch == '\n') {
                        next = changing.pushLine();
                        glyphs.pop();
                        if (next == null) {
                            if (!this.handleEllipsis(changing)) continue block1;
                            this.calculateSize(changing);
                            return changing;
                        }
                        next.height = Math.max(next.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                        long[] arr2 = next.glyphs.setSize(glyphs.size - i - 1);
                        System.arraycopy(glyphs.items, i + 1, arr2, 0, glyphs.size - i - 1);
                        glyphs.truncate(i);
                        glyphs.add(10L);
                        continue block1;
                    }
                    tr = font.mapping.get(ch);
                    if (tr == null) continue;
                    changedW = Font.xAdvance(font, scaleX, glyph);
                    if (i == 0 && (ox = tr.offsetX * scaleX) < 0.0f) {
                        changedW -= ox;
                    }
                    if (breakPoint >= 0 && drawn + changedW > targetWidth) {
                        Line next2;
                        cutoff = breakPoint - spacingSpan + 1;
                        if (changing.lines() == ln + 1) {
                            next2 = changing.pushLine();
                            glyphs.pop();
                        } else {
                            next2 = changing.getLine(ln + 1);
                        }
                        if (next2 == null) {
                            glyphs.truncate(cutoff);
                            if (!this.handleEllipsis(changing)) continue block1;
                            this.calculateSize(changing);
                            return changing;
                        }
                        next2.height = Math.max(next2.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                        nextSize = next2.glyphs.size;
                        arr = next2.glyphs.setSize(nextSize + glyphs.size - cutoff);
                        System.arraycopy(arr, 0, arr, glyphs.size - cutoff, nextSize);
                        System.arraycopy(glyphs.items, cutoff, arr, 0, glyphs.size - cutoff);
                        glyphs.truncate(cutoff);
                        continue block1;
                    }
                    if (glyph >>> 32 == 0L) {
                        breakPoint = i;
                        spacingSpan = spacingPoint + 1 < i ? 0 : ++spacingSpan;
                        spacingPoint = i;
                    } else if (Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)glyph) >= 0) {
                        breakPoint = i;
                        if (Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)glyph) >= 0) {
                            spacingSpan = spacingPoint + 1 < i ? 0 : ++spacingSpan;
                            spacingPoint = i;
                        }
                    }
                    drawn += changedW;
                    continue;
                }
                scale = (int)((glyph & 0x1000000L) != 0L ? 3L : glyph + 0x300000L >>> 20 & 0xFL);
                line.height = Math.max(line.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                scaleX = ch >= '\ue000' && ch < '\uf800' ? (float)(scale + 1) * 0.25f * font.cellHeight / font.mapping.get((int)ch, (GlyphRegion)font.defaultValue).xAdvance : font.scaleX * (float)(scale + 1) * 0.25f;
                kern = kern << 16 | ch;
                float amt = font.kerning.get(kern, 0.0f) * scaleX;
                if (ch == '\n') {
                    next = changing.pushLine();
                    glyphs.pop();
                    if (next == null) {
                        if (!this.handleEllipsis(changing)) continue block1;
                        this.calculateSize(changing);
                        return changing;
                    }
                    next.height = Math.max(next.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                    long[] arr3 = next.glyphs.setSize(glyphs.size - i - 1);
                    System.arraycopy(glyphs.items, i + 1, arr3, 0, glyphs.size - i - 1);
                    glyphs.truncate(i);
                    glyphs.add(10L);
                    continue block1;
                }
                tr = font.mapping.get(ch);
                if (tr == null) continue;
                changedW = Font.xAdvance(font, scaleX, glyph);
                if (i == 0 && (ox = tr.offsetX * scaleX) < 0.0f) {
                    changedW -= ox;
                }
                if (breakPoint >= 0 && drawn + changedW + amt > targetWidth) {
                    Line next3;
                    cutoff = breakPoint - spacingSpan + 1;
                    if (changing.lines() == ln + 1) {
                        next3 = changing.pushLine();
                        glyphs.pop();
                    } else {
                        next3 = changing.getLine(ln + 1);
                    }
                    if (next3 == null) {
                        glyphs.truncate(cutoff);
                        if (!this.handleEllipsis(changing)) continue block1;
                        this.calculateSize(changing);
                        return changing;
                    }
                    next3.height = Math.max(next3.height, font.cellHeight * (float)(scale + 1) * 0.25f);
                    nextSize = next3.glyphs.size;
                    arr = next3.glyphs.setSize(nextSize + glyphs.size - cutoff);
                    System.arraycopy(arr, 0, arr, glyphs.size - cutoff, nextSize);
                    System.arraycopy(glyphs.items, cutoff, arr, 0, glyphs.size - cutoff);
                    glyphs.truncate(cutoff);
                    continue block1;
                }
                if (glyph >>> 32 == 0L) {
                    breakPoint = i;
                    spacingSpan = spacingPoint + 1 < i ? 0 : ++spacingSpan;
                    spacingPoint = i;
                } else if (Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)glyph) >= 0) {
                    breakPoint = i;
                    if (Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)glyph) >= 0) {
                        spacingSpan = spacingPoint + 1 < i ? 0 : ++spacingSpan;
                        spacingPoint = i;
                    }
                }
                drawn += changedW + amt;
            }
        }
        this.calculateSize(changing);
        return changing;
    }

    public Font setFamily(FontFamily family) {
        this.family = family;
        return this;
    }

    public void resizeDistanceField(int width, int height) {
        if (this.distanceField == DistanceFieldType.SDF) {
            this.actualCrispness = Gdx.graphics.getBackBufferWidth() == 0 || Gdx.graphics.getBackBufferHeight() == 0 ? this.distanceFieldCrispness : this.distanceFieldCrispness * (float)Math.pow(4.0, Math.max((float)width / (float)Gdx.graphics.getBackBufferWidth(), (float)height / (float)Gdx.graphics.getBackBufferHeight()) * 1.9f - 2.0f + this.cellHeight * 0.005f);
        } else if (this.distanceField == DistanceFieldType.MSDF) {
            this.actualCrispness = Gdx.graphics.getBackBufferWidth() == 0 || Gdx.graphics.getBackBufferHeight() == 0 ? this.distanceFieldCrispness : this.distanceFieldCrispness * (float)Math.pow(8.0, Math.max((float)width / (float)Gdx.graphics.getBackBufferWidth(), (float)height / (float)Gdx.graphics.getBackBufferHeight()) * 1.9f - 2.15f + this.cellHeight * 0.01f);
        }
    }

    public static int extractColor(long glyph) {
        return (int)(glyph >>> 32);
    }

    public static long applyColor(long glyph, int color) {
        return glyph & 0xFFFFFFFFL | (long)color << 32 & 0xFFFFFFFE00000000L;
    }

    public static long extractStyle(long glyph) {
        return glyph & 0x7E000000L;
    }

    public static long applyStyle(long glyph, long style) {
        return glyph & 0xFFFFFFFF81FFFFFFL | style & 0x7E000000L;
    }

    public static float extractScale(long glyph) {
        return (glyph & 0x1000000L) != 0L ? 1.0f : (float)(glyph + 0x400000L >>> 20 & 0xFL) * 0.25f;
    }

    public static long applyScale(long glyph, float scale) {
        return glyph & 0xFFFFFFFFFE0FFFFFL | ((long)Math.floor((double)scale * 4.0 - 4.0) & 0xFL) << 20;
    }

    public static long extractMode(long glyph) {
        return (glyph & 0x1000000L) == 0L ? 0L : glyph & 0x1F00000L;
    }

    public static long applyMode(long glyph, long modeFlags) {
        return glyph & 0xFFFFFFFFFE0FFFFFL | 0x1F00000L & modeFlags;
    }

    public static char extractChar(long glyph) {
        char c = (char)glyph;
        return c == '\u0002' ? (char)'[' : (char)c;
    }

    public static long applyChar(long glyph, char c) {
        return glyph & 0xFFFFFFFFFFFF0000L | (long)c;
    }

    @Override
    public void dispose() {
        if (this.shader != null) {
            this.shader.dispose();
        }
        if (this.whiteBlock != null) {
            this.whiteBlock.dispose();
        }
    }

    public static void clearStatic() {
        TypingConfig.GLOBAL_VARS.clear();
    }

    public String toString() {
        return "Font '" + this.name + "' at scale " + this.scaleX + " by " + this.scaleY;
    }

    protected void drawVertices(Batch batch, Texture texture, float[] vertices) {
        batch.draw(texture, vertices, 0, 20);
    }

    public static enum DistanceFieldType {
        STANDARD,
        SDF,
        MSDF;

    }

    public static class GlyphRegion
    extends TextureRegion {
        public float offsetX;
        public float offsetY;
        public float xAdvance;

        public GlyphRegion(TextureRegion textureRegion) {
            this(textureRegion, 0.0f, 0.0f, textureRegion.getRegionWidth());
        }

        public GlyphRegion(TextureAtlas.AtlasRegion atlasRegion) {
            this(atlasRegion, atlasRegion.offsetX, atlasRegion.offsetY, atlasRegion.originalWidth);
        }

        public GlyphRegion(TextureRegion textureRegion, float offsetX, float offsetY, float xAdvance) {
            super(textureRegion);
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.xAdvance = xAdvance;
        }

        public GlyphRegion(TextureRegion textureRegion, float x, float y, float width, float height) {
            super(textureRegion, Math.round(x), Math.round(y), Math.round(width), Math.round(height));
            this.offsetX = 0.0f;
            this.offsetY = 0.0f;
            this.xAdvance = width;
        }

        public GlyphRegion(GlyphRegion other) {
            super(other);
            this.offsetX = other.offsetX;
            this.offsetY = other.offsetY;
            this.xAdvance = other.xAdvance;
        }

        @Override
        public void flip(boolean x, boolean y) {
            super.flip(x, y);
            if (x) {
                this.offsetX = -this.offsetX;
                this.xAdvance = -this.xAdvance;
            }
            if (y) {
                this.offsetY = -this.offsetY;
            }
        }
    }

    public static class FontFamily {
        public final Font[] connected = new Font[16];
        public final CaseInsensitiveIntMap fontAliases = new CaseInsensitiveIntMap(48);

        public FontFamily() {
        }

        public FontFamily(Font[] fonts) {
            this(fonts, 0, fonts.length);
        }

        public FontFamily(Font[] fonts, int offset, int length) {
            if (fonts == null || fonts.length == 0) {
                return;
            }
            int i = offset;
            int a = 0;
            while (i < length && i < fonts.length) {
                if (fonts[i] != null) {
                    this.connected[a & 0xF] = fonts[i];
                    if (fonts[i].name != null) {
                        this.fontAliases.put(fonts[i].name, a & 0xF);
                    }
                    this.fontAliases.put(String.valueOf(a & 0xF), a & 0xF);
                }
                ++i;
                ++a;
            }
        }

        public FontFamily(String[] aliases, Font[] fonts) {
            this(aliases, fonts, 0, Math.min(aliases.length, fonts.length));
        }

        public FontFamily(String[] aliases, Font[] fonts, int offset, int length) {
            if (aliases == null || fonts == null || (aliases.length & fonts.length) == 0) {
                return;
            }
            int i = offset;
            int a = 0;
            while (i < length && i < aliases.length && i < fonts.length) {
                if (fonts[i] != null) {
                    this.connected[a & 0xF] = fonts[i];
                    this.fontAliases.put(aliases[i], a & 0xF);
                    if (fonts[i].name != null) {
                        this.fontAliases.put(fonts[i].name, a & 0xF);
                    }
                    this.fontAliases.put(String.valueOf(a & 0xF), a & 0xF);
                }
                ++i;
                ++a;
            }
        }

        public FontFamily(OrderedMap<String, Font> map) {
            Array<String> ks = map.orderedKeys();
            for (int i = 0; i < map.size && i < 16; ++i) {
                String name = ks.get(i);
                this.connected[i] = (Font)map.get(name);
                if (this.connected[i] == null) continue;
                this.fontAliases.put(name, i);
                this.fontAliases.put(this.connected[i].name, i);
                this.fontAliases.put(String.valueOf(i), i);
            }
        }

        public FontFamily(Skin skin) {
            ObjectMap<String, BitmapFont> map = skin.getAll(BitmapFont.class);
            Array<String> keys = map.keys().toArray();
            for (int i = 0; i < map.size && i < 16; ++i) {
                String name = keys.get(i);
                Font font = new Font(map.get(name));
                font.name = name;
                font.family = this;
                this.connected[i] = font;
                this.fontAliases.put(name, i);
                this.fontAliases.put(this.connected[i].name, i);
                this.fontAliases.put(String.valueOf(i), i);
            }
        }

        public FontFamily(FontFamily other) {
            System.arraycopy(other.connected, 0, this.connected, 0, 16);
            this.fontAliases.putAll(other.fontAliases);
        }

        public Font get(String name) {
            if (name == null) {
                return null;
            }
            return this.connected[this.fontAliases.get(name, 0) & 0xF];
        }
    }
}

