/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.github.tommyettinger.textra.Parser;
import com.github.tommyettinger.textra.TypingLabel;

public abstract class Effect {
    private static final float FADEOUT_SPLIT = 0.25f;
    protected final TypingLabel label;
    public int indexStart = -1;
    public int indexEnd = -1;
    public float duration = Float.POSITIVE_INFINITY;
    protected float totalTime;

    public Effect(TypingLabel label) {
        this.label = label;
    }

    public void update(float delta) {
        this.totalTime += delta;
    }

    public final void apply(long glyph, int glyphIndex, float delta) {
        int localIndex = glyphIndex - this.indexStart;
        this.onApply(glyph, localIndex, glyphIndex, delta);
    }

    protected abstract void onApply(long var1, int var3, int var4, float var5);

    public boolean isFinished() {
        return this.duration < 0.0f || this.totalTime > this.duration;
    }

    protected float calculateFadeout() {
        if (this.duration < 0.0f || this.duration == Float.POSITIVE_INFINITY) {
            return 1.0f;
        }
        float progress = MathUtils.clamp(this.totalTime / this.duration, 0.0f, 1.0f);
        if (progress < 0.25f) {
            return 1.0f;
        }
        return Interpolation.smooth.apply(1.0f, 0.0f, (progress - 0.25f) / 0.75f);
    }

    protected float calculateProgress(float modifier) {
        return this.calculateProgress(modifier, 0.0f, true);
    }

    protected float calculateProgress(float modifier, float offset) {
        return this.calculateProgress(modifier, offset, true);
    }

    protected float calculateProgress(float modifier, float offset, boolean pingpong) {
        float progress;
        for (progress = this.totalTime / modifier + offset; progress < 0.0f; progress += 2.0f) {
        }
        if (pingpong) {
            if ((progress %= 2.0f) > 1.0f) {
                progress = 1.0f - (progress - 1.0f);
            }
        } else {
            progress %= 1.0f;
        }
        progress = MathUtils.clamp(progress, 0.0f, 1.0f);
        return progress;
    }

    protected float paramAsFloat(String str, float defaultValue) {
        return Parser.stringToFloat(str, defaultValue);
    }

    protected boolean paramAsBoolean(String str) {
        return Parser.stringToBoolean(str);
    }

    protected int paramAsColor(String str) {
        return Parser.stringToColor(this.label, str);
    }
}

