/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectCollectionSchema;
import org.gradle.api.Namer;
import org.gradle.api.Rule;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.tasks.DefaultTaskCollection;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.type.ModelType;

public class DefaultRealizableTaskCollection<T extends Task>
implements TaskCollection<T>,
TaskDependencyContainer {
    private final TaskCollection<T> delegate;
    private final Class<T> type;
    private final AtomicBoolean realized = new AtomicBoolean();
    private final MutableModelNode modelNode;
    private final Instantiator instantiator;

    public DefaultRealizableTaskCollection(Class<T> type, TaskCollection<T> delegate, MutableModelNode modelNode, Instantiator instantiator) {
        assert (!(delegate instanceof DefaultRealizableTaskCollection)) : "Attempt to wrap already realizable task collection in realizable wrapper: " + delegate;
        this.delegate = delegate;
        this.type = type;
        this.modelNode = modelNode;
        this.instantiator = instantiator;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        if (this.modelNode != null && this.realized.compareAndSet(false, true)) {
            this.modelNode.ensureAtLeast(ModelNode.State.SelfClosed);
            for (MutableModelNode node : this.modelNode.getLinks(ModelType.of(this.type))) {
                node.ensureAtLeast(ModelNode.State.GraphClosed);
            }
        }
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            Task t = (Task)iterator.next();
            context.add((Object)t);
        }
    }

    private <S extends T> TaskCollection<S> realizable(Class<S> type, TaskCollection<S> collection) {
        return (TaskCollection)Cast.uncheckedCast((Object)this.instantiator.newInstance(DefaultRealizableTaskCollection.class, new Object[]{type, collection, this.modelNode, this.instantiator}));
    }

    public TaskCollection<T> matching(Spec<? super T> spec) {
        return this.realizable(this.type, this.delegate.matching(spec));
    }

    public TaskCollection<T> matching(Closure closure) {
        return this.realizable(this.type, this.delegate.matching(closure));
    }

    public T getByName(String name, Closure configureClosure) throws UnknownTaskException {
        return (T)this.delegate.getByName(name, configureClosure);
    }

    public T getByName(String name, Action<? super T> configureAction) throws UnknownTaskException {
        return (T)((Task)this.delegate.getByName(name, configureAction));
    }

    public T getByName(String name) throws UnknownTaskException {
        return (T)this.delegate.getByName(name);
    }

    public <S extends T> TaskCollection<S> withType(Class<S> type) {
        return this.realizable(type, this.delegate.withType(type));
    }

    public Action<? super T> whenTaskAdded(Action<? super T> action) {
        return this.delegate.whenTaskAdded(action);
    }

    public void whenTaskAdded(Closure closure) {
        this.delegate.whenTaskAdded(closure);
    }

    public T getAt(String name) throws UnknownTaskException {
        return (T)this.delegate.getAt(name);
    }

    public Set<T> findAll(Closure spec) {
        return this.delegate.findAll(spec);
    }

    public boolean add(T e) {
        return this.delegate.add(e);
    }

    public void addLater(Provider<? extends T> provider) {
        this.delegate.addLater(provider);
    }

    public void addAllLater(Provider<? extends Iterable<T>> provider) {
        this.delegate.addAllLater(provider);
    }

    public boolean addAll(Collection<? extends T> c) {
        return this.delegate.addAll(c);
    }

    public Namer<T> getNamer() {
        return this.delegate.getNamer();
    }

    public SortedMap<String, T> getAsMap() {
        return this.delegate.getAsMap();
    }

    public SortedSet<String> getNames() {
        return this.delegate.getNames();
    }

    public T findByName(String name) {
        return (T)((Task)this.delegate.findByName(name));
    }

    public Rule addRule(Rule rule) {
        return this.delegate.addRule(rule);
    }

    public Rule addRule(String description, Closure ruleAction) {
        return this.delegate.addRule(description, ruleAction);
    }

    public Rule addRule(String description, Action<String> ruleAction) {
        return this.delegate.addRule(description, ruleAction);
    }

    public List<Rule> getRules() {
        return this.delegate.getRules();
    }

    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Action<? super S> configureAction) {
        return this.realizable(type, (DefaultTaskCollection)this.delegate.withType(type, configureAction));
    }

    public <S extends T> DomainObjectCollection<S> withType(Class<S> type, Closure configureClosure) {
        return this.realizable(type, (DefaultTaskCollection)this.delegate.withType(type, configureClosure));
    }

    public Action<? super T> whenObjectAdded(Action<? super T> action) {
        return this.delegate.whenObjectAdded(action);
    }

    public void whenObjectAdded(Closure action) {
        this.delegate.whenObjectAdded(action);
    }

    public Action<? super T> whenObjectRemoved(Action<? super T> action) {
        return this.delegate.whenObjectRemoved(action);
    }

    public void whenObjectRemoved(Closure action) {
        this.delegate.whenObjectRemoved(action);
    }

    public void all(Action<? super T> action) {
        this.delegate.all(action);
    }

    public void all(Closure action) {
        this.delegate.all(action);
    }

    public void configureEach(Action<? super T> action) {
        this.delegate.configureEach(action);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    public Iterator<T> iterator() {
        return this.delegate.iterator();
    }

    public Object[] toArray() {
        return this.delegate.toArray();
    }

    public <R> R[] toArray(R[] a) {
        return this.delegate.toArray((Object[])a);
    }

    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    public void clear() {
        this.delegate.clear();
    }

    public TaskProvider<T> named(String name) throws InvalidUserDataException {
        return this.delegate.named(name);
    }

    public TaskProvider<T> named(String name, Action<? super T> configurationAction) throws UnknownTaskException {
        return this.delegate.named(name, configurationAction);
    }

    public <S extends T> TaskProvider<S> named(String name, Class<S> type) throws UnknownTaskException {
        return this.delegate.named(name, type);
    }

    public <S extends T> TaskProvider<S> named(String name, Class<S> type, Action<? super S> configurationAction) throws UnknownTaskException {
        return this.delegate.named(name, type, configurationAction);
    }

    public NamedDomainObjectCollectionSchema getCollectionSchema() {
        return this.delegate.getCollectionSchema();
    }
}

