/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J,\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\rH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/AssigningNamedArgumentToVarargChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkAssignmentOfSingleElementInAnnotation", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "checkAssignmentOfSingleElementInFunction", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "checkAssignmentOfSingleElementToVararg", "hasSpread", "", "frontend"})
public final class AssigningNamedArgumentToVarargChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"resolvedCall.valueArguments");
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : map.entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            for (ValueArgument argument2 : resolvedArgument.getArguments()) {
                Intrinsics.checkNotNullExpressionValue((Object)argument2, (String)"argument");
                Intrinsics.checkNotNullExpressionValue((Object)parameterDescriptor, (String)"parameterDescriptor");
                this.checkAssignmentOfSingleElementToVararg(argument2, parameterDescriptor, context.getResolutionContext());
            }
        }
    }

    private final void checkAssignmentOfSingleElementToVararg(ValueArgument argument2, ValueParameterDescriptor parameterDescriptor, ResolutionContext<?> context) {
        if (!context.languageVersionSettings.supportsFeature(LanguageFeature.AssigningArraysToVarargsInNamedFormInAnnotations)) {
            return;
        }
        if (!argument2.isNamed()) {
            return;
        }
        if (!ArgumentsUtilsKt.isVararg(parameterDescriptor)) {
            return;
        }
        KtExpression ktExpression = argument2.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        if (DescriptorUtilsKt.isParameterOfAnnotation(parameterDescriptor)) {
            this.checkAssignmentOfSingleElementInAnnotation(argument2, argumentExpression, context);
        } else {
            this.checkAssignmentOfSingleElementInFunction(argument2, argumentExpression, context, parameterDescriptor);
        }
    }

    private final void checkAssignmentOfSingleElementInAnnotation(ValueArgument argument2, KtExpression argumentExpression, ResolutionContext<?> context) {
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
        if (CallResolverUtilKt.isArrayOrArrayLiteral(argument2, bindingTrace)) {
            if (this.hasSpread(argument2)) {
                context.trace.report(Errors.REDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_ANNOTATION.on((KtExpression)((PsiElement)argumentExpression)));
            }
        } else {
            BindingTrace bindingTrace2 = context.trace;
            LanguageVersionSettings languageVersionSettings = context.languageVersionSettings;
            Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"context.languageVersionSettings");
            bindingTrace2.report(Errors.ASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_ANNOTATION.on(languageVersionSettings, (KtExpression)((PsiElement)argumentExpression)));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void checkAssignmentOfSingleElementInFunction(ValueArgument argument2, KtExpression argumentExpression, ResolutionContext<?> context, ValueParameterDescriptor parameterDescriptor) {
        if (context.languageVersionSettings.supportsFeature(LanguageFeature.AllowAssigningArrayElementsToVarargsInNamedFormForFunctions)) {
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"context.trace");
            if (CallResolverUtilKt.isArrayOrArrayLiteral(argument2, bindingTrace)) {
                if (!this.hasSpread(argument2)) return;
                context.trace.report(Errors.REDUNDANT_SPREAD_OPERATOR_IN_NAMED_FORM_IN_FUNCTION.on((KtExpression)((PsiElement)argumentExpression)));
                return;
            }
        }
        if (this.hasSpread(argument2)) return;
        BindingTrace bindingTrace = context.trace;
        LanguageVersionSettings languageVersionSettings = context.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"context.languageVersionSettings");
        bindingTrace.report(Errors.ASSIGNING_SINGLE_ELEMENT_TO_VARARG_IN_NAMED_FORM_FUNCTION.on(languageVersionSettings, (KtExpression)((PsiElement)argumentExpression), parameterDescriptor.getType()));
    }

    private final boolean hasSpread(ValueArgument $this$hasSpread) {
        return $this$hasSpread.getSpreadElement() != null;
    }
}

