/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/EnumValues;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "()V", "evaluate", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getEnumClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getListOfAcceptableFunctions", "", "", "unwind", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "ir.interpreter"})
public final class EnumValues
extends IntrinsicBase {
    @NotNull
    public static final EnumValues INSTANCE = new EnumValues();

    private EnumValues() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        return CollectionsKt.listOf((Object)"kotlin.enumValues");
    }

    private final IrClass getEnumClass(IrFunction irFunction2, IrInterpreterEnvironment environment) {
        IrClass irClass2;
        if (Intrinsics.areEqual((Object)UtilsKt.getFqName(irFunction2), (Object)"kotlin.enumValues")) {
            State state = environment.getCallStack$ir_interpreter().loadState(((IrTypeParameter)CollectionsKt.first(irFunction2.getTypeParameters())).getSymbol());
            Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
            KTypeState kType = (KTypeState)state;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(kType.getIrType());
            Intrinsics.checkNotNull((Object)irClassSymbol);
            irClass2 = (IrClass)irClassSymbol.getOwner();
        } else {
            IrDeclarationParent irDeclarationParent = irFunction2.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            irClass2 = (IrClass)irDeclarationParent;
        }
        return irClass2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Instruction> unwind(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        IrClass enumClass2 = this.getEnumClass(irFunction2, environment);
        Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enumEntries2 = (List)destination$iv$iv;
        $this$filterIsInstance$iv = CollectionsKt.reversed((Iterable)enumEntries2);
        Collection collection = super.unwind(irFunction2, environment);
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrEnumEntry irEnumEntry = (IrEnumEntry)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new SimpleInstruction((IrElement)it));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void evaluate(@NotNull IrFunction irFunction2, @NotNull IrInterpreterEnvironment environment) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        IrClass enumClass2 = this.getEnumClass(irFunction2, environment);
        Iterable $this$filterIsInstance$iv = enumClass2.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrEnumEntry irEnumEntry = (IrEnumEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(environment.getMapOfEnums$ir_interpreter().get(it.getSymbol()));
        }
        List enumEntries2 = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = enumEntries2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        environment.getCallStack$ir_interpreter().pushState(environment.convertToState$ir_interpreter(thisCollection$iv.toArray(new Complex[0]), irFunction2.getReturnType()));
    }
}

