/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.preferences.core;

import androidx.datastore.preferences.core.Actual_jvmAndroidKt;
import androidx.datastore.preferences.core.AtomicBoolean;
import androidx.datastore.preferences.core.MutablePreferences;
import androidx.datastore.preferences.core.Preferences;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B+\b\u0000\u0012\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u000eH\u0016J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0006\u0010\u0012\u001a\u00020\u0010J\u001d\u0010\u0013\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0004H\u0096\u0002J\u0013\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0096\u0002J\r\u0010\u0018\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0019J$\u0010\u001a\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0015\u0010\u001e\u001a\u00020\u00102\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0001H\u0086\u0002J\u0015\u0010\u001f\u001a\u00020\u00102\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0086\u0002J'\u0010#\u001a\u00020\u00102\u001a\u0010$\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\"0%\"\u0006\u0012\u0002\b\u00030\"\u00a2\u0006\u0002\u0010&J\u001f\u0010'\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0004\u00a2\u0006\u0002\u0010\u001bJ*\u0010(\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00042\u0006\u0010)\u001a\u0002H\u0014H\u0086\u0002\u00a2\u0006\u0002\u0010*J#\u0010+\u001a\u00020\u00102\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00042\b\u0010)\u001a\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\b,J\b\u0010-\u001a\u00020.H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006/"}, d2={"Landroidx/datastore/preferences/core/MutablePreferences;", "Landroidx/datastore/preferences/core/Preferences;", "preferencesMap", "", "Landroidx/datastore/preferences/core/Preferences$Key;", "", "startFrozen", "", "(Ljava/util/Map;Z)V", "frozen", "Landroidx/datastore/preferences/core/AtomicBoolean;", "getPreferencesMap$datastore_preferences_core", "()Ljava/util/Map;", "asMap", "", "checkNotFrozen", "", "checkNotFrozen$datastore_preferences_core", "clear", "contains", "T", "key", "equals", "other", "freeze", "freeze$datastore_preferences_core", "get", "(Landroidx/datastore/preferences/core/Preferences$Key;)Ljava/lang/Object;", "hashCode", "", "minusAssign", "plusAssign", "prefs", "pair", "Landroidx/datastore/preferences/core/Preferences$Pair;", "putAll", "pairs", "", "([Landroidx/datastore/preferences/core/Preferences$Pair;)V", "remove", "set", "value", "(Landroidx/datastore/preferences/core/Preferences$Key;Ljava/lang/Object;)V", "setUnchecked", "setUnchecked$datastore_preferences_core", "toString", "", "datastore-preferences-core"})
@SourceDebugExtension(value={"SMAP\nPreferences.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Preferences.kt\nandroidx/datastore/preferences/core/MutablePreferences\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,361:1\n1#2:362\n1179#3,2:363\n1253#3,4:365\n13579#4,2:369\n167#5,3:371\n*S KotlinDebug\n*F\n+ 1 Preferences.kt\nandroidx/datastore/preferences/core/MutablePreferences\n*L\n158#1:363,2\n158#1:365,4\n250#1:369,2\n283#1:371,3\n*E\n"})
public final class MutablePreferences
extends Preferences {
    @NotNull
    private final Map<Preferences.Key<?>, Object> preferencesMap;
    @NotNull
    private final AtomicBoolean frozen;

    public MutablePreferences(@NotNull Map<Preferences.Key<?>, Object> preferencesMap, boolean startFrozen) {
        Intrinsics.checkNotNullParameter(preferencesMap, (String)"preferencesMap");
        this.preferencesMap = preferencesMap;
        this.frozen = new AtomicBoolean(startFrozen);
    }

    public /* synthetic */ MutablePreferences(Map map, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(map, bl);
    }

    @NotNull
    public final Map<Preferences.Key<?>, Object> getPreferencesMap$datastore_preferences_core() {
        return this.preferencesMap;
    }

    public final void checkNotFrozen$datastore_preferences_core() {
        if (!(!this.frozen.get())) {
            boolean bl = false;
            String string = "Do mutate preferences once returned to DataStore.";
            throw new IllegalStateException(string.toString());
        }
    }

    public final void freeze$datastore_preferences_core() {
        this.frozen.set(true);
    }

    @Override
    public <T> boolean contains(@NotNull Preferences.Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.preferencesMap.containsKey(key);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public <T> T get(@NotNull Preferences.Key<T> key) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Object value = this.preferencesMap.get(key);
        if (value instanceof byte[]) {
            byte[] byArray2 = (byte[])value;
            byte[] byArray3 = Arrays.copyOf(byArray2, byArray2.length);
            byArray = byArray3;
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"copyOf(this, size)");
        } else {
            void var2_2;
            byArray = var2_2;
        }
        return (T)byArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Preferences.Key<?>, Object> asMap() {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = this.preferencesMap.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Pair pair;
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object value = entry.getValue();
            if (value instanceof byte[]) {
                Object k = entry.getKey();
                byte[] byArray = (byte[])value;
                byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, size)");
                pair = new Pair(k, (Object)byArray2);
            } else {
                pair = new Pair(entry.getKey(), entry.getValue());
            }
            Pair pair2 = pair;
            map.put(pair2.getFirst(), pair2.getSecond());
        }
        return Actual_jvmAndroidKt.immutableMap(destination$iv$iv);
    }

    public final <T> void set(@NotNull Preferences.Key<T> key, T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.setUnchecked$datastore_preferences_core(key, value);
    }

    public final void setUnchecked$datastore_preferences_core(@NotNull Preferences.Key<?> key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.checkNotFrozen$datastore_preferences_core();
        Object object = value;
        if (object == null) {
            this.remove(key);
        } else if (object instanceof Set) {
            this.preferencesMap.put(key, Actual_jvmAndroidKt.immutableCopyOfSet((Set)value));
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])value;
            byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(this, size)");
            this.preferencesMap.put(key, byArray2);
        } else {
            this.preferencesMap.put(key, value);
        }
    }

    public final void plusAssign(@NotNull Preferences prefs) {
        Intrinsics.checkNotNullParameter((Object)prefs, (String)"prefs");
        this.checkNotFrozen$datastore_preferences_core();
        this.preferencesMap.putAll(prefs.asMap());
    }

    public final void plusAssign(@NotNull Preferences.Pair<?> pair) {
        Intrinsics.checkNotNullParameter(pair, (String)"pair");
        this.checkNotFrozen$datastore_preferences_core();
        Preferences.Pair[] pairArray = new Preferences.Pair[]{pair};
        this.putAll(pairArray);
    }

    public final void minusAssign(@NotNull Preferences.Key<?> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.checkNotFrozen$datastore_preferences_core();
        this.remove(key);
    }

    public final void putAll(Preferences.Pair<?> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.checkNotFrozen$datastore_preferences_core();
        Preferences.Pair<?>[] $this$forEach$iv = pairs;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Preferences.Pair<?> element$iv;
            Preferences.Pair<?> it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.setUnchecked$datastore_preferences_core(it.getKey$datastore_preferences_core(), it.getValue$datastore_preferences_core());
        }
    }

    public final <T> T remove(@NotNull Preferences.Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.checkNotFrozen$datastore_preferences_core();
        return (T)this.preferencesMap.remove(key);
    }

    public final void clear() {
        this.checkNotFrozen$datastore_preferences_core();
        this.preferencesMap.clear();
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        block8: {
            if (!(other instanceof MutablePreferences)) {
                return false;
            }
            if (((MutablePreferences)other).preferencesMap == this.preferencesMap) {
                return true;
            }
            if (((MutablePreferences)other).preferencesMap.size() != this.preferencesMap.size()) {
                return false;
            }
            Map<Preferences.Key<?>, Object> $this$all$iv = ((MutablePreferences)other).preferencesMap;
            boolean $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                bl = true;
            } else {
                Iterator<Map.Entry<Preferences.Key<?>, Object>> iterator = $this$all$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    boolean bl2;
                    Map.Entry<Preferences.Key<?>, Object> element$iv;
                    Map.Entry<Preferences.Key<?>, Object> otherEntry = element$iv = iterator.next();
                    boolean bl3 = false;
                    if (this.preferencesMap.get(otherEntry.getKey()) != null) {
                        Object value;
                        boolean bl4 = false;
                        Object otherVal = otherEntry.getValue();
                        bl2 = otherVal instanceof byte[] ? value instanceof byte[] && Arrays.equals((byte[])otherVal, (byte[])value) : Intrinsics.areEqual((Object)otherVal, (Object)value);
                    } else {
                        bl2 = false;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        Iterable iterable = this.preferencesMap.entrySet();
        int n = 0;
        for (Object t : iterable) {
            void entry;
            Map.Entry entry2 = (Map.Entry)t;
            int n2 = n;
            boolean bl = false;
            Object value = entry.getValue();
            int n3 = value instanceof byte[] ? Arrays.hashCode((byte[])value) : value.hashCode();
            n = n2 + n3;
        }
        return n;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.preferencesMap.entrySet(), (CharSequence)",\n", (CharSequence)"{\n", (CharSequence)"\n}", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
    }

    public MutablePreferences() {
        this(null, false, 3, null);
    }
}

