/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.animatedimage;

import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.animation.core.DurationBasedAnimationSpec;
import androidx.compose.animation.core.InfiniteRepeatableSpec;
import androidx.compose.animation.core.InfiniteTransition;
import androidx.compose.animation.core.InfiniteTransitionKt;
import androidx.compose.animation.core.KeyframesSpec;
import androidx.compose.animation.core.TwoWayConverter;
import androidx.compose.animation.core.VectorConvertersKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.State;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.SkiaImageAsset_skikoKt;
import java.net.MalformedURLException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.animatedimage.AnimatedImage;
import org.jetbrains.compose.animatedimage.AnimatedImageKt;
import org.jetbrains.compose.animatedimage.AnimatedImageLoader;
import org.jetbrains.compose.animatedimage.LocalAnimatedImageLoader;
import org.jetbrains.compose.animatedimage.NetworkAnimatedImageLoader;
import org.jetbrains.compose.animatedimage.ResourceAnimatedImageLoader;
import org.jetbrains.skia.AnimationFrameInfo;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Codec;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0086@\u00a2\u0006\u0002\u0010\u0006\u001a\u0011\u0010\b\u001a\u00020\t*\u00020\u0003H\u0007\u00a2\u0006\u0002\u0010\n\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012\u00b2\u0006\n\u0010\u0013\u001a\u00020\u0001X\u008a\u0084\u0002"}, d2={"DEFAULT_FRAME_DURATION", "", "loadAnimatedImage", "Lorg/jetbrains/compose/animatedimage/AnimatedImage;", "path", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadResourceAnimatedImage", "animate", "Landroidx/compose/ui/graphics/ImageBitmap;", "(Lorg/jetbrains/compose/animatedimage/AnimatedImage;Landroidx/compose/runtime/Composer;I)Landroidx/compose/ui/graphics/ImageBitmap;", "calcFrameDuration", "frame", "Lorg/jetbrains/skia/AnimationFrameInfo;", "getAnimatedImageLoaderByPath", "Lorg/jetbrains/compose/animatedimage/AnimatedImageLoader;", "isNetworkPath", "", "library", "frameIndex"})
@SourceDebugExtension(value={"SMAP\nDesktopAnimatedImage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopAnimatedImage.kt\norg/jetbrains/compose/animatedimage/DesktopAnimatedImageKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,94:1\n1247#2,3:95\n1250#2,3:99\n1247#2,6:102\n1247#2,6:108\n1247#2,6:114\n1247#2,6:120\n1#3:98\n85#4:126\n*S KotlinDebug\n*F\n+ 1 DesktopAnimatedImage.kt\norg/jetbrains/compose/animatedimage/DesktopAnimatedImageKt\n*L\n33#1:95,3\n33#1:99,3\n34#1:102,6\n46#1:108,6\n58#1:114,6\n60#1:120,6\n41#1:126\n*E\n"})
public final class DesktopAnimatedImageKt {
    private static final int DEFAULT_FRAME_DURATION = 100;

    @Nullable
    public static final Object loadAnimatedImage(@NotNull String path, @NotNull Continuation<? super AnimatedImage> $completion) {
        AnimatedImageLoader loader = DesktopAnimatedImageKt.getAnimatedImageLoaderByPath(path);
        return loader.loadAnimatedImage($completion);
    }

    @Nullable
    public static final Object loadResourceAnimatedImage(@NotNull String path, @NotNull Continuation<? super AnimatedImage> $completion) {
        ResourceAnimatedImageLoader loader = new ResourceAnimatedImageLoader(path);
        return loader.loadAnimatedImage($completion);
    }

    /*
     * WARNING - void declaration
     */
    @Composable
    @NotNull
    public static final ImageBitmap animate(@NotNull AnimatedImage $this$animate, @Nullable Composer $composer, int $changed) {
        Object object;
        Object object2;
        Composer $this$cache$iv;
        Object object3;
        void invalid$iv;
        void $this$cache$iv2;
        InfiniteTransition transition;
        Intrinsics.checkNotNullParameter((Object)$this$animate, (String)"<this>");
        $composer.startReplaceGroup(-2003984445);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-2003984445, (int)$changed, (int)-1, (String)"org.jetbrains.compose.animatedimage.animate (DesktopAnimatedImage.kt:27)");
        }
        switch ($this$animate.getCodec().getFrameCount()) {
            case 0: {
                $composer.startReplaceGroup(1906063421);
                ImageBitmap imageBitmap = AnimatedImageKt.getBlank(ImageBitmap.Companion);
                $composer.endReplaceGroup();
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
                $composer.endReplaceGroup();
                return imageBitmap;
            }
            case 1: {
                Object object4;
                void $this$cache$iv3;
                Object object5;
                void $this$cache$iv4;
                $composer.startReplaceGroup(1906129079);
                Codec codec = $this$animate.getCodec();
                $composer.startReplaceGroup(338584752);
                Composer composer = $composer;
                boolean invalid$iv2 = $composer.changed((Object)codec);
                boolean $i$f$cache = false;
                Object it$iv = $this$cache$iv4.rememberedValue();
                boolean bl = false;
                if (invalid$iv2 || it$iv == Composer.Companion.getEmpty()) {
                    Bitmap bitmap;
                    boolean bl2 = false;
                    Bitmap $this$animate_u24lambda_u241_u24lambda_u240 = bitmap = new Bitmap();
                    boolean bl3 = false;
                    $this$animate_u24lambda_u241_u24lambda_u240.allocPixels($this$animate.getCodec().getImageInfo());
                    Bitmap value$iv = bitmap;
                    $this$cache$iv4.updateRememberedValue((Object)value$iv);
                    object5 = value$iv;
                } else {
                    object5 = it$iv;
                }
                Bitmap bitmap = (Bitmap)object5;
                $composer.endReplaceGroup();
                Bitmap bitmap2 = bitmap;
                $composer.startReplaceGroup(338587321);
                bitmap = $composer;
                boolean invalid$iv3 = $composer.changed((Object)bitmap2);
                boolean $i$f$cache2 = false;
                Object it$iv2 = $this$cache$iv3.rememberedValue();
                $i$a$-let-ComposerKt$cache$1$iv = false;
                if (invalid$iv3 || it$iv2 == Composer.Companion.getEmpty()) {
                    boolean bl4 = false;
                    Codec value$iv = $this$animate.getCodec().readPixels(bitmap2, 0);
                    $this$cache$iv3.updateRememberedValue((Object)value$iv);
                    object4 = value$iv;
                } else {
                    object4 = it$iv2;
                }
                codec = (Codec)object4;
                $composer.endReplaceGroup();
                codec = SkiaImageAsset_skikoKt.asComposeImageBitmap((Bitmap)bitmap2);
                $composer.endReplaceGroup();
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
                $composer.endReplaceGroup();
                return codec;
            }
        }
        $composer.startReplaceGroup(1906451355);
        InfiniteTransition infiniteTransition = transition = InfiniteTransitionKt.rememberInfiniteTransition(null, (Composer)$composer, (int)0, (int)1);
        Integer n = 0;
        Integer n2 = $this$animate.getCodec().getFrameCount() - 1;
        TwoWayConverter twoWayConverter = VectorConvertersKt.getVectorConverter((IntCompanionObject)IntCompanionObject.INSTANCE);
        $composer.startReplaceGroup(338603090);
        Composer invalid$iv3 = $composer;
        boolean $i$f$cache2 = $composer.changedInstance((Object)$this$animate);
        boolean $i$f$cache222 = false;
        Object it$iv = $this$cache$iv2.rememberedValue();
        boolean bl = false;
        if (invalid$iv != false || it$iv == Composer.Companion.getEmpty()) {
            TwoWayConverter twoWayConverter2 = twoWayConverter;
            Integer n3 = n2;
            Integer n4 = n;
            InfiniteTransition infiniteTransition2 = infiniteTransition;
            boolean bl5 = false;
            Function1 function1 = arg_0 -> DesktopAnimatedImageKt.animate$lambda$4$lambda$3($this$animate, arg_0);
            infiniteTransition = infiniteTransition2;
            n = n4;
            n2 = n3;
            twoWayConverter = twoWayConverter2;
            Function1 value$iv = function1;
            $this$cache$iv2.updateRememberedValue((Object)value$iv);
            object3 = value$iv;
        } else {
            object3 = it$iv;
        }
        Function1 $this$cache$iv3 = (Function1)object3;
        $composer.endReplaceGroup();
        State frameIndex$delegate = InfiniteTransitionKt.animateValue((InfiniteTransition)infiniteTransition, (Object)n, (Object)n2, (TwoWayConverter)twoWayConverter, (InfiniteRepeatableSpec)AnimationSpecKt.infiniteRepeatable-9IiC70o$default((DurationBasedAnimationSpec)((DurationBasedAnimationSpec)AnimationSpecKt.keyframes((Function1)$this$cache$iv3)), null, (long)0L, (int)6, null), null, (Composer)$composer, (int)(0x30 | InfiniteTransition.$stable | InfiniteRepeatableSpec.$stable << 12), (int)16);
        Codec codec = $this$animate.getCodec();
        $composer.startReplaceGroup(338616112);
        Composer $i$f$cache222 = $composer;
        boolean invalid$iv4 = $composer.changed((Object)codec);
        boolean $i$f$cache = false;
        Object it$iv3 = $this$cache$iv.rememberedValue();
        $i$a$-let-ComposerKt$cache$1$iv = false;
        if (invalid$iv4 || it$iv3 == Composer.Companion.getEmpty()) {
            Bitmap bl3;
            boolean bl6 = false;
            Bitmap $this$animate_u24lambda_u247_u24lambda_u246 = bl3 = new Bitmap();
            boolean bl7 = false;
            $this$animate_u24lambda_u247_u24lambda_u246.allocPixels($this$animate.getCodec().getImageInfo());
            Bitmap value$iv = bl3;
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object2 = value$iv;
        } else {
            object2 = it$iv3;
        }
        Bitmap bitmap = (Bitmap)object2;
        $composer.endReplaceGroup();
        Bitmap bitmap3 = bitmap;
        int n5 = DesktopAnimatedImageKt.animate$lambda$5((State<Integer>)frameIndex$delegate);
        $composer.startReplaceGroup(338618734);
        $this$cache$iv = $composer;
        invalid$iv4 = $composer.changed((Object)bitmap3) | $composer.changed(n5);
        $i$f$cache = false;
        it$iv3 = $this$cache$iv.rememberedValue();
        $i$a$-let-ComposerKt$cache$1$iv = false;
        if (invalid$iv4 || it$iv3 == Composer.Companion.getEmpty()) {
            boolean bl8 = false;
            Codec value$iv = $this$animate.getCodec().readPixels(bitmap3, DesktopAnimatedImageKt.animate$lambda$5((State<Integer>)frameIndex$delegate));
            $this$cache$iv.updateRememberedValue((Object)value$iv);
            object = value$iv;
        } else {
            object = it$iv3;
        }
        bitmap = (Codec)object;
        $composer.endReplaceGroup();
        ImageBitmap imageBitmap = SkiaImageAsset_skikoKt.asComposeImageBitmap((Bitmap)bitmap3);
        $composer.endReplaceGroup();
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceGroup();
        return imageBitmap;
    }

    private static final int calcFrameDuration(AnimationFrameInfo frame) {
        int frameDuration = frame.getDuration();
        return frameDuration == 0 ? 100 : frameDuration;
    }

    private static final AnimatedImageLoader getAnimatedImageLoaderByPath(String path) {
        return DesktopAnimatedImageKt.isNetworkPath(path) ? (AnimatedImageLoader)new NetworkAnimatedImageLoader(path) : (AnimatedImageLoader)new LocalAnimatedImageLoader(path);
    }

    private static final boolean isNetworkPath(String path) {
        boolean bl;
        try {
            new URL(path);
            bl = true;
        }
        catch (MalformedURLException e) {
            bl = false;
        }
        return bl;
    }

    private static final Unit animate$lambda$4$lambda$3(AnimatedImage $this_animate, KeyframesSpec.KeyframesSpecConfig $this$keyframes) {
        Intrinsics.checkNotNullParameter((Object)$this$keyframes, (String)"$this$keyframes");
        $this$keyframes.setDurationMillis(0);
        AnimationFrameInfo[] animationFrameInfoArray = $this_animate.getCodec().getFramesInfo();
        int n = animationFrameInfoArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            AnimationFrameInfo frame = animationFrameInfoArray[i];
            $this$keyframes.at((Object)index, $this$keyframes.getDurationMillis());
            int frameDuration = DesktopAnimatedImageKt.calcFrameDuration(frame);
            $this$keyframes.setDurationMillis($this$keyframes.getDurationMillis() + frameDuration);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final int animate$lambda$5(State<Integer> $frameIndex$delegate) {
        void $this$getValue$iv;
        State<Integer> state = $frameIndex$delegate;
        Object var2_2 = null;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }
}

