/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.viewmodels;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.TaskType;
import com.jetpackduba.gitnuro.extensions.RefExtensionsKt;
import com.jetpackduba.gitnuro.git.RefreshType;
import com.jetpackduba.gitnuro.git.TabState;
import com.jetpackduba.gitnuro.git.branches.CheckoutRefUseCase;
import com.jetpackduba.gitnuro.git.remote_operations.DeleteRemoteBranchUseCase;
import com.jetpackduba.gitnuro.git.remote_operations.PullFromSpecificBranchUseCase;
import com.jetpackduba.gitnuro.git.remote_operations.PushToSpecificBranchUseCase;
import com.jetpackduba.gitnuro.models.Notification;
import com.jetpackduba.gitnuro.models.NotificationKt;
import com.jetpackduba.gitnuro.ui.context_menu.BranchContextMenuKt;
import com.jetpackduba.gitnuro.viewmodels.ISharedRemotesViewModel;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skiko.ClipboardManager;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetpackduba/gitnuro/viewmodels/SharedRemotesViewModel;", "Lcom/jetpackduba/gitnuro/viewmodels/ISharedRemotesViewModel;", "tabState", "Lcom/jetpackduba/gitnuro/git/TabState;", "deleteRemoteBranchUseCase", "Lcom/jetpackduba/gitnuro/git/remote_operations/DeleteRemoteBranchUseCase;", "checkoutRefUseCase", "Lcom/jetpackduba/gitnuro/git/branches/CheckoutRefUseCase;", "pushToSpecificBranchUseCase", "Lcom/jetpackduba/gitnuro/git/remote_operations/PushToSpecificBranchUseCase;", "pullFromSpecificBranchUseCase", "Lcom/jetpackduba/gitnuro/git/remote_operations/PullFromSpecificBranchUseCase;", "clipboardManager", "Lorg/jetbrains/skiko/ClipboardManager;", "<init>", "(Lcom/jetpackduba/gitnuro/git/TabState;Lcom/jetpackduba/gitnuro/git/remote_operations/DeleteRemoteBranchUseCase;Lcom/jetpackduba/gitnuro/git/branches/CheckoutRefUseCase;Lcom/jetpackduba/gitnuro/git/remote_operations/PushToSpecificBranchUseCase;Lcom/jetpackduba/gitnuro/git/remote_operations/PullFromSpecificBranchUseCase;Lorg/jetbrains/skiko/ClipboardManager;)V", "deleteRemoteBranch", "Lkotlinx/coroutines/Job;", "ref", "Lorg/eclipse/jgit/lib/Ref;", "checkoutRemoteBranch", "remoteBranch", "pushToRemoteBranch", "branch", "pullFromRemoteBranch", "copyBranchNameToClipboard", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class SharedRemotesViewModel
implements ISharedRemotesViewModel {
    @NotNull
    private final TabState tabState;
    @NotNull
    private final DeleteRemoteBranchUseCase deleteRemoteBranchUseCase;
    @NotNull
    private final CheckoutRefUseCase checkoutRefUseCase;
    @NotNull
    private final PushToSpecificBranchUseCase pushToSpecificBranchUseCase;
    @NotNull
    private final PullFromSpecificBranchUseCase pullFromSpecificBranchUseCase;
    @NotNull
    private final ClipboardManager clipboardManager;
    public static final int $stable = 8;

    @Inject
    public SharedRemotesViewModel(@NotNull TabState tabState, @NotNull DeleteRemoteBranchUseCase deleteRemoteBranchUseCase, @NotNull CheckoutRefUseCase checkoutRefUseCase, @NotNull PushToSpecificBranchUseCase pushToSpecificBranchUseCase, @NotNull PullFromSpecificBranchUseCase pullFromSpecificBranchUseCase, @NotNull ClipboardManager clipboardManager) {
        Intrinsics.checkNotNullParameter((Object)tabState, (String)"tabState");
        Intrinsics.checkNotNullParameter((Object)deleteRemoteBranchUseCase, (String)"deleteRemoteBranchUseCase");
        Intrinsics.checkNotNullParameter((Object)checkoutRefUseCase, (String)"checkoutRefUseCase");
        Intrinsics.checkNotNullParameter((Object)pushToSpecificBranchUseCase, (String)"pushToSpecificBranchUseCase");
        Intrinsics.checkNotNullParameter((Object)pullFromSpecificBranchUseCase, (String)"pullFromSpecificBranchUseCase");
        Intrinsics.checkNotNullParameter((Object)clipboardManager, (String)"clipboardManager");
        this.tabState = tabState;
        this.deleteRemoteBranchUseCase = deleteRemoteBranchUseCase;
        this.checkoutRefUseCase = checkoutRefUseCase;
        this.pushToSpecificBranchUseCase = pushToSpecificBranchUseCase;
        this.pullFromSpecificBranchUseCase = pullFromSpecificBranchUseCase;
        this.clipboardManager = clipboardManager;
    }

    @Override
    @NotNull
    public Job deleteRemoteBranch(@NotNull Ref ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        return TabState.safeProcessing$default(this.tabState, RefreshType.ALL_DATA, "Deleting remote branch", "Remote branch " + RefExtensionsKt.getSimpleName(ref) + " will be deleted from the remote", TaskType.DELETE_REMOTE_BRANCH, false, false, null, (Function2)new Function2<Git, Continuation<? super Notification>, Object>(this, ref, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SharedRemotesViewModel this$0;
            final /* synthetic */ Ref $ref;
            {
                this.this$0 = $receiver;
                this.$ref = $ref;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Git git = (Git)this.L$0;
                        this.label = 1;
                        Object object3 = SharedRemotesViewModel.access$getDeleteRemoteBranchUseCase$p(this.this$0).invoke(git, this.$ref, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return NotificationKt.positiveNotification("Remote branch \"" + RefExtensionsKt.getSimpleName(this.$ref) + "\" deleted");
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return NotificationKt.positiveNotification("Remote branch \"" + RefExtensionsKt.getSimpleName(this.$ref) + "\" deleted");
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Git p1, Continuation<? super Notification> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 112, null);
    }

    @Override
    @NotNull
    public Job checkoutRemoteBranch(@NotNull Ref remoteBranch) {
        Intrinsics.checkNotNullParameter((Object)remoteBranch, (String)"remoteBranch");
        return TabState.safeProcessing$default(this.tabState, RefreshType.ALL_DATA, null, null, TaskType.CHECKOUT_REMOTE_BRANCH, false, false, null, (Function2)new Function2<Git, Continuation<? super Notification>, Object>(this, remoteBranch, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SharedRemotesViewModel this$0;
            final /* synthetic */ Ref $remoteBranch;
            {
                this.this$0 = $receiver;
                this.$remoteBranch = $remoteBranch;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Git git = (Git)this.L$0;
                        this.label = 1;
                        Object object3 = SharedRemotesViewModel.access$getCheckoutRefUseCase$p(this.this$0).invoke(git, this.$remoteBranch, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return NotificationKt.positiveNotification("\"" + RefExtensionsKt.getSimpleName(this.$remoteBranch) + "\" checked out");
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return NotificationKt.positiveNotification("\"" + RefExtensionsKt.getSimpleName(this.$remoteBranch) + "\" checked out");
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Git p1, Continuation<? super Notification> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 118, null);
    }

    @Override
    @NotNull
    public Job pushToRemoteBranch(@NotNull Ref branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return TabState.safeProcessing$default(this.tabState, RefreshType.ALL_DATA, "Push", "Pushing current branch to " + RefExtensionsKt.getSimpleName(branch), TaskType.PUSH_TO_BRANCH, false, false, null, (Function2)new Function2<Git, Continuation<? super Notification>, Object>(this, branch, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SharedRemotesViewModel this$0;
            final /* synthetic */ Ref $branch;
            {
                this.this$0 = $receiver;
                this.$branch = $branch;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void var2_3;
                        ResultKt.throwOnFailure((Object)object);
                        Git git = (Git)this.L$0;
                        this.label = 1;
                        Object object3 = SharedRemotesViewModel.access$getPushToSpecificBranchUseCase$p(this.this$0).invoke((Git)var2_3, false, false, this.$branch, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return NotificationKt.positiveNotification("Pushed to \"" + RefExtensionsKt.getSimpleName(this.$branch) + "\"");
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return NotificationKt.positiveNotification("Pushed to \"" + RefExtensionsKt.getSimpleName(this.$branch) + "\"");
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Git p1, Continuation<? super Notification> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 112, null);
    }

    @Override
    @NotNull
    public Job pullFromRemoteBranch(@NotNull Ref branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return TabState.safeProcessing$default(this.tabState, RefreshType.ALL_DATA, "Pull", "Pulling changes from " + RefExtensionsKt.getSimpleName(branch) + " to the current branch", TaskType.PULL_FROM_BRANCH, false, false, null, (Function2)new Function2<Git, Continuation<? super Notification>, Object>(this, branch, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ SharedRemotesViewModel this$0;
            final /* synthetic */ Ref $branch;
            {
                this.this$0 = $receiver;
                this.$branch = $branch;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Git git = (Git)this.L$0;
                        this.label = 1;
                        Object object3 = SharedRemotesViewModel.access$getPullFromSpecificBranchUseCase$p(this.this$0).invoke(git, this.$branch, (Continuation<? super Boolean>)((Continuation)this));
                        if (object3 != object2) return (Boolean)object3 != false ? NotificationKt.warningNotification("Pull produced conflicts, fix them to continue") : NotificationKt.positiveNotification("Pulled from \"" + RefExtensionsKt.getSimpleName(this.$branch) + "\"");
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return (Boolean)object3 != false ? NotificationKt.warningNotification("Pull produced conflicts, fix them to continue") : NotificationKt.positiveNotification("Pulled from \"" + RefExtensionsKt.getSimpleName(this.$branch) + "\"");
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Git p1, Continuation<? super Notification> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 112, null);
    }

    @Override
    @NotNull
    public Job copyBranchNameToClipboard(@NotNull Ref branch) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        return TabState.safeProcessing$default(this.tabState, RefreshType.NONE, null, null, TaskType.UNSPECIFIED, false, false, null, (Function2)new Function2<Git, Continuation<? super Notification>, Object>(branch, this, null){
            int label;
            final /* synthetic */ Ref $branch;
            final /* synthetic */ SharedRemotesViewModel this$0;
            {
                this.$branch = $branch;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return BranchContextMenuKt.copyBranchNameToClipboardAndGetNotification(this.$branch, SharedRemotesViewModel.access$getClipboardManager$p(this.this$0));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Git p1, Continuation<? super Notification> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 118, null);
    }

    public static final /* synthetic */ DeleteRemoteBranchUseCase access$getDeleteRemoteBranchUseCase$p(SharedRemotesViewModel $this) {
        return $this.deleteRemoteBranchUseCase;
    }

    public static final /* synthetic */ CheckoutRefUseCase access$getCheckoutRefUseCase$p(SharedRemotesViewModel $this) {
        return $this.checkoutRefUseCase;
    }

    public static final /* synthetic */ PushToSpecificBranchUseCase access$getPushToSpecificBranchUseCase$p(SharedRemotesViewModel $this) {
        return $this.pushToSpecificBranchUseCase;
    }

    public static final /* synthetic */ PullFromSpecificBranchUseCase access$getPullFromSpecificBranchUseCase$p(SharedRemotesViewModel $this) {
        return $this.pullFromSpecificBranchUseCase;
    }

    public static final /* synthetic */ ClipboardManager access$getClipboardManager$p(SharedRemotesViewModel $this) {
        return $this.clipboardManager;
    }
}

