/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.viewmodels;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.Logging;
import com.jetpackduba.gitnuro.TaskType;
import com.jetpackduba.gitnuro.di.qualifiers.AppCoroutineScope;
import com.jetpackduba.gitnuro.logging.LoggerKt;
import com.jetpackduba.gitnuro.managers.Error;
import com.jetpackduba.gitnuro.managers.ErrorsManagerKt;
import com.jetpackduba.gitnuro.models.DateTimeFormat;
import com.jetpackduba.gitnuro.preferences.AvatarProviderType;
import com.jetpackduba.gitnuro.repositories.AppSettingsRepository;
import com.jetpackduba.gitnuro.repositories.ProxySettings;
import com.jetpackduba.gitnuro.system.OpenFilePickerUseCase;
import com.jetpackduba.gitnuro.system.PickerType;
import com.jetpackduba.gitnuro.theme.LinesHeightType;
import com.jetpackduba.gitnuro.theme.Theme;
import com.jetpackduba.gitnuro.ui.dialogs.settings.ProxyType;
import java.awt.Desktop;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b8\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u00012\u0007\u0010\u0086\u0001\u001a\u00020*J\t\u0010\u0087\u0001\u001a\u0004\u0018\u00010*J\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001J\u000f\u0010\u008a\u0001\u001a\u00020\u001b2\u0006\u00105\u001a\u00020*R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0016R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0016R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0016R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0016R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0016R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0016R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0016R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0016R\u0017\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0016R$\u00107\u001a\u0002062\u0006\u00105\u001a\u0002068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R$\u0010<\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R$\u0010A\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010>\"\u0004\bC\u0010@R$\u0010D\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bE\u0010>\"\u0004\bF\u0010@R$\u0010G\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010>\"\u0004\bI\u0010@R$\u0010J\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bK\u0010>\"\u0004\bL\u0010@R$\u0010M\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bN\u0010>\"\u0004\bO\u0010@R$\u0010P\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bQ\u0010>\"\u0004\bR\u0010@R$\u0010S\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR$\u0010X\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R$\u0010]\u001a\u00020*2\u0006\u00105\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b^\u0010_\"\u0004\b`\u0010aR$\u0010b\u001a\u00020-2\u0006\u00105\u001a\u00020-8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bc\u0010d\"\u0004\be\u0010fR$\u0010g\u001a\u0002002\u0006\u00105\u001a\u0002008F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bh\u0010i\"\u0004\bj\u0010kR$\u0010l\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bm\u0010>\"\u0004\bn\u0010@R$\u0010p\u001a\u00020o2\u0006\u00105\u001a\u00020o8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bq\u0010r\"\u0004\bs\u0010tR$\u0010u\u001a\u00020*2\u0006\u00105\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bv\u0010_\"\u0004\bw\u0010aR$\u0010x\u001a\u00020\r2\u0006\u00105\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\by\u0010\u000f\"\u0004\bz\u0010\u0011R$\u0010{\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b|\u0010>\"\u0004\b}\u0010@R%\u0010~\u001a\u00020*2\u0006\u00105\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\r\u001a\u0004\b\u007f\u0010_\"\u0005\b\u0080\u0001\u0010aR'\u0010\u0081\u0001\u001a\u00020*2\u0006\u00105\u001a\u00020*8F@FX\u0086\u000e\u00a2\u0006\u000e\u001a\u0005\b\u0082\u0001\u0010_\"\u0005\b\u0083\u0001\u0010a\u00a8\u0006\u008b\u0001"}, d2={"Lcom/jetpackduba/gitnuro/viewmodels/SettingsViewModel;", "", "appSettingsRepository", "Lcom/jetpackduba/gitnuro/repositories/AppSettingsRepository;", "openFilePickerUseCase", "Lcom/jetpackduba/gitnuro/system/OpenFilePickerUseCase;", "logging", "Lcom/jetpackduba/gitnuro/Logging;", "appScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/jetpackduba/gitnuro/repositories/AppSettingsRepository;Lcom/jetpackduba/gitnuro/system/OpenFilePickerUseCase;Lcom/jetpackduba/gitnuro/Logging;Lkotlinx/coroutines/CoroutineScope;)V", "commitsLimit", "", "getCommitsLimit", "()I", "setCommitsLimit", "(I)V", "themeState", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/jetpackduba/gitnuro/theme/Theme;", "getThemeState", "()Lkotlinx/coroutines/flow/StateFlow;", "linesHeightTypeState", "Lcom/jetpackduba/gitnuro/theme/LinesHeightType;", "getLinesHeightTypeState", "ffMergeFlow", "", "getFfMergeFlow", "mergeAutoStashFlow", "getMergeAutoStashFlow", "pullRebaseFlow", "getPullRebaseFlow", "pushWithLeaseFlow", "getPushWithLeaseFlow", "swapUncommittedChangesFlow", "getSwapUncommittedChangesFlow", "cacheCredentialsInMemoryFlow", "getCacheCredentialsInMemoryFlow", "verifySslFlow", "getVerifySslFlow", "terminalPathFlow", "", "getTerminalPathFlow", "avatarProviderFlow", "Lcom/jetpackduba/gitnuro/preferences/AvatarProviderType;", "getAvatarProviderFlow", "dateFormatFlow", "Lcom/jetpackduba/gitnuro/models/DateTimeFormat;", "getDateFormatFlow", "proxyFlow", "Lcom/jetpackduba/gitnuro/repositories/ProxySettings;", "getProxyFlow", "value", "", "scaleUi", "getScaleUi", "()F", "setScaleUi", "(F)V", "swapUncommittedChanges", "getSwapUncommittedChanges", "()Z", "setSwapUncommittedChanges", "(Z)V", "ffMerge", "getFfMerge", "setFfMerge", "mergeAutoStash", "getMergeAutoStash", "setMergeAutoStash", "cacheCredentialsInMemory", "getCacheCredentialsInMemory", "setCacheCredentialsInMemory", "verifySsl", "getVerifySsl", "setVerifySsl", "pullRebase", "getPullRebase", "setPullRebase", "pushWithLease", "getPushWithLease", "setPushWithLease", "theme", "getTheme", "()Lcom/jetpackduba/gitnuro/theme/Theme;", "setTheme", "(Lcom/jetpackduba/gitnuro/theme/Theme;)V", "linesHeightType", "getLinesHeightType", "()Lcom/jetpackduba/gitnuro/theme/LinesHeightType;", "setLinesHeightType", "(Lcom/jetpackduba/gitnuro/theme/LinesHeightType;)V", "terminalPath", "getTerminalPath", "()Ljava/lang/String;", "setTerminalPath", "(Ljava/lang/String;)V", "avatarProvider", "getAvatarProvider", "()Lcom/jetpackduba/gitnuro/preferences/AvatarProviderType;", "setAvatarProvider", "(Lcom/jetpackduba/gitnuro/preferences/AvatarProviderType;)V", "dateFormat", "getDateFormat", "()Lcom/jetpackduba/gitnuro/models/DateTimeFormat;", "setDateFormat", "(Lcom/jetpackduba/gitnuro/models/DateTimeFormat;)V", "useProxy", "getUseProxy", "setUseProxy", "Lcom/jetpackduba/gitnuro/ui/dialogs/settings/ProxyType;", "proxyType", "getProxyType", "()Lcom/jetpackduba/gitnuro/ui/dialogs/settings/ProxyType;", "setProxyType", "(Lcom/jetpackduba/gitnuro/ui/dialogs/settings/ProxyType;)V", "proxyHostName", "getProxyHostName", "setProxyHostName", "proxyPortNumber", "getProxyPortNumber", "setProxyPortNumber", "proxyUseAuth", "getProxyUseAuth", "setProxyUseAuth", "proxyHostUser", "getProxyHostUser", "setProxyHostUser", "proxyHostPassword", "getProxyHostPassword", "setProxyHostPassword", "saveCustomTheme", "Lcom/jetpackduba/gitnuro/managers/Error;", "filePath", "openFileDialog", "openLogsFolderInFileExplorer", "", "isValidDateFormat", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class SettingsViewModel {
    @NotNull
    private final AppSettingsRepository appSettingsRepository;
    @NotNull
    private final OpenFilePickerUseCase openFilePickerUseCase;
    @NotNull
    private final Logging logging;
    @NotNull
    private final CoroutineScope appScope;
    private int commitsLimit;
    @NotNull
    private final StateFlow<Theme> themeState;
    @NotNull
    private final StateFlow<LinesHeightType> linesHeightTypeState;
    @NotNull
    private final StateFlow<Boolean> ffMergeFlow;
    @NotNull
    private final StateFlow<Boolean> mergeAutoStashFlow;
    @NotNull
    private final StateFlow<Boolean> pullRebaseFlow;
    @NotNull
    private final StateFlow<Boolean> pushWithLeaseFlow;
    @NotNull
    private final StateFlow<Boolean> swapUncommittedChangesFlow;
    @NotNull
    private final StateFlow<Boolean> cacheCredentialsInMemoryFlow;
    @NotNull
    private final StateFlow<Boolean> verifySslFlow;
    @NotNull
    private final StateFlow<String> terminalPathFlow;
    @NotNull
    private final StateFlow<AvatarProviderType> avatarProviderFlow;
    @NotNull
    private final StateFlow<DateTimeFormat> dateFormatFlow;
    @NotNull
    private final StateFlow<ProxySettings> proxyFlow;
    public static final int $stable = 8;

    @Inject
    public SettingsViewModel(@NotNull AppSettingsRepository appSettingsRepository, @NotNull OpenFilePickerUseCase openFilePickerUseCase, @NotNull Logging logging, @AppCoroutineScope @NotNull CoroutineScope appScope) {
        Intrinsics.checkNotNullParameter((Object)appSettingsRepository, (String)"appSettingsRepository");
        Intrinsics.checkNotNullParameter((Object)openFilePickerUseCase, (String)"openFilePickerUseCase");
        Intrinsics.checkNotNullParameter((Object)logging, (String)"logging");
        Intrinsics.checkNotNullParameter((Object)appScope, (String)"appScope");
        this.appSettingsRepository = appSettingsRepository;
        this.openFilePickerUseCase = openFilePickerUseCase;
        this.logging = logging;
        this.appScope = appScope;
        this.commitsLimit = -1;
        this.themeState = this.appSettingsRepository.getThemeState();
        this.linesHeightTypeState = this.appSettingsRepository.getLinesHeightTypeState();
        this.ffMergeFlow = this.appSettingsRepository.getFfMergeFlow();
        this.mergeAutoStashFlow = this.appSettingsRepository.getMergeAutoStashFlow();
        this.pullRebaseFlow = this.appSettingsRepository.getPullRebaseFlow();
        this.pushWithLeaseFlow = this.appSettingsRepository.getPushWithLeaseFlow();
        this.swapUncommittedChangesFlow = this.appSettingsRepository.getSwapUncommittedChangesFlow();
        this.cacheCredentialsInMemoryFlow = this.appSettingsRepository.getCacheCredentialsInMemoryFlow();
        this.verifySslFlow = this.appSettingsRepository.getVerifySslFlow();
        this.terminalPathFlow = this.appSettingsRepository.getTerminalPathFlow();
        this.avatarProviderFlow = this.appSettingsRepository.getAvatarProviderTypeFlow();
        this.dateFormatFlow = this.appSettingsRepository.getDateTimeFormatFlow();
        this.proxyFlow = this.appSettingsRepository.getProxyFlow();
    }

    public final int getCommitsLimit() {
        return this.commitsLimit;
    }

    public final void setCommitsLimit(int n) {
        this.commitsLimit = n;
    }

    @NotNull
    public final StateFlow<Theme> getThemeState() {
        return this.themeState;
    }

    @NotNull
    public final StateFlow<LinesHeightType> getLinesHeightTypeState() {
        return this.linesHeightTypeState;
    }

    @NotNull
    public final StateFlow<Boolean> getFfMergeFlow() {
        return this.ffMergeFlow;
    }

    @NotNull
    public final StateFlow<Boolean> getMergeAutoStashFlow() {
        return this.mergeAutoStashFlow;
    }

    @NotNull
    public final StateFlow<Boolean> getPullRebaseFlow() {
        return this.pullRebaseFlow;
    }

    @NotNull
    public final StateFlow<Boolean> getPushWithLeaseFlow() {
        return this.pushWithLeaseFlow;
    }

    @NotNull
    public final StateFlow<Boolean> getSwapUncommittedChangesFlow() {
        return this.swapUncommittedChangesFlow;
    }

    @NotNull
    public final StateFlow<Boolean> getCacheCredentialsInMemoryFlow() {
        return this.cacheCredentialsInMemoryFlow;
    }

    @NotNull
    public final StateFlow<Boolean> getVerifySslFlow() {
        return this.verifySslFlow;
    }

    @NotNull
    public final StateFlow<String> getTerminalPathFlow() {
        return this.terminalPathFlow;
    }

    @NotNull
    public final StateFlow<AvatarProviderType> getAvatarProviderFlow() {
        return this.avatarProviderFlow;
    }

    @NotNull
    public final StateFlow<DateTimeFormat> getDateFormatFlow() {
        return this.dateFormatFlow;
    }

    @NotNull
    public final StateFlow<ProxySettings> getProxyFlow() {
        return this.proxyFlow;
    }

    public final float getScaleUi() {
        return this.appSettingsRepository.getScaleUi();
    }

    public final void setScaleUi(float value) {
        this.appSettingsRepository.setScaleUi(value);
    }

    public final boolean getSwapUncommittedChanges() {
        return this.appSettingsRepository.getSwapUncommittedChanges();
    }

    public final void setSwapUncommittedChanges(boolean value) {
        this.appSettingsRepository.setSwapUncommittedChanges(value);
    }

    public final boolean getFfMerge() {
        return this.appSettingsRepository.getFfMerge();
    }

    public final void setFfMerge(boolean value) {
        this.appSettingsRepository.setFfMerge(value);
    }

    public final boolean getMergeAutoStash() {
        return this.appSettingsRepository.getMergeAutoStash();
    }

    public final void setMergeAutoStash(boolean value) {
        this.appSettingsRepository.setMergeAutoStash(value);
    }

    public final boolean getCacheCredentialsInMemory() {
        return this.appSettingsRepository.getCacheCredentialsInMemory();
    }

    public final void setCacheCredentialsInMemory(boolean value) {
        this.appSettingsRepository.setCacheCredentialsInMemory(value);
    }

    public final boolean getVerifySsl() {
        return this.appSettingsRepository.getVerifySsl();
    }

    public final void setVerifySsl(boolean value) {
        this.appSettingsRepository.setVerifySsl(value);
    }

    public final boolean getPullRebase() {
        return this.appSettingsRepository.getPullRebase();
    }

    public final void setPullRebase(boolean value) {
        this.appSettingsRepository.setPullRebase(value);
    }

    public final boolean getPushWithLease() {
        return this.appSettingsRepository.getPushWithLease();
    }

    public final void setPushWithLease(boolean value) {
        this.appSettingsRepository.setPushWithLease(value);
    }

    @NotNull
    public final Theme getTheme() {
        return this.appSettingsRepository.getTheme();
    }

    public final void setTheme(@NotNull Theme value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.appSettingsRepository.setTheme(value);
    }

    @NotNull
    public final LinesHeightType getLinesHeightType() {
        return this.appSettingsRepository.getLinesHeightType();
    }

    public final void setLinesHeightType(@NotNull LinesHeightType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.appSettingsRepository.setLinesHeightType(value);
    }

    @NotNull
    public final String getTerminalPath() {
        return this.appSettingsRepository.getTerminalPath();
    }

    public final void setTerminalPath(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.appSettingsRepository.setTerminalPath(value);
    }

    @NotNull
    public final AvatarProviderType getAvatarProvider() {
        return this.appSettingsRepository.getAvatarProviderType();
    }

    public final void setAvatarProvider(@NotNull AvatarProviderType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.appSettingsRepository.setAvatarProviderType(value);
    }

    @NotNull
    public final DateTimeFormat getDateFormat() {
        return this.appSettingsRepository.getDateTimeFormat();
    }

    public final void setDateFormat(@NotNull DateTimeFormat value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.appSettingsRepository.setDateTimeFormat(value);
    }

    public final boolean getUseProxy() {
        return this.appSettingsRepository.getUseProxy();
    }

    public final void setUseProxy(boolean value) {
        this.appSettingsRepository.setUseProxy(value);
    }

    @NotNull
    public final ProxyType getProxyType() {
        return this.appSettingsRepository.getProxyType();
    }

    public final void setProxyType(@NotNull ProxyType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.appSettingsRepository.setProxyType(value);
    }

    @NotNull
    public final String getProxyHostName() {
        return this.appSettingsRepository.getProxyHostName();
    }

    public final void setProxyHostName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.appSettingsRepository.setProxyHostName(value);
    }

    public final int getProxyPortNumber() {
        return this.appSettingsRepository.getProxyPortNumber();
    }

    public final void setProxyPortNumber(int value) {
        this.appSettingsRepository.setProxyPortNumber(value);
    }

    public final boolean getProxyUseAuth() {
        return this.appSettingsRepository.getProxyUseAuth();
    }

    public final void setProxyUseAuth(boolean value) {
        this.appSettingsRepository.setProxyUseAuth(value);
    }

    @NotNull
    public final String getProxyHostUser() {
        return this.appSettingsRepository.getProxyHostUser();
    }

    public final void setProxyHostUser(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.appSettingsRepository.setProxyHostUser(value);
    }

    @NotNull
    public final String getProxyHostPassword() {
        return this.appSettingsRepository.getProxyHostPassword();
    }

    public final void setProxyHostPassword(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.appSettingsRepository.setProxyHostPassword(value);
    }

    @Nullable
    public final Error saveCustomTheme(@NotNull String filePath) {
        Error error;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            this.appSettingsRepository.saveCustomTheme(filePath);
            error = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            error = ErrorsManagerKt.newErrorNow(TaskType.SAVE_CUSTOM_THEME, ex);
        }
        return error;
    }

    @Nullable
    public final String openFileDialog() {
        return this.openFilePickerUseCase.invoke(PickerType.FILES, null);
    }

    public final void openLogsFolderInFileExplorer() {
        try {
            Desktop.getDesktop().open(this.logging.getLogsDirectory());
        }
        catch (Exception ex) {
            String string2 = ex.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            LoggerKt.printError("SettingsViewModel", string2, ex);
        }
    }

    public final boolean isValidDateFormat(@NotNull String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        try {
            ZoneId zoneId = ZoneId.systemDefault();
            DateTimeFormatter sdf = DateTimeFormatter.ofPattern(value);
            sdf.format(Instant.now().atZone(zoneId).toLocalDate());
            bl = true;
        }
        catch (Exception ex) {
            LoggerKt.printError("SettingsViewModel", "Is valid format date: " + ex.getMessage(), ex);
            bl = false;
        }
        return bl;
    }
}

