/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.viewmodels;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.input.TextFieldValue;
import com.jetpackduba.gitnuro.git.CloneState;
import com.jetpackduba.gitnuro.git.TabState;
import com.jetpackduba.gitnuro.git.remote_operations.CloneRepositoryUseCase;
import com.jetpackduba.gitnuro.system.OpenFilePickerUseCase;
import com.jetpackduba.gitnuro.system.PickerType;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020 J\u0006\u0010'\u001a\u00020\"J\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020\u001cJ\b\u0010)\u001a\u0004\u0018\u00010\u001cJ\u000e\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\fJ\u000e\u0010,\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0010R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetpackduba/gitnuro/viewmodels/CloneViewModel;", "", "tabState", "Lcom/jetpackduba/gitnuro/git/TabState;", "cloneRepositoryUseCase", "Lcom/jetpackduba/gitnuro/git/remote_operations/CloneRepositoryUseCase;", "openFilePickerUseCase", "Lcom/jetpackduba/gitnuro/system/OpenFilePickerUseCase;", "<init>", "(Lcom/jetpackduba/gitnuro/git/TabState;Lcom/jetpackduba/gitnuro/git/remote_operations/CloneRepositoryUseCase;Lcom/jetpackduba/gitnuro/system/OpenFilePickerUseCase;)V", "_repositoryUrl", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Landroidx/compose/ui/text/input/TextFieldValue;", "repositoryUrl", "Lkotlinx/coroutines/flow/StateFlow;", "getRepositoryUrl", "()Lkotlinx/coroutines/flow/StateFlow;", "_directoryPath", "directoryPath", "getDirectoryPath", "_folder", "folder", "getFolder", "_cloneState", "Lcom/jetpackduba/gitnuro/git/CloneState;", "cloneState", "getCloneState", "_error", "", "error", "getError", "cloneJob", "Lkotlinx/coroutines/Job;", "clone", "", "url", "cloneSubmodules", "", "cancelClone", "resetStateIfError", "repoName", "openDirectoryPicker", "onDirectoryPathChanged", "directory", "onRepositoryUrlChanged", "onFolderNameChanged", "folderName", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class CloneViewModel {
    @NotNull
    private final TabState tabState;
    @NotNull
    private final CloneRepositoryUseCase cloneRepositoryUseCase;
    @NotNull
    private final OpenFilePickerUseCase openFilePickerUseCase;
    @NotNull
    private final MutableStateFlow<TextFieldValue> _repositoryUrl;
    @NotNull
    private final StateFlow<TextFieldValue> repositoryUrl;
    @NotNull
    private final MutableStateFlow<TextFieldValue> _directoryPath;
    @NotNull
    private final StateFlow<TextFieldValue> directoryPath;
    @NotNull
    private final MutableStateFlow<TextFieldValue> _folder;
    @NotNull
    private final StateFlow<TextFieldValue> folder;
    @NotNull
    private final MutableStateFlow<CloneState> _cloneState;
    @NotNull
    private final StateFlow<CloneState> cloneState;
    @NotNull
    private final MutableStateFlow<String> _error;
    @NotNull
    private final StateFlow<String> error;
    @Nullable
    private Job cloneJob;
    public static final int $stable = 8;

    @Inject
    public CloneViewModel(@NotNull TabState tabState, @NotNull CloneRepositoryUseCase cloneRepositoryUseCase, @NotNull OpenFilePickerUseCase openFilePickerUseCase) {
        Intrinsics.checkNotNullParameter((Object)tabState, (String)"tabState");
        Intrinsics.checkNotNullParameter((Object)cloneRepositoryUseCase, (String)"cloneRepositoryUseCase");
        Intrinsics.checkNotNullParameter((Object)openFilePickerUseCase, (String)"openFilePickerUseCase");
        this.tabState = tabState;
        this.cloneRepositoryUseCase = cloneRepositoryUseCase;
        this.openFilePickerUseCase = openFilePickerUseCase;
        this._repositoryUrl = StateFlowKt.MutableStateFlow((Object)new TextFieldValue("", 0L, null, 6, null));
        this.repositoryUrl = FlowKt.asStateFlow(this._repositoryUrl);
        this._directoryPath = StateFlowKt.MutableStateFlow((Object)new TextFieldValue("", 0L, null, 6, null));
        this.directoryPath = FlowKt.asStateFlow(this._directoryPath);
        this._folder = StateFlowKt.MutableStateFlow((Object)new TextFieldValue("", 0L, null, 6, null));
        this.folder = FlowKt.asStateFlow(this._folder);
        this._cloneState = StateFlowKt.MutableStateFlow((Object)CloneState.None.INSTANCE);
        this.cloneState = FlowKt.asStateFlow(this._cloneState);
        this._error = StateFlowKt.MutableStateFlow((Object)"");
        this.error = FlowKt.asStateFlow(this._error);
    }

    @NotNull
    public final StateFlow<TextFieldValue> getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @NotNull
    public final StateFlow<TextFieldValue> getDirectoryPath() {
        return this.directoryPath;
    }

    @NotNull
    public final StateFlow<TextFieldValue> getFolder() {
        return this.folder;
    }

    @NotNull
    public final StateFlow<CloneState> getCloneState() {
        return this.cloneState;
    }

    @NotNull
    public final StateFlow<String> getError() {
        return this.error;
    }

    public final void clone(@NotNull String directoryPath, @NotNull String url, @NotNull String folder, boolean cloneSubmodules) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        this.cloneJob = TabState.safeProcessingWithoutGit$default(this.tabState, null, null, false, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(directoryPath, this, url, folder, cloneSubmodules, null){
            int label;
            final /* synthetic */ String $directoryPath;
            final /* synthetic */ CloneViewModel this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ String $folder;
            final /* synthetic */ boolean $cloneSubmodules;
            {
                this.$directoryPath = $directoryPath;
                this.this$0 = $receiver;
                this.$url = $url;
                this.$folder = $folder;
                this.$cloneSubmodules = $cloneSubmodules;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        File repoDir;
                        ResultKt.throwOnFailure((Object)object);
                        if (StringsKt.isBlank((CharSequence)this.$directoryPath)) {
                            CloneViewModel.access$get_error$p(this.this$0).setValue((Object)"Invalid empty directory");
                            return Unit.INSTANCE;
                        }
                        if (StringsKt.isBlank((CharSequence)this.$url)) {
                            CloneViewModel.access$get_error$p(this.this$0).setValue((Object)"Invalid empty URL");
                            return Unit.INSTANCE;
                        }
                        if (StringsKt.isBlank((CharSequence)this.$folder)) {
                            CloneViewModel.access$get_error$p(this.this$0).setValue((Object)"Invalid empty folder name");
                            return Unit.INSTANCE;
                        }
                        File directory = new File(this.$directoryPath);
                        if (!directory.exists()) {
                            directory.mkdirs();
                        }
                        if (!(repoDir = new File(directory, this.$folder)).exists()) {
                            repoDir.mkdir();
                        }
                        this.label = 1;
                        Object object3 = FlowKt.flowOn(CloneViewModel.access$getCloneRepositoryUseCase$p(this.this$0).invoke(repoDir, this.$url, this.$cloneSubmodules), (CoroutineContext)((CoroutineContext)Dispatchers.getIO())).collect(new FlowCollector(this.this$0){
                            final /* synthetic */ CloneViewModel this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(CloneState newCloneStatus, Continuation<? super Unit> $completion) {
                                if (newCloneStatus instanceof CloneState.Fail) {
                                    CloneViewModel.access$get_error$p(this.this$0).setValue((Object)((CloneState.Fail)newCloneStatus).getReason());
                                    CloneViewModel.access$get_cloneState$p(this.this$0).setValue((Object)CloneState.None.INSTANCE);
                                } else {
                                    CloneViewModel.access$get_cloneState$p(this.this$0).setValue((Object)newCloneStatus);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 7, null);
    }

    @NotNull
    public final Job cancelClone() {
        return TabState.safeProcessingWithoutGit$default(this.tabState, null, null, false, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CloneViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CloneViewModel.access$get_cloneState$p(this.this$0).setValue((Object)CloneState.Cancelling.INSTANCE);
                        Job job2 = CloneViewModel.access$getCloneJob$p(this.this$0);
                        if (job2 == null) break;
                        this.label = 1;
                        Object object3 = JobKt.cancelAndJoin((Job)job2, (Continuation)((Continuation)this));
                        if (object3 == object2) {
                            return object2;
                        }
                        break;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        break;
                    }
                }
                CloneViewModel.access$get_cloneState$p(this.this$0).setValue((Object)CloneState.None.INSTANCE);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 7, null);
    }

    public final void resetStateIfError() {
        this._error.setValue((Object)"");
    }

    @NotNull
    public final String repoName(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String[] stringArray = new String[]{"/", "\\"};
        List urlSplit = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)url, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (!((Collection)urlSplit).isEmpty() && StringsKt.isBlank((CharSequence)((CharSequence)CollectionsKt.last((List)urlSplit)))) {
            CollectionsKt.removeLast((List)urlSplit);
        }
        String string2 = (String)CollectionsKt.lastOrNull((List)urlSplit);
        String string3 = string2 != null ? StringsKt.removeSuffix((String)string2, (CharSequence)".git") : null;
        if (string3 == null) {
            string3 = "";
        }
        return string3;
    }

    @Nullable
    public final String openDirectoryPicker() {
        return this.openFilePickerUseCase.invoke(PickerType.DIRECTORIES, null);
    }

    public final void onDirectoryPathChanged(@NotNull TextFieldValue directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this._directoryPath.setValue((Object)directory);
    }

    public final void onRepositoryUrlChanged(@NotNull TextFieldValue repositoryUrl) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        this._repositoryUrl.setValue((Object)repositoryUrl);
    }

    public final void onFolderNameChanged(@NotNull TextFieldValue folderName) {
        Intrinsics.checkNotNullParameter((Object)folderName, (String)"folderName");
        this._folder.setValue((Object)folderName);
    }

    public static final /* synthetic */ MutableStateFlow access$get_error$p(CloneViewModel $this) {
        return $this._error;
    }

    public static final /* synthetic */ CloneRepositoryUseCase access$getCloneRepositoryUseCase$p(CloneViewModel $this) {
        return $this.cloneRepositoryUseCase;
    }

    public static final /* synthetic */ MutableStateFlow access$get_cloneState$p(CloneViewModel $this) {
        return $this._cloneState;
    }

    public static final /* synthetic */ Job access$getCloneJob$p(CloneViewModel $this) {
        return $this.cloneJob;
    }
}

