/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.ui.context_menu;

import androidx.compose.runtime.Composer;
import androidx.compose.ui.graphics.painter.Painter;
import com.jetpackduba.gitnuro.extensions.RefExtensionsKt;
import com.jetpackduba.gitnuro.models.Notification;
import com.jetpackduba.gitnuro.models.NotificationKt;
import com.jetpackduba.gitnuro.ui.context_menu.BranchContextMenuKt;
import com.jetpackduba.gitnuro.ui.context_menu.ContextMenuElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.lib.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.ClipboardManager;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u00ae\u0001\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a8\u0006\u0018"}, d2={"branchContextMenuItems", "", "Lcom/jetpackduba/gitnuro/ui/context_menu/ContextMenuElement;", "branch", "Lorg/eclipse/jgit/lib/Ref;", "isCurrentBranch", "", "currentBranch", "isLocal", "onCheckoutBranch", "Lkotlin/Function0;", "", "onMergeBranch", "onRebaseBranch", "onDeleteBranch", "onDeleteRemoteBranch", "onPushToRemoteBranch", "onPullFromRemoteBranch", "onChangeDefaultUpstreamBranch", "onCopyBranchNameToClipboard", "copyBranchNameToClipboardAndGetNotification", "Lcom/jetpackduba/gitnuro/models/Notification;", "clipboardManager", "Lorg/jetbrains/skiko/ClipboardManager;", "Gitnuro"})
public final class BranchContextMenuKt {
    @NotNull
    public static final List<ContextMenuElement> branchContextMenuItems(@NotNull Ref branch, boolean isCurrentBranch, @Nullable Ref currentBranch, boolean isLocal, @NotNull Function0<Unit> onCheckoutBranch, @NotNull Function0<Unit> onMergeBranch, @NotNull Function0<Unit> onRebaseBranch, @NotNull Function0<Unit> onDeleteBranch, @NotNull Function0<Unit> onDeleteRemoteBranch, @NotNull Function0<Unit> onPushToRemoteBranch, @NotNull Function0<Unit> onPullFromRemoteBranch, @NotNull Function0<Unit> onChangeDefaultUpstreamBranch, @NotNull Function0<Unit> onCopyBranchNameToClipboard) {
        List list;
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Intrinsics.checkNotNullParameter(onCheckoutBranch, (String)"onCheckoutBranch");
        Intrinsics.checkNotNullParameter(onMergeBranch, (String)"onMergeBranch");
        Intrinsics.checkNotNullParameter(onRebaseBranch, (String)"onRebaseBranch");
        Intrinsics.checkNotNullParameter(onDeleteBranch, (String)"onDeleteBranch");
        Intrinsics.checkNotNullParameter(onDeleteRemoteBranch, (String)"onDeleteRemoteBranch");
        Intrinsics.checkNotNullParameter(onPushToRemoteBranch, (String)"onPushToRemoteBranch");
        Intrinsics.checkNotNullParameter(onPullFromRemoteBranch, (String)"onPullFromRemoteBranch");
        Intrinsics.checkNotNullParameter(onChangeDefaultUpstreamBranch, (String)"onChangeDefaultUpstreamBranch");
        Intrinsics.checkNotNullParameter(onCopyBranchNameToClipboard, (String)"onCopyBranchNameToClipboard");
        List $this$branchContextMenuItems_u24lambda_u242 = list = (List)new ArrayList();
        boolean bl = false;
        if (!isCurrentBranch) {
            $this$branchContextMenuItems_u24lambda_u242.add(new ContextMenuElement.ContextTextEntry("Checkout branch", (Function2<? super Composer, ? super Integer, ? extends Painter>)((Function2)branchContextMenuItems.2.1.INSTANCE), onCheckoutBranch));
            if (currentBranch != null && !RefExtensionsKt.isHead(currentBranch)) {
                $this$branchContextMenuItems_u24lambda_u242.add(new ContextMenuElement.ContextTextEntry("Merge branch", null, onMergeBranch, 2, null));
                $this$branchContextMenuItems_u24lambda_u242.add(new ContextMenuElement.ContextTextEntry("Rebase branch", null, onRebaseBranch, 2, null));
                $this$branchContextMenuItems_u24lambda_u242.add(ContextMenuElement.ContextSeparator.INSTANCE);
            }
        }
        if (!isLocal && currentBranch != null && !RefExtensionsKt.isHead(currentBranch)) {
            $this$branchContextMenuItems_u24lambda_u242.add(new ContextMenuElement.ContextTextEntry("Push " + RefExtensionsKt.getSimpleLogName(currentBranch) + " to " + RefExtensionsKt.getSimpleLogName(branch), null, onPushToRemoteBranch, 2, null));
            $this$branchContextMenuItems_u24lambda_u242.add(new ContextMenuElement.ContextTextEntry("Pull " + RefExtensionsKt.getSimpleLogName(branch) + " to " + RefExtensionsKt.getSimpleLogName(currentBranch), null, onPullFromRemoteBranch, 2, null));
            $this$branchContextMenuItems_u24lambda_u242.add(ContextMenuElement.ContextSeparator.INSTANCE);
        }
        if (isLocal) {
            $this$branchContextMenuItems_u24lambda_u242.add(new ContextMenuElement.ContextTextEntry("Change default upstream branch", null, onChangeDefaultUpstreamBranch, 2, null));
            $this$branchContextMenuItems_u24lambda_u242.add(ContextMenuElement.ContextSeparator.INSTANCE);
        }
        if (!isLocal) {
            $this$branchContextMenuItems_u24lambda_u242.add(new ContextMenuElement.ContextTextEntry("Delete remote branch", (Function2<? super Composer, ? super Integer, ? extends Painter>)((Function2)branchContextMenuItems.2.2.INSTANCE), onDeleteRemoteBranch));
            $this$branchContextMenuItems_u24lambda_u242.add(ContextMenuElement.ContextSeparator.INSTANCE);
        }
        if (isLocal && !isCurrentBranch) {
            $this$branchContextMenuItems_u24lambda_u242.add(new ContextMenuElement.ContextTextEntry("Delete branch", (Function2<? super Composer, ? super Integer, ? extends Painter>)((Function2)branchContextMenuItems.2.3.INSTANCE), onDeleteBranch));
            $this$branchContextMenuItems_u24lambda_u242.add(ContextMenuElement.ContextSeparator.INSTANCE);
        }
        $this$branchContextMenuItems_u24lambda_u242.add(new ContextMenuElement.ContextTextEntry("Copy branch name", (Function2<? super Composer, ? super Integer, ? extends Painter>)((Function2)branchContextMenuItems.2.4.INSTANCE), (Function0<Unit>)((Function0)() -> BranchContextMenuKt.branchContextMenuItems$lambda$2$lambda$1(onCopyBranchNameToClipboard))));
        return list;
    }

    public static /* synthetic */ List branchContextMenuItems$default(Ref ref, boolean bl, Ref ref2, boolean bl2, Function0 function0, Function0 function02, Function0 function03, Function0 function04, Function0 function05, Function0 function06, Function0 function07, Function0 function08, Function0 function09, int n, Object object) {
        if ((n & 0x100) != 0) {
            function05 = BranchContextMenuKt::branchContextMenuItems$lambda$0;
        }
        return BranchContextMenuKt.branchContextMenuItems(ref, bl, ref2, bl2, (Function0<Unit>)function0, (Function0<Unit>)function02, (Function0<Unit>)function03, (Function0<Unit>)function04, (Function0<Unit>)function05, (Function0<Unit>)function06, (Function0<Unit>)function07, (Function0<Unit>)function08, (Function0<Unit>)function09);
    }

    @NotNull
    public static final Notification copyBranchNameToClipboardAndGetNotification(@NotNull Ref branch, @NotNull ClipboardManager clipboardManager) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Intrinsics.checkNotNullParameter((Object)clipboardManager, (String)"clipboardManager");
        String branchName = RefExtensionsKt.getSimpleName(branch);
        clipboardManager.setText(branchName);
        return NotificationKt.positiveNotification("\"" + branchName + "\" copied to clipboard");
    }

    private static final Unit branchContextMenuItems$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit branchContextMenuItems$lambda$2$lambda$1(Function0 $onCopyBranchNameToClipboard) {
        $onCopyBranchNameToClipboard.invoke();
        return Unit.INSTANCE;
    }
}

