/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.ui.components;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.di.AppComponent;
import com.jetpackduba.gitnuro.di.DaggerTabComponent;
import com.jetpackduba.gitnuro.di.TabComponent;
import com.jetpackduba.gitnuro.managers.AppStateManager;
import com.jetpackduba.gitnuro.viewmodels.TabViewModel;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010$\u001a\u00020\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u001c8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0010\u00a8\u0006&"}, d2={"Lcom/jetpackduba/gitnuro/ui/components/TabInformation;", "", "tabName", "Landroidx/compose/runtime/MutableState;", "", "initialPath", "onTabPathChanged", "Lkotlin/Function0;", "", "appComponent", "Lcom/jetpackduba/gitnuro/di/AppComponent;", "<init>", "(Landroidx/compose/runtime/MutableState;Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lcom/jetpackduba/gitnuro/di/AppComponent;)V", "getTabName", "()Landroidx/compose/runtime/MutableState;", "getInitialPath", "()Ljava/lang/String;", "getOnTabPathChanged", "()Lkotlin/jvm/functions/Function0;", "tabComponent", "Lcom/jetpackduba/gitnuro/di/TabComponent;", "tabViewModel", "Lcom/jetpackduba/gitnuro/viewmodels/TabViewModel;", "getTabViewModel", "()Lcom/jetpackduba/gitnuro/viewmodels/TabViewModel;", "setTabViewModel", "(Lcom/jetpackduba/gitnuro/viewmodels/TabViewModel;)V", "appStateManager", "Lcom/jetpackduba/gitnuro/managers/AppStateManager;", "getAppStateManager", "()Lcom/jetpackduba/gitnuro/managers/AppStateManager;", "setAppStateManager", "(Lcom/jetpackduba/gitnuro/managers/AppStateManager;)V", "value", "path", "getPath", "dispose", "Companion", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class TabInformation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableState<String> tabName;
    @Nullable
    private final String initialPath;
    @NotNull
    private final Function0<Unit> onTabPathChanged;
    @NotNull
    private final TabComponent tabComponent;
    @Inject
    public TabViewModel tabViewModel;
    @Inject
    public AppStateManager appStateManager;
    @Nullable
    private String path;
    public static final int $stable = 8;
    @NotNull
    public static final String DEFAULT_NAME = "New tab";

    public TabInformation(@NotNull MutableState<String> tabName, @Nullable String initialPath, @NotNull Function0<Unit> onTabPathChanged, @Nullable AppComponent appComponent) {
        Intrinsics.checkNotNullParameter(tabName, (String)"tabName");
        Intrinsics.checkNotNullParameter(onTabPathChanged, (String)"onTabPathChanged");
        this.tabName = tabName;
        this.initialPath = initialPath;
        this.onTabPathChanged = onTabPathChanged;
        TabComponent tabComponent = DaggerTabComponent.builder().appComponent(appComponent).build();
        Intrinsics.checkNotNullExpressionValue((Object)tabComponent, (String)"build(...)");
        this.tabComponent = tabComponent;
        this.path = this.initialPath;
        this.tabComponent.inject(this);
        if (this.initialPath != null) {
            Path path = Paths.get(this.initialPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            this.tabName.setValue((Object)PathsKt.getName((Path)path));
        }
        this.getTabViewModel().setOnRepositoryChanged((Function1<? super String, Unit>)((Function1)arg_0 -> TabInformation._init_$lambda$0(this, arg_0)));
        this.getTabViewModel().setInitialPath(this.initialPath);
    }

    @NotNull
    public final MutableState<String> getTabName() {
        return this.tabName;
    }

    @Nullable
    public final String getInitialPath() {
        return this.initialPath;
    }

    @NotNull
    public final Function0<Unit> getOnTabPathChanged() {
        return this.onTabPathChanged;
    }

    @NotNull
    public final TabViewModel getTabViewModel() {
        TabViewModel tabViewModel = this.tabViewModel;
        if (tabViewModel != null) {
            return tabViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tabViewModel");
        return null;
    }

    public final void setTabViewModel(@NotNull TabViewModel tabViewModel) {
        Intrinsics.checkNotNullParameter((Object)tabViewModel, (String)"<set-?>");
        this.tabViewModel = tabViewModel;
    }

    @NotNull
    public final AppStateManager getAppStateManager() {
        AppStateManager appStateManager = this.appStateManager;
        if (appStateManager != null) {
            return appStateManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"appStateManager");
        return null;
    }

    public final void setAppStateManager(@NotNull AppStateManager appStateManager) {
        Intrinsics.checkNotNullParameter((Object)appStateManager, (String)"<set-?>");
        this.appStateManager = appStateManager;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    public final void dispose() {
        this.getTabViewModel().dispose();
    }

    private static final Unit _init_$lambda$0(TabInformation this$0, String newPath) {
        this$0.path = newPath;
        if (newPath == null) {
            this$0.tabName.setValue((Object)DEFAULT_NAME);
        } else {
            MutableState<String> mutableState = this$0.tabName;
            Path path = Paths.get(newPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            mutableState.setValue((Object)PathsKt.getName((Path)path));
            this$0.getAppStateManager().repositoryTabChanged(newPath);
        }
        this$0.onTabPathChanged.invoke();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetpackduba/gitnuro/ui/components/TabInformation$Companion;", "", "<init>", "()V", "DEFAULT_NAME", "", "Gitnuro"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

