/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.ui;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.di.AppComponent;
import com.jetpackduba.gitnuro.repositories.AppSettingsRepository;
import com.jetpackduba.gitnuro.ui.components.TabInformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u000fJ\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u000fH\u0002J\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u000fJ\b\u0010\"\u001a\u00020\u0018H\u0002J\u0006\u0010#\u001a\u00020\u0018J$\u0010$\u001a\u00020\u000f2\u000e\b\u0002\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001b0&2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0016\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006+"}, d2={"Lcom/jetpackduba/gitnuro/ui/TabsManager;", "", "appSettingsRepository", "Lcom/jetpackduba/gitnuro/repositories/AppSettingsRepository;", "<init>", "(Lcom/jetpackduba/gitnuro/repositories/AppSettingsRepository;)V", "appComponent", "Lcom/jetpackduba/gitnuro/di/AppComponent;", "getAppComponent", "()Lcom/jetpackduba/gitnuro/di/AppComponent;", "setAppComponent", "(Lcom/jetpackduba/gitnuro/di/AppComponent;)V", "_tabsFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/jetpackduba/gitnuro/ui/components/TabInformation;", "tabsFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getTabsFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "_currentTab", "currentTab", "getCurrentTab", "loadPersistedTabs", "", "addNewTabFromPath", "path", "", "selectTab", "", "tabToBeReplacedPath", "tab", "persistTabSelected", "closeTab", "updatePersistedTabs", "addNewEmptyTab", "newAppTab", "tabName", "Landroidx/compose/runtime/MutableState;", "onMoveTab", "fromIndex", "", "toIndex", "Gitnuro"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTabsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TabsManager.kt\ncom/jetpackduba/gitnuro/ui/TabsManager\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 6 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,159:1\n147#2:160\n1563#3:161\n1634#3,3:162\n295#3,2:166\n774#3:173\n865#3,2:174\n1563#3:176\n1634#3,3:177\n1#4:165\n230#5,5:168\n230#5,5:181\n230#5,5:186\n113#6:180\n*S KotlinDebug\n*F\n+ 1 TabsManager.kt\ncom/jetpackduba/gitnuro/ui/TabsManager\n*L\n32#1:160\n32#1:161\n32#1:162,3\n51#1:166,2\n120#1:173\n120#1:174,2\n122#1:176\n122#1:177,3\n57#1:168,5\n129#1:181,5\n151#1:186,5\n122#1:180\n*E\n"})
public final class TabsManager {
    @NotNull
    private final AppSettingsRepository appSettingsRepository;
    public AppComponent appComponent;
    @NotNull
    private final MutableStateFlow<List<TabInformation>> _tabsFlow;
    @NotNull
    private final StateFlow<List<TabInformation>> tabsFlow;
    @NotNull
    private final MutableStateFlow<TabInformation> _currentTab;
    @NotNull
    private final StateFlow<TabInformation> currentTab;
    public static final int $stable = 8;

    @Inject
    public TabsManager(@NotNull AppSettingsRepository appSettingsRepository) {
        Intrinsics.checkNotNullParameter((Object)appSettingsRepository, (String)"appSettingsRepository");
        this.appSettingsRepository = appSettingsRepository;
        this._tabsFlow = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.tabsFlow = (StateFlow)this._tabsFlow;
        this._currentTab = StateFlowKt.MutableStateFlow(null);
        this.currentTab = (StateFlow)this._currentTab;
    }

    @NotNull
    public final AppComponent getAppComponent() {
        AppComponent appComponent = this.appComponent;
        if (appComponent != null) {
            return appComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"appComponent");
        return null;
    }

    public final void setAppComponent(@NotNull AppComponent appComponent) {
        Intrinsics.checkNotNullParameter((Object)appComponent, (String)"<set-?>");
        this.appComponent = appComponent;
    }

    @NotNull
    public final StateFlow<List<TabInformation>> getTabsFlow() {
        return this.tabsFlow;
    }

    @NotNull
    public final StateFlow<TabInformation> getCurrentTab() {
        return this.currentTab;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadPersistedTabs() {
        TabInformation tabInformation;
        boolean bl;
        Collection collection;
        List list;
        Object object;
        Iterable $this$map$iv;
        String repositoriesSaved = this.appSettingsRepository.getLatestTabsOpened();
        if (((CharSequence)repositoriesSaved).length() > 0) {
            void $this$mapTo$iv$iv;
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            $this$map$iv = (Iterable)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), repositoriesSaved);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void path;
                String string2 = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl2 = false;
                object.add((TabInformation)TabsManager.newAppTab$default(this, null, (String)path, 1, null));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List repositoriesList = list;
        MutableStateFlow<List<TabInformation>> mutableStateFlow = this._tabsFlow;
        $this$map$iv = repositoriesList;
        if ($this$map$iv.isEmpty()) {
            object = mutableStateFlow;
            boolean bl3 = false;
            collection = CollectionsKt.listOf((Object)TabsManager.newAppTab$default(this, null, null, 3, null));
            mutableStateFlow = object;
        } else {
            collection = $this$map$iv;
        }
        mutableStateFlow.setValue((Object)collection);
        int latestSelectedTabIndex = this.appSettingsRepository.getLatestRepositoryTabSelected();
        boolean bl4 = bl = latestSelectedTabIndex < 0;
        if (bl) {
            tabInformation = (TabInformation)CollectionsKt.first((List)((List)this.tabsFlow.getValue()));
        } else if (!bl) {
            tabInformation = (TabInformation)CollectionsKt.getOrNull((List)((List)this.tabsFlow.getValue()), (int)latestSelectedTabIndex);
            if (tabInformation == null) {
                tabInformation = (TabInformation)CollectionsKt.first((List)((List)this.tabsFlow.getValue()));
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this._currentTab.setValue((Object)tabInformation);
    }

    public final void addNewTabFromPath(@NotNull String path, boolean selectTab, @Nullable String tabToBeReplacedPath) {
        List newTabsList;
        List nextValue$iv;
        Object prevValue$iv;
        Object v0;
        Object it;
        block4: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Iterable $this$firstOrNull$iv = (Iterable)this.tabsFlow.getValue();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (TabInformation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)((TabInformation)it).getPath(), (Object)tabToBeReplacedPath)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        TabInformation tabToBeReplaced = v0;
        TabInformation newTab = this.newAppTab((MutableState<String>)SnapshotStateKt.mutableStateOf$default((Object)"", null, (int)2, null), path);
        MutableStateFlow<List<TabInformation>> $this$update$iv = this._tabsFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (List)prevValue$iv;
            boolean bl = false;
            newTabsList = CollectionsKt.toMutableList((Collection)((Collection)it));
            if (tabToBeReplaced != null) {
                int index = newTabsList.indexOf(tabToBeReplaced);
                newTabsList.set(index, newTab);
                continue;
            }
            newTabsList.add(newTab);
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = newTabsList)));
        if (selectTab) {
            this._currentTab.setValue((Object)newTab);
        }
    }

    public static /* synthetic */ void addNewTabFromPath$default(TabsManager tabsManager, String string2, boolean bl, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        tabsManager.addNewTabFromPath(string2, bl, string3);
    }

    public final void selectTab(@NotNull TabInformation tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        this._currentTab.setValue((Object)tab);
        this.persistTabSelected(tab);
    }

    private final void persistTabSelected(TabInformation tab) {
        this.appSettingsRepository.setLatestRepositoryTabSelected(((List)this.tabsFlow.getValue()).indexOf(tab));
    }

    public final void closeTab(@NotNull TabInformation tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        List tabsList = CollectionsKt.toMutableList((Collection)((Collection)this._tabsFlow.getValue()));
        TabInformation newCurrentTab = null;
        tab.getTabViewModel().dispose();
        if (Intrinsics.areEqual((Object)this.currentTab.getValue(), (Object)tab)) {
            int index = tabsList.indexOf(tab);
            if (((Collection)tabsList).size() == 1) {
                newCurrentTab = TabsManager.newAppTab$default(this, null, null, 3, null);
            } else if (index > 0) {
                newCurrentTab = (TabInformation)tabsList.get(index - 1);
            } else if (index == 0) {
                newCurrentTab = (TabInformation)tabsList.get(1);
            }
        }
        tab.dispose();
        tabsList.remove(tab);
        if (newCurrentTab != null) {
            if (!tabsList.contains(newCurrentTab)) {
                tabsList.add(newCurrentTab);
            }
            this._tabsFlow.setValue((Object)tabsList);
            this._currentTab.setValue((Object)newCurrentTab);
        } else {
            this._tabsFlow.setValue((Object)tabsList);
        }
        this.updatePersistedTabs();
    }

    /*
     * WARNING - void declaration
     */
    private final void updatePersistedTabs() {
        void $this$encodeToString$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)this.tabsFlow.getValue();
        boolean $i$f$filter22 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TabInformation it = (TabInformation)element$iv$iv;
            boolean bl = false;
            if (!(it.getPath() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tabs = (List)destination$iv$iv;
        $this$filter$iv = (StringFormat)Json.Default;
        Iterable $i$f$filter22 = tabs;
        AppSettingsRepository appSettingsRepository = this.appSettingsRepository;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TabInformation bl = (TabInformation)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getPath());
        }
        List value$iv = (List)destination$iv$iv2;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        appSettingsRepository.setLatestTabsOpened($this$encodeToString$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(BuiltinSerializersKt.getNullable((KSerializer)StringSerializer.INSTANCE)), (Object)value$iv));
        this.appSettingsRepository.setLatestRepositoryTabSelected(CollectionsKt.indexOf((List)tabs, (Object)this.currentTab.getValue()));
    }

    public final void addNewEmptyTab() {
        List list;
        List nextValue$iv;
        Object prevValue$iv;
        TabInformation newTab = TabsManager.newAppTab$default(this, null, null, 3, null);
        MutableStateFlow<List<TabInformation>> $this$update$iv = this._tabsFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            List it = (List)prevValue$iv;
            boolean bl = false;
            List $this$addNewEmptyTab_u24lambda_u247_u24lambda_u246 = list = CollectionsKt.toMutableList((Collection)it);
            boolean bl2 = false;
            $this$addNewEmptyTab_u24lambda_u247_u24lambda_u246.add(newTab);
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = list)));
        this._currentTab.setValue((Object)newTab);
    }

    private final TabInformation newAppTab(MutableState<String> tabName, String path) {
        return new TabInformation(tabName, path, (Function0<Unit>)((Function0)() -> TabsManager.newAppTab$lambda$8(this)), this.getAppComponent());
    }

    static /* synthetic */ TabInformation newAppTab$default(TabsManager tabsManager, MutableState mutableState, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            mutableState = SnapshotStateKt.mutableStateOf$default((Object)"New tab", null, (int)2, null);
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return tabsManager.newAppTab((MutableState<String>)mutableState, string2);
    }

    public final void onMoveTab(int fromIndex, int toIndex) {
        List list;
        List nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<List<TabInformation>> $this$update$iv = this._tabsFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            List it = (List)prevValue$iv;
            boolean bl = false;
            List $this$onMoveTab_u24lambda_u2410_u24lambda_u249 = list = CollectionsKt.toMutableList((Collection)it);
            boolean bl2 = false;
            $this$onMoveTab_u24lambda_u2410_u24lambda_u249.add(toIndex, $this$onMoveTab_u24lambda_u2410_u24lambda_u249.remove(fromIndex));
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = list)));
        this.updatePersistedTabs();
    }

    private static final Unit newAppTab$lambda$8(TabsManager this$0) {
        this$0.updatePersistedTabs();
        return Unit.INSTANCE;
    }
}

