/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.terminal;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.repositories.AppSettingsRepository;
import com.jetpackduba.gitnuro.terminal.ITerminalProvider;
import com.jetpackduba.gitnuro.terminal.TerminalEmulator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetpackduba/gitnuro/terminal/OpenRepositoryInTerminalUseCase;", "", "terminalProvider", "Lcom/jetpackduba/gitnuro/terminal/ITerminalProvider;", "settings", "Lcom/jetpackduba/gitnuro/repositories/AppSettingsRepository;", "<init>", "(Lcom/jetpackduba/gitnuro/terminal/ITerminalProvider;Lcom/jetpackduba/gitnuro/repositories/AppSettingsRepository;)V", "invoke", "", "path", "", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class OpenRepositoryInTerminalUseCase {
    @NotNull
    private final ITerminalProvider terminalProvider;
    @NotNull
    private final AppSettingsRepository settings;
    public static final int $stable = 8;

    @Inject
    public OpenRepositoryInTerminalUseCase(@NotNull ITerminalProvider terminalProvider, @NotNull AppSettingsRepository settings) {
        Intrinsics.checkNotNullParameter((Object)terminalProvider, (String)"terminalProvider");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.terminalProvider = terminalProvider;
        this.settings = settings;
    }

    public final void invoke(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List<TerminalEmulator> terminalEmulators = this.terminalProvider.getTerminalEmulators();
        if (((CharSequence)this.settings.getTerminalPath()).length() > 0) {
            this.terminalProvider.startTerminal(new TerminalEmulator("CUSTOM_TERMINAL", this.settings.getTerminalPath()), path);
        } else {
            for (TerminalEmulator terminal : terminalEmulators) {
                boolean isTerminalEmulatorInstalled = this.terminalProvider.isTerminalInstalled(terminal);
                if (!isTerminalEmulatorInstalled) continue;
                this.terminalProvider.startTerminal(terminal, path);
                break;
            }
        }
    }
}

