/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.terminal;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.managers.IShellManager;
import com.jetpackduba.gitnuro.terminal.ITerminalProvider;
import com.jetpackduba.gitnuro.terminal.TerminalEmulator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetpackduba/gitnuro/terminal/LinuxTerminalProvider;", "Lcom/jetpackduba/gitnuro/terminal/ITerminalProvider;", "shellManager", "Lcom/jetpackduba/gitnuro/managers/IShellManager;", "<init>", "(Lcom/jetpackduba/gitnuro/managers/IShellManager;)V", "getTerminalEmulators", "", "Lcom/jetpackduba/gitnuro/terminal/TerminalEmulator;", "isTerminalInstalled", "", "terminalEmulator", "startTerminal", "", "repositoryPath", "", "Gitnuro"})
@StabilityInferred(parameters=0)
public final class LinuxTerminalProvider
implements ITerminalProvider {
    @NotNull
    private final IShellManager shellManager;
    public static final int $stable = 8;

    @Inject
    public LinuxTerminalProvider(@NotNull IShellManager shellManager) {
        Intrinsics.checkNotNullParameter((Object)shellManager, (String)"shellManager");
        this.shellManager = shellManager;
    }

    @Override
    @NotNull
    public List<TerminalEmulator> getTerminalEmulators() {
        Object[] objectArray = new TerminalEmulator[]{new TerminalEmulator("Gnome Terminal", "gnome-terminal"), new TerminalEmulator("KDE Terminal", "konsole"), new TerminalEmulator("XFCE Terminal", "xfce4-terminal"), new TerminalEmulator("Mate Terminal", "mate-terminal"), new TerminalEmulator("LXQT Terminal", "qterminal")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean isTerminalInstalled(@NotNull TerminalEmulator terminalEmulator) {
        Intrinsics.checkNotNullParameter((Object)terminalEmulator, (String)"terminalEmulator");
        Object object = new String[]{"which", terminalEmulator.getPath(), "2>/dev/null"};
        String checkTerminalInstalled = this.shellManager.runCommand(CollectionsKt.listOf((Object[])object));
        object = checkTerminalInstalled;
        return !(object == null || object.length() == 0);
    }

    @Override
    public void startTerminal(@NotNull TerminalEmulator terminalEmulator, @NotNull String repositoryPath) {
        Intrinsics.checkNotNullParameter((Object)terminalEmulator, (String)"terminalEmulator");
        Intrinsics.checkNotNullParameter((Object)repositoryPath, (String)"repositoryPath");
        this.shellManager.runCommandInPath(CollectionsKt.listOf((Object)terminalEmulator.getPath()), repositoryPath);
    }
}

