/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.system;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.logging.LoggerKt;
import com.jetpackduba.gitnuro.system.OpenPathInSystemUseCase;
import java.awt.Desktop;
import java.net.URI;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetpackduba/gitnuro/system/OpenUrlInBrowserUseCase;", "", "openPathInSystemUseCase", "Lcom/jetpackduba/gitnuro/system/OpenPathInSystemUseCase;", "<init>", "(Lcom/jetpackduba/gitnuro/system/OpenPathInSystemUseCase;)V", "invoke", "", "url", "", "openUrlInBrowserJdk", "Gitnuro"})
@StabilityInferred(parameters=1)
public final class OpenUrlInBrowserUseCase {
    @NotNull
    private final OpenPathInSystemUseCase openPathInSystemUseCase;
    public static final int $stable;

    @Inject
    public OpenUrlInBrowserUseCase(@NotNull OpenPathInSystemUseCase openPathInSystemUseCase) {
        Intrinsics.checkNotNullParameter((Object)openPathInSystemUseCase, (String)"openPathInSystemUseCase");
        this.openPathInSystemUseCase = openPathInSystemUseCase;
    }

    public final void invoke(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!this.openPathInSystemUseCase.invoke(url)) {
            this.openUrlInBrowserJdk(url);
        }
    }

    private final void openUrlInBrowserJdk(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception ex) {
            LoggerKt.printError$default("SystemUtils", "Failed to open URL in browser", null, 4, null);
            ex.printStackTrace();
        }
    }
}

