/*
 * Decompiled with CFR 0.152.
 */
package com.jetpackduba.gitnuro.system;

import androidx.compose.runtime.internal.StabilityInferred;
import com.jetpackduba.gitnuro.logging.LoggerKt;
import com.jetpackduba.gitnuro.managers.ShellManager;
import com.jetpackduba.gitnuro.system.OS;
import com.jetpackduba.gitnuro.system.OSKt;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetpackduba/gitnuro/system/OpenPathInSystemUseCase;", "", "shellManager", "Lcom/jetpackduba/gitnuro/managers/ShellManager;", "<init>", "(Lcom/jetpackduba/gitnuro/managers/ShellManager;)V", "invoke", "", "path", "", "Gitnuro"})
@StabilityInferred(parameters=1)
public final class OpenPathInSystemUseCase {
    @NotNull
    private final ShellManager shellManager;
    public static final int $stable;

    @Inject
    public OpenPathInSystemUseCase(@NotNull ShellManager shellManager) {
        Intrinsics.checkNotNullParameter((Object)shellManager, (String)"shellManager");
        this.shellManager = shellManager;
    }

    public final boolean invoke(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        switch (WhenMappings.$EnumSwitchMapping$0[OSKt.getCurrentOs().ordinal()]) {
            case 1: {
                Object[] objectArray = new String[]{"xdg-open", path};
                if (this.shellManager.runCommandWithoutResult(CollectionsKt.listOf((Object[])objectArray))) {
                    return true;
                }
                objectArray = new String[]{"kde-open", path};
                if (this.shellManager.runCommandWithoutResult(CollectionsKt.listOf((Object[])objectArray))) {
                    return true;
                }
                objectArray = new String[]{"gnome-open", path};
                if (!this.shellManager.runCommandWithoutResult(CollectionsKt.listOf((Object[])objectArray))) break;
                return true;
            }
            case 2: {
                Object[] objectArray = new String[]{"explorer", path};
                if (!this.shellManager.runCommandWithoutResult(CollectionsKt.listOf((Object[])objectArray))) break;
                return true;
            }
            case 3: {
                Object[] objectArray = new String[]{"open", path};
                if (!this.shellManager.runCommandWithoutResult(CollectionsKt.listOf((Object[])objectArray))) break;
                return true;
            }
            default: {
                LoggerKt.printError$default("OpenPathInSystemUseCase", "Unknown OS", null, 4, null);
            }
        }
        return false;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.LINUX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.WINDOWS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.MAC.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

